package org.ojrandom.paiesque.data;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;

import org.ojrandom.paiesque.logging.AppLogger;

public class SyncCheckpointManager {
    private static final String TAG = "SyncCheckpointManager";
    private static final String TABLE_SYNC_CHECKPOINTS = "SYNC_CHECKPOINTS";

    private final SQLiteDatabase targetDb;

    public SyncCheckpointManager(SQLiteDatabase targetDb) {
        this.targetDb = targetDb;
        createSyncCheckpointsTable();
    }

    private void createSyncCheckpointsTable() {
        String sql = "CREATE TABLE IF NOT EXISTS " + TABLE_SYNC_CHECKPOINTS + " (" +
                "CHECKPOINT_KEY TEXT PRIMARY KEY, " +
                "LAST_SYNC_TIMESTAMP INTEGER NOT NULL, " +
                "SYNCED_AT INTEGER DEFAULT (strftime('%s','now'))" +
                ")";
        try {
            targetDb.execSQL(sql);
            AppLogger.d(TAG, "Sync checkpoints table created/verified");
        } catch (Exception e) {
            AppLogger.e(TAG, "Error creating sync checkpoints table", e);
        }
    }

    public long getGlobalLastSyncTimestamp() {
        String sql = "SELECT LAST_SYNC_TIMESTAMP FROM " + TABLE_SYNC_CHECKPOINTS +
                " WHERE CHECKPOINT_KEY = 'GLOBAL_HEART_RATE_SYNC'";

        try (Cursor cursor = targetDb.rawQuery(sql, null)) {
            if (cursor.moveToFirst()) {
                return cursor.getLong(0);
            }
        } catch (Exception e) {
            AppLogger.e(TAG, "Error reading global sync checkpoint", e);
        }

        return 0L; // Return 0 if no checkpoint exists
    }

    public void updateGlobalSyncTimestamp(long lastTimestamp) {
        String sql = "INSERT OR REPLACE INTO " + TABLE_SYNC_CHECKPOINTS +
                " (CHECKPOINT_KEY, LAST_SYNC_TIMESTAMP) VALUES ('GLOBAL_HEART_RATE_SYNC', ?)";
        try {
            targetDb.execSQL(sql, new Object[]{lastTimestamp});
            AppLogger.d(TAG, "Updated global sync timestamp to: " + lastTimestamp);
        } catch (Exception e) {
            AppLogger.e(TAG, "Error updating global sync checkpoint", e);
        }
    }
}