package org.ojrandom.paiesque.data;

import android.content.Context;
import android.net.Uri;

/**
 * Handles importing database files exported from the Gadgetbridge app.
 * Pure file operations - no database connections.
 */
public class GadgetbridgeFileImporter {

    private final Context context;
    private final Uri uri;
    private final DatabaseFileCopier fileCopier;

    public GadgetbridgeFileImporter(Context context, Uri exportUri) {
        this.context = context;
        this.uri = exportUri;
        // Remove dbManager dependency - pure file operations only
        this.fileCopier = new DatabaseFileCopier(context, exportUri);
    }

    /**
     * Copies the exported Gadgetbridge database to internal storage
     * @return Path to the copied database file, or null if failed
     */
    public DatabaseFileCopier.CopyResult importToInternalStorage() {
        // Use the existing fileCopier instance instead of creating a new one
        return fileCopier.copyDbToInternal();
    }

    public void close() {
        // No database connections to close - pure file operations
    }
}