package org.ojrandom.paiesque.calculation;

import org.ojrandom.paiesque.data.DailyHeartRates;
import org.ojrandom.paiesque.rhr.RhrResult;

import java.time.LocalDate;
import java.util.List;
import java.util.Map;

public interface CalculationProgressListener {
    void onProgressUpdate(int currentStep, int totalSteps, String status);
    void onHeartRatesLoaded(Map<LocalDate, DailyHeartRates> dailyHeartRates);
    void onPaiCalculated(List<Map<String, String>> rollingPAI);
    void onHrStored();
    void onRhrCalculated(RhrResult rhrResult);
    void onStorageComplete();
    void onError(String error);
    void onAllCalculationsComplete(Boolean hasHeartRateData);
    void onBatchProgress(int currentBatch, int totalBatches, String batchType);
}