package org.ojrandom.paiesque;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.ListAdapter;
import androidx.recyclerview.widget.RecyclerView;
import org.ojrandom.paiesque.logging.AppLogger;
import java.text.SimpleDateFormat;
import java.util.*;

public class LogAdapter extends ListAdapter<AppLogger.LogEntry, LogAdapter.ViewHolder> {

    public LogAdapter() {
        super(new DiffUtil.ItemCallback<AppLogger.LogEntry>() {
            @Override
            public boolean areItemsTheSame(@NonNull AppLogger.LogEntry oldItem, @NonNull AppLogger.LogEntry newItem) {
                return oldItem.timestamp == newItem.timestamp &&
                        oldItem.tag.equals(newItem.tag) &&
                        oldItem.message.equals(newItem.message);
            }

            @Override
            public boolean areContentsTheSame(@NonNull AppLogger.LogEntry oldItem, @NonNull AppLogger.LogEntry newItem) {
                return oldItem.equals(newItem);
            }
        });
    }

    public void addLogEntry(AppLogger.LogEntry entry) {
        List<AppLogger.LogEntry> newList = new ArrayList<>(getCurrentList());
        newList.add(0, entry); // Add to top
        submitList(newList);
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.item_log_entry, parent, false);
        return new ViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        holder.bind(getItem(position));
    }

    static class ViewHolder extends RecyclerView.ViewHolder {
        private final TextView timestamp;
        private final TextView level;
        private final TextView tag;
        private final TextView message;

        ViewHolder(View view) {
            super(view);
            timestamp = view.findViewById(R.id.timestamp);
            level = view.findViewById(R.id.level);
            tag = view.findViewById(R.id.tag);
            message = view.findViewById(R.id.message);
        }

        void bind(AppLogger.LogEntry entry) {
            SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss.SSS", Locale.getDefault());
            timestamp.setText(timeFormat.format(new Date(entry.timestamp)));
            level.setText(entry.level.name());
            tag.setText(entry.tag);
            message.setText(entry.message);

            // Colors will be handled by the system theme
            // The text colors are set in the layout XML using ?android:attr references
        }
    }
}