package org.ojrandom.paiesque.ui;

import java.time.LocalDate;

public class ZoneDayData {
    private LocalDate date;
    private double totalPai;
    private double paiZone50_59;
    private double paiZone60_69;
    private double paiZone70_79;
    private double paiZone80_89;
    private double paiZone90Plus;
    private double timeZone50_59; // in seconds
    private double timeZone60_69;
    private double timeZone70_79;
    private double timeZone80_89;
    private double timeZone90Plus;

    public ZoneDayData(LocalDate date) {
        this.date = date;
    }

    // Getters and Setters
    public LocalDate getDate() { return date; }
    public void setDate(LocalDate date) { this.date = date; }

    public double getTotalPai() { return totalPai; }
    public void setTotalPai(double totalPai) { this.totalPai = totalPai; }

    public double getPaiZone50_59() { return paiZone50_59; }
    public void setPaiZone50_59(double paiZone50_59) { this.paiZone50_59 = paiZone50_59; }

    public double getPaiZone60_69() { return paiZone60_69; }
    public void setPaiZone60_69(double paiZone60_69) { this.paiZone60_69 = paiZone60_69; }

    public double getPaiZone70_79() { return paiZone70_79; }
    public void setPaiZone70_79(double paiZone70_79) { this.paiZone70_79 = paiZone70_79; }

    public double getPaiZone80_89() { return paiZone80_89; }
    public void setPaiZone80_89(double paiZone80_89) { this.paiZone80_89 = paiZone80_89; }

    public double getPaiZone90Plus() { return paiZone90Plus; }
    public void setPaiZone90Plus(double paiZone90Plus) { this.paiZone90Plus = paiZone90Plus; }

    public double getTimeZone50_59() { return timeZone50_59; }
    public void setTimeZone50_59(double timeZone50_59) { this.timeZone50_59 = timeZone50_59; }

    public double getTimeZone60_69() { return timeZone60_69; }
    public void setTimeZone60_69(double timeZone60_69) { this.timeZone60_69 = timeZone60_69; }

    public double getTimeZone70_79() { return timeZone70_79; }
    public void setTimeZone70_79(double timeZone70_79) { this.timeZone70_79 = timeZone70_79; }

    public double getTimeZone80_89() { return timeZone80_89; }
    public void setTimeZone80_89(double timeZone80_89) { this.timeZone80_89 = timeZone80_89; }

    public double getTimeZone90Plus() { return timeZone90Plus; }
    public void setTimeZone90Plus(double timeZone90Plus) { this.timeZone90Plus = timeZone90Plus; }

    // Helper methods
    public double getTotalZonePai() {
        return paiZone50_59 + paiZone60_69 + paiZone70_79 + paiZone80_89 + paiZone90Plus;
    }

    public double getTotalZoneTime() {
        return timeZone50_59 + timeZone60_69 + timeZone70_79 + timeZone80_89 + timeZone90Plus;
    }

    @Override
    public String toString() {
        return String.format("ZoneDayData{date=%s, total=%.1f, zones=[%.1f, %.1f, %.1f, %.1f, %.1f]}",
                date, totalPai, paiZone50_59, paiZone60_69, paiZone70_79, paiZone80_89, paiZone90Plus);
    }
}