package org.ojrandom.paiesque.ui;

import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.net.Uri;
import android.view.MenuItem;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;

import org.ojrandom.paiesque.HelpActivity;
import org.ojrandom.paiesque.LogViewerActivity;
import org.ojrandom.paiesque.R;
import org.ojrandom.paiesque.SettingsActivity;
import org.ojrandom.paiesque.SleepSettingsActivity;

public class MenuManager {
    private final AppCompatActivity activity;
    private MenuActionListener actionListener;

    public MenuManager(AppCompatActivity activity) {
        this.activity = activity;
    }

    public void setActionListener(MenuActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public boolean handleMenuAction(MenuItem item) {
        int id = item.getItemId();

        if (id == R.id.menu_select_database) {
            if (actionListener != null) actionListener.onSelectDatabase();
            return true;
        } else if (id == R.id.menu_reload_database) {
            if (actionListener != null) actionListener.onReloadDatabase();
            return true;
        } else if (id == R.id.menu_export_backup) {
            if (actionListener != null) actionListener.onExportBackup();
            return true;
        } else if (id == R.id.menu_import_backup) {
            if (actionListener != null) actionListener.onImportBackup();
            return true;
        } else if (id == R.id.menu_delete_all) {
            showDeleteConfirmation();
            return true;
        } else if (id == R.id.action_heart_info) {
            showHeartSettingsDialog();
            return true;
        } else if (id == R.id.menu_help) {
            openHelp();
            return true;
        } else if (id == R.id.menu_view_logs) {
            openLogViewer();
            return true;
        } else if (id == R.id.menu_report_bug) {
            openBugTracker();
            return true;
        }
        return false;
    }

    private void openBugTracker() {
        try {
            Intent intent = new Intent(Intent.ACTION_VIEW,
                    Uri.parse("https://codeberg.org/ojrandom/paiesque/issues"));
            activity.startActivity(intent);
        } catch (ActivityNotFoundException e) {
            Toast.makeText(activity, R.string.toast_no_browser, Toast.LENGTH_SHORT).show();
        }
    }

    private void openLogViewer() {
        Intent intent = new Intent(activity, LogViewerActivity.class);
        activity.startActivity(intent);
    }

    private void showHeartSettingsDialog() {
        String[] options = {
                activity.getString(R.string.menu_heart_rate_zones),
                activity.getString(R.string.menu_sleep_time_rhr)
        };

        AlertDialog.Builder builder = new AlertDialog.Builder(activity);
        builder.setTitle(R.string.menu_heart_settings);
        builder.setItems(options, (dialog, which) -> {
            if (which == 0) {
                openSettings();
            } else if (which == 1) {
                openSleepSettings();
            }
        });
        builder.setNegativeButton(R.string.menu_cancel, null);
        builder.show();
    }

    private void showDeleteConfirmation() {
        new AlertDialog.Builder(activity)
                .setTitle(R.string.menu_delete_all_data)
                .setMessage(R.string.menu_delete_confirmation)
                .setPositiveButton(R.string.menu_delete, (dialog, which) -> {
                    if (actionListener != null) actionListener.onDeleteAllData();
                })
                .setNegativeButton(R.string.menu_cancel, null)
                .show();
    }

    private void openHelp() {
        Intent intent = new Intent(activity, HelpActivity.class);
        activity.startActivity(intent);
    }

    private void openSettings() {
        Intent intent = new Intent(activity, SettingsActivity.class);
        activity.startActivity(intent);
    }

    private void openSleepSettings() {
        Intent intent = new Intent(activity, SleepSettingsActivity.class);
        activity.startActivity(intent);
    }

    public interface MenuActionListener {
        void onSelectDatabase();
        void onReloadDatabase();
        void onDeleteAllData();
        void onDeviceSelected(String device);
        void onExportBackup();
        void onImportBackup();
    }
}