package org.ojrandom.paiesque.data.sync;

import android.database.Cursor;

import org.ojrandom.paiesque.data.GadgetbridgeSyncSource;
import org.ojrandom.paiesque.logging.AppLogger;

import java.util.Map;

/**
 * Standard query handler for manufacturers with typical table schemas.
 * Used by most devices that follow the TIMESTAMP, DEVICE_ID, HEART_RATE pattern.
 */
public class StandardQueryHandler extends BaseQueryHandler {

    @Override
    public String buildQuery(String tableName, long lastSyncTimestamp) {
        return super.buildQuery(tableName, lastSyncTimestamp);
    }

    @Override
    public String buildQuery(String[] tableNames, long lastSyncTimestamp) {
        // Standard handler only supports single tables
        if (tableNames.length == 1) {
            return buildQuery(tableNames[0], lastSyncTimestamp);
        }
        throw new UnsupportedOperationException(
                "StandardQueryHandler doesn't support multiple tables. " +
                        "Use TwoTableQueryHandler for CMF and COLMI devices.");
    }

    @Override
    public HeartRateRecord extractRecord(Cursor cursor, String tableName,
                                         Map<String, Long> deviceMap, GadgetbridgeSyncSource sourceDbHelper) {
        try {
            long timestamp = cursor.getLong(0);
            String sourceDeviceId = String.valueOf(cursor.getLong(1));
            int heartRate = cursor.getInt(2);

            return createHeartRateRecord(timestamp, sourceDeviceId, heartRate, deviceMap, tableName);
        } catch (Exception e) {
            AppLogger.e(TAG, "Error extracting standard record", e);
            return HeartRateRecord.invalid();
        }
    }
}