// DatabaseStatsRepository.java
package org.ojrandom.paiesque.data.repositories;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;

import org.ojrandom.paiesque.data.AppConstants;
import org.ojrandom.paiesque.logging.AppLogger;

public class DatabaseStatsRepository {
    private static final String TAG = "DatabaseStatsRepository";
    private final SQLiteDatabase database;

    public DatabaseStatsRepository(SQLiteDatabase database) {
        this.database = database;
    }

    public boolean isPaiesqueDbAvailable() {
        String sql = "SELECT name FROM sqlite_master WHERE type='table' AND name=?";
        try (Cursor cursor = database.rawQuery(sql,
                new String[]{AppConstants.PaiesqueTables.HEART_RATES})) {
            return cursor.moveToFirst();
        } catch (Exception e) {
            AppLogger.e(TAG, "Error checking paiesque.db availability", e);
            return false;
        }
    }
}