package org.ojrandom.paiesque.data;

import java.util.ArrayList;
import java.util.List;

public class DailyHeartRates {
    private final List<HeartRateRecord> records;

    public static class HeartRateRecord {
        private final long timestamp;
        private final int heartRate;
        private final int minutesOfDay;

        public HeartRateRecord(long timestamp, int heartRate, int minutesOfDay) {
            this.timestamp = timestamp;
            this.heartRate = heartRate;
            this.minutesOfDay = minutesOfDay;
        }

        public long getTimestamp() { return timestamp; }
        public int getHeartRate() { return heartRate; }
        public int getMinutesOfDay() { return minutesOfDay; }
    }

    public DailyHeartRates(List<HeartRateRecord> records) {
        this.records = records;
    }

    // Method for other uses (like DataManager)
    public List<HeartRateRecord> getRecords() {
        return new ArrayList<>(records); // Return a copy for safety
    }

    // Count method for MainActivity
    public int getCount() {
        return records.size();
    }

}