package org.ojrandom.paiesque.data;

import org.ojrandom.paiesque.data.sync.HuaweiQueryHandler;
import org.ojrandom.paiesque.data.sync.QueryHandler;
import org.ojrandom.paiesque.data.sync.StandardQueryHandler;
import org.ojrandom.paiesque.data.sync.TwoTableQueryHandler;

import java.util.HashMap;
import java.util.Map;

public class AppConstants {
    // Database constants
    public static final String KEY_DB_NAME = "gadgetbridge.db";
    public static final String KEY_PAIESQUE_DB_NAME = "paiesque.db";

    // Preference keys
    public static final String PREFS_NAME = "paiesque_prefs";
    public static final String KEY_DB_PATH = "db_path";
    public static final String KEY_DEVICE = "device";

    public static class Database {
        // Existing tables
        public static final String TABLE_DEVICE = "DEVICE";
        public static final String TABLE_HUAMI_EXTENDED_ACTIVITY_SAMPLE = "HUAMI_EXTENDED_ACTIVITY_SAMPLE";
        public static final String TABLE_HUAWEI_WORKOUT_DATA_SAMPLE = "HUAWEI_WORKOUT_DATA_SAMPLE";
        public static final String TABLE_HUAWEI_ACTIVITY_SAMPLE = "HUAWEI_ACTIVITY_SAMPLE";

        // New manufacturer tables
        public static final String TABLE_BANGLE_JS_ACTIVITY_SAMPLE = "BANGLE_JSACTIVITY_SAMPLE";
        public static final String TABLE_GARMIN_ACTIVITY_SAMPLE = "GARMIN_ACTIVITY_SAMPLE";
        public static final String TABLE_POLAR_H10_ACTIVITY_SAMPLE = "POLAR_H10_ACTIVITY_SAMPLE";
        public static final String TABLE_XIAOMI_ACTIVITY_SAMPLE = "XIAOMI_ACTIVITY_SAMPLE";
        public static final String TABLE_CMF_ACTIVITY_SAMPLE = "CMF_ACTIVITY_SAMPLE";
        public static final String TABLE_CMF_HEART_RATE_SAMPLE = "CMF_HEART_RATE_SAMPLE";
        public static final String TABLE_COLMI_ACTIVITY_SAMPLE = "COLMI_ACTIVITY_SAMPLE";
        public static final String TABLE_COLMI_HEART_RATE_SAMPLE = "COLMI_HEART_RATE_SAMPLE";
        public static final String TABLE_FIT_PRO_ACTIVITY_SAMPLE = "FIT_PRO_ACTIVITY_SAMPLE";
        public static final String TABLE_MI_BAND_ACTIVITY_SAMPLE = "MI_BAND_ACTIVITY_SAMPLE";
        public static final String TABLE_MOYOUNG_ACTIVITY_SAMPLE = "MOYOUNG_ACTIVITY_SAMPLE";
        public static final String TABLE_PINE_TIME_ACTIVITY_SAMPLE = "PINE_TIME_ACTIVITY_SAMPLE";
    }

    // Database column names
    public static class Columns {
        // Common columns
        public static final String TIMESTAMP = "TIMESTAMP";
        public static final String HEART_RATE = "HEART_RATE";
        public static final String DEVICE_ID = "DEVICE_ID";
        public static final String NAME = "NAME";
        public static final String MANUFACTURER = "MANUFACTURER";
        public static final String ID = "_id";
        public static final String IDENTIFIER = "IDENTIFIER";

        public static final String LOCAL_DATE = "calculation_date";
        public static final String ROLLING_PAI_SCORE = "rolling_pai_score";
    }

    // Settings preference keys
    public static class Settings {
        public static final String KEY_DEVICE_SELECTION = "device_selection";
        public static final String KEY_RHR = "resting_heart_rate";
        public static final String KEY_MAX_HR = "max_heart_rate";
        public static final String KEY_SETTINGS_CHANGED = "settings_changed";
    }

    // Sleep settings preference keys
    public static class SleepSettings {
        public static final String KEY_SLEEP_START = "sleep_start_time";
        public static final String KEY_SLEEP_END = "sleep_end_time";
        public static final String KEY_SLEEP_SETTINGS_CHANGED = "sleep_settings_changed";
    }

    public static class Manufacturers {
        // Existing manufacturers
        public static final String HUAWEI = "Huawei";
        public static final String AMAZFIT = "Amazfit";

        // New manufacturers from GadgetBridge source
        public static final String BANGLE_JS = "Bangle.js";
        public static final String GARMIN = "Garmin";
        public static final String POLAR = "Polar";
        public static final String XIAOMI = "Xiaomi";

        // Generic manufacturers
        public static final String CMF = "Cmf";
        public static final String COLMI = "Colmi";
        public static final String FIT_PRO = "FIT_PRO";
        public static final String MI_BAND = "MI_BAND";
        public static final String MOYOUNG = "MOYOUNG";
        public static final String PINE = "Pine";
        public static final String GENERIC = "Generic";

        // Manufacturer configuration with table schemas
        public static Map<String, ManufacturerConfig> getManufacturerConfigs() {
            Map<String, ManufacturerConfig> configs = new HashMap<>();

            // Huawei Workout - Special case for JOIN query (no DEVICE_ID in source table)
            configs.put("HuaweiWorkout", new ManufacturerConfig(
                    new String[]{Database.TABLE_HUAWEI_WORKOUT_DATA_SAMPLE},
                    new String[]{"TIMESTAMP", "HEART_RATE"},  // Only columns that exist in source table
                    HuaweiQueryHandler.class
            ));

            // uses TwoTableQueryHandler
            configs.put(CMF, new ManufacturerConfig(
                    new String[]{Database.TABLE_CMF_ACTIVITY_SAMPLE, Database.TABLE_CMF_HEART_RATE_SAMPLE},
                    new String[]{"TIMESTAMP", "DEVICE_ID", "HEART_RATE"},
                    TwoTableQueryHandler.class
            ));

            // TwoTableQueryHandler
            configs.put(COLMI, new ManufacturerConfig(
                    new String[]{Database.TABLE_COLMI_ACTIVITY_SAMPLE, Database.TABLE_COLMI_HEART_RATE_SAMPLE},
                    new String[]{"TIMESTAMP", "DEVICE_ID", "HEART_RATE"},
                    TwoTableQueryHandler.class
            ));

            // All other manufacturers use the standard handler
            ManufacturerConfig standardConfig = new ManufacturerConfig(
                    null, // Tables populated below
                    new String[]{"TIMESTAMP", "DEVICE_ID", "HEART_RATE"},
                    StandardQueryHandler.class
            );

            configs.put(HUAWEI, standardConfig.withTable(Database.TABLE_HUAWEI_ACTIVITY_SAMPLE));
            configs.put(AMAZFIT, standardConfig.withTable(Database.TABLE_HUAMI_EXTENDED_ACTIVITY_SAMPLE));
            configs.put(BANGLE_JS, standardConfig.withTable(Database.TABLE_BANGLE_JS_ACTIVITY_SAMPLE));
            configs.put(GARMIN, standardConfig.withTable(Database.TABLE_GARMIN_ACTIVITY_SAMPLE));
            configs.put(POLAR, standardConfig.withTable(Database.TABLE_POLAR_H10_ACTIVITY_SAMPLE));
            configs.put(XIAOMI, standardConfig.withTable(Database.TABLE_XIAOMI_ACTIVITY_SAMPLE));
            configs.put(FIT_PRO, standardConfig.withTable(Database.TABLE_FIT_PRO_ACTIVITY_SAMPLE));
            configs.put(MI_BAND, standardConfig.withTable(Database.TABLE_MI_BAND_ACTIVITY_SAMPLE));
            configs.put(MOYOUNG, standardConfig.withTable(Database.TABLE_MOYOUNG_ACTIVITY_SAMPLE));
            configs.put(PINE, standardConfig.withTable(Database.TABLE_PINE_TIME_ACTIVITY_SAMPLE));

            return configs;
        }

        // Dynamic manufacturer discovery
        public static String discoverManufacturer(String deviceName, String manufacturer) {
            if (deviceName == null && manufacturer == null) return GENERIC;

            String searchString = ((deviceName != null ? deviceName : "") + " " +
                    (manufacturer != null ? manufacturer : "")).toLowerCase();

            // Ordered by specificity (most specific first)
            if (searchString.contains("bangle.js")) return BANGLE_JS;
            if (searchString.contains("polar")) return POLAR;
            if (searchString.contains("garmin")) return GARMIN;
            if (searchString.contains("xiaomi") || searchString.contains("mi band")) return XIAOMI;
            if (searchString.contains("cmf")) return CMF;
            if (searchString.contains("colmi")) return COLMI;
            if (searchString.contains("fitpro") || searchString.contains("fit pro")) return FIT_PRO;
            if (searchString.contains("moyoung")) return MOYOUNG;
            if (searchString.contains("pine")) return PINE;
            if (searchString.contains("huawei")) return HUAWEI;
            if (searchString.contains("amazfit")) return AMAZFIT;

            return manufacturer != null ? manufacturer : GENERIC;
        }

        // Configuration class for manufacturer-specific settings
        public static class ManufacturerConfig {
            private final String[] tableNames;
            private final String[] requiredColumns;
            private final Class<? extends QueryHandler> queryHandler;

            public ManufacturerConfig(String[] tableNames, String[] requiredColumns,
                                      Class<? extends QueryHandler> queryHandler) {
                this.tableNames = tableNames;
                this.requiredColumns = requiredColumns;
                this.queryHandler = queryHandler;
            }

            public ManufacturerConfig withTable(String tableName) {
                return new ManufacturerConfig(new String[]{tableName}, requiredColumns, queryHandler);
            }

            // Getters
            public String[] getTableNames() {
                return tableNames;
            }

            public String[] getRequiredColumns() {
                return requiredColumns;
            }

            public Class<? extends QueryHandler> getQueryHandler() {
                return queryHandler;
            }
        }
    }

    public static class PaiesqueTables {
        public static final String HEART_RATES = "HEART_RATES";
        public static final String PAI_SCORES = "PAI_SCORES";
        public static final String PAI_TIMESTAMPS = "PAI_TIMESTAMPS";
        public static final String RHR_VALUES = "RHR_VALUES";
        public static final String RHR_TIMESTAMPS = "RHR_TIMESTAMPS";
        public static final String ROLLING_PAI_HISTORY = "rolling_pai_history";
    }

    // Backup constants
    public static class Backup {
        public static final int BATCH_SIZE = 5000;
        public static final int BUFFER_SIZE = 65536; // 64KB for fast I/O
    }

    // Settings constants
    public static class SettingsTables {
        public static final String APP_SETTINGS = "app_settings";
    }

    public static class SettingsColumns {
        public static final String ID = "id";
        public static final String SETTING_KEY = "setting_key";
        public static final String SETTING_VALUE = "setting_value";
        public static final String SETTING_TYPE = "setting_type";
        public static final String CATEGORY = "category";
        public static final String LAST_MODIFIED = "last_modified";
    }

    public static class SettingsCategories {
        public static final String SLEEP = "sleep";
        public static final String PAI = "pai";
        public static final String GENERAL = "general";
    }

    public static class SettingTypes {
        public static final String INT = "int";
        public static final String STRING = "string";
        public static final String BOOLEAN = "boolean";
    }


    // Zone constants
    public static final String ZONE_50_59 = "zone_50_59";
    public static final String ZONE_60_69 = "zone_60_69";
    public static final String ZONE_70_79 = "zone_70_79";
    public static final String ZONE_80_89 = "zone_80_89";
    public static final String ZONE_90_PLUS = "zone_90_plus";
}