package org.ojrandom.paiesque;

import android.os.Bundle;
import android.webkit.WebView;
import android.webkit.WebSettings;

import androidx.appcompat.app.AppCompatActivity;

public class HelpActivity extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_help);

        WebView webView = findViewById(R.id.webview_help);
        configureWebViewSecurity(webView);

        // Use modern API directly - no need for version checks if minSdk >= 24
        String language = getResources().getConfiguration().getLocales().get(0).getLanguage();

        if ("de".equals(language)) {
            webView.loadUrl("file:///android_asset/gadgetbridge_help_de.html");
        } else {
            webView.loadUrl("file:///android_asset/gadgetbridge_help.html");
        }
    }

    private void configureWebViewSecurity(WebView webView) {
        WebSettings settings = webView.getSettings();

        // Security: Disable JavaScript for local content
        settings.setJavaScriptEnabled(false);

        // Security: Restrict file access
        settings.setAllowFileAccess(true);
        settings.setAllowContentAccess(false);

        // Performance
        settings.setCacheMode(WebSettings.LOAD_NO_CACHE);
    }
}