# PAIesque: An Open-Source Cardiovascular Fitness Tracker for Android

An Android app that helps you **track and improve your cardiovascular health** using your heart rate data. It calculates a **personalized activity score** and monitors your **resting heart rate**, giving you clear, actionable insights into your fitness progress - all, with no subscriptions or data sharing.

**How It Works:**

PAIesque is inspired by public research from the [NTNU Cardiac Exercise Research Group (CERG)](https://www.ntnu.edu/cerg). Their foundational studies on the PAI (Personal Activity Intelligence) metric demonstrated a powerful finding:

> Our **research** shows that those who achieve **100 PAI** or more every week over time **live on average eight years longer** than others.

While PAIesque does **NOT** use the official **PAI®** algorithm (that is not known anyway), it applies this same, powerful principle: **Your score rises faster when your heart works harder** - so both long brisk walks and vigorous workouts move you toward your goal.

**Key Differentiators:**

*   **Open & Transparent:** Unlike “black box” scores, every calculation is based on the disclosed [Karvonen Heart Rate Reserve](https://www.omnicalculator.com/health/karvonen-formula) (HRR) method in combination with a simplified [Training Impulse Calculation](https://www.firstbeat.com/en/blog/what-is-trimp) (TRIMP). You always know how your score is determined.
*   **Universal & Consistent:** Use it with almost any fitness tracker supported by [Gadgetbridge](https://gadgetbridge.org/) (Amazfit, Garmin, Xiaomi, Fitbit, 100+ devices). Your scoring method [stays the same](https://codeberg.org/ojrandom/paiesque/wiki/Why-a-Consistent-Standard-Matters) even if you change devices.
*   **Privacy-First & Local:** Everything is processed on your phone. Your heart rate data never leaves your device, and no internet connection or account is required.

**Note:** This is an independent, community-developed application. It is based on publicly available scientific research but is **not affiliated with or endorsed by NTNU CERG**, and its score is distinct from the proprietary **Personal Activity Intelligence (PAI®)** metric.

[Screenshots](https://codeberg.org/ojrandom/paiesque/wiki)

<div align="center">

|                                                                                                                                            Main Screen                                                                                                                                            |                                                                                                                                          Intensity Zones                                                                                                                                          |                                                                                                                                               Trend                                                                                                                                               |                                                                                                                                               Trend                                                                                                                                               |                                                                                                                                              Devices                                                                                                                                              |                                                                                                                                      Fitness Score Settings                                                                                                                                       |                                                                                                                                           RHR Settings                                                                                                                                            |
|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|
| <a href="https://codeberg.org/ojrandom/paiesque/raw/branch/main/fastlane/metadata/android/en-US/images/phoneScreenshots/01.png" target="_blank"><img src="https://codeberg.org/ojrandom/paiesque/raw/branch/main/fastlane/metadata/android/en-US/images/phoneScreenshots/01.png" width="150"></a> | <a href="https://codeberg.org/ojrandom/paiesque/raw/branch/main/fastlane/metadata/android/en-US/images/phoneScreenshots/02.png" target="_blank"><img src="https://codeberg.org/ojrandom/paiesque/raw/branch/main/fastlane/metadata/android/en-US/images/phoneScreenshots/02.png" width="150"></a> | <a href="https://codeberg.org/ojrandom/paiesque/raw/branch/main/fastlane/metadata/android/en-US/images/phoneScreenshots/03.png" target="_blank"><img src="https://codeberg.org/ojrandom/paiesque/raw/branch/main/fastlane/metadata/android/en-US/images/phoneScreenshots/03.png" width="150"></a> | <a href="https://codeberg.org/ojrandom/paiesque/raw/branch/main/fastlane/metadata/android/en-US/images/phoneScreenshots/04.png" target="_blank"><img src="https://codeberg.org/ojrandom/paiesque/raw/branch/main/fastlane/metadata/android/en-US/images/phoneScreenshots/04.png" width="150"></a> | <a href="https://codeberg.org/ojrandom/paiesque/raw/branch/main/fastlane/metadata/android/en-US/images/phoneScreenshots/05.png" target="_blank"><img src="https://codeberg.org/ojrandom/paiesque/raw/branch/main/fastlane/metadata/android/en-US/images/phoneScreenshots/05.png" width="150"></a> | <a href="https://codeberg.org/ojrandom/paiesque/raw/branch/main/fastlane/metadata/android/en-US/images/phoneScreenshots/06.png" target="_blank"><img src="https://codeberg.org/ojrandom/paiesque/raw/branch/main/fastlane/metadata/android/en-US/images/phoneScreenshots/06.png" width="150"></a> | <a href="https://codeberg.org/ojrandom/paiesque/raw/branch/main/fastlane/metadata/android/en-US/images/phoneScreenshots/07.png" target="_blank"><img src="https://codeberg.org/ojrandom/paiesque/raw/branch/main/fastlane/metadata/android/en-US/images/phoneScreenshots/07.png" width="150"></a> |
|                                                                                                                                             *Summary*                                                                                                                                             |                                                                                                                                          *Zone Analysis*                                                                                                                                          |                                                                                                                                              *7-day*                                                                                                                                              |                                                                                                                                             *30-day*                                                                                                                                              |                                                                                                                                             *Devices*                                                                                                                                             |                                                                                                                                       *Heart Rate Reserve*                                                                                                                                        |                                                                                                                                       *RHR Masurement Time*                                                                                                                                       |

</div>[format.html](../../dev/format.html)

## Installation

### 1. Prerequisite - Gadgetbridge

#### a. Install and configure [Gadgetbridge](https://f-droid.org/packages/nodomain.freeyourgadget.gadgetbridge/)

...to read heart rate data from your fitness tracker / wearable.

#### b. Enable automatic Export

<div align="center">

|                                                                                                                                           Gadgetbridge                                                                                                                                            |                                                                                                                                           Gadgetbridge                                                                                                                                            |                                                                                                                                           Gadgetbridge                                                                                                                                            |                                                                                                                                           Gadgetbridge                                                                                                                                            |                                                                                                                                           Gadgetbridge                                                                                                                                            |                                                                                                                                             PAIesque                                                                                                                                              |
|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|
| <a href="https://codeberg.org/ojrandom/paiesque/raw/branch/main/fastlane/metadata/android/en-US/images/phoneScreenshots/09.png" target="_blank"><img src="https://codeberg.org/ojrandom/paiesque/raw/branch/main/fastlane/metadata/android/en-US/images/phoneScreenshots/09.png" width="150"></a> | <a href="https://codeberg.org/ojrandom/paiesque/raw/branch/main/fastlane/metadata/android/en-US/images/phoneScreenshots/10.png" target="_blank"><img src="https://codeberg.org/ojrandom/paiesque/raw/branch/main/fastlane/metadata/android/en-US/images/phoneScreenshots/10.png" width="150"></a> | <a href="https://codeberg.org/ojrandom/paiesque/raw/branch/main/fastlane/metadata/android/en-US/images/phoneScreenshots/11.png" target="_blank"><img src="https://codeberg.org/ojrandom/paiesque/raw/branch/main/fastlane/metadata/android/en-US/images/phoneScreenshots/11.png" width="150"></a> | <a href="https://codeberg.org/ojrandom/paiesque/raw/branch/main/fastlane/metadata/android/en-US/images/phoneScreenshots/12.png" target="_blank"><img src="https://codeberg.org/ojrandom/paiesque/raw/branch/main/fastlane/metadata/android/en-US/images/phoneScreenshots/12.png" width="150"></a> | <a href="https://codeberg.org/ojrandom/paiesque/raw/branch/main/fastlane/metadata/android/en-US/images/phoneScreenshots/13.png" target="_blank"><img src="https://codeberg.org/ojrandom/paiesque/raw/branch/main/fastlane/metadata/android/en-US/images/phoneScreenshots/13.png" width="150"></a> | <a href="https://codeberg.org/ojrandom/paiesque/raw/branch/main/fastlane/metadata/android/en-US/images/phoneScreenshots/14.png" target="_blank"><img src="https://codeberg.org/ojrandom/paiesque/raw/branch/main/fastlane/metadata/android/en-US/images/phoneScreenshots/14.png" width="150"></a> |
|                                                                                                                                          *Open Settings*                                                                                                                                          |                                                                                                                                        *Open Automations*                                                                                                                                         |                                                                                                                                    *Open Auto export database*                                                                                                                                    |                                                                                                                                    *Enable + Export Location*                                                                                                                                     |                                                                                                                                       *Run AutoExport Now*                                                                                                                                        |                                                                                                                                      *Import into PAIesque*                                                                                                                                       |

</div>

### 2. For Users: Install the App

Cardiovascular Fitness Tracker is available on [**F-Droid**](https://f-droid.org/packages/org.ojrandom.paiesque/) - the free and open-source app store:

[<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png" alt="Get it on F-Droid" height="80">](https://f-droid.org/packages/org.ojrandom.paiesque/)

**Recommended for most users** - automatic updates, verified builds, and easy installation.

As an alternative to F-Droid, you could use apps like [Obtainium](https://f-droid.org/de/packages/dev.imranr.obtainium.fdroid/).

### 3. For Developers: Build from Source

If you want to contribute, test development versions, or customize the app:

```
git clone https://codeberg.org/ojrandom/paiesque
cd paiesque
./gradlew assembleDebug
```


## Overview

This application focuses on two key health metrics:

- **Cardiovascular Fitness Score**: A direct, simplified application of the [HRR](https://www.omnicalculator.com/health/karvonen-formula) based [Training Impulse](https://www.firstbeat.com/en/blog/what-is-trimp) (TRIMP) method to model cardiovascular stress linked to long-term mortality risk
- **RHR Analysis**: Resting heart rate tracking and trends from your device data.

### Research-Backed Methodology

This implementation follows research principles from the **[NTNU Cardiac Exercise Research Group](https://www.ntnu.edu/cerg) (CERG)**:

- **Primary Research**: Based on the Nord-Trøndelag Health Study (HUNT) tracking over 45,000
  participants
- **Independent Validation**: Confirmed in the Aerobics Center Longitudinal Study with 56,000
  participants followed for 15 years
- **Health Benefits**: Maintaining 100+ Points weekly is associated with reduced cardiovascular disease
  risk

> **Disclaimer**: This is an independent implementation based on published research principles. It is not affiliated with or endorsed by NTNU CERG. For official PAI scores, use authorized applications. *PAI® is a registered trademark.*

## Why Choose This App?

### Universal Standard Across Devices

- **Device Independence**: Get [consistent scores](https://codeberg.org/ojrandom/paiesque/wiki/Why-a-Consistent-Standard-Matters) regardless of your fitness tracker model.
- **Manufacturer-Agnostic**: Works with any device supported by Gadgetbridge (Amazfit, Fitbit, Huawei, Xiaomi, and many more).
- **Data Consistency**: Same calculation method applied to all your historical data.

See this [dedicated page](https://codeberg.org/ojrandom/paiesque/wiki/Why-a-Consistent-Standard-Matters) for a practical demonstration of the problem.

### Open & Transparent

- **Open Source**: Full visibility into the algorithms and calculations.
- **No Black Box**: Understand exactly how your scores are calculated.
- **Community-Driven**: Developed openly with community input and review.

### Privacy-First

- **Local Processing**: All calculations happen on your device—no cloud dependency.
- **Your Data Stays Yours**: Heart rate data never leaves your phone.
- **Offline Capable**: Works completely without an internet connection.

## Tested Devices & Wearables

This app works with any device supported by Gadgetbridge. The following devices have been specifically tested:

### Confirmed Working

- **Garmin**: Fenix 7 Pro, Vivoactiv 5, HRM-Pro Plus ([low resolution data](https://codeberg.org/Freeyourgadget/Gadgetbridge/issues/5614) only)
- **Amazfit**: Bip U, Band 5/7, Active 2 (Round), Helio Strap ([low resolution data](https://codeberg.org/Freeyourgadget/Gadgetbridge/issues/5617) only)
- **Xiaomi**: Mi Smart Band 6
- **Huawei**: Watch Fit 4 Pro
- **Colmi**: R09, R02
- **Pine64** [PineTime](https://pine64.org/devices/pinetime/)

### 🌐 All Gadgetbridge-Compatible Devices

Since the app uses Gadgetbridge for data import, it should work with [all 100+ devices supported by Gadgetbridge](https://codeberg.org/Freeyourgadget/Gadgetbridge/wiki/Devices).

Want to **add your device**? Test the app with your wearable and:
- open an [issue](https://codeberg.org/ojrandom/paiesque/issues), or
- submit a merge request via git to update this list!

### Bonus Privacy

Devices that allow you to disable Bluetooth to prevent tracking:
- Amazfit Active 2 (Round)

Use [BLE Radar](https://f-droid.org/packages/f.cking.software/) to check what data your devices broadcast.

## Data Flow

```
Your fitness tracker
    ↓ (read by Gadgetbridge)
Gadgetbridge.db
    ↓ (file copy by app)
gadgetbridge.db (read-only)
    ↓ (data sync by app)  
app.db (read-write)
    ├── Heart rate data
    ├── Fitness score calculations 
    ├── RHR calculations
    └── App settings
```

## Calculation Details

### Scientific Foundation

The algorithm translates physiological stress on the cardiovascular system (heart rate over time) into a quantified score. This is based on the established [Karvonen](https://www.omnicalculator.com/health/karvonen-formula) (HRR) method, a standard in exercise science for personalizing intensity, and is similar in concept to foundational training load models like [TRIMP](https://www.firstbeat.com/en/blog/what-is-trimp).

### Core Formula

The score is calculated using **Heart Rate Reserve** (HRR) **Intensity**:

Heart Rate Reserve

    HRR = maxHR - RHR

Intensity

    Intensity = (HR - RHR) / (maxHR - RHR)

*HR... heart rate*  
*RHR... resting heart rate*  
*maxHR... maximum heart rate*  
*HRR... heart rate reserve*

### Intensity to Points Mapping

| Intensity Band | Points per Minute |
|----------------|----------------|
| < 50% HRR      | 0.0            |
| 50-59% HRR     | 0.2            |
| 60-69% HRR     | 0.5            |
| 70-79% HRR     | 1.0            |
| 80-89% HRR     | 1.5            |
| ≥90% HRR       | 2.0            |

### Daily and Weekly Calculation

- **Daily Points**: Sum of all second-by-second points.
- **7-Day Score**: Rolling sum of the last 7 days' points.

### Core Algorithm of Fitness Score

```mermaid
flowchart TD
    Start[Start with HR Data] --> Pairs[Process HR Point Pairs]
    
    Pairs --> ForEach[For each consecutive pair A→B]
    
    ForEach --> Check{Is time gap valid?<br>0 < seconds ≤ 300}
    
    Check -->|NO<br>Too large or zero| Skip[Skip: Invalid interval]
    
    Check -->|YES<br>Valid range| Math[Math Operations:<br>• HR change per second<br>• Find zone boundaries crossed]
    
    Skip --> NextCheck{More pairs?}
    
    Math --> Split[Split at boundaries<br>Where HR changes zones]
    
    Split --> Distribute[Add time to<br>each zone bucket]
    
    Distribute --> NextCheck
    
    NextCheck -->|YES| ForEach
    
    NextCheck -->|NO| Multiply[Final Calculation:<br>Zone time × points/min]
    
    Multiply --> Result[Output: Daily Points Result<br>with total + breakdown]
    
    style Skip fill:#ffebee,stroke:#c62828
    style Math fill:#e8f5e8,stroke:#2e7d32
    style Check fill:#fff3e0,stroke:#f57c00
```

### How It Works- Example Calculation

```mermaid
flowchart TD
    Profile[User Profile:<br>RHR=60, MaxHR=200] --> Calculate[Calculate Personal Zones]
    
    Calculate --> Zones[Personal Zones:<br>• Zone 0: <130 bpm ─ 0.0 Points/min<br>• Zone 1: 130-144 ─ 0.2 Points/min<br>• Zone 2: 144-158 ─ 0.5 Points/min<br>• Zone 3: 158-172 ─ 1.0 Points/min<br>• Zone 4: 172-186 ─ 1.5 Points/min<br>• Zone 5: >186 ─ 2.0 Points/min<br>]
    
    Zones --> Match[Match HR Data to Zones]
    
    Data[HR Data: 130→160 in 120s] --> Match
    
    Match --> Interpolate[Interpolate: Find when<br>130→144→158→160]
    
    Interpolate --> Distribute[56s Zone2 + 56s Zone3 + 8s Zone4]
    
    Distribute --> Score[Score: 0.787 Points<br>56s@0.2/min + 56s@0.5/min + 8s@1.0/min]
```

### Implementing Core Classes

- [PAIesqueCalculator.java](https://codeberg.org/ojrandom/paiesque/src/branch/main/app/src/main/java/org/ojrandom/paiesque/pai/PAIesqueCalculator.java)
- [SimpleRHRCalculator.java](https://codeberg.org/ojrandom/paiesque/src/branch/main/app/src/main/java/org/ojrandom/paiesque/rhr/SimpleRHRCalculator.java)

## Gadgetbridge Integration

The [core calculation class](https://codeberg.org/ojrandom/paiesque/src/branch/main/app/src/main/java/org/ojrandom/paiesque/pai/PAIesqueCalculator.java) could be a candidate for Gadgetbridge integration. There was a feature request to add similar functionality to Gadgetbridge: [Add support to PAI Health](https://codeberg.org/Freeyourgadget/Gadgetbridge/issues/1905).

### Why a Consistent Standard Matters

This calculator addresses a gap in wearable ecosystems: [consistent](https://codeberg.org/ojrandom/paiesque/wiki/Why-a-Consistent-Standard-Matters) health scoring across different devices. Unlike manufacturer-specific solutions, this app provides:

- **Cross-Platform Consistency**: Same calculation whether you switch devices.
- **Historical Comparability**: Compare your fitness progress even when changing devices.
- **No Vendor Lock-in**: Your health data isn't trapped in proprietary platforms.

## Similar Products

- [Mia Health by NTNU](https://miahealth.no/en/about-mia) (Note: Uses a newer AQ algorithm)
- [Strava's fitness score](https://support.strava.com/hc/en-us/articles/360032451811-Fitness)
- [Garmin's Intensity Minutes](https://www.garmin.com/en-US/garmin-technology/health-science/intensity-minutes/)

## Comparison of Fitness Scoring Systems and Methods

### 1. Comparison of Specific Fitness Scoring Systems

The following table details specific systems, including the community-developed PAIesque app, comparing their formulas, heart rate methods, and practical aspects like transparency and cost.

| Feature / System | Heart Rate Zone & Point Calculation | Heart Rate Zone Basis (HRR Clarification) | Primary Purpose | Accessibility, Transparency & Limitations |
| :--- | :--- | :--- | :--- | :--- |
| **Personal Activity Intelligence (PAI)** | **Formula not public.** Accumulates points based on heart rate above a personalized threshold over a **7-day rolling period**. Points are not linear; higher intensity yields points faster. | Uses a **personalized model** based on age, sex, resting HR, and max HR. Likely uses **Heart Rate Reserve (HRR)** as a core component. | **Long-term health outcome.** Backed by research linking a **weekly score of 100+** to reduced mortality risk. | **Proprietary/Black Box.** Official metric now via **Mia Health app** (subscription-based). Requires specific compatible devices or app. |
| **PAIesque App** | **Formula fully disclosed.** <br>**1.** `Intensity = (HR - RHR) / (maxHR - RHR)` <br>**2.** Points per minute mapped to **6 HRR% bands** (e.g., 50-59% HRR = 0.2, ≥90% HRR = 2.0). <br>**3**. Rolling 7-day sum. | Based on **Heart Rate Reserve (HRR)**: `HRR = maxHR - RHR`. Zones are defined as percentages of this **personalized reserve** (e.g., 50-59% HRR). | **Independent, research-based health tracking.** Provides a transparent, device-agnostic PAI-like score. | **Open Source & Transparent.** All calculations are visible. **Free, no subscription.** Requires technical setup with **Gadgetbridge**. Device-agnostic. |
| **Fitbit Active Zone Minutes** | Points accrue for time spent in 3 zones: <br>• **Fat Burn** (> 40% HRR): 1x point/min. <br>• **Cardio** (> 70% HRR): 2x points/min. <br>• **Peak** (> 85% HRR): 2x points/min. | Uses **Heart Rate Reserve (HRR)** for personalized zones. Max HR often uses the **Tanaka method** (`208 - 0.7 × age`). | **Meeting weekly activity guidelines.** Goal is **≥150 AZM/week** (aligned with WHO). | **Proprietary but clear.** Zone logic is published. Requires **Fitbit device & app** (subscription for full insights). |
| **Garmin Intensity Minutes** | Points for time in 2 levels: <br>• **Moderate** (≥ 50% HRR / 64% Max HR): 1x minute. <br>• **Vigorous** (≥ 70% HRR / 77% Max HR): 2x minutes. Goal is 150+ min/week. | **User-configurable basis:** <br>1. **% of HRR** (Karvonen method). <br>2. % of Max HR. <br>3. % of **Lactate Threshold** (most accurate for performance). | **Guideline-based activity tracking & training.** Integrates with Garmin's broader training ecosystem. | **Proprietary but flexible.** User can choose and customize the calculation basis. Requires **Garmin device**. |
| **Strava Relative Effort** | **Not zone-based.** Calculates a **composite score**: `Relative Effort = (Normalized Graded Heart Rate as % of HRR)² × Duration`. Vigorous efforts are **exponentially weighted**. | Relies on **Heart Rate Reserve (HRR)** to normalize effort. Requires accurate user profiles for Max HR and Resting HR. | **Athletic training load management.** Quantifies workout strain to balance training and prevent overtraining. | **Proprietary formula.** Algorithm is not public. Requires a **heart rate monitor** and **Strava subscription** for full analysis. |

### 2. Foundational Exercise Intensity Methods

These are the general, science-based methods used in medical studies and by professionals to prescribe and analyze exercise. The systems above are often built upon these principles.

| Method | Core Principle & Formula | Heart Rate Basis | Primary Application | Relation to Scoring Systems |
| :--- | :--- | :--- | :--- | :--- |
| **Karvonen Method (HRR)** | **Calculates Target HR Zone**: `Target HR = [(Max HR - Resting HR) × %Intensity] + Resting HR`. Personalizes intensity based on individual reserve capacity. | **Heart Rate Reserve (HRR)**: `HRR = Max HR - Resting HR`. This is the **standard medical/physiological definition**. | **Clinical exercise prescription, personalized training zones.** The gold standard for personalization. | **Foundation for PAIesque, Fitbit, and Garmin's HRR mode.** PAI's model is almost certainly based on HRR principles. |
| **Percent of Max Heart Rate** | **Simpler Target HR**: `Target HR = Max HR × %Intensity`. Uses a fixed percentage of theoretical maximum. | **Maximum Heart Rate (HRmax)**: Often estimated by formulas like `220 - age` (less accurate). | **General fitness guidance, population-level recommendations.** | **Garmin offers this as a simpler option.** Less personalized than HRR. |
| **Training Impulse (TRIMP)** | **Quantifies Training Load**: Original `TRIMP = Duration (min) × ΔHR Ratio × Gender Factor`. `ΔHR Ratio = (Exercise HR - Resting HR) / (Max HR - Resting HR)`. | Based on **Heart Rate Reserve (HRR)** for the ΔHR Ratio component. A foundational model for internal load. | **Sports science research, periodization for athletes.** | **Historical Context:** Strava's Relative Effort and PAI's algorithm are sophisticated evolutions of this HRR-based load concept. PAIesque is a direct, simplified application. |
| **Rating of Perceived Exertion (RPE)** | **Subjective Intensity Scale**: The Borg Scales (e.g., 6-20 or 0-10) where you self-report how hard you feel you are working. | **Not heart rate based.** Correlates with heart rate and lactate. Validates subjective effort. | **Clinical settings, complementing HR data.** Used for a complete picture when HR monitoring is impractical. | **Context:** Even precise systems like PAI can be validated against RPE. It's a reminder that internal feeling matters alongside metrics. |

### 3. Key Insights and Summary

*   **Formula Transparency**: **PAIesque** is unique in providing a fully disclosed formula, acting as an open-source reference implementation. The official **PAI** and **Strava** algorithms are proprietary "black boxes," while **Fitbit** and **Garmin** publish their zone logic but not their full scoring engines.
*   **Heart Rate Reserve (HRR) in Practice**: While **PAIesque, Fitbit, and Strava** all use the standard HRR (`Max HR - Resting HR`), they apply it differently:
    *   **PAIesque & Fitbit**: Use HRR to define fixed percentage zones for linear point accrual.
    *   **Strava**: Uses HRR as a normalization factor in a complex, **non-linear, exponential equation**.
    *   **Garmin**: Offers the most user choice, including the gold-standard **Lactate Threshold** for athletes.
*   **Purpose & Philosophy**: Systems are optimized for different goals:
    *   **Health Outcome (PAI, PAIesque)**: Use HRR to model cardiovascular stress linked to long-term mortality risk.
    *   **Guideline Adherence (Fitbit, Garmin)**: Use HRR/%Max HR to track time spent meeting public health activity recommendations (e.g., 150 min/week).
    *   **Performance Management (Strava, Garmin Lactate)**: Use HRR or more advanced metrics to quantify training load and optimize athletic performance, emphasizing high-intensity work.
*   **Access Models**: There is a trade-off between convenience, cost, and control:
    *   **Commercial/Proprietary (PAI/Mia, Fitbit, Garmin, Strava)**: Easier setup, integrated hardware/software, but often require specific devices, subscriptions, and lock you into an ecosystem.
    *   **Open/Community (PAIesque)**: Free, transparent, and device-agnostic, granting full data ownership. The cost is a more technical setup process (using Gadgetbridge).

**Conclusion:** Choosing a system depends on whether your primary goal is **long-term health** (PAI/PAIesque), **meeting activity guidelines** (Fitbit/Garmin), or **athletic performance** (Strava/Garmin), and how much you value **transparency and data control** (PAIesque) versus **convenience and integration** (commercial platforms). Understanding the foundational HRR and TRIMP concepts reveals how most modern scores are interconnected evolutions of core exercise science principles.

## For Developers: Setup & Building

### Prerequisites

- Android Studio (latest version recommended)
- JDK 11 or higher
- Android SDK Platform 33 or higher
- Git

### Build from Source

#### Clone the repository

    git clone https://codeberg.org/ojrandom/paiesque
    cd paiesque

#### Open in Android Studio

    android-studio .

#### Or build from command line

    ./gradlew assembleDebug

## References & Research

- **Heart Rate Reserve Research**: [NTNU CERG](https://www.ntnu.edu/cerg)
- **Mia Health**: [by NTNU](https://miahealth.no/en/about-mia)
- **Original Study**: Nes et al. (The HUNT Study) - Cardiovascular Health Benefits

## License

MIT License

Copyright (c) 2025

*This implementation is provided for educational and research purposes based on publicly available scientific principles.*

## Contributing

Contributions are welcome! Please feel free to submit pull requests or open issues for:

- Bug fixes
- Performance improvements
- Enhanced documentation
- Translations
- Gadgetbridge integration progress

---

**Maintainer**: OJ Random  
**License**: MIT  
**Status**: Active Development
