package org.nuclearfog.smither.ui.adapter.recyclerview.holder;

import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.RecyclerView.ViewHolder;

import org.nuclearfog.smither.R;
import org.nuclearfog.smither.config.GlobalSettings;
import org.nuclearfog.smither.model.Account;
import org.nuclearfog.smither.utils.AppStyles;
import org.nuclearfog.smither.utils.ImageWorker;
import org.nuclearfog.smither.utils.StringUtils;

/**
 * item holder for a user login item
 *
 * @author nuclearfog
 * @see org.nuclearfog.smither.ui.adapter.recyclerview.AccountAdapter
 */
public class AccountHolder extends ViewHolder implements OnClickListener {

	private static final int EMPTY_COLOR = 0x2F000000;

	private ImageView profile;
	private ImageButton remove;
	private TextView screenName, date;
	private Drawable placeholder;

	private OnHolderClickListener listener;
	private GlobalSettings settings;
	private ImageWorker imageWorker;

	/**
	 *
	 */
	public AccountHolder(ViewGroup parent, OnHolderClickListener listener) {
		super(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_account, parent, false));
		settings = GlobalSettings.get(parent.getContext());
		imageWorker = ImageWorker.get(parent.getContext());
		this.listener = listener;

		screenName = itemView.findViewById(R.id.item_account_screenname);
		date = itemView.findViewById(R.id.item_account_date);
		remove = itemView.findViewById(R.id.item_account_remove);
		profile = itemView.findViewById(R.id.item_account_profile);
		placeholder = new ColorDrawable(EMPTY_COLOR);

		AppStyles.setTheme((ViewGroup) itemView);

		itemView.setOnClickListener(this);
		remove.setOnClickListener(this);
	}


	@Override
	public void onClick(View v) {
		int position = getLayoutPosition();
		if (position != RecyclerView.NO_POSITION) {
			if (v == itemView) {
				listener.onItemClick(position, OnHolderClickListener.ACCOUNT_SELECT);
			} else if (v == remove) {
				listener.onItemClick(position, OnHolderClickListener.ACCOUNT_REMOVE);
			}
		}
	}

	/**
	 * set view content
	 *
	 * @param account content
	 */
	public void setContent(Account account) {
		date.setText(StringUtils.formatCreationTime(itemView.getResources(), account.getTimestamp()));
		// set profile information
		screenName.setText(account.getScreenName());
		// set profile image
		String profileImageUrl = account.getProfileImageUrl();
		if (settings.imagesEnabled() && !profileImageUrl.isEmpty()) {
			imageWorker.loadProfileImage(profile, profileImageUrl);
		} else {
			profile.setImageDrawable(placeholder);
		}
		switch (account.getConfiguration()) {
			case MASTODON:
				String host = account.getHostname();
				if (host.startsWith("https://"))
					host = host.substring(8);
				screenName.append(" @" + host);
				break;
		}
	}
}