package org.nuclearfog.smither.notification;

import android.content.Context;

import org.nuclearfog.smither.BuildConfig;
import org.nuclearfog.smither.config.GlobalSettings;
import org.nuclearfog.smither.utils.StringUtils;
import org.unifiedpush.android.connector.RegistrationDialogContent;
import org.unifiedpush.android.connector.UnifiedPush;

import java.util.ArrayList;

/**
 * Unified push subscription manager class
 *
 * @author nuclearfog
 */
public class PushSubscription {

	/**
	 * subscribe to unified push service using app settings
	 * push messages will be then received by {@link PushNotificationReceiver}
	 */
	public static void subscribe(Context context) {
		GlobalSettings settings = GlobalSettings.get(context);
		if (settings.isLoggedIn() && settings.getLogin().getConfiguration().isWebPushSupported()) {
			try {
				ArrayList<String> features = new ArrayList<>(1);
				features.add(UnifiedPush.FEATURE_BYTES_MESSAGE);
				// create unique push identifier for a single login
				String instance = StringUtils.getPushInstanceHash(settings.getLogin());
				UnifiedPush.registerAppWithDialog(context, instance, new RegistrationDialogContent(), features, "");
			} catch (Exception exception) {
				// thrown when ntfy-app was not found
				if (BuildConfig.DEBUG) {
					exception.printStackTrace();
				}
			}
		}
	}

	/**
	 * unregister from unified push
	 */
	public static void unsubscribe(Context context) {
		GlobalSettings settings = GlobalSettings.get(context);
		if (settings.isLoggedIn() && settings.getLogin().getConfiguration().isWebPushSupported()) {
			try {
				UnifiedPush.unregisterApp(context.getApplicationContext(), settings.getWebPush().getHost());
			} catch (Exception exception) {
				// thrown when ntfy-app was not found
				if (BuildConfig.DEBUG) {
					exception.printStackTrace();
				}
			}
		}
	}
}