package org.nuclearfog.smither.database.impl;

import android.database.Cursor;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import org.nuclearfog.smither.database.DatabaseAdapter.NotificationTable;
import org.nuclearfog.smither.model.Account;
import org.nuclearfog.smither.model.Notification;
import org.nuclearfog.smither.model.Status;
import org.nuclearfog.smither.model.User;

/**
 * Database implementation of a notification
 *
 * @author nuclerfog
 */
public class DatabaseNotification implements Notification, NotificationTable {

	private static final long serialVersionUID = 436155941776152806L;

	private long id, timestamp, itemId;
	private int type;

	private User user;
	@Nullable
	private Status status;

	/**
	 * @param cursor  database cursor containing Notification table column
	 * @param account current user information
	 */
	public DatabaseNotification(Cursor cursor, Account account) {
		user = new DatabaseUser(cursor, account);
		id = cursor.getLong(cursor.getColumnIndexOrThrow(ID));
		itemId = cursor.getLong(cursor.getColumnIndexOrThrow(ITEM));
		type = cursor.getInt(cursor.getColumnIndexOrThrow(TYPE));
		timestamp = cursor.getLong(cursor.getColumnIndexOrThrow(TIME));
	}


	@Override
	public long getId() {
		return id;
	}


	@Override
	public int getType() {
		return type;
	}


	@Override
	public long getTimestamp() {
		return timestamp;
	}


	@Override
	public User getUser() {
		return user;
	}


	@Nullable
	@Override
	public Status getStatus() {
		return status;
	}

	/**
	 * attach status information
	 *
	 * @param status status information
	 */
	public void addStatus(Status status) {
		this.status = status;
	}

	/**
	 * get ID of the attached item (user/status ID)
	 *
	 * @return item ID
	 */
	public long getItemId() {
		return itemId;
	}


	@Override
	public boolean equals(@Nullable Object obj) {
		if (!(obj instanceof Notification))
			return false;
		return ((Notification) obj).getId() == getId();
	}


	@NonNull
	@Override
	public String toString() {
		return "id=" + getId() + " " + getUser();
	}
}