package org.nuclearfog.smither.backend.async;

import android.content.Context;

import androidx.annotation.NonNull;

import org.nuclearfog.smither.backend.api.Connection;
import org.nuclearfog.smither.backend.api.ConnectionException;
import org.nuclearfog.smither.backend.api.ConnectionManager;
import org.nuclearfog.smither.model.lists.Rules;

/**
 * Loader class used to load instance rules
 *
 * @author nuclearfog
 * @see org.nuclearfog.smither.ui.dialogs.ReportDialog
 */
public class RuleLoader extends AsyncExecutor<Void, Rules> {

	private Connection connection;

	/**
	 *
	 */
	public RuleLoader(Context context) {
		connection = ConnectionManager.getDefaultConnection(context);
	}


	@Override
	protected Rules doInBackground(@NonNull Void param) {
		try {
			return connection.getRules();
		} catch (ConnectionException exception) {
			return null;
		}
	}
}