package org.nuclearfog.smither.backend.async;

import android.content.Context;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import org.nuclearfog.smither.backend.api.Connection;
import org.nuclearfog.smither.backend.api.ConnectionException;
import org.nuclearfog.smither.backend.api.ConnectionManager;
import org.nuclearfog.smither.backend.helper.update.ReportUpdate;

/**
 * status/user report updater
 *
 * @author nuclearfog
 * @see org.nuclearfog.smither.ui.dialogs.ReportDialog
 */
public class ReportUpdater extends AsyncExecutor<ReportUpdate, ReportUpdater.Result> {

	private Connection connection;

	/**
	 *
	 */
	public ReportUpdater(Context context) {
		connection = ConnectionManager.getDefaultConnection(context);
	}


	@Override
	protected Result doInBackground(@NonNull ReportUpdate param) {
		try {
			connection.createReport(param);
			return new Result(null);
		} catch (ConnectionException exception) {
			return new Result(exception);
		}
	}

	/**
	 *
	 */
	public static class Result {

		@Nullable
		public final ConnectionException exception;

		Result(@Nullable ConnectionException exception) {
			this.exception = exception;
		}
	}
}