package org.nuclearfog.smither.backend.async;

import android.content.Context;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import org.nuclearfog.smither.backend.api.Connection;
import org.nuclearfog.smither.backend.api.ConnectionException;
import org.nuclearfog.smither.backend.api.ConnectionManager;
import org.nuclearfog.smither.config.GlobalSettings;
import org.nuclearfog.smither.database.AppDatabase;
import org.nuclearfog.smither.model.Credentials;
import org.nuclearfog.smither.model.User;

/**
 * Async-loader used to load information about the current user
 *
 * @author nuclearfog
 */
public class CredentialsLoader extends AsyncExecutor<Void, CredentialsLoader.Result> {

	private Connection connection;
	private GlobalSettings settings;
	private AppDatabase db;


	public CredentialsLoader(Context context) {
		db = new AppDatabase(context);
		connection = ConnectionManager.getDefaultConnection(context);
		settings = GlobalSettings.get(context);
	}


	@Override
	protected Result doInBackground(@NonNull Void param) {
		try {
			Credentials credentials = connection.getCredentials();
			User user = connection.showUser(settings.getLogin().getId());
			db.updateCurrentLogin(user);
			return new Result(user, credentials, null);

		} catch (ConnectionException exception) {
			return new Result(null, null, exception);
		}
	}

	/**
	 *
	 */
	public static class Result {

		@Nullable
		public final User user;
		@Nullable
		public final Credentials credentials;
		@Nullable
		public final ConnectionException exception;

		/**
		 * @param user        current user's information or null if an error occurred
		 * @param credentials current user's credentials or null if an error occurred
		 */
		public Result(@Nullable User user, @Nullable Credentials credentials, @Nullable ConnectionException exception) {
			this.exception = exception;
			this.credentials = credentials;
			this.user = user;
		}
	}
}