package org.nuclearfog.smither;

import android.app.Application;

import org.nuclearfog.smither.backend.image.EmojiCache;
import org.nuclearfog.smither.config.GlobalSettings;
import org.nuclearfog.smither.notification.PushSubscription;
import org.nuclearfog.smither.utils.BlurHashDecoder;
import org.nuclearfog.smither.utils.ImageWorker;

/**
 * @author nuclearfog
 */
public class ClientApplication extends Application {

	private GlobalSettings settings;


	@Override
	public void onCreate() {
		super.onCreate();
		// setup push receiver
		settings = GlobalSettings.get(getApplicationContext());
		if (settings.pushEnabled()) {
			PushSubscription.subscribe(getApplicationContext());
		}
	}


	@Override
	public void onTerminate() {
		if (settings.pushEnabled()) {
			PushSubscription.unsubscribe(getApplicationContext());
		}
		super.onTerminate();
	}


	@Override
	public void onLowMemory() {
		EmojiCache.clear();
		ImageWorker.clear();
		BlurHashDecoder.clearCache();
		super.onLowMemory();
	}
}