package org.nuclearfog.smither.ui.adapter.recyclerview.holder;

import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.cardview.widget.CardView;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.RecyclerView.ViewHolder;

import org.nuclearfog.smither.R;
import org.nuclearfog.smither.config.GlobalSettings;
import org.nuclearfog.smither.model.UserList;
import org.nuclearfog.smither.utils.AppStyles;

/**
 * view holder class for an user list item
 *
 * @author nuclearfog
 * @see org.nuclearfog.smither.ui.adapter.recyclerview.UserlistAdapter
 */
public class UserListHolder extends ViewHolder implements OnClickListener {

	private OnHolderClickListener listener;
	private TextView title;

	/**
	 *
	 */
	public UserListHolder(ViewGroup parent, OnHolderClickListener listener) {
		super(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_list, parent, false));
		GlobalSettings settings = GlobalSettings.get(parent.getContext());
		CardView background = (CardView) itemView;
		title = itemView.findViewById(R.id.item_list_title);
		this.listener = listener;

		AppStyles.setTheme((ViewGroup) itemView);
		background.setCardBackgroundColor(settings.getCardColor());
		itemView.setOnClickListener(this);
	}


	@Override
	public void onClick(View v) {
		int position = getLayoutPosition();
		if (position != RecyclerView.NO_POSITION) {
			if (v == itemView) {
				listener.onItemClick(position, OnHolderClickListener.LIST_CLICK);
			}
		}
	}

	/**
	 * set view content
	 */
	public void setContent(UserList userlist) {
		title.setText(userlist.getTitle());
	}
}