package org.nuclearfog.smither.ui.adapter.recyclerview.holder;

import android.annotation.SuppressLint;
import android.content.res.Resources;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.RecyclerView.ViewHolder;

import org.nuclearfog.smither.R;
import org.nuclearfog.smither.model.Tag;
import org.nuclearfog.smither.ui.adapter.recyclerview.TagAdapter;
import org.nuclearfog.smither.utils.AppStyles;
import org.nuclearfog.smither.utils.StringUtils;

/**
 * ViewHolder for a trend item
 *
 * @author nuclearfog
 * @see TagAdapter
 */
public class TagHolder extends ViewHolder implements OnClickListener {

	private TextView name, rank, vol;

	private OnHolderClickListener listener;


	public TagHolder(ViewGroup parent, OnHolderClickListener listener, boolean enableRemove) {
		super(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_tag, parent, false));
		ViewGroup container = itemView.findViewById(R.id.item_tag_container);
		View btnRemove = itemView.findViewById(R.id.item_tag_delete_button);
		rank = itemView.findViewById(R.id.item_tag_rank);
		name = itemView.findViewById(R.id.item_tag_name);
		vol = itemView.findViewById(R.id.item_tag_vol);
		this.listener = listener;

		AppStyles.setTheme((ViewGroup) itemView);
		if (enableRemove) {
			btnRemove.setVisibility(View.VISIBLE);
		} else {
			btnRemove.setVisibility(View.GONE);
		}
		container.setOnClickListener(this);
		btnRemove.setOnClickListener(this);
	}


	@Override
	public void onClick(View v) {
		int position = getLayoutPosition();
		if (v.getId() == R.id.item_tag_delete_button) {
			if (position != RecyclerView.NO_POSITION) {
				listener.onItemClick(position, OnHolderClickListener.TAG_REMOVE);
			}
		} else if (v.getId() == R.id.item_tag_container) {
			if (position != RecyclerView.NO_POSITION) {
				listener.onItemClick(position, OnHolderClickListener.TAG_CLICK);
			}
		}
	}

	/**
	 * set view content
	 *
	 * @param tag   content information
	 * @param index index of the item
	 */
	@SuppressLint("SetTextI18n")
	public void setContent(Tag tag, int index) {
		rank.setText(index + 1 + ".");
		name.setText(tag.getName());
		if (tag.getPopularity() > 0) {
			Resources resources = vol.getResources();
			String trendVol = StringUtils.NUMBER_FORMAT.format(tag.getPopularity()) + resources.getString(R.string.trend_range);
			vol.setText(trendVol);
			vol.setVisibility(View.VISIBLE);
		} else {
			vol.setVisibility(View.GONE);
		}
	}
}