package org.nuclearfog.smither.ui.adapter.recyclerview.holder;

import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.RecyclerView.ViewHolder;

import org.nuclearfog.smither.R;
import org.nuclearfog.smither.utils.AppStyles;

/**
 * domain holder class for {@link org.nuclearfog.smither.ui.adapter.recyclerview.DomainAdapter}
 *
 * @author nuclearfog
 */
public class DomainHolder extends ViewHolder implements OnClickListener {

	private TextView domain_name;

	private OnHolderClickListener listener;

	/**
	 *
	 */
	public DomainHolder(ViewGroup parent, OnHolderClickListener listener) {
		super(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_domain, parent, false));
		this.listener = listener;
		View deleteButton = itemView.findViewById(R.id.item_domain_delete);
		domain_name = itemView.findViewById(R.id.item_domain_name);

		AppStyles.setTheme((ViewGroup) itemView);

		deleteButton.setOnClickListener(this);
	}


	@Override
	public void onClick(View v) {
		if (v.getId() == R.id.item_domain_delete) {
			int position = getLayoutPosition();
			if (position != RecyclerView.NO_POSITION) {
				listener.onItemClick(position, OnHolderClickListener.DOMAIN_REMOVE);
			}
		}
	}

	/**
	 * set domain information
	 *
	 * @param name domain information
	 */
	public void setContent(String name) {
		domain_name.setText(name);
	}
}