package org.nuclearfog.smither.ui.activities;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.FragmentTransaction;

import org.nuclearfog.smither.R;
import org.nuclearfog.smither.config.GlobalSettings;
import org.nuclearfog.smither.ui.fragments.ScheduleFragment;
import org.nuclearfog.smither.utils.AppStyles;

/**
 * Activity class used to show a list of scheduled posts
 *
 * @author nuclearfog
 */
public class ScheduleActivity extends AppCompatActivity implements OnClickListener {


	@Override
	protected void onCreate(@Nullable Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.page_fragment);
		ViewGroup root = findViewById(R.id.page_fragment_root);
		View floatingButton = findViewById(R.id.page_fragment_floating_button);
		Toolbar toolbar = findViewById(R.id.page_fragment_toolbar);
		GlobalSettings settings = GlobalSettings.get(this);

		if (savedInstanceState == null) {
			FragmentTransaction fragmentTransaction = getSupportFragmentManager().beginTransaction();
			fragmentTransaction.replace(R.id.page_fragment_container, ScheduleFragment.class, null);
			fragmentTransaction.commit();
		}
		if (settings.floatingButtonEnabled()) {
			floatingButton.setVisibility(View.VISIBLE);
		}
		toolbar.setTitle(R.string.menu_schedule);
		setSupportActionBar(toolbar);
		AppStyles.setTheme(root);

		floatingButton.setOnClickListener(this);
	}


	@Override
	public void onClick(View v) {
		if (v.getId() == R.id.page_fragment_floating_button) {
			Intent intent = new Intent(this, StatusEditor.class);
			startActivity(intent);
		}
	}
}