package org.nuclearfog.smither.backend.async;

import android.content.Context;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import org.nuclearfog.smither.backend.api.Connection;
import org.nuclearfog.smither.backend.api.ConnectionException;
import org.nuclearfog.smither.backend.api.ConnectionManager;
import org.nuclearfog.smither.backend.helper.update.UserListUpdate;
import org.nuclearfog.smither.model.UserList;
import org.nuclearfog.smither.ui.dialogs.UserListDialog;

/**
 * This class creates and updates user lists
 * Backend for {@link UserListDialog}
 *
 * @author nuclearfog
 */
public class UserListUpdater extends AsyncExecutor<UserListUpdate, UserListUpdater.Result> {

	private Connection connection;

	/**
	 *
	 */
	public UserListUpdater(Context context) {
		connection = ConnectionManager.getDefaultConnection(context);
	}


	@Override
	protected Result doInBackground(@NonNull UserListUpdate update) {
		try {
			UserList result = connection.updateUserlist(update);
			if (update.getId() != 0L)
				return new Result(Result.UPDATED, result, null);
			return new Result(Result.CREATED, result, null);
		} catch (ConnectionException exception) {
			return new Result(Result.ERROR, null, exception);
		}
	}

	/**
	 *
	 */
	public static class Result {

		public static final int CREATED = 1;
		public static final int UPDATED = 2;
		public static final int ERROR = -1;

		public final int action;
		@Nullable
		public final UserList userlist;
		@Nullable
		public final ConnectionException exception;

		/**
		 * @param action   action performed on user list
		 * @param userList updated user list
		 */
		Result(int action, @Nullable UserList userList, @Nullable ConnectionException exception) {
			this.action = action;
			this.userlist = userList;
			this.exception = exception;
		}
	}
}