package org.nuclearfog.smither.ui.adapter.recyclerview.holder;

import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.RecyclerView.ViewHolder;

import org.nuclearfog.smither.R;
import org.nuclearfog.smither.config.GlobalSettings;
import org.nuclearfog.smither.model.Emoji;
import org.nuclearfog.smither.utils.ImageWorker;

/**
 * Emoji holder class for {@link org.nuclearfog.smither.ui.adapter.recyclerview.EmojiAdapter}
 *
 * @author nuclearfog
 */
public class EmojiHolder extends ViewHolder implements OnClickListener {

	public static final int ROW_COUNT = 6;

	private ImageView[] emojiViews = new ImageView[ROW_COUNT];
	private TextView groupLabel;

	private ImageWorker imageWorker;
	private OnHolderClickListener listener;

	/**
	 *
	 */
	public EmojiHolder(ViewGroup parent, OnHolderClickListener listener) {
		super(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_emoji, parent, false));
		GlobalSettings settings = GlobalSettings.get(parent.getContext());
		imageWorker = ImageWorker.get(parent.getContext());
		this.listener = listener;

		groupLabel = itemView.findViewById(R.id.item_emoji_group);
		emojiViews[0] = itemView.findViewById(R.id.item_emoji_1);
		emojiViews[1] = itemView.findViewById(R.id.item_emoji_2);
		emojiViews[2] = itemView.findViewById(R.id.item_emoji_3);
		emojiViews[3] = itemView.findViewById(R.id.item_emoji_4);
		emojiViews[4] = itemView.findViewById(R.id.item_emoji_5);
		emojiViews[5] = itemView.findViewById(R.id.item_emoji_6);

		for (ImageView emojiView : emojiViews)
			emojiView.setOnClickListener(this);
		groupLabel.setTextColor(settings.getTextColor());
		groupLabel.setTypeface(settings.getTypeFace());
	}


	@Override
	public void onClick(View v) {
		int pos = getLayoutPosition();
		if (pos != RecyclerView.NO_POSITION) {
			for (int i = 0; i < emojiViews.length; i++) {
				if (v == emojiViews[i]) {
					listener.onItemClick(pos, OnHolderClickListener.EMOJI_CLICK, i);
					v.startAnimation(AnimationUtils.loadAnimation(v.getContext(), R.anim.emoji));
				}
			}
		}
	}

	/**
	 * set emoji group
	 *
	 * @param emojis a group of emojis
	 */
	public void setContent(Emoji[] emojis) {
		for (int i = 0; i < emojiViews.length; i++) {
			Emoji emoji = null;
			if (i < emojis.length)
				emoji = emojis[i];
			if (emoji != null && !emoji.getUrl().isEmpty()) {
				imageWorker.load(emojiViews[i], emoji.getUrl());
				emojiViews[i].setVisibility(View.VISIBLE);
			} else {
				emojiViews[i].setVisibility(View.INVISIBLE);
			}
		}
		groupLabel.setVisibility(View.GONE);
	}

	/**
	 * set emoji group label
	 *
	 * @param label name of the group
	 */
	public void setLabel(String label) {
		for (ImageView emojiView : emojiViews) {
			emojiView.setVisibility(View.GONE);
		}
		groupLabel.setText(label);
		groupLabel.setVisibility(View.VISIBLE);
	}
}