package org.nuclearfog.smither.backend.async;

import android.content.Context;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import org.nuclearfog.smither.backend.api.Connection;
import org.nuclearfog.smither.backend.api.ConnectionException;
import org.nuclearfog.smither.backend.api.ConnectionManager;
import org.nuclearfog.smither.model.lists.Announcements;

/**
 * Async loader for instance announcements
 *
 * @author nuclearfog
 */
public class AnnouncementLoader extends AsyncExecutor<Void, AnnouncementLoader.Result> {

	private Connection connection;

	/**
	 *
	 */
	public AnnouncementLoader(Context context) {
		connection = ConnectionManager.getDefaultConnection(context);
	}


	@Override
	protected Result doInBackground(@NonNull Void param) {
		try {
			Announcements announcements = connection.getAnnouncements();
			return new Result(announcements, null);
		} catch (ConnectionException exception) {
			return new Result(null, exception);
		}
	}

	/**
	 *
	 */
	public static class Result {

		@Nullable
		public final Announcements announcements;
		@Nullable
		public final ConnectionException exception;

		/**
		 * @param announcements a list of announcements of the instance server or null if an error occurred
		 */
		public Result(@Nullable Announcements announcements, @Nullable ConnectionException exception) {
			this.announcements = announcements;
			this.exception = exception;
		}
	}
}