package org.nuclearfog.smither.backend.async;

import android.content.Context;

import androidx.annotation.NonNull;

import org.nuclearfog.smither.database.AppDatabase;
import org.nuclearfog.smither.model.lists.Accounts;

/**
 * Async loader to get saved login information
 *
 * @author nuclearfog
 */
public class AccountLoader extends AsyncExecutor<Void, AccountLoader.Result> {

	private AppDatabase db;

	/**
	 *
	 */
	public AccountLoader(Context context) {
		db = new AppDatabase(context);
	}


	@Override
	protected Result doInBackground(@NonNull Void v) {
		return new Result(db.getLogins());
	}

	/**
	 *
	 */
	public static class Result {

		public final Accounts accounts;

		Result(Accounts accounts) {
			this.accounts = accounts;
		}
	}
}