package org.nsh07.wikireader.data

import java.util.Locale

object LanguageData {
    val langCodes = listOf(
        "ab",
        "ace",
        "ady",
        "af",
        "als",
        "alt",
        "am",
        "ami",
        "an",
        "ang",
        "anp",
        "ar",
        "arc",
        "ary",
        "arz",
        "as",
        "ast",
        "atj",
        "av",
        "avk",
        "awa",
        "ay",
        "az",
        "azb",
        "ba",
        "ban",
        "bar",
        "bat-smg",
        "bbc",
        "bcl",
        "bdr",
        "be",
        "be-tarask",
        "bew",
        "bg",
        "bh",
        "bi",
        "bjn",
        "blk",
        "bm",
        "bn",
        "bo",
        "bpy",
        "br",
        "bs",
        "btm",
        "bug",
        "bxr",
        "ca",
        "cbk-zam",
        "cdo",
        "ce",
        "ceb",
        "ch",
        "chr",
        "chy",
        "ckb",
        "co",
        "cr",
        "crh",
        "cs",
        "csb",
        "cu",
        "cv",
        "cy",
        "da",
        "dag",
        "de",
        "dga",
        "din",
        "diq",
        "dsb",
        "dtp",
        "dty",
        "dv",
        "dz",
        "ee",
        "el",
        "eml",
        "en",
        "eo",
        "es",
        "et",
        "eu",
        "ext",
        "fa",
        "fat",
        "ff",
        "fi",
        "fiu-vro",
        "fj",
        "fo",
        "fon",
        "fr",
        "frp",
        "frr",
        "fur",
        "fy",
        "ga",
        "gag",
        "gan",
        "gcr",
        "gd",
        "gl",
        "glk",
        "gn",
        "gom",
        "gor",
        "got",
        "gpe",
        "gu",
        "guc",
        "gur",
        "guw",
        "gv",
        "ha",
        "hak",
        "haw",
        "he",
        "hi",
        "hif",
        "hr",
        "hsb",
        "ht",
        "hu",
        "hy",
        "hyw",
        "ia",
        "id",
        "ie",
        "ig",
        "igl",
        "ik",
        "ilo",
        "inh",
        "io",
        "is",
        "it",
        "iu",
        "ja",
        "jam",
        "jbo",
        "jv",
        "ka",
        "kaa",
        "kab",
        "kbd",
        "kbp",
        "kcg",
        "kg",
        "ki",
        "kk",
        "kl",
        "km",
        "kn",
        "ko",
        "koi",
        "krc",
        "ks",
        "ksh",
        "ku",
        "kus",
        "kv",
        "kw",
        "ky",
        "la",
        "lad",
        "lb",
        "lbe",
        "lez",
        "lfn",
        "lg",
        "li",
        "lij",
        "lld",
        "lmo",
        "ln",
        "lo",
        "lt",
        "ltg",
        "lv",
        "mad",
        "mai",
        "map-bms",
        "mdf",
        "mg",
        "mhr",
        "mi",
        "min",
        "mk",
        "ml",
        "mn",
        "mni",
        "mnw",
        "mr",
        "mrj",
        "ms",
        "mt",
        "mwl",
        "my",
        "myv",
        "mzn",
        "nah",
        "nap",
        "nds",
        "nds-nl",
        "ne",
        "new",
        "nia",
        "nl",
        "nn",
        "no",
        "nov",
        "nqo",
        "nrm",
        "nso",
        "nv",
        "ny",
        "oc",
        "olo",
        "om",
        "or",
        "os",
        "pa",
        "pag",
        "pam",
        "pap",
        "pcd",
        "pcm",
        "pdc",
        "pfl",
        "pi",
        "pih",
        "pl",
        "pms",
        "pnb",
        "pnt",
        "ps",
        "pt",
        "pwn",
        "qu",
        "rm",
        "rmy",
        "rn",
        "ro",
        "roa-rup",
        "roa-tara",
        "ru",
        "rue",
        "rw",
        "sa",
        "sah",
        "sat",
        "sc",
        "scn",
        "sco",
        "sd",
        "se",
        "sg",
        "sh",
        "shi",
        "shn",
        "si",
        "simple",
        "sk",
        "skr",
        "sl",
        "sm",
        "smn",
        "sn",
        "so",
        "sq",
        "sr",
        "srn",
        "ss",
        "st",
        "stq",
        "su",
        "sv",
        "sw",
        "szl",
        "szy",
        "ta",
        "tay",
        "tcy",
        "te",
        "tet",
        "tg",
        "th",
        "ti",
        "tk",
        "tl",
        "tly",
        "tn",
        "to",
        "tpi",
        "tr",
        "trv",
        "ts",
        "tt",
        "tum",
        "tw",
        "ty",
        "tyv",
        "udm",
        "ug",
        "uk",
        "ur",
        "uz",
        "ve",
        "vec",
        "vep",
        "vi",
        "vls",
        "vo",
        "wa",
        "war",
        "wo",
        "wuu",
        "xal",
        "xh",
        "xmf",
        "yi",
        "yo",
        "za",
        "zea",
        "zgh",
        "zh",
        "zh-classical",
        "zh-min-nan",
        "zh-yue",
        "zu"
    )
    val rtlLangCodes = listOf(
        "ar",
        "arc",
        "ary",
        "arz",
        "ckb",
        "dv",
        "fa",
        "he",
        "ku",
        "ur"
    )
    val langNames = listOf(
        "Abkhaz",
        "Acehnese",
        "Adyghe",
        "Afrikaans",
        "Alemannic German",
        "Southern Altai",
        "Amharic",
        "Amis",
        "Aragonese",
        "Old English",
        "Angika",
        "Arabic",
        "Aramaic (Syriac)",
        "Moroccan Arabic",
        "Egyptian Arabic",
        "Assamese",
        "Asturian",
        "Atikamekw",
        "Avar",
        "Kotava",
        "Awadhi",
        "Aymara",
        "Azerbaijani",
        "South Azerbaijani",
        "Bashkir",
        "Balinese",
        "Bavarian",
        "Samogitian",
        "Toba Batak",
        "Central Bikol",
        "West Coast Bajau",
        "Belarusian (official Narkamaŭka orthography)",
        "Belarusian (Taraškievica orthography)",
        "Betawi",
        "Bulgarian",
        "Bihari (Bhojpuri)",
        "Bislama",
        "Banjarese",
        "Pa'O",
        "Bambara",
        "Bengali",
        "Central Tibetan (Lhasa Tibetan)",
        "Bishnupriya Manipuri",
        "Breton",
        "Bosnian",
        "Mandailing Batak",
        "Buginese",
        "Buryat (Russia Buriat)",
        "Catalan",
        "Zamboanga Chavacano",
        "Eastern Min",
        "Chechen",
        "Cebuano",
        "Chamorro",
        "Cherokee",
        "Cheyenne",
        "Kurdish (Sorani)",
        "Corsican",
        "Cree",
        "Crimean Tatar",
        "Czech",
        "Kashubian",
        "Old Church Slavonic",
        "Chuvash",
        "Welsh",
        "Danish",
        "Dagbani",
        "German",
        "Dagaare",
        "Dinka",
        "Zaza",
        "Lower Sorbian",
        "Dusun",
        "Doteli",
        "Maldivian",
        "Dzongkha",
        "Ewe",
        "Greek",
        "Emilian–Romagnol",
        "English",
        "Esperanto",
        "Spanish",
        "Estonian",
        "Basque",
        "Extremaduran",
        "Persian",
        "Fante",
        "Fula",
        "Finnish",
        "Võro",
        "Fijian",
        "Faroese",
        "Fon",
        "French",
        "Franco-Provençal",
        "North Frisian",
        "Friulian",
        "West Frisian",
        "Irish",
        "Gagauz",
        "Gan Chinese",
        "French Guianese Creole",
        "Scottish Gaelic",
        "Galician",
        "Gilaki",
        "Guarani",
        "Konkani (Goan Konkani)",
        "Gorontalo",
        "Gothic",
        "Ghanaian Pidgin English",
        "Gujarati",
        "Wayuu",
        "Farefare (Gurene)",
        "Gun",
        "Manx",
        "Hausa",
        "Hakka Chinese",
        "Hawaiian",
        "Hebrew",
        "Hindi",
        "Fiji Hindi",
        "Croatian",
        "Upper Sorbian",
        "Haitian Creole",
        "Hungarian",
        "Armenian",
        "Western Armenian",
        "Interlingua",
        "Indonesian",
        "Interlingue",
        "Igbo",
        "Igala",
        "Iñupiaq",
        "Ilocano",
        "Ingush",
        "Ido",
        "Icelandic",
        "Italian",
        "Inuktitut",
        "Japanese",
        "Jamaican Patois",
        "Lojban",
        "Javanese",
        "Georgian",
        "Karakalpak",
        "Kabyle",
        "Kabardian",
        "Kabiye",
        "Tyap",
        "Kongo",
        "Kikuyu",
        "Kazakh",
        "Greenlandic",
        "Khmer",
        "Kannada",
        "Korean",
        "Komi-Permyak",
        "Karachay-Balkar",
        "Kashmiri",
        "Ripuarian",
        "Kurdish (Kurmanji)",
        "Kusaal",
        "Komi",
        "Cornish",
        "Kyrgyz",
        "Latin",
        "Judaeo-Spanish",
        "Luxembourgish",
        "Lak",
        "Lezgian",
        "Lingua Franca Nova",
        "Luganda",
        "Limburgish",
        "Ligurian",
        "Ladin",
        "Lombard",
        "Lingala",
        "Lao",
        "Lithuanian",
        "Latgalian",
        "Latvian",
        "Madurese",
        "Maithili",
        "Banyumasan",
        "Moksha",
        "Malagasy",
        "Meadow Mari",
        "Māori",
        "Minangkabau",
        "Macedonian",
        "Malayalam",
        "Mongolian",
        "Meitei",
        "Mon",
        "Marathi",
        "Hill Mari",
        "Malay",
        "Maltese",
        "Mirandese",
        "Burmese",
        "Erzya",
        "Mazanderani",
        "Nahuatl",
        "Neapolitan",
        "Low German",
        "Dutch Low Saxon",
        "Nepali",
        "Newar",
        "Nias",
        "Dutch",
        "Norwegian (Nynorsk)",
        "Norwegian (Bokmål)",
        "Novial",
        "N'Ko",
        "Norman",
        "Northern Sotho",
        "Navajo",
        "Chewa",
        "Occitan",
        "Livvi-Karelian",
        "Oromo",
        "Odia",
        "Ossetian",
        "Punjabi",
        "Pangasinan",
        "Kapampangan",
        "Papiamento",
        "Picard",
        "Nigerian Pidgin",
        "Pennsylvania Dutch",
        "Palatine German",
        "Pali",
        "Norfuk",
        "Polish",
        "Piedmontese",
        "Western Punjabi",
        "Pontic Greek",
        "Pashto",
        "Portuguese",
        "Paiwan",
        "Quechua (Southern Quechua)",
        "Romansh",
        "Romani (Vlax Romani)",
        "Kirundi",
        "Romanian",
        "Aromanian",
        "Tarantino",
        "Russian",
        "Rusyn",
        "Kinyarwanda",
        "Sanskrit",
        "Yakut",
        "Santali",
        "Sardinian",
        "Sicilian",
        "Scots",
        "Sindhi",
        "Northern Sámi",
        "Sango",
        "Serbo-Croatian",
        "Shilha",
        "Shan",
        "Sinhala",
        "Simple English",
        "Slovak",
        "Saraiki",
        "Slovene",
        "Samoan",
        "Inari Sámi",
        "Shona",
        "Somali",
        "Albanian",
        "Serbian",
        "Sranan Tongo",
        "Swazi",
        "Sotho",
        "Saterland Frisian",
        "Sundanese",
        "Swedish",
        "Swahili",
        "Silesian",
        "Sakizaya",
        "Tamil",
        "Atayal",
        "Tulu",
        "Telugu",
        "Tetum",
        "Tajik",
        "Thai",
        "Tigrinya",
        "Turkmen",
        "Tagalog",
        "Talysh",
        "Tswana",
        "Tongan",
        "Tok Pisin",
        "Turkish",
        "Seediq",
        "Tsonga",
        "Tatar",
        "Tumbuka",
        "Twi",
        "Tahitian",
        "Tuvan",
        "Udmurt",
        "Uyghur",
        "Ukrainian",
        "Urdu",
        "Uzbek",
        "Venda",
        "Venetian",
        "Veps",
        "Vietnamese",
        "West Flemish",
        "Volapük",
        "Walloon",
        "Waray",
        "Wolof",
        "Wu Chinese",
        "Kalmyk Oirat",
        "Xhosa",
        "Mingrelian",
        "Yiddish",
        "Yoruba",
        "Zhuang (Standard Zhuang)",
        "Zeelandic",
        "Standard Moroccan Amazigh",
        "Chinese (written vernacular Chinese)",
        "Classical Chinese",
        "Southern Min",
        "Cantonese",
        "Zulu"
    )
    val wikipediaNames = listOf(
        "Аԥсуа авикипедиа",
        "Wikipèdia bahsa Acèh",
        "Адыгэ Википедие",
        "Afrikaanse Wikipedia",
        "Alemannische Wikipedia",
        "Тӱштӱк алтай Википедия",
        "አማርኛ ዊኪፔዲያ",
        "Wikipitiya 'Amis",
        "Biquipedia en aragonés",
        "Engliscan Ƿikipǣdia",
        "विकिपीडिया",
        "ويكيبيديا العربية",
        "ܘܝܩܝܦܕܝܐ ܠܫܢܐ ܣܘܪܝܝܐ",
        "ويكيبيديا المغربية",
        "ويكيپيديا مصرى",
        "অসমীয়া ৱিকিপিডিয়া",
        "Wikipedia n'asturianu",
        "Atikamekw Wikipetcia",
        "Авар Википедия",
        "Wikipedia men Kotava",
        "अवधी विकिपीडिया",
        "Aymar Wikipidiya",
        "Azərbaycanca Vikipediya",
        "تورکجه ویکی‌پدیا",
        "Башҡорт Википедияһы",
        "Wikipédia Basa Bali",
        "Boarische Wikipedia",
        "Žemaitėška Vikipedėjė",
        "Wikipedia Batak Toba",
        "Wikipedyang Bikol Sentral",
        "Wikipidia Bajau Sama",
        "Беларуская Вікіпедыя",
        "Беларуская Вікіпэдыя",
        "Wikipédi basa Betawi",
        "Българоезична Уикипедия",
        "बिहारी विकिपीडिया",
        "Wikipedia long Bislama",
        "Wikipidia basa Banjar",
        "ပအိုဝ်ႏဝီခီပီးဒီးယား",
        "Wikipedi Bamanankan",
        "বাংলা উইকিপিডিয়া",
        "བོད་ཡིག་གི་ཝེ་ཁེ་རིག་མཛོད",
        "বিষ্ণুপ্রিয়া মণিপুরী উইকিপিডিয়া",
        "Wikipedia e brezhoneg",
        "Wikipedia na bosanskom jeziku",
        "Wikipedia Saro Mandailing",
        "ᨓᨗᨀᨗᨄᨙᨉᨗᨕ ᨅᨔ ᨕᨘᨁᨗ",
        "Буряад Википеэди",
        "Viquipèdia en català",
        "Chavacano Wikipedia",
        "Bàng-uâ-cê : Bànguâpedia or Mìng-dĕ̤ng-ngṳ̄ Wikipedia",
        "Нохчийн Википеди",
        "Wikipedya sa Sinugboanon",
        "Wikipedia Chamoru",
        "ᏫᎩᏇᏗᏯ ᏣᎳᎩ",
        "Vekepete'a Tsėhésenėstsestȯtse",
        "ویکیپیدیای کوردیی سۆرانی",
        "Corsipedia or Wikipedia in lingua corsa",
        "ᐎᑭᐱᑎᔭ ᓀᐦᐃᔭᐍᐏᐣ",
        "Qırımtatarca Vikipediya",
        "Česká Wikipedie",
        "Kaszëbskô Wikipedijô",
        "Словѣньска Википєдїꙗ",
        "Чăваш Википедийĕ",
        "Wicipedia Cymraeg",
        "Dansk Wikipedia",
        "Wikipidia Dagbani",
        "Deutschsprachige Wikipedia",
        "Dagaare Wikipiideɛ",
        "Wikipedia Thuɔŋjäŋ",
        "Wikipediyay Zazaki",
        "Dolnoserbska wikipedija",
        "Wikipedia Dusun",
        "डोटेली विकिपिडिया",
        "ދިވެހި ވިކިޕީޑިޔާ",
        "རྫོང་ཁ་ཝེ་ཁེ་རིག་མཛོད",
        "Wikipiɖia Eʋegbe",
        "Ελληνική Βικιπαίδεια",
        "Emiliàn e rumagnòl Vichipedèia",
        "English Wikipedia",
        "Vikipedio en Esperanto",
        "Wikipedia en español",
        "Eestikeelne Vikipeedia",
        "Euskarazko Wikipedia",
        "Güiquipeya en estremeñu",
        "ویکی‌پدیای فارسی",
        "Fante Wikipedia",
        "Wikipedia Fulfude",
        "Suomenkielinen Wikipedia",
        "Võrokeeline Vikipeediä",
        "Vaka-Viti Wikipedia",
        "Føroysk Wikipedia",
        "Wikipedya ɖò Fɔngbemɛ",
        "Wikipédia en français",
        "Vouiquipèdia en arpetan",
        "Nordfriisk Wikipedia",
        "Vichipedie par furlan",
        "Frysktalige Wikipedy",
        "Vicipéid na Gaeilge",
        "Gagauzca Vikipediya",
        "Traditional: 贛語維基百科 , simplified: 赣语维基百科",
        "Wikipédja an kriyòl gwiyannen",
        "Uicipeid na Gàidhlig",
        "Galipedia or Wikipedia en galego",
        "گیلکی ویکیپدیاٰ",
        "Vikipetã avañe'ẽme",
        "कोंकणी विकिपीडिया",
        "Wikipedia bahasa Hulontalo",
        "𐌲𐌿𐍄𐌹𐍃𐌺 𐍅𐌹𐌺𐌹𐍀𐌰𐌹𐌳𐌾𐌰",
        "Ghanaian Pidgin Wikipedia",
        "ગુજરાતી વિકિપીડિયા",
        "Wikipeetia süka wayuunaiki",
        "Gurenɛ Wikipedia",
        "Gungbe Wikipedia",
        "Wikipedia yn Gaelg",
        "Wikipedia Hausa",
        "Pha̍k-fa-sṳ : Hakkâpedia or Hak-kâ-ngî Wikipedia",
        "Hawai‘i Wikipikia",
        "ויקיפדיה העברית",
        "हिन्दी विकिपीडिया",
        "Fiji Baat Wikipedia",
        "Hrvatska Wikipedija",
        "Hornjoserbska wikipedija",
        "Wikipedya kreyòl ayisyen",
        "Magyar Wikipédia",
        "Հայերեն Վիքիպեդիա",
        "Արեւմտահայերէն Ուիքիփետիա",
        "Wikipedia in interlingua",
        "Wikipedia bahasa Indonesia",
        "Wikipedia in Interlingue",
        "Wikipedia Igbo",
        "Wikipídiya Igala",
        "Uiqipitia Iñupiatun",
        "Wikipedia nga Ilokano",
        "Гӏалгӏай Википеди",
        "Wikipedio en Ido",
        "Íslenska Wikipedia",
        "Wikipedia in italiano",
        "ᐃᓄᒃᑎᑐᑦ ᐊᕆᐅᙵᐃᐹ",
        "ウィキペディア日本語版",
        "Jumiekan Patwa Wikipidia",
        "ni'o la .uikipedi'as. pe lo jbobau",
        "Wikipedia basa Jawa",
        "ქართული ვიკიპედია",
        "Qaraqalpaq Wikipediası",
        "Wikipedia taqbaylit",
        "Адыгэбзэ Уикипедиэ",
        "Wikipediya kabɩyɛ",
        "Wukipedia nTyap",
        "Wikipedia kikôngo",
        "Wikipedia Gĩgĩkũyũ",
        "Қазақша Уикипедия",
        "Kalaallisut Wikipedia",
        "វិគីភីឌាភាសាខ្មែរ",
        "ಕನ್ನಡ ವಿಕಿಪೀಡಿಯ",
        "한국어 위키백과",
        "Перем коми Википедия",
        "Къарачай-Малкъар Википедия",
        "کٲشُر وِکیٖپیٖڈیا",
        "Wikkipedija en Ripoarisch Platt",
        "Wîkîpediya kurdî",
        "Wikipiidia Kʋsaal",
        "Коми Википедия",
        "Wikipedya Kernowek",
        "Кыргыз Википедиясы",
        "Vicipaedia Latina",
        "Vikipedya en lingua Judeo-Espanyola",
        "Wikipedia op Lëtzebuergesch",
        "Лакку мазрал Википедия",
        "Лезги Википедия",
        "Vicipedia en lingua franca nova",
        "Wikipediya Luganda",
        "Limburgse Wikipedia",
        "Wikipedia Ligure",
        "Wikipedia per ladin",
        "Wikipedia in lombard",
        "Lingála Wikipedia",
        "ວິກິພີເດຍ ພາສາລາວ",
        "Lietuviškoji Vikipedija",
        "Vikipedeja latgaļu volūdā",
        "Vikipēdija latviešu valodā",
        "Wikipèḍia bhâsa Madhurâ",
        "मैथिली विकिपिडिया",
        "Wikipédia basa Banyumasan",
        "Мокшень Википедиесь",
        "Wikipedia amin'ny teny malagasy",
        "Олык Марий Википедий",
        "Wikipedia Māori",
        "Wikipedia Minangkabau",
        "Македонска Википедија",
        "മലയാളം വിക്കിപീടിയ",
        "Монгол Википедиа",
        "ꯃꯤꯇꯩꯂꯣꯟ ꯋꯤꯀꯤꯄꯦꯗꯤꯌꯥ",
        "ဝဳကဳပဳဒဳယာမန်",
        "मराठी विकिपीडिया",
        "Кырык марла Википеди",
        "Wikipedia Bahasa Melayu",
        "Wikipedija Malti",
        "Biquipédia an lhéngua mirandesa",
        "မြန်မာဝီကီပီးဒီးယား",
        "Эрзянь Википедия",
        "مازرونی ویکی‌پدیا",
        "Huiquipedia nāhuatlahtōlcopa",
        "Wikipedia napulitana",
        "Plattdüütsche Wikipedia",
        "Nedersaksische Wikipedie",
        "नेपाली विकिपिडिया",
        "विकिपिडियाय् लसकुस",
        "Wikipedia Li Niha",
        "Nederlandstalige Wikipedia",
        "Norsk  Wikipedia",
        "Norsk Wikipedia",
        "Wikipedie in novial",
        "ߥߞߌߔߘߋߞߎ ߒߞߏ",
        "Witchipedi Normãdi",
        "Wikipedia Sesotho sa Leboa",
        "Wikiibíídiiya Dinék'ehjí",
        "Wikipedia Chichewa",
        "Wikipèdia en occitan",
        "Livvinkarjalan Wikipedii",
        "Oromoo Wikipedia",
        "ଓଡ଼ିଆ ଉଇକିପିଡ଼ିଆ",
        "Ирон Википеди",
        "ਪੰਜਾਬੀ ਵਿਕੀਪੀਡੀਆ",
        "Wikipedia Pangasinan",
        "Wikipediang Kapampángan",
        "Wikipedia na papiamentu",
        "Wikipédia in lingue picarde",
        "Naijá Wikipedia",
        "Pennsilfaanisch-Deitsche Wikipedelche",
        "Pälzisch Wikipedia",
        "पालि विकिपीडिया",
        "Norfuk Wikkapedya",
        "Polskojęzyczna Wikipedia",
        "Wikipedia an piemontèisa",
        "پنجابی وکیپیڈیا",
        "Ποντιακόν Βικιπαίδεια",
        "پښتو ويکيپېډيا",
        "Wikipédia em português",
        "wikipidiya nua pinayuanan",
        "Qhichwa Wikipidiya",
        "Vichipedia rumantscha",
        "Romani Vikipidiya",
        "Wikipediya mu Ikirundi",
        "Wikipedia în limba română",
        "Wikipedia pri Armâneaști",
        "Uicchipèdie tarandíne",
        "Русская Википедия",
        "Русиньска Вікіпедія",
        "Wikipediya mu Ikinyarwanda",
        "संस्कृतविकिपीडिया",
        "Сахалыы Бикипиэдьийэ",
        "ᱥᱟᱱᱛᱟᱲᱤ ᱣᱤᱠᱤᱯᱤᱰᱤᱭᱟ",
        "Wikipedia in sardu",
        "Wikipedia ’n sicilianu",
        "Scots Wikipædia",
        "سنڌي وڪيپيڊيا",
        "Davvisámegiel Wikipedia",
        "Wïkïpêdïyäa na Sängö",
        "Srpskohrvatska Wikipedija",
        "Wikipidya taclḥiyt",
        "ဝီႇၶီႇၽီးတီးယႃးတႆး",
        "සිංහල විකිපීඩියා",
        "Simple English Wikipedia",
        "Slovenská Wikipedia",
        "سرائیکی ویٖکیٖپیڈیا",
        "Slovenska Wikipedija",
        "Wikipedia gagana Sāmoa",
        "Anarâškielâlâš Wikipedia",
        "Wikipedhiya chiShona",
        "Soomaali Wikipedia",
        "Wikipedia shqip",
        "Википедија на српском језику",
        "Sranan Wikipedia",
        "Wikipedia siSwati",
        "Wikipedia Sesotho",
        "Seelterfräiske Wikipedia",
        "Wikipédia basa Sunda",
        "Svenskspråkiga Wikipedia",
        "Wikipedia ya Kiswahili",
        "Ślůnsko Wikipedyjo",
        "Wikipitiya nu Sakizaya",
        "தமிழ் விக்கிபீடியா",
        "Wikibitia na Tayal",
        "ತುಳು ವಿಕಿಪೀಡಿಯ",
        "తెలుగు వికీపీడియా",
        "Wikipédia iha lia-tetun",
        "Википедияи Тоҷикӣ",
        "วิกิพีเดียภาษาไทย",
        "ዊኪፐድያ ብትግርኛ",
        "Türkmençe Wikipediýa",
        "Wikipediang Tagalog",
        "Tolyšə Vikipedijə",
        "Wikipedia Setswana",
        "Wikipedia ʻi lea fakatonga",
        "Wikipedia long Tok Pisin",
        "Türkçe Vikipedi",
        "Seediq Wikipidiya",
        "Wikipediya Xitsonga",
        "Татар Википедиясе",
        "Wikipedia Chitumbuka",
        "Wikipidia Twi",
        "Vitipetia Reo Tahiti",
        "Тыва Википедия",
        "Удмурт Википедия",
        "UEY : ئۇيغۇرچە ۋىكىپېدىيە",
        "Українська Вікіпедія",
        "اردو ویکیپیڈیا",
        "Oʻzbekcha Vikipediya",
        "Wikipedia nga tshiVenḓa",
        "Wikipedia en łéngoa vèneta",
        "Vepsän Vikipedii",
        "Wikipedia tiếng Việt",
        "West-Vlamse Wikipedia",
        "Vükiped Volapükik",
        "Wikipedia e walon",
        "Waray Wikipedia",
        "Wikipedia Wolof",
        "Traditional: 吳語維基百科, Simplified: 吴语维基百科",
        "Хальмг Бикипеди",
        "Wikipedia isiXhosa",
        "მარგალური ვიკიპედია",
        "יידישע וויקיפעדיע",
        "Wikipéédíà Yorùbá",
        "Veizgiek Bakgoh Vahcuengh",
        "Zeêuwstaelihe Wikipedia",
        "ⵡⵉⴽⵉⴱⵉⴷⵢⴰ ⵜⴰⵎⴰⵣⵉⵖⵜ ⵜⴰⵏⴰⵡⴰⵢⵜ",
        "Traditional: 中 文 維 基 百 科, Simplified: 中 文 维 基 百 科",
        "文言維基大典",
        "Pe̍h-ōe-jī : Holopedia or Wikipedia Bân-lâm-gú",
        "Traditional Chinese : 粵文維基百科",
        "Wikipedia isiZulu"
    )

    val fifaCodeToAlpha3CodeMap = mapOf(
        "ALG" to "DZA",
        "ASA" to "ASM",
        "ANG" to "AGO",
        "ARU" to "ABW",
        "BAH" to "BHS",
        "BAN" to "BGD",
        "BER" to "BMU",
        "BHU" to "BTN",
        "BOT" to "BWA",
        "BRU" to "BRN",
        "BUL" to "BGR",
        "CAM" to "KHM",
        "CAY" to "CYM",
        "CTA" to "CAF",
        "CHA" to "TCD",
        "CHI" to "CHL",
        "CGO" to "COG",
        "CRC" to "CRI",
        "CRO" to "HRV",
        "DEN" to "DNK",
        "EQG" to "GNQ",
        "TAH" to "PYF",
        "GAM" to "GMB",
        "GER" to "DEU",
        "GRE" to "GRC",
        "GRN" to "GRD",
        "GUA" to "GTM",
        "GUI" to "GIN",
        "HAI" to "HTI",
        "HON" to "HND",
        "KUW" to "KWT",
        "LES" to "LSO",
        "MAD" to "MDG",
        "MAS" to "MYS",
        "MTN" to "MRT",
        "MRI" to "MUS",
        "MYA" to "MMR",
        "NEP" to "NPL",
        "NED" to "NLD",
        "NCA" to "NIC",
        "NIG" to "NER",
        "OMA" to "OMN",
        "PLE" to "PSE",
        "PAR" to "PRY",
        "PHI" to "PHL",
        "POR" to "PRT",
        "PUR" to "PRI",
        "SKN" to "KNA",
        "VIN" to "VCT",
        "SAM" to "WSM",
        "KSA" to "SAU",
        "SEY" to "SYC",
        "SIN" to "SGP",
        "SOL" to "SLB",
        "RSA" to "ZAF",
        "SRI" to "LKA",
        "SUI" to "CHE",
        "TPE" to "TWN",
        "TAN" to "TZA",
        "TOG" to "TGO",
        "TGA" to "TON",
        "TRI" to "TTO",
        "UAE" to "ARE",
        "URU" to "URY",
        "VAN" to "VUT",
        "VIE" to "VNM",
        "ZAM" to "ZMB",
        "ZIM" to "ZWE"
    )

    val countryNameToAlpha2CodeMap = Locale.getISOCountries()
        .associateBy { Locale.Builder().setRegion(it).build().displayCountry }

    val alpha3CodeToAlpha2CodeMap = Locale.getISOCountries()
        .associateBy { Locale.Builder().setRegion(it).build().isO3Country }
}