<div align="center">
  <img src="fastlane/metadata/android/en-US/images/featureGraphic.png">

## About

Tomato is a minimalist Pomodoro timer for Android based on Material 3 Expressive.

</div>

<div align="center">

<a href="https://hosted.weblate.org/engage/tomato/?utm_source=widget">
  <img src="https://img.shields.io/weblate/progress/tomato?logo=weblate&labelColor=1a1a1a&color=2ecba9">
</a>
<a href="https://github.com/nsh07/tomato/releases/latest">
  <img src="https://img.shields.io/github/v/release/nsh07/tomato?logo=github&labelColor=1a1a1a">
</a>
<a href="https://f-droid.org/packages/org.nsh07.pomodoro">
  <img src="https://img.shields.io/f-droid/v/org.nsh07.pomodoro?logo=f-droid&labelColor=1a1a1a">
</a>
<a href="https://github.com/nsh07/tomato/blob/main/LICENSE">
  <img src="https://img.shields.io/github/license/nsh07/tomato?logo=gnu&color=blue&labelColor=1a1a1a">
</a>
<img src="https://img.shields.io/badge/API-27+-blue?logo=android&labelColor=1a1a1a">

<p>
  <a href="https://play.google.com/store/apps/details?id=org.nsh07.pomodoro">
    <img src=".github/repo_photos/googleplay.png" width="200">
  </a>
  <a href="https://f-droid.org/packages/org.nsh07.pomodoro">
      <img src="https://f-droid.org/badge/get-it-on.png" width="200">
  </a>
  <a href="https://apt.izzysoft.de/fdroid/index/apk/org.nsh07.pomodoro">
    <img src="https://gitlab.com/IzzyOnDroid/repo/-/raw/master/assets/IzzyOnDroid.png" width="200">
  </a>
</p>
<p>
  <a href="https://hosted.weblate.org/engage/tomato/">
    <img src="https://hosted.weblate.org/widget/tomato/287x66-black.png" alt="Translation status" />
  </a>
</p>

<br/>

> *"It just might be the best looking timer app that I've ever seen"*

\- [*HowToMen* on YouTube](https://www.youtube.com/watch?v=iwvHk4SUrMQ&t=280s)

<br/>

> *"... an app to support this habit helps me stay focused and get things done. Currently, that app
is Tomato."*

\- [*Android
Authority*](https://www.androidauthority.com/best-new-android-apps-october-2025-3602966/)

<br/>

</div>

## Screenshots

<p align="center" width="100%">
<img src="fastlane/metadata/android/en-US/images/phoneScreenshots/1.png" width="25%"><img src="fastlane/metadata/android/en-US/images/phoneScreenshots/2.png" width="25%"><img src="fastlane/metadata/android/en-US/images/phoneScreenshots/3.png" width="25%"><img src="fastlane/metadata/android/en-US/images/phoneScreenshots/4.png" width="25%"><img src="fastlane/metadata/android/en-US/images/phoneScreenshots/5.png" width="25%"><img src="fastlane/metadata/android/en-US/images/phoneScreenshots/6.png" width="25%"><img src="fastlane/metadata/android/en-US/images/phoneScreenshots/7.png" width="25%"><img src="fastlane/metadata/android/en-US/images/phoneScreenshots/8.png" width="25%">
</p>

### Features

- Minimalist UI based on the latest Material 3 Expressive guidelines
- Detailed statistics of work/study times in an easy to understand manner
    - Stats for the current day visible at a glance
    - Stats for the last week and last month shown in an easy to read, clean graph
    - Additional stats for last week and month showing at what time of the day you're the most
      productive
- Customizable timer parameters
- Support for Now Bar/Live Updates on Android 16 and later

## Translation

This project is [available on Hosted Weblate](https://hosted.weblate.org/engage/tomato/) for
translation.

You can contribute to this project even if you are not a developer by helping in
translating this project into languages you know.

<a href="https://hosted.weblate.org/engage/tomato/">
<img src="https://hosted.weblate.org/widget/tomato/horizontal-auto.svg" alt="Translation status" />
</a>

## Download

- **Google Play Store** (recommended): Tomato is available on the Google Play Store.
  [You can download it through this link](https://play.google.com/store/apps/details?id=org.nsh07.pomodoro).
- **F-Droid** (recommended): Tomato is available on the official F-Droid repository. Simply open
  your preferred F-Droid app and search for Tomato. Updates on F-Droid are generally a week late. To
  get faster updates, you can install it through
  the [IzzyOnDroid repository](https://apt.izzysoft.de/fdroid/).
- **GitHub releases**: Alternatively, you can manually download and install APKs from
  the [Releases](https://github.com/nsh07/Tomato/releases/latest) section of this repo (This method
  is not recommended, use Google Play/F-Droid instead).

> [!TIP]
> To [verify](https://developer.android.com/studio/command-line/apksigner#usage-verify) the APK
> downloaded from GitHub, use the following signing certificate fingerprints:
> ```
>   SHA1: B1:4E:17:93:11:E8:DB:D5:35:EF:8D:E9:FB:8F:FF:08:F8:EC:65:08
> SHA256: 07:BE:F3:05:81:BA:EE:8F:45:EC:93:E4:7E:E6:8E:F2:08:74:E5:0E:F5:70:9C:78:B2:EE:67:AC:86:BE:4C:3D
> ```
> The SHA256 and MD5 hashes of the individual APK files are also available in the `checksum.txt`
> file for each release.

## Donate

You can support Tomato's development
through [my GitHub Sponsors page](https://github.com/sponsors/nsh07)
or [my BuyMeACoffee page](https://coff.ee/nsh07):

<a href="https://github.com/sponsors/nsh07">
  <img src=".github/repo_photos/sponsors.png" width="128px">
</a>
<a href="https://coff.ee/nsh07">
  <img src=".github/repo_photos/bmc_qr.png" width="128px">
</a>

### Members and Sponsors

- Shun Min Chang ([@jack24254029](https://github.com/jack24254029) on GitHub)
- Chinedu Oji (on BuyMeACoffee)
- Zach Alden (on BuyMeACoffee)

## Special Thanks

This app was made possible by the following libraries:

- [Jetpack Navigation 3](https://developer.android.com/jetpack/androidx/releases/navigation3) -
  Navigation
- [Room](https://developer.android.com/jetpack/androidx/releases/room) - SQLite Database
- [Vico](https://github.com/patrykandpatrick/vico) - Graphs and charts
- [MaterialKolor](https://github.com/jordond/materialkolor)- Material 3 color schemes

### Fonts:

- [Roboto Flex](https://fonts.google.com/specimen/Roboto+Flex) by
  Google<br/><img src=".github/repo_photos/roboto-flex-banner.jpg" width="400">

- [Google Sans Flex](https://fonts.google.com/specimen/Google+Sans+Flex) by
  Google<br/><img src=".github/repo_photos/google-sans-flex.jpg" width="400">

- [Inter](https://rsms.me/inter/) by
  Rasmus Andersson<br/><img src=".github/repo_photos/inter-banner.png" width="400">

## Star History

Please give this repo a star if you liked my work

[![Star History Chart](https://app.repohistory.com/api/svg?repo=nsh07/Tomato&type=Date&background=F9FAEF&color=4C662B)](https://app.repohistory.com/star-history)
