/*
 * This file is part of Open Sudoku - an open-source Sudoku game.
 * Copyright (C) 2009-2023 by original authors.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package org.moire.opensudoku.game.nextstep

import android.content.Context
import org.moire.opensudoku.R

/** enum class with an id for each strategy
 */
enum class StrategyIds() {
	NONE,
	WRONG_VALUES,
	MISSING_CANDIDATES,
	OBSOLETE_CANDIDATES,
	LAST_DIGIT,
	NAKED_SINGLE,
	HIDDEN_SINGLE,
	NAKED_GROUP,
	NAKED_PAIR,
	LOCKED_GROUP,
	LOCKED_PAIR,
	HIDDEN_GROUP,
	HIDDEN_PAIR,
	POINTING_GROUP,
	POINTING_PAIR,
	POINTING_TRIPLE,
	CLAIMING_GROUP,
	CLAIMING_PAIR,
	CLAIMING_TRIPLE,
	NAKED_TRIPLE,
	LOCKED_TRIPLE,
	HIDDEN_TRIPLE,
	NAKED_QUAD,
	HIDDEN_QUAD,
	BASIC_FISH_GROUP,
	BASIC_FISH_2N_X_WING,
	REMOTE_PAIR,
	CHUTE_REMOTE_PAIR,
	CHUTE_REMOTE_PAIR_SINGLE,
	CHUTE_REMOTE_PAIR_DOUBLE,
	CHUTE_REMOTE_PAIR_BONUS,
	SIMPLE_COLORING_TYPE_1,
	SIMPLE_COLORING_TYPE_2,
	TURBOT_SKYSCRAPER,
	TURBOT_2_STRING_KITE,
	TURBOT_CRANE,
	EMPTY_RECTANGLE,
	BASIC_FISH_3N_SWORDFISH,
	XY_WING,
	XYZ_WING,
	X_CHAIN,
	X_CHAIN_LOOP,
	X_CHAIN_ONE_ENDPOINT,
	XY_CHAIN,
	XY_CHAIN_LOOP,
	BUG1,
	UNIQUE_RECTANGLE_TYPE_1,
	UNIQUE_RECTANGLE_TYPE_1M,
	UNIQUE_RECTANGLE_TYPE_2,
	UNIQUE_RECTANGLE_TYPE_3,
	UNIQUE_RECTANGLE_TYPE_4,
	UNIQUE_RECTANGLE_TYPE_4M,
	UNIQUE_RECTANGLE_TYPE_5,
	UNIQUE_RECTANGLE_TYPE_5P,
	UNIQUE_RECTANGLE_TYPE_6,
	UNIQUE_RECTANGLE_TYPE_7,
	BASIC_FISH_4N_JELLYFISH,
	WXYZ_WING,
	BASIC_FISH_5N_STARFISH,
	BASIC_FISH_6N_WHALE,
	BASIC_FISH_7N_LEVIATHAN,
	NO_NEXT_STEP_FOUND;


	fun isStrategy(): Boolean {
		val nonStrategies = listOf(
			NONE,
			WRONG_VALUES,
			NAKED_GROUP,
			LOCKED_GROUP,
			HIDDEN_GROUP,
			POINTING_GROUP,
			CLAIMING_GROUP,
			BASIC_FISH_GROUP,
			CHUTE_REMOTE_PAIR,
			NO_NEXT_STEP_FOUND)
		return (this !in nonStrategies)
	}


	fun getStrategyName(context: Context) : String {
		val strategyName = when( this ) {
			NONE -> this.name
			WRONG_VALUES -> context.getString(R.string.hint_strategy_wrong_value)
			MISSING_CANDIDATES -> context.getString(R.string.hint_strategy_missing_candidate)
			OBSOLETE_CANDIDATES -> context.getString(R.string.hint_strategy_obsolete_candidate)
			LAST_DIGIT -> context.getString(R.string.hint_strategy_last_digit)
			NAKED_SINGLE -> context.getString(R.string.hint_strategy_naked_single)
			HIDDEN_SINGLE -> context.getString(R.string.hint_strategy_hidden_single)
			NAKED_GROUP -> context.getString(R.string.hint_strategy_naked_group," > 4")
			NAKED_PAIR -> context.getString(R.string.hint_strategy_naked_pair)
			LOCKED_GROUP -> context.getString(R.string.hint_strategy_locked_group," > 3")
			LOCKED_PAIR -> context.getString(R.string.hint_strategy_locked_pair)
			HIDDEN_GROUP -> context.getString(R.string.hint_strategy_hidden_group," > 4")
			HIDDEN_PAIR -> context.getString(R.string.hint_strategy_hidden_pair)
			POINTING_GROUP -> context.getString(R.string.hint_strategy_pointing_group," > 4")
			POINTING_PAIR -> context.getString(R.string.hint_strategy_pointing_pair)
			POINTING_TRIPLE -> context.getString(R.string.hint_strategy_pointing_triple)
			CLAIMING_GROUP -> context.getString(R.string.hint_strategy_claiming_group," > 3")
			CLAIMING_PAIR -> context.getString(R.string.hint_strategy_claiming_pair)
			CLAIMING_TRIPLE -> context.getString(R.string.hint_strategy_claiming_triple)
			NAKED_TRIPLE -> context.getString(R.string.hint_strategy_naked_triple)
			LOCKED_TRIPLE -> context.getString(R.string.hint_strategy_locked_triple)
			HIDDEN_TRIPLE-> context.getString(R.string.hint_strategy_hidden_triple)
			NAKED_QUAD -> context.getString(R.string.hint_strategy_naked_quad)
			HIDDEN_QUAD -> context.getString(R.string.hint_strategy_hidden_quad)
			BASIC_FISH_GROUP -> context.getString(R.string.hint_strategy_fish_basic_group," > 7")
			BASIC_FISH_2N_X_WING -> context.getString(R.string.hint_strategy_fish_basic_2n)
			REMOTE_PAIR -> context.getString(R.string.hint_strategy_remote_pair)
			CHUTE_REMOTE_PAIR -> context.getString(R.string.hint_strategy_chute_remote_pair_unknown)
			CHUTE_REMOTE_PAIR_SINGLE -> context.getString(R.string.hint_strategy_chute_remote_pair_single)
			CHUTE_REMOTE_PAIR_DOUBLE -> context.getString(R.string.hint_strategy_chute_remote_pair_double)
			CHUTE_REMOTE_PAIR_BONUS -> context.getString(R.string.hint_strategy_chute_remote_pair_bonus)
			SIMPLE_COLORING_TYPE_1 -> context.getString(R.string.hint_strategy_simple_coloring_type_1)
			SIMPLE_COLORING_TYPE_2 -> context.getString(R.string.hint_strategy_simple_coloring_type_2)
			TURBOT_SKYSCRAPER -> context.getString(R.string.hint_strategy_turbot_skyscraper)
			TURBOT_2_STRING_KITE -> context.getString(R.string.hint_strategy_turbot_2_string_kite)
			TURBOT_CRANE -> context.getString(R.string.hint_strategy_turbot_crane)
			EMPTY_RECTANGLE -> context.getString(R.string.hint_strategy_empty_rectangle)
			BASIC_FISH_3N_SWORDFISH -> context.getString(R.string.hint_strategy_fish_basic_3n)
			XY_WING -> context.getString(R.string.hint_strategy_xy_wing)
			XYZ_WING -> context.getString(R.string.hint_strategy_xyz_wing)
			X_CHAIN -> context.getString(R.string.hint_strategy_x_chain)
			X_CHAIN_LOOP -> context.getString(R.string.hint_strategy_x_chain_loop)
			X_CHAIN_ONE_ENDPOINT -> context.getString(R.string.hint_strategy_x_chain_one_endpoint)
			XY_CHAIN -> context.getString(R.string.hint_strategy_xy_chain)
			XY_CHAIN_LOOP -> context.getString(R.string.hint_strategy_xy_chain_loop)
			BUG1 -> context.getString(R.string.hint_strategy_bug1)
			UNIQUE_RECTANGLE_TYPE_1 -> context.getString(R.string.hint_strategy_unique_rectangle_type_1)
			UNIQUE_RECTANGLE_TYPE_1M -> context.getString(R.string.hint_strategy_unique_rectangle_type_1m)
			UNIQUE_RECTANGLE_TYPE_2 -> context.getString(R.string.hint_strategy_unique_rectangle_type_2)
			UNIQUE_RECTANGLE_TYPE_3 -> context.getString(R.string.hint_strategy_unique_rectangle_type_3)
			UNIQUE_RECTANGLE_TYPE_4 -> context.getString(R.string.hint_strategy_unique_rectangle_type_4)
			UNIQUE_RECTANGLE_TYPE_4M -> context.getString(R.string.hint_strategy_unique_rectangle_type_4m)
			UNIQUE_RECTANGLE_TYPE_5 -> context.getString(R.string.hint_strategy_unique_rectangle_type_5)
			UNIQUE_RECTANGLE_TYPE_5P -> context.getString(R.string.hint_strategy_unique_rectangle_type_5p)
			UNIQUE_RECTANGLE_TYPE_6 -> context.getString(R.string.hint_strategy_unique_rectangle_type_6)
			UNIQUE_RECTANGLE_TYPE_7 -> context.getString(R.string.hint_strategy_unique_rectangle_type_7)
			BASIC_FISH_4N_JELLYFISH -> context.getString(R.string.hint_strategy_fish_basic_4n)
			WXYZ_WING -> context.getString(R.string.hint_strategy_wxyz_wing)
			BASIC_FISH_5N_STARFISH -> context.getString(R.string.hint_strategy_fish_basic_5n)
			BASIC_FISH_6N_WHALE -> context.getString(R.string.hint_strategy_fish_basic_6n)
			BASIC_FISH_7N_LEVIATHAN -> context.getString(R.string.hint_strategy_fish_basic_7n)
			NO_NEXT_STEP_FOUND -> context.getString(R.string.hint_strategy_no_step_found)
		}
		return strategyName
	}

	companion object{

		fun getStrategyNameList(context: Context): List<String> {
			val lst = mutableListOf<String>()
			for (s in StrategyIds.entries) {
				if ( s.isStrategy() ) lst.add(s.getStrategyName(context))
			}
			return lst
		}

	}
}



