/*
 * This file is part of Open Sudoku - an open-source Sudoku game.
 * Copyright (C) 2009-2025 by Open Sudoku authors.
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package org.moire.opensudoku.game.command

import org.moire.opensudoku.game.CellMarks

class ClearAllMarksCommand : AbstractMultiMarksCommand() {
	override fun execute() {
		val cells = cells
		primaryMarksBeforeCommandEntries.clear()
		secondaryMarksBeforeCommandEntries.clear()
		cells.cells.forEachIndexed { rowIndex, row ->
			row.forEachIndexed { columnIndex, cell ->
				if (!cell.primaryMarks.isEmpty) {
					primaryMarksBeforeCommandEntries.add(MarksEntry(rowIndex, columnIndex, cell.primaryMarks))
					cell.primaryMarks = CellMarks()
				}
				if (!cell.secondaryMarks.isEmpty) {
					secondaryMarksBeforeCommandEntries.add(MarksEntry(rowIndex, columnIndex, cell.secondaryMarks))
					cell.secondaryMarks = CellMarks()
				}
			}
		}
	}
}
