/*
 * This file is part of Open Sudoku - an open-source Sudoku game.
 * Copyright (C) 2025-2025 by Open Sudoku authors.
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

//file:noinspection HardCodedStringLiteral
plugins {
	id("com.android.application")
	id("org.jetbrains.kotlin.android")
}

android {
	namespace = "org.moire.opensudoku"
	compileSdk = 35

	defaultConfig {
		applicationId = "org.moire.opensudoku"
		minSdk = 26
		targetSdk = 35
		versionCode = 20251109
		versionName = "4.5.8"

		testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner"
		vectorDrawables.useSupportLibrary = true
	}

	buildTypes {
		getByName("release") {
			isMinifyEnabled = true
			isShrinkResources = true
			proguardFiles(
				getDefaultProguardFile("proguard-android.txt"),
				"proguard-rules.pro"
			)
			ndk.debugSymbolLevel = "FULL"
		}
		getByName("debug") {
			versionNameSuffix = "-DBG"
			applicationIdSuffix = ".debug"
		}
		create("demo") {
			initWith(getByName("release"))
			versionNameSuffix = "-DMO"
			applicationIdSuffix = ".demo"
		}
	}

	compileOptions {
		encoding = "UTF-8"
		sourceCompatibility = JavaVersion.VERSION_17
		targetCompatibility = JavaVersion.VERSION_17
	}

	@Suppress("DEPRECATION")
	kotlinOptions {
		jvmTarget = "17"
	}

	packaging {
		jniLibs {
			excludes += "META-INF/*"
		}
		resources {
			excludes += "META-INF/*"
		}
	}

	lint {
		checkReleaseBuilds = false
	}

	buildFeatures {
		buildConfig = true
	}
}

tasks.withType<Test> {
	useJUnitPlatform()
}

dependencies {
	implementation("androidx.preference:preference:1.2.1")
	implementation("androidx.gridlayout:gridlayout:1.1.0")
	implementation("com.google.android.material:material:1.13.0")

	// The original net.margaritov.preference.colorpicker.ColorPickerPreference does not work
	// with androidx.preference.Preference.
	// This fork does, but is not published to a repository, so use the module direct from
	// GitHub. Gradle source dependencies do not support specifying a git ref or tag, so for
	// reproducibility, use the tag and depend on jitpack.io in the parent build.gradle.
	implementation("com.github.attenzione:android-ColorPickerPreference:1.2.1")

	testImplementation("org.jetbrains.kotlin:kotlin-test:2.2.21")
	testImplementation("io.kotest:kotest-assertions-core:6.0.4")

	androidTestImplementation("androidx.test.ext:junit-ktx:1.3.0")
	androidTestImplementation("androidx.test.espresso:espresso-core:3.7.0")
}
