// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

@file:Suppress("NAME_SHADOWING")

package uniffi.mages_ffi

// Common helper code.
//
// Ideally this would live in a separate .kt file where it can be unittested etc
// in isolation, and perhaps even published as a re-useable package.
//
// However, it's important that the details of how this helper code works (e.g. the
// way that different builtin types are passed across the FFI) exactly match what's
// expected by the Rust code on the other side of the interface. In practice right
// now that means coming from the exact some version of `uniffi` that was used to
// compile the Rust component. The easiest way to ensure this is to bundle the Kotlin
// helpers directly inline like we're doing here.

import com.sun.jna.Library
import com.sun.jna.IntegerType
import com.sun.jna.Native
import com.sun.jna.Pointer
import com.sun.jna.Structure
import com.sun.jna.Callback
import com.sun.jna.ptr.*
import java.nio.ByteBuffer
import java.nio.ByteOrder
import java.nio.CharBuffer
import java.nio.charset.CodingErrorAction
import java.util.concurrent.atomic.AtomicLong
import java.util.concurrent.ConcurrentHashMap
import java.util.concurrent.atomic.AtomicBoolean

// This is a helper for safely working with byte buffers returned from the Rust code.
// A rust-owned buffer is represented by its capacity, its current length, and a
// pointer to the underlying data.

/**
 * @suppress
 */
@Structure.FieldOrder("capacity", "len", "data")
open class RustBuffer : Structure() {
    // Note: `capacity` and `len` are actually `ULong` values, but JVM only supports signed values.
    // When dealing with these fields, make sure to call `toULong()`.
    @JvmField var capacity: Long = 0
    @JvmField var len: Long = 0
    @JvmField var data: Pointer? = null

    class ByValue: RustBuffer(), Structure.ByValue
    class ByReference: RustBuffer(), Structure.ByReference

   internal fun setValue(other: RustBuffer) {
        capacity = other.capacity
        len = other.len
        data = other.data
    }

    companion object {
        internal fun alloc(size: ULong = 0UL) = uniffiRustCall() { status ->
            // Note: need to convert the size to a `Long` value to make this work with JVM.
            UniffiLib.INSTANCE.ffi_mages_ffi_rustbuffer_alloc(size.toLong(), status)
        }.also {
            if(it.data == null) {
               throw RuntimeException("RustBuffer.alloc() returned null data pointer (size=${size})")
           }
        }

        internal fun create(capacity: ULong, len: ULong, data: Pointer?): RustBuffer.ByValue {
            var buf = RustBuffer.ByValue()
            buf.capacity = capacity.toLong()
            buf.len = len.toLong()
            buf.data = data
            return buf
        }

        internal fun free(buf: RustBuffer.ByValue) = uniffiRustCall() { status ->
            UniffiLib.INSTANCE.ffi_mages_ffi_rustbuffer_free(buf, status)
        }
    }

    @Suppress("TooGenericExceptionThrown")
    fun asByteBuffer() =
        this.data?.getByteBuffer(0, this.len.toLong())?.also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
}

/**
 * The equivalent of the `*mut RustBuffer` type.
 * Required for callbacks taking in an out pointer.
 *
 * Size is the sum of all values in the struct.
 *
 * @suppress
 */
class RustBufferByReference : ByReference(16) {
    /**
     * Set the pointed-to `RustBuffer` to the given value.
     */
    fun setValue(value: RustBuffer.ByValue) {
        // NOTE: The offsets are as they are in the C-like struct.
        val pointer = getPointer()
        pointer.setLong(0, value.capacity)
        pointer.setLong(8, value.len)
        pointer.setPointer(16, value.data)
    }

    /**
     * Get a `RustBuffer.ByValue` from this reference.
     */
    fun getValue(): RustBuffer.ByValue {
        val pointer = getPointer()
        val value = RustBuffer.ByValue()
        value.writeField("capacity", pointer.getLong(0))
        value.writeField("len", pointer.getLong(8))
        value.writeField("data", pointer.getLong(16))

        return value
    }
}

// This is a helper for safely passing byte references into the rust code.
// It's not actually used at the moment, because there aren't many things that you
// can take a direct pointer to in the JVM, and if we're going to copy something
// then we might as well copy it into a `RustBuffer`. But it's here for API
// completeness.

@Structure.FieldOrder("len", "data")
internal open class ForeignBytes : Structure() {
    @JvmField var len: Int = 0
    @JvmField var data: Pointer? = null

    class ByValue : ForeignBytes(), Structure.ByValue
}
/**
 * The FfiConverter interface handles converter types to and from the FFI
 *
 * All implementing objects should be public to support external types.  When a
 * type is external we need to import it's FfiConverter.
 *
 * @suppress
 */
public interface FfiConverter<KotlinType, FfiType> {
    // Convert an FFI type to a Kotlin type
    fun lift(value: FfiType): KotlinType

    // Convert an Kotlin type to an FFI type
    fun lower(value: KotlinType): FfiType

    // Read a Kotlin type from a `ByteBuffer`
    fun read(buf: ByteBuffer): KotlinType

    // Calculate bytes to allocate when creating a `RustBuffer`
    //
    // This must return at least as many bytes as the write() function will
    // write. It can return more bytes than needed, for example when writing
    // Strings we can't know the exact bytes needed until we the UTF-8
    // encoding, so we pessimistically allocate the largest size possible (3
    // bytes per codepoint).  Allocating extra bytes is not really a big deal
    // because the `RustBuffer` is short-lived.
    fun allocationSize(value: KotlinType): ULong

    // Write a Kotlin type to a `ByteBuffer`
    fun write(value: KotlinType, buf: ByteBuffer)

    // Lower a value into a `RustBuffer`
    //
    // This method lowers a value into a `RustBuffer` rather than the normal
    // FfiType.  It's used by the callback interface code.  Callback interface
    // returns are always serialized into a `RustBuffer` regardless of their
    // normal FFI type.
    fun lowerIntoRustBuffer(value: KotlinType): RustBuffer.ByValue {
        val rbuf = RustBuffer.alloc(allocationSize(value))
        try {
            val bbuf = rbuf.data!!.getByteBuffer(0, rbuf.capacity).also {
                it.order(ByteOrder.BIG_ENDIAN)
            }
            write(value, bbuf)
            rbuf.writeField("len", bbuf.position().toLong())
            return rbuf
        } catch (e: Throwable) {
            RustBuffer.free(rbuf)
            throw e
        }
    }

    // Lift a value from a `RustBuffer`.
    //
    // This here mostly because of the symmetry with `lowerIntoRustBuffer()`.
    // It's currently only used by the `FfiConverterRustBuffer` class below.
    fun liftFromRustBuffer(rbuf: RustBuffer.ByValue): KotlinType {
        val byteBuf = rbuf.asByteBuffer()!!
        try {
           val item = read(byteBuf)
           if (byteBuf.hasRemaining()) {
               throw RuntimeException("junk remaining in buffer after lifting, something is very wrong!!")
           }
           return item
        } finally {
            RustBuffer.free(rbuf)
        }
    }
}

/**
 * FfiConverter that uses `RustBuffer` as the FfiType
 *
 * @suppress
 */
public interface FfiConverterRustBuffer<KotlinType>: FfiConverter<KotlinType, RustBuffer.ByValue> {
    override fun lift(value: RustBuffer.ByValue) = liftFromRustBuffer(value)
    override fun lower(value: KotlinType) = lowerIntoRustBuffer(value)
}
// A handful of classes and functions to support the generated data structures.
// This would be a good candidate for isolating in its own ffi-support lib.

internal const val UNIFFI_CALL_SUCCESS = 0.toByte()
internal const val UNIFFI_CALL_ERROR = 1.toByte()
internal const val UNIFFI_CALL_UNEXPECTED_ERROR = 2.toByte()

@Structure.FieldOrder("code", "error_buf")
internal open class UniffiRustCallStatus : Structure() {
    @JvmField var code: Byte = 0
    @JvmField var error_buf: RustBuffer.ByValue = RustBuffer.ByValue()

    class ByValue: UniffiRustCallStatus(), Structure.ByValue

    fun isSuccess(): Boolean {
        return code == UNIFFI_CALL_SUCCESS
    }

    fun isError(): Boolean {
        return code == UNIFFI_CALL_ERROR
    }

    fun isPanic(): Boolean {
        return code == UNIFFI_CALL_UNEXPECTED_ERROR
    }

    companion object {
        fun create(code: Byte, errorBuf: RustBuffer.ByValue): UniffiRustCallStatus.ByValue {
            val callStatus = UniffiRustCallStatus.ByValue()
            callStatus.code = code
            callStatus.error_buf = errorBuf
            return callStatus
        }
    }
}

class InternalException(message: String) : kotlin.Exception(message)

/**
 * Each top-level error class has a companion object that can lift the error from the call status's rust buffer
 *
 * @suppress
 */
interface UniffiRustCallStatusErrorHandler<E> {
    fun lift(error_buf: RustBuffer.ByValue): E;
}

// Helpers for calling Rust
// In practice we usually need to be synchronized to call this safely, so it doesn't
// synchronize itself

// Call a rust function that returns a Result<>.  Pass in the Error class companion that corresponds to the Err
private inline fun <U, E: kotlin.Exception> uniffiRustCallWithError(errorHandler: UniffiRustCallStatusErrorHandler<E>, callback: (UniffiRustCallStatus) -> U): U {
    var status = UniffiRustCallStatus()
    val return_value = callback(status)
    uniffiCheckCallStatus(errorHandler, status)
    return return_value
}

// Check UniffiRustCallStatus and throw an error if the call wasn't successful
private fun<E: kotlin.Exception> uniffiCheckCallStatus(errorHandler: UniffiRustCallStatusErrorHandler<E>, status: UniffiRustCallStatus) {
    if (status.isSuccess()) {
        return
    } else if (status.isError()) {
        throw errorHandler.lift(status.error_buf)
    } else if (status.isPanic()) {
        // when the rust code sees a panic, it tries to construct a rustbuffer
        // with the message.  but if that code panics, then it just sends back
        // an empty buffer.
        if (status.error_buf.len > 0) {
            throw InternalException(FfiConverterString.lift(status.error_buf))
        } else {
            throw InternalException("Rust panic")
        }
    } else {
        throw InternalException("Unknown rust call status: $status.code")
    }
}

/**
 * UniffiRustCallStatusErrorHandler implementation for times when we don't expect a CALL_ERROR
 *
 * @suppress
 */
object UniffiNullRustCallStatusErrorHandler: UniffiRustCallStatusErrorHandler<InternalException> {
    override fun lift(error_buf: RustBuffer.ByValue): InternalException {
        RustBuffer.free(error_buf)
        return InternalException("Unexpected CALL_ERROR")
    }
}

// Call a rust function that returns a plain value
private inline fun <U> uniffiRustCall(callback: (UniffiRustCallStatus) -> U): U {
    return uniffiRustCallWithError(UniffiNullRustCallStatusErrorHandler, callback)
}

internal inline fun<T> uniffiTraitInterfaceCall(
    callStatus: UniffiRustCallStatus,
    makeCall: () -> T,
    writeReturn: (T) -> Unit,
) {
    try {
        writeReturn(makeCall())
    } catch(e: kotlin.Exception) {
        callStatus.code = UNIFFI_CALL_UNEXPECTED_ERROR
        callStatus.error_buf = FfiConverterString.lower(e.toString())
    }
}

internal inline fun<T, reified E: Throwable> uniffiTraitInterfaceCallWithError(
    callStatus: UniffiRustCallStatus,
    makeCall: () -> T,
    writeReturn: (T) -> Unit,
    lowerError: (E) -> RustBuffer.ByValue
) {
    try {
        writeReturn(makeCall())
    } catch(e: kotlin.Exception) {
        if (e is E) {
            callStatus.code = UNIFFI_CALL_ERROR
            callStatus.error_buf = lowerError(e)
        } else {
            callStatus.code = UNIFFI_CALL_UNEXPECTED_ERROR
            callStatus.error_buf = FfiConverterString.lower(e.toString())
        }
    }
}
// Map handles to objects
//
// This is used pass an opaque 64-bit handle representing a foreign object to the Rust code.
internal class UniffiHandleMap<T: Any> {
    private val map = ConcurrentHashMap<Long, T>()
    private val counter = java.util.concurrent.atomic.AtomicLong(0)

    val size: Int
        get() = map.size

    // Insert a new object into the handle map and get a handle for it
    fun insert(obj: T): Long {
        val handle = counter.getAndAdd(1)
        map.put(handle, obj)
        return handle
    }

    // Get an object from the handle map
    fun get(handle: Long): T {
        return map.get(handle) ?: throw InternalException("UniffiHandleMap.get: Invalid handle")
    }

    // Remove an entry from the handlemap and get the Kotlin object back
    fun remove(handle: Long): T {
        return map.remove(handle) ?: throw InternalException("UniffiHandleMap: Invalid handle")
    }
}

// Contains loading, initialization code,
// and the FFI Function declarations in a com.sun.jna.Library.
@Synchronized
private fun findLibraryName(componentName: String): String {
    val libOverride = System.getProperty("uniffi.component.$componentName.libraryOverride")
    if (libOverride != null) {
        return libOverride
    }
    return "mages_ffi"
}

private inline fun <reified Lib : Library> loadIndirect(
    componentName: String
): Lib {
    return Native.load<Lib>(findLibraryName(componentName), Lib::class.java)
}

// Define FFI callback types
internal interface UniffiRustFutureContinuationCallback : com.sun.jna.Callback {
    fun callback(`data`: Long,`pollResult`: Byte,)
}
internal interface UniffiForeignFutureFree : com.sun.jna.Callback {
    fun callback(`handle`: Long,)
}
internal interface UniffiCallbackInterfaceFree : com.sun.jna.Callback {
    fun callback(`handle`: Long,)
}
@Structure.FieldOrder("handle", "free")
internal open class UniffiForeignFuture(
    @JvmField internal var `handle`: Long = 0.toLong(),
    @JvmField internal var `free`: UniffiForeignFutureFree? = null,
) : Structure() {
    class UniffiByValue(
        `handle`: Long = 0.toLong(),
        `free`: UniffiForeignFutureFree? = null,
    ): UniffiForeignFuture(`handle`,`free`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFuture) {
        `handle` = other.`handle`
        `free` = other.`free`
    }

}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU8(
    @JvmField internal var `returnValue`: Byte = 0.toByte(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Byte = 0.toByte(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructU8(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructU8) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteU8 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructU8.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI8(
    @JvmField internal var `returnValue`: Byte = 0.toByte(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Byte = 0.toByte(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructI8(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructI8) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteI8 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructI8.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU16(
    @JvmField internal var `returnValue`: Short = 0.toShort(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Short = 0.toShort(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructU16(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructU16) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteU16 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructU16.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI16(
    @JvmField internal var `returnValue`: Short = 0.toShort(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Short = 0.toShort(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructI16(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructI16) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteI16 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructI16.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU32(
    @JvmField internal var `returnValue`: Int = 0,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Int = 0,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructU32(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructU32) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteU32 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructU32.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI32(
    @JvmField internal var `returnValue`: Int = 0,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Int = 0,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructI32(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructI32) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteI32 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructI32.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU64(
    @JvmField internal var `returnValue`: Long = 0.toLong(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Long = 0.toLong(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructU64(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructU64) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteU64 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructU64.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI64(
    @JvmField internal var `returnValue`: Long = 0.toLong(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Long = 0.toLong(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructI64(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructI64) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteI64 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructI64.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructF32(
    @JvmField internal var `returnValue`: Float = 0.0f,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Float = 0.0f,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructF32(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructF32) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteF32 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructF32.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructF64(
    @JvmField internal var `returnValue`: Double = 0.0,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Double = 0.0,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructF64(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructF64) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteF64 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructF64.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructPointer(
    @JvmField internal var `returnValue`: Pointer = Pointer.NULL,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Pointer = Pointer.NULL,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructPointer(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructPointer) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompletePointer : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructPointer.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructRustBuffer(
    @JvmField internal var `returnValue`: RustBuffer.ByValue = RustBuffer.ByValue(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: RustBuffer.ByValue = RustBuffer.ByValue(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructRustBuffer(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructRustBuffer) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteRustBuffer : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructRustBuffer.UniffiByValue,)
}
@Structure.FieldOrder("callStatus")
internal open class UniffiForeignFutureStructVoid(
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructVoid(`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructVoid) {
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteVoid : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructVoid.UniffiByValue,)
}
internal interface UniffiCallbackInterfaceCallObserverMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`invite`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceCallWidgetObserverMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`message`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceConnectionObserverMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`state`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceLiveLocationObserverMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`shares`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceProgressObserverMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`sent`: Long,`total`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceReceiptsObserverMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceRoomListObserverMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`items`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceRoomListObserverMethod1 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`item`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceSendObserverMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`update`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceSyncObserverMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`status`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceTimelineObserverMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`diff`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceTimelineObserverMethod1 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`message`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceTypingObserverMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`names`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceUrlOpenerMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`url`: RustBuffer.ByValue,`uniffiOutReturn`: ByteByReference,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceVerificationInboxObserverMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`flowId`: RustBuffer.ByValue,`fromUser`: RustBuffer.ByValue,`fromDevice`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceVerificationInboxObserverMethod1 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`message`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceVerificationObserverMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`flowId`: RustBuffer.ByValue,`phase`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceVerificationObserverMethod1 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`payload`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceVerificationObserverMethod2 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`flowId`: RustBuffer.ByValue,`message`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
@Structure.FieldOrder("onInvite", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceCallObserver(
    @JvmField internal var `onInvite`: UniffiCallbackInterfaceCallObserverMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `onInvite`: UniffiCallbackInterfaceCallObserverMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceCallObserver(`onInvite`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceCallObserver) {
        `onInvite` = other.`onInvite`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("onToWidget", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceCallWidgetObserver(
    @JvmField internal var `onToWidget`: UniffiCallbackInterfaceCallWidgetObserverMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `onToWidget`: UniffiCallbackInterfaceCallWidgetObserverMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceCallWidgetObserver(`onToWidget`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceCallWidgetObserver) {
        `onToWidget` = other.`onToWidget`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("onConnectionChange", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceConnectionObserver(
    @JvmField internal var `onConnectionChange`: UniffiCallbackInterfaceConnectionObserverMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `onConnectionChange`: UniffiCallbackInterfaceConnectionObserverMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceConnectionObserver(`onConnectionChange`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceConnectionObserver) {
        `onConnectionChange` = other.`onConnectionChange`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("onUpdate", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceLiveLocationObserver(
    @JvmField internal var `onUpdate`: UniffiCallbackInterfaceLiveLocationObserverMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `onUpdate`: UniffiCallbackInterfaceLiveLocationObserverMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceLiveLocationObserver(`onUpdate`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceLiveLocationObserver) {
        `onUpdate` = other.`onUpdate`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("onProgress", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceProgressObserver(
    @JvmField internal var `onProgress`: UniffiCallbackInterfaceProgressObserverMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `onProgress`: UniffiCallbackInterfaceProgressObserverMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceProgressObserver(`onProgress`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceProgressObserver) {
        `onProgress` = other.`onProgress`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("onChanged", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceReceiptsObserver(
    @JvmField internal var `onChanged`: UniffiCallbackInterfaceReceiptsObserverMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `onChanged`: UniffiCallbackInterfaceReceiptsObserverMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceReceiptsObserver(`onChanged`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceReceiptsObserver) {
        `onChanged` = other.`onChanged`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("onReset", "onUpdate", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceRoomListObserver(
    @JvmField internal var `onReset`: UniffiCallbackInterfaceRoomListObserverMethod0? = null,
    @JvmField internal var `onUpdate`: UniffiCallbackInterfaceRoomListObserverMethod1? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `onReset`: UniffiCallbackInterfaceRoomListObserverMethod0? = null,
        `onUpdate`: UniffiCallbackInterfaceRoomListObserverMethod1? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceRoomListObserver(`onReset`,`onUpdate`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceRoomListObserver) {
        `onReset` = other.`onReset`
        `onUpdate` = other.`onUpdate`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("onUpdate", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceSendObserver(
    @JvmField internal var `onUpdate`: UniffiCallbackInterfaceSendObserverMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `onUpdate`: UniffiCallbackInterfaceSendObserverMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceSendObserver(`onUpdate`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceSendObserver) {
        `onUpdate` = other.`onUpdate`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("onState", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceSyncObserver(
    @JvmField internal var `onState`: UniffiCallbackInterfaceSyncObserverMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `onState`: UniffiCallbackInterfaceSyncObserverMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceSyncObserver(`onState`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceSyncObserver) {
        `onState` = other.`onState`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("onDiff", "onError", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceTimelineObserver(
    @JvmField internal var `onDiff`: UniffiCallbackInterfaceTimelineObserverMethod0? = null,
    @JvmField internal var `onError`: UniffiCallbackInterfaceTimelineObserverMethod1? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `onDiff`: UniffiCallbackInterfaceTimelineObserverMethod0? = null,
        `onError`: UniffiCallbackInterfaceTimelineObserverMethod1? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceTimelineObserver(`onDiff`,`onError`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceTimelineObserver) {
        `onDiff` = other.`onDiff`
        `onError` = other.`onError`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("onUpdate", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceTypingObserver(
    @JvmField internal var `onUpdate`: UniffiCallbackInterfaceTypingObserverMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `onUpdate`: UniffiCallbackInterfaceTypingObserverMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceTypingObserver(`onUpdate`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceTypingObserver) {
        `onUpdate` = other.`onUpdate`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("open", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceUrlOpener(
    @JvmField internal var `open`: UniffiCallbackInterfaceUrlOpenerMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `open`: UniffiCallbackInterfaceUrlOpenerMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceUrlOpener(`open`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceUrlOpener) {
        `open` = other.`open`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("onRequest", "onError", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceVerificationInboxObserver(
    @JvmField internal var `onRequest`: UniffiCallbackInterfaceVerificationInboxObserverMethod0? = null,
    @JvmField internal var `onError`: UniffiCallbackInterfaceVerificationInboxObserverMethod1? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `onRequest`: UniffiCallbackInterfaceVerificationInboxObserverMethod0? = null,
        `onError`: UniffiCallbackInterfaceVerificationInboxObserverMethod1? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceVerificationInboxObserver(`onRequest`,`onError`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceVerificationInboxObserver) {
        `onRequest` = other.`onRequest`
        `onError` = other.`onError`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("onPhase", "onEmojis", "onError", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceVerificationObserver(
    @JvmField internal var `onPhase`: UniffiCallbackInterfaceVerificationObserverMethod0? = null,
    @JvmField internal var `onEmojis`: UniffiCallbackInterfaceVerificationObserverMethod1? = null,
    @JvmField internal var `onError`: UniffiCallbackInterfaceVerificationObserverMethod2? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `onPhase`: UniffiCallbackInterfaceVerificationObserverMethod0? = null,
        `onEmojis`: UniffiCallbackInterfaceVerificationObserverMethod1? = null,
        `onError`: UniffiCallbackInterfaceVerificationObserverMethod2? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceVerificationObserver(`onPhase`,`onEmojis`,`onError`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceVerificationObserver) {
        `onPhase` = other.`onPhase`
        `onEmojis` = other.`onEmojis`
        `onError` = other.`onError`
        `uniffiFree` = other.`uniffiFree`
    }

}



























































































































































































































































































































































































// For large crates we prevent `MethodTooLargeException` (see #2340)
// N.B. the name of the extension is very misleading, since it is 
// rather `InterfaceTooLargeException`, caused by too many methods 
// in the interface for large crates.
//
// By splitting the otherwise huge interface into two parts
// * UniffiLib 
// * IntegrityCheckingUniffiLib (this)
// we allow for ~2x as many methods in the UniffiLib interface.
// 
// The `ffi_uniffi_contract_version` method and all checksum methods are put 
// into `IntegrityCheckingUniffiLib` and these methods are called only once,
// when the library is loaded.
internal interface IntegrityCheckingUniffiLib : Library {
    // Integrity check functions only
    fun uniffi_mages_ffi_checksum_method_client_accept_invite(
): Short
fun uniffi_mages_ffi_checksum_method_client_accept_verification(
): Short
fun uniffi_mages_ffi_checksum_method_client_ban_user(
): Short
fun uniffi_mages_ffi_checksum_method_client_call_widget_from_webview(
): Short
fun uniffi_mages_ffi_checksum_method_client_cancel_verification(
): Short
fun uniffi_mages_ffi_checksum_method_client_cancel_verification_request(
): Short
fun uniffi_mages_ffi_checksum_method_client_check_verification_request(
): Short
fun uniffi_mages_ffi_checksum_method_client_confirm_verification(
): Short
fun uniffi_mages_ffi_checksum_method_client_create_room(
): Short
fun uniffi_mages_ffi_checksum_method_client_create_space(
): Short
fun uniffi_mages_ffi_checksum_method_client_dm_peer_user_id(
): Short
fun uniffi_mages_ffi_checksum_method_client_download_attachment_to_cache_file(
): Short
fun uniffi_mages_ffi_checksum_method_client_download_attachment_to_path(
): Short
fun uniffi_mages_ffi_checksum_method_client_edit(
): Short
fun uniffi_mages_ffi_checksum_method_client_enable_room_encryption(
): Short
fun uniffi_mages_ffi_checksum_method_client_encryption_catchup_once(
): Short
fun uniffi_mages_ffi_checksum_method_client_enqueue_text(
): Short
fun uniffi_mages_ffi_checksum_method_client_ensure_dm(
): Short
fun uniffi_mages_ffi_checksum_method_client_ensure_send_queue_supervision(
): Short
fun uniffi_mages_ffi_checksum_method_client_enter_background(
): Short
fun uniffi_mages_ffi_checksum_method_client_enter_foreground(
): Short
fun uniffi_mages_ffi_checksum_method_client_fetch_notification(
): Short
fun uniffi_mages_ffi_checksum_method_client_fetch_notifications_since(
): Short
fun uniffi_mages_ffi_checksum_method_client_get_presence(
): Short
fun uniffi_mages_ffi_checksum_method_client_ignore_user(
): Short
fun uniffi_mages_ffi_checksum_method_client_ignored_users(
): Short
fun uniffi_mages_ffi_checksum_method_client_invite_user(
): Short
fun uniffi_mages_ffi_checksum_method_client_is_event_read_by(
): Short
fun uniffi_mages_ffi_checksum_method_client_is_logged_in(
): Short
fun uniffi_mages_ffi_checksum_method_client_is_marked_unread(
): Short
fun uniffi_mages_ffi_checksum_method_client_is_space(
): Short
fun uniffi_mages_ffi_checksum_method_client_is_user_ignored(
): Short
fun uniffi_mages_ffi_checksum_method_client_join_by_id_or_alias(
): Short
fun uniffi_mages_ffi_checksum_method_client_kick_user(
): Short
fun uniffi_mages_ffi_checksum_method_client_leave_room(
): Short
fun uniffi_mages_ffi_checksum_method_client_list_invited(
): Short
fun uniffi_mages_ffi_checksum_method_client_list_members(
): Short
fun uniffi_mages_ffi_checksum_method_client_list_my_devices(
): Short
fun uniffi_mages_ffi_checksum_method_client_load_room_list_cache(
): Short
fun uniffi_mages_ffi_checksum_method_client_login(
): Short
fun uniffi_mages_ffi_checksum_method_client_login_sso_loopback(
): Short
fun uniffi_mages_ffi_checksum_method_client_logout(
): Short
fun uniffi_mages_ffi_checksum_method_client_mark_fully_read_at(
): Short
fun uniffi_mages_ffi_checksum_method_client_mark_read(
): Short
fun uniffi_mages_ffi_checksum_method_client_mark_read_at(
): Short
fun uniffi_mages_ffi_checksum_method_client_media_cache_clean(
): Short
fun uniffi_mages_ffi_checksum_method_client_monitor_connection(
): Short
fun uniffi_mages_ffi_checksum_method_client_mxc_thumbnail_to_cache(
): Short
fun uniffi_mages_ffi_checksum_method_client_my_spaces(
): Short
fun uniffi_mages_ffi_checksum_method_client_next_sub_id(
): Short
fun uniffi_mages_ffi_checksum_method_client_observe_live_location(
): Short
fun uniffi_mages_ffi_checksum_method_client_observe_own_receipt(
): Short
fun uniffi_mages_ffi_checksum_method_client_observe_receipts(
): Short
fun uniffi_mages_ffi_checksum_method_client_observe_room_list(
): Short
fun uniffi_mages_ffi_checksum_method_client_observe_sends(
): Short
fun uniffi_mages_ffi_checksum_method_client_observe_timeline(
): Short
fun uniffi_mages_ffi_checksum_method_client_observe_typing(
): Short
fun uniffi_mages_ffi_checksum_method_client_own_last_read(
): Short
fun uniffi_mages_ffi_checksum_method_client_paginate_backwards(
): Short
fun uniffi_mages_ffi_checksum_method_client_paginate_forwards(
): Short
fun uniffi_mages_ffi_checksum_method_client_public_rooms(
): Short
fun uniffi_mages_ffi_checksum_method_client_publish_room_alias(
): Short
fun uniffi_mages_ffi_checksum_method_client_react(
): Short
fun uniffi_mages_ffi_checksum_method_client_reactions_batch(
): Short
fun uniffi_mages_ffi_checksum_method_client_reactions_for_event(
): Short
fun uniffi_mages_ffi_checksum_method_client_recent_events(
): Short
fun uniffi_mages_ffi_checksum_method_client_recover_with_key(
): Short
fun uniffi_mages_ffi_checksum_method_client_redact(
): Short
fun uniffi_mages_ffi_checksum_method_client_register_unifiedpush(
): Short
fun uniffi_mages_ffi_checksum_method_client_reply(
): Short
fun uniffi_mages_ffi_checksum_method_client_resolve_room_id(
): Short
fun uniffi_mages_ffi_checksum_method_client_retry_by_txn(
): Short
fun uniffi_mages_ffi_checksum_method_client_room_directory_visibility(
): Short
fun uniffi_mages_ffi_checksum_method_client_room_list_set_unread_only(
): Short
fun uniffi_mages_ffi_checksum_method_client_room_notification_mode(
): Short
fun uniffi_mages_ffi_checksum_method_client_room_predecessor(
): Short
fun uniffi_mages_ffi_checksum_method_client_room_profile(
): Short
fun uniffi_mages_ffi_checksum_method_client_room_send_queue_set_enabled(
): Short
fun uniffi_mages_ffi_checksum_method_client_room_successor(
): Short
fun uniffi_mages_ffi_checksum_method_client_room_tags(
): Short
fun uniffi_mages_ffi_checksum_method_client_room_unread_stats(
): Short
fun uniffi_mages_ffi_checksum_method_client_room_upgrade_links(
): Short
fun uniffi_mages_ffi_checksum_method_client_rooms(
): Short
fun uniffi_mages_ffi_checksum_method_client_search_room(
): Short
fun uniffi_mages_ffi_checksum_method_client_search_users(
): Short
fun uniffi_mages_ffi_checksum_method_client_seen_by_for_event(
): Short
fun uniffi_mages_ffi_checksum_method_client_send_attachment_bytes(
): Short
fun uniffi_mages_ffi_checksum_method_client_send_attachment_from_path(
): Short
fun uniffi_mages_ffi_checksum_method_client_send_existing_attachment(
): Short
fun uniffi_mages_ffi_checksum_method_client_send_live_location(
): Short
fun uniffi_mages_ffi_checksum_method_client_send_message(
): Short
fun uniffi_mages_ffi_checksum_method_client_send_poll_end(
): Short
fun uniffi_mages_ffi_checksum_method_client_send_poll_response(
): Short
fun uniffi_mages_ffi_checksum_method_client_send_poll_start(
): Short
fun uniffi_mages_ffi_checksum_method_client_send_queue_set_enabled(
): Short
fun uniffi_mages_ffi_checksum_method_client_send_thread_text(
): Short
fun uniffi_mages_ffi_checksum_method_client_set_mark_unread(
): Short
fun uniffi_mages_ffi_checksum_method_client_set_media_retention_policy(
): Short
fun uniffi_mages_ffi_checksum_method_client_set_presence(
): Short
fun uniffi_mages_ffi_checksum_method_client_set_room_canonical_alias(
): Short
fun uniffi_mages_ffi_checksum_method_client_set_room_directory_visibility(
): Short
fun uniffi_mages_ffi_checksum_method_client_set_room_favourite(
): Short
fun uniffi_mages_ffi_checksum_method_client_set_room_history_visibility(
): Short
fun uniffi_mages_ffi_checksum_method_client_set_room_join_rule(
): Short
fun uniffi_mages_ffi_checksum_method_client_set_room_low_priority(
): Short
fun uniffi_mages_ffi_checksum_method_client_set_room_name(
): Short
fun uniffi_mages_ffi_checksum_method_client_set_room_notification_mode(
): Short
fun uniffi_mages_ffi_checksum_method_client_set_room_topic(
): Short
fun uniffi_mages_ffi_checksum_method_client_set_typing(
): Short
fun uniffi_mages_ffi_checksum_method_client_shutdown(
): Short
fun uniffi_mages_ffi_checksum_method_client_space_add_child(
): Short
fun uniffi_mages_ffi_checksum_method_client_space_hierarchy(
): Short
fun uniffi_mages_ffi_checksum_method_client_space_invite_user(
): Short
fun uniffi_mages_ffi_checksum_method_client_space_remove_child(
): Short
fun uniffi_mages_ffi_checksum_method_client_start_call_inbox(
): Short
fun uniffi_mages_ffi_checksum_method_client_start_element_call(
): Short
fun uniffi_mages_ffi_checksum_method_client_start_live_location(
): Short
fun uniffi_mages_ffi_checksum_method_client_start_self_sas(
): Short
fun uniffi_mages_ffi_checksum_method_client_start_supervised_sync(
): Short
fun uniffi_mages_ffi_checksum_method_client_start_user_sas(
): Short
fun uniffi_mages_ffi_checksum_method_client_start_verification_inbox(
): Short
fun uniffi_mages_ffi_checksum_method_client_stop_call_inbox(
): Short
fun uniffi_mages_ffi_checksum_method_client_stop_element_call(
): Short
fun uniffi_mages_ffi_checksum_method_client_stop_live_location(
): Short
fun uniffi_mages_ffi_checksum_method_client_thread_replies(
): Short
fun uniffi_mages_ffi_checksum_method_client_thread_summary(
): Short
fun uniffi_mages_ffi_checksum_method_client_thumbnail_to_cache(
): Short
fun uniffi_mages_ffi_checksum_method_client_unban_user(
): Short
fun uniffi_mages_ffi_checksum_method_client_unignore_user(
): Short
fun uniffi_mages_ffi_checksum_method_client_unobserve_connection(
): Short
fun uniffi_mages_ffi_checksum_method_client_unobserve_live_location(
): Short
fun uniffi_mages_ffi_checksum_method_client_unobserve_receipts(
): Short
fun uniffi_mages_ffi_checksum_method_client_unobserve_room_list(
): Short
fun uniffi_mages_ffi_checksum_method_client_unobserve_sends(
): Short
fun uniffi_mages_ffi_checksum_method_client_unobserve_timeline(
): Short
fun uniffi_mages_ffi_checksum_method_client_unobserve_typing(
): Short
fun uniffi_mages_ffi_checksum_method_client_unobserve_verification_inbox(
): Short
fun uniffi_mages_ffi_checksum_method_client_unpublish_room_alias(
): Short
fun uniffi_mages_ffi_checksum_method_client_unregister_unifiedpush(
): Short
fun uniffi_mages_ffi_checksum_method_client_upgrade_room(
): Short
fun uniffi_mages_ffi_checksum_method_client_wake_sync_once(
): Short
fun uniffi_mages_ffi_checksum_method_client_whoami(
): Short
fun uniffi_mages_ffi_checksum_constructor_client_new(
): Short
fun uniffi_mages_ffi_checksum_method_callobserver_on_invite(
): Short
fun uniffi_mages_ffi_checksum_method_callwidgetobserver_on_to_widget(
): Short
fun uniffi_mages_ffi_checksum_method_connectionobserver_on_connection_change(
): Short
fun uniffi_mages_ffi_checksum_method_livelocationobserver_on_update(
): Short
fun uniffi_mages_ffi_checksum_method_progressobserver_on_progress(
): Short
fun uniffi_mages_ffi_checksum_method_receiptsobserver_on_changed(
): Short
fun uniffi_mages_ffi_checksum_method_roomlistobserver_on_reset(
): Short
fun uniffi_mages_ffi_checksum_method_roomlistobserver_on_update(
): Short
fun uniffi_mages_ffi_checksum_method_sendobserver_on_update(
): Short
fun uniffi_mages_ffi_checksum_method_syncobserver_on_state(
): Short
fun uniffi_mages_ffi_checksum_method_timelineobserver_on_diff(
): Short
fun uniffi_mages_ffi_checksum_method_timelineobserver_on_error(
): Short
fun uniffi_mages_ffi_checksum_method_typingobserver_on_update(
): Short
fun uniffi_mages_ffi_checksum_method_urlopener_open(
): Short
fun uniffi_mages_ffi_checksum_method_verificationinboxobserver_on_request(
): Short
fun uniffi_mages_ffi_checksum_method_verificationinboxobserver_on_error(
): Short
fun uniffi_mages_ffi_checksum_method_verificationobserver_on_phase(
): Short
fun uniffi_mages_ffi_checksum_method_verificationobserver_on_emojis(
): Short
fun uniffi_mages_ffi_checksum_method_verificationobserver_on_error(
): Short
fun ffi_mages_ffi_uniffi_contract_version(
): Int

}

// A JNA Library to expose the extern-C FFI definitions.
// This is an implementation detail which will be called internally by the public API.
internal interface UniffiLib : Library {
    companion object {
        internal val INSTANCE: UniffiLib by lazy {
            val componentName = "mages_ffi"
            // For large crates we prevent `MethodTooLargeException` (see #2340)
            // N.B. the name of the extension is very misleading, since it is 
            // rather `InterfaceTooLargeException`, caused by too many methods 
            // in the interface for large crates.
            //
            // By splitting the otherwise huge interface into two parts
            // * UniffiLib (this)
            // * IntegrityCheckingUniffiLib
            // And all checksum methods are put into `IntegrityCheckingUniffiLib`
            // we allow for ~2x as many methods in the UniffiLib interface.
            // 
            // Thus we first load the library with `loadIndirect` as `IntegrityCheckingUniffiLib`
            // so that we can (optionally!) call `uniffiCheckApiChecksums`...
            loadIndirect<IntegrityCheckingUniffiLib>(componentName)
                .also { lib: IntegrityCheckingUniffiLib ->
                    uniffiCheckContractApiVersion(lib)
                    uniffiCheckApiChecksums(lib)
                }
            // ... and then we load the library as `UniffiLib`
            // N.B. we cannot use `loadIndirect` once and then try to cast it to `UniffiLib`
            // => results in `java.lang.ClassCastException: com.sun.proxy.$Proxy cannot be cast to ...`
            // error. So we must call `loadIndirect` twice. For crates large enough
            // to trigger this issue, the performance impact is negligible, running on
            // a macOS M1 machine the `loadIndirect` call takes ~50ms.
            val lib = loadIndirect<UniffiLib>(componentName)
            // No need to check the contract version and checksums, since 
            // we already did that with `IntegrityCheckingUniffiLib` above.
            uniffiCallbackInterfaceCallObserver.register(lib)
            uniffiCallbackInterfaceCallWidgetObserver.register(lib)
            uniffiCallbackInterfaceConnectionObserver.register(lib)
            uniffiCallbackInterfaceLiveLocationObserver.register(lib)
            uniffiCallbackInterfaceProgressObserver.register(lib)
            uniffiCallbackInterfaceReceiptsObserver.register(lib)
            uniffiCallbackInterfaceRoomListObserver.register(lib)
            uniffiCallbackInterfaceSendObserver.register(lib)
            uniffiCallbackInterfaceSyncObserver.register(lib)
            uniffiCallbackInterfaceTimelineObserver.register(lib)
            uniffiCallbackInterfaceTypingObserver.register(lib)
            uniffiCallbackInterfaceUrlOpener.register(lib)
            uniffiCallbackInterfaceVerificationInboxObserver.register(lib)
            uniffiCallbackInterfaceVerificationObserver.register(lib)
            // Loading of library with integrity check done.
            lib
        }
        
        // The Cleaner for the whole library
        internal val CLEANER: UniffiCleaner by lazy {
            UniffiCleaner.create()
        }
    }

    // FFI functions
    fun uniffi_mages_ffi_fn_clone_client(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_mages_ffi_fn_free_client(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_mages_ffi_fn_constructor_client_new(`homeserverUrl`: RustBuffer.ByValue,`storeDir`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_mages_ffi_fn_method_client_accept_invite(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_accept_verification(`ptr`: Pointer,`flowId`: RustBuffer.ByValue,`otherUserId`: RustBuffer.ByValue,`observer`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_ban_user(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`userId`: RustBuffer.ByValue,`reason`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_call_widget_from_webview(`ptr`: Pointer,`sessionId`: Long,`message`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_cancel_verification(`ptr`: Pointer,`flowId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_cancel_verification_request(`ptr`: Pointer,`flowId`: RustBuffer.ByValue,`otherUserId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_check_verification_request(`ptr`: Pointer,`userId`: RustBuffer.ByValue,`flowId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_confirm_verification(`ptr`: Pointer,`flowId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_create_room(`ptr`: Pointer,`name`: RustBuffer.ByValue,`topic`: RustBuffer.ByValue,`invitees`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_create_space(`ptr`: Pointer,`name`: RustBuffer.ByValue,`topic`: RustBuffer.ByValue,`isPublic`: Byte,`invitees`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_dm_peer_user_id(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_download_attachment_to_cache_file(`ptr`: Pointer,`att`: RustBuffer.ByValue,`filenameHint`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_download_attachment_to_path(`ptr`: Pointer,`att`: RustBuffer.ByValue,`savePath`: RustBuffer.ByValue,`progress`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_edit(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`targetEventId`: RustBuffer.ByValue,`newBody`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_enable_room_encryption(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_encryption_catchup_once(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_enqueue_text(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`body`: RustBuffer.ByValue,`txnId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_ensure_dm(`ptr`: Pointer,`userId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_ensure_send_queue_supervision(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_mages_ffi_fn_method_client_enter_background(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_mages_ffi_fn_method_client_enter_foreground(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_mages_ffi_fn_method_client_fetch_notification(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`eventId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_fetch_notifications_since(`ptr`: Pointer,`sinceTsMs`: Long,`maxRooms`: Int,`maxEvents`: Int,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_get_presence(`ptr`: Pointer,`userId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_ignore_user(`ptr`: Pointer,`userId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_mages_ffi_fn_method_client_ignored_users(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_invite_user(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`userId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_is_event_read_by(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`eventId`: RustBuffer.ByValue,`userId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_is_logged_in(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_is_marked_unread(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_is_space(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_is_user_ignored(`ptr`: Pointer,`userId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_join_by_id_or_alias(`ptr`: Pointer,`idOrAlias`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_kick_user(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`userId`: RustBuffer.ByValue,`reason`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_leave_room(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_mages_ffi_fn_method_client_list_invited(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_list_members(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_list_my_devices(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_load_room_list_cache(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_login(`ptr`: Pointer,`username`: RustBuffer.ByValue,`password`: RustBuffer.ByValue,`deviceDisplayName`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_mages_ffi_fn_method_client_login_sso_loopback(`ptr`: Pointer,`opener`: Long,`deviceName`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_mages_ffi_fn_method_client_logout(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_mark_fully_read_at(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`eventId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_mark_read(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_mark_read_at(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`eventId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_media_cache_clean(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_mages_ffi_fn_method_client_monitor_connection(`ptr`: Pointer,`observer`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Long
fun uniffi_mages_ffi_fn_method_client_mxc_thumbnail_to_cache(`ptr`: Pointer,`mxcUri`: RustBuffer.ByValue,`width`: Int,`height`: Int,`crop`: Byte,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_my_spaces(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_next_sub_id(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Long
fun uniffi_mages_ffi_fn_method_client_observe_live_location(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`observer`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Long
fun uniffi_mages_ffi_fn_method_client_observe_own_receipt(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`observer`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Long
fun uniffi_mages_ffi_fn_method_client_observe_receipts(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`observer`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Long
fun uniffi_mages_ffi_fn_method_client_observe_room_list(`ptr`: Pointer,`observer`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Long
fun uniffi_mages_ffi_fn_method_client_observe_sends(`ptr`: Pointer,`observer`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Long
fun uniffi_mages_ffi_fn_method_client_observe_timeline(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`observer`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Long
fun uniffi_mages_ffi_fn_method_client_observe_typing(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`observer`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Long
fun uniffi_mages_ffi_fn_method_client_own_last_read(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_paginate_backwards(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`count`: Short,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_paginate_forwards(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`count`: Short,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_public_rooms(`ptr`: Pointer,`server`: RustBuffer.ByValue,`search`: RustBuffer.ByValue,`limit`: Int,`since`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_publish_room_alias(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`alias`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_react(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`eventId`: RustBuffer.ByValue,`emoji`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_reactions_batch(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`eventIds`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_reactions_for_event(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`eventId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_recent_events(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`limit`: Int,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_recover_with_key(`ptr`: Pointer,`recoveryKey`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_redact(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`eventId`: RustBuffer.ByValue,`reason`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_register_unifiedpush(`ptr`: Pointer,`appId`: RustBuffer.ByValue,`pushkey`: RustBuffer.ByValue,`gatewayUrl`: RustBuffer.ByValue,`deviceDisplayName`: RustBuffer.ByValue,`lang`: RustBuffer.ByValue,`profileTag`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_reply(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`inReplyTo`: RustBuffer.ByValue,`body`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_resolve_room_id(`ptr`: Pointer,`idOrAlias`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_retry_by_txn(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`txnId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_room_directory_visibility(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_room_list_set_unread_only(`ptr`: Pointer,`token`: Long,`unreadOnly`: Byte,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_room_notification_mode(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_room_predecessor(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_room_profile(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_room_send_queue_set_enabled(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`enabled`: Byte,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_room_successor(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_room_tags(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_room_unread_stats(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_room_upgrade_links(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_rooms(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_search_room(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`query`: RustBuffer.ByValue,`limit`: Int,`offset`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_search_users(`ptr`: Pointer,`searchTerm`: RustBuffer.ByValue,`limit`: Long,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_seen_by_for_event(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`eventId`: RustBuffer.ByValue,`limit`: Int,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_send_attachment_bytes(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`filename`: RustBuffer.ByValue,`mime`: RustBuffer.ByValue,`bytes`: RustBuffer.ByValue,`progress`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_send_attachment_from_path(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`path`: RustBuffer.ByValue,`mime`: RustBuffer.ByValue,`filename`: RustBuffer.ByValue,`progress`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_send_existing_attachment(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`att`: RustBuffer.ByValue,`body`: RustBuffer.ByValue,`progress`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_send_live_location(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`geoUri`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_mages_ffi_fn_method_client_send_message(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`body`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_send_poll_end(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`pollEventId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_mages_ffi_fn_method_client_send_poll_response(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`pollEventId`: RustBuffer.ByValue,`answers`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_mages_ffi_fn_method_client_send_poll_start(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`def`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_send_queue_set_enabled(`ptr`: Pointer,`enabled`: Byte,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_send_thread_text(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`rootEventId`: RustBuffer.ByValue,`body`: RustBuffer.ByValue,`replyToEventId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_set_mark_unread(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`unread`: Byte,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_set_media_retention_policy(`ptr`: Pointer,`maxCacheSizeBytes`: RustBuffer.ByValue,`maxFileSizeBytes`: RustBuffer.ByValue,`lastAccessExpirySecs`: RustBuffer.ByValue,`cleanupFrequencySecs`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_mages_ffi_fn_method_client_set_presence(`ptr`: Pointer,`state`: RustBuffer.ByValue,`statusMsg`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_mages_ffi_fn_method_client_set_room_canonical_alias(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`alias`: RustBuffer.ByValue,`altAliases`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_mages_ffi_fn_method_client_set_room_directory_visibility(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`visibility`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_mages_ffi_fn_method_client_set_room_favourite(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`fav`: Byte,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_set_room_history_visibility(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`vis`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_mages_ffi_fn_method_client_set_room_join_rule(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`rule`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_mages_ffi_fn_method_client_set_room_low_priority(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`low`: Byte,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_set_room_name(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`name`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_set_room_notification_mode(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`mode`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_mages_ffi_fn_method_client_set_room_topic(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`topic`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_set_typing(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`typing`: Byte,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_shutdown(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_mages_ffi_fn_method_client_space_add_child(`ptr`: Pointer,`spaceId`: RustBuffer.ByValue,`childRoomId`: RustBuffer.ByValue,`order`: RustBuffer.ByValue,`suggested`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_mages_ffi_fn_method_client_space_hierarchy(`ptr`: Pointer,`spaceId`: RustBuffer.ByValue,`from`: RustBuffer.ByValue,`limit`: Int,`maxDepth`: RustBuffer.ByValue,`suggestedOnly`: Byte,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_space_invite_user(`ptr`: Pointer,`spaceId`: RustBuffer.ByValue,`userId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_space_remove_child(`ptr`: Pointer,`spaceId`: RustBuffer.ByValue,`childRoomId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_mages_ffi_fn_method_client_start_call_inbox(`ptr`: Pointer,`observer`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Long
fun uniffi_mages_ffi_fn_method_client_start_element_call(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`elementCallUrl`: RustBuffer.ByValue,`intent`: RustBuffer.ByValue,`observer`: Long,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_start_live_location(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`durationMs`: Long,`description`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_mages_ffi_fn_method_client_start_self_sas(`ptr`: Pointer,`deviceId`: RustBuffer.ByValue,`observer`: Long,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_start_supervised_sync(`ptr`: Pointer,`observer`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_mages_ffi_fn_method_client_start_user_sas(`ptr`: Pointer,`userId`: RustBuffer.ByValue,`observer`: Long,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_start_verification_inbox(`ptr`: Pointer,`observer`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Long
fun uniffi_mages_ffi_fn_method_client_stop_call_inbox(`ptr`: Pointer,`token`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_stop_element_call(`ptr`: Pointer,`sessionId`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_stop_live_location(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_mages_ffi_fn_method_client_thread_replies(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`rootEventId`: RustBuffer.ByValue,`from`: RustBuffer.ByValue,`limit`: Int,`directionForward`: Byte,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_thread_summary(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`rootEventId`: RustBuffer.ByValue,`perPage`: Int,`maxPages`: Int,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_thumbnail_to_cache(`ptr`: Pointer,`att`: RustBuffer.ByValue,`width`: Int,`height`: Int,`useCrop`: Byte,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_unban_user(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`userId`: RustBuffer.ByValue,`reason`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_unignore_user(`ptr`: Pointer,`userId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_mages_ffi_fn_method_client_unobserve_connection(`ptr`: Pointer,`subId`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_unobserve_live_location(`ptr`: Pointer,`subId`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_unobserve_receipts(`ptr`: Pointer,`subId`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_unobserve_room_list(`ptr`: Pointer,`token`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_unobserve_sends(`ptr`: Pointer,`id`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_unobserve_timeline(`ptr`: Pointer,`subId`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_unobserve_typing(`ptr`: Pointer,`subId`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_unobserve_verification_inbox(`ptr`: Pointer,`subId`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_unpublish_room_alias(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`alias`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_unregister_unifiedpush(`ptr`: Pointer,`appId`: RustBuffer.ByValue,`pushkey`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_upgrade_room(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`newVersion`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_method_client_wake_sync_once(`ptr`: Pointer,`timeoutMs`: Int,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_mages_ffi_fn_method_client_whoami(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_mages_ffi_fn_init_callback_vtable_callobserver(`vtable`: UniffiVTableCallbackInterfaceCallObserver,
): Unit
fun uniffi_mages_ffi_fn_init_callback_vtable_callwidgetobserver(`vtable`: UniffiVTableCallbackInterfaceCallWidgetObserver,
): Unit
fun uniffi_mages_ffi_fn_init_callback_vtable_connectionobserver(`vtable`: UniffiVTableCallbackInterfaceConnectionObserver,
): Unit
fun uniffi_mages_ffi_fn_init_callback_vtable_livelocationobserver(`vtable`: UniffiVTableCallbackInterfaceLiveLocationObserver,
): Unit
fun uniffi_mages_ffi_fn_init_callback_vtable_progressobserver(`vtable`: UniffiVTableCallbackInterfaceProgressObserver,
): Unit
fun uniffi_mages_ffi_fn_init_callback_vtable_receiptsobserver(`vtable`: UniffiVTableCallbackInterfaceReceiptsObserver,
): Unit
fun uniffi_mages_ffi_fn_init_callback_vtable_roomlistobserver(`vtable`: UniffiVTableCallbackInterfaceRoomListObserver,
): Unit
fun uniffi_mages_ffi_fn_init_callback_vtable_sendobserver(`vtable`: UniffiVTableCallbackInterfaceSendObserver,
): Unit
fun uniffi_mages_ffi_fn_init_callback_vtable_syncobserver(`vtable`: UniffiVTableCallbackInterfaceSyncObserver,
): Unit
fun uniffi_mages_ffi_fn_init_callback_vtable_timelineobserver(`vtable`: UniffiVTableCallbackInterfaceTimelineObserver,
): Unit
fun uniffi_mages_ffi_fn_init_callback_vtable_typingobserver(`vtable`: UniffiVTableCallbackInterfaceTypingObserver,
): Unit
fun uniffi_mages_ffi_fn_init_callback_vtable_urlopener(`vtable`: UniffiVTableCallbackInterfaceUrlOpener,
): Unit
fun uniffi_mages_ffi_fn_init_callback_vtable_verificationinboxobserver(`vtable`: UniffiVTableCallbackInterfaceVerificationInboxObserver,
): Unit
fun uniffi_mages_ffi_fn_init_callback_vtable_verificationobserver(`vtable`: UniffiVTableCallbackInterfaceVerificationObserver,
): Unit
fun ffi_mages_ffi_rustbuffer_alloc(`size`: Long,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun ffi_mages_ffi_rustbuffer_from_bytes(`bytes`: ForeignBytes.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun ffi_mages_ffi_rustbuffer_free(`buf`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun ffi_mages_ffi_rustbuffer_reserve(`buf`: RustBuffer.ByValue,`additional`: Long,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun ffi_mages_ffi_rust_future_poll_u8(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_mages_ffi_rust_future_cancel_u8(`handle`: Long,
): Unit
fun ffi_mages_ffi_rust_future_free_u8(`handle`: Long,
): Unit
fun ffi_mages_ffi_rust_future_complete_u8(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun ffi_mages_ffi_rust_future_poll_i8(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_mages_ffi_rust_future_cancel_i8(`handle`: Long,
): Unit
fun ffi_mages_ffi_rust_future_free_i8(`handle`: Long,
): Unit
fun ffi_mages_ffi_rust_future_complete_i8(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun ffi_mages_ffi_rust_future_poll_u16(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_mages_ffi_rust_future_cancel_u16(`handle`: Long,
): Unit
fun ffi_mages_ffi_rust_future_free_u16(`handle`: Long,
): Unit
fun ffi_mages_ffi_rust_future_complete_u16(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Short
fun ffi_mages_ffi_rust_future_poll_i16(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_mages_ffi_rust_future_cancel_i16(`handle`: Long,
): Unit
fun ffi_mages_ffi_rust_future_free_i16(`handle`: Long,
): Unit
fun ffi_mages_ffi_rust_future_complete_i16(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Short
fun ffi_mages_ffi_rust_future_poll_u32(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_mages_ffi_rust_future_cancel_u32(`handle`: Long,
): Unit
fun ffi_mages_ffi_rust_future_free_u32(`handle`: Long,
): Unit
fun ffi_mages_ffi_rust_future_complete_u32(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Int
fun ffi_mages_ffi_rust_future_poll_i32(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_mages_ffi_rust_future_cancel_i32(`handle`: Long,
): Unit
fun ffi_mages_ffi_rust_future_free_i32(`handle`: Long,
): Unit
fun ffi_mages_ffi_rust_future_complete_i32(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Int
fun ffi_mages_ffi_rust_future_poll_u64(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_mages_ffi_rust_future_cancel_u64(`handle`: Long,
): Unit
fun ffi_mages_ffi_rust_future_free_u64(`handle`: Long,
): Unit
fun ffi_mages_ffi_rust_future_complete_u64(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Long
fun ffi_mages_ffi_rust_future_poll_i64(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_mages_ffi_rust_future_cancel_i64(`handle`: Long,
): Unit
fun ffi_mages_ffi_rust_future_free_i64(`handle`: Long,
): Unit
fun ffi_mages_ffi_rust_future_complete_i64(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Long
fun ffi_mages_ffi_rust_future_poll_f32(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_mages_ffi_rust_future_cancel_f32(`handle`: Long,
): Unit
fun ffi_mages_ffi_rust_future_free_f32(`handle`: Long,
): Unit
fun ffi_mages_ffi_rust_future_complete_f32(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Float
fun ffi_mages_ffi_rust_future_poll_f64(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_mages_ffi_rust_future_cancel_f64(`handle`: Long,
): Unit
fun ffi_mages_ffi_rust_future_free_f64(`handle`: Long,
): Unit
fun ffi_mages_ffi_rust_future_complete_f64(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Double
fun ffi_mages_ffi_rust_future_poll_pointer(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_mages_ffi_rust_future_cancel_pointer(`handle`: Long,
): Unit
fun ffi_mages_ffi_rust_future_free_pointer(`handle`: Long,
): Unit
fun ffi_mages_ffi_rust_future_complete_pointer(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun ffi_mages_ffi_rust_future_poll_rust_buffer(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_mages_ffi_rust_future_cancel_rust_buffer(`handle`: Long,
): Unit
fun ffi_mages_ffi_rust_future_free_rust_buffer(`handle`: Long,
): Unit
fun ffi_mages_ffi_rust_future_complete_rust_buffer(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun ffi_mages_ffi_rust_future_poll_void(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_mages_ffi_rust_future_cancel_void(`handle`: Long,
): Unit
fun ffi_mages_ffi_rust_future_free_void(`handle`: Long,
): Unit
fun ffi_mages_ffi_rust_future_complete_void(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Unit

}

private fun uniffiCheckContractApiVersion(lib: IntegrityCheckingUniffiLib) {
    // Get the bindings contract version from our ComponentInterface
    val bindings_contract_version = 29
    // Get the scaffolding contract version by calling the into the dylib
    val scaffolding_contract_version = lib.ffi_mages_ffi_uniffi_contract_version()
    if (bindings_contract_version != scaffolding_contract_version) {
        throw RuntimeException("UniFFI contract version mismatch: try cleaning and rebuilding your project")
    }
}
@Suppress("UNUSED_PARAMETER")
private fun uniffiCheckApiChecksums(lib: IntegrityCheckingUniffiLib) {
    if (lib.uniffi_mages_ffi_checksum_method_client_accept_invite() != 24794.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_accept_verification() != 29343.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_ban_user() != 21083.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_call_widget_from_webview() != 14145.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_cancel_verification() != 23398.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_cancel_verification_request() != 59656.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_check_verification_request() != 41063.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_confirm_verification() != 6644.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_create_room() != 26245.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_create_space() != 17223.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_dm_peer_user_id() != 45790.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_download_attachment_to_cache_file() != 26462.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_download_attachment_to_path() != 37448.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_edit() != 17804.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_enable_room_encryption() != 49002.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_encryption_catchup_once() != 47045.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_enqueue_text() != 46531.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_ensure_dm() != 6447.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_ensure_send_queue_supervision() != 52739.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_enter_background() != 13396.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_enter_foreground() != 64540.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_fetch_notification() != 58961.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_fetch_notifications_since() != 2152.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_get_presence() != 43099.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_ignore_user() != 60997.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_ignored_users() != 16159.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_invite_user() != 25139.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_is_event_read_by() != 49843.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_is_logged_in() != 30474.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_is_marked_unread() != 6154.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_is_space() != 27745.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_is_user_ignored() != 18402.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_join_by_id_or_alias() != 62172.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_kick_user() != 59423.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_leave_room() != 17352.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_list_invited() != 18743.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_list_members() != 50866.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_list_my_devices() != 56472.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_load_room_list_cache() != 15441.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_login() != 34083.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_login_sso_loopback() != 64842.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_logout() != 13331.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_mark_fully_read_at() != 2717.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_mark_read() != 47994.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_mark_read_at() != 38991.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_media_cache_clean() != 20532.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_monitor_connection() != 14581.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_mxc_thumbnail_to_cache() != 19669.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_my_spaces() != 45957.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_next_sub_id() != 60320.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_observe_live_location() != 16517.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_observe_own_receipt() != 8077.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_observe_receipts() != 43188.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_observe_room_list() != 51317.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_observe_sends() != 62512.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_observe_timeline() != 37825.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_observe_typing() != 60410.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_own_last_read() != 12895.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_paginate_backwards() != 21654.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_paginate_forwards() != 56708.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_public_rooms() != 18102.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_publish_room_alias() != 4423.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_react() != 5071.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_reactions_batch() != 7183.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_reactions_for_event() != 44067.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_recent_events() != 43398.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_recover_with_key() != 43770.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_redact() != 34137.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_register_unifiedpush() != 31870.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_reply() != 47802.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_resolve_room_id() != 11141.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_retry_by_txn() != 56906.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_room_directory_visibility() != 41650.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_room_list_set_unread_only() != 58007.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_room_notification_mode() != 15415.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_room_predecessor() != 35885.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_room_profile() != 34786.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_room_send_queue_set_enabled() != 33714.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_room_successor() != 19869.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_room_tags() != 36290.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_room_unread_stats() != 63503.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_room_upgrade_links() != 36734.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_rooms() != 6441.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_search_room() != 32348.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_search_users() != 27044.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_seen_by_for_event() != 6678.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_send_attachment_bytes() != 57629.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_send_attachment_from_path() != 1685.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_send_existing_attachment() != 58866.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_send_live_location() != 39479.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_send_message() != 5661.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_send_poll_end() != 63464.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_send_poll_response() != 17495.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_send_poll_start() != 15050.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_send_queue_set_enabled() != 5103.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_send_thread_text() != 49543.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_set_mark_unread() != 27869.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_set_media_retention_policy() != 49556.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_set_presence() != 21576.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_set_room_canonical_alias() != 38620.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_set_room_directory_visibility() != 32032.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_set_room_favourite() != 24780.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_set_room_history_visibility() != 43134.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_set_room_join_rule() != 21590.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_set_room_low_priority() != 46489.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_set_room_name() != 11655.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_set_room_notification_mode() != 37689.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_set_room_topic() != 10833.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_set_typing() != 6072.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_shutdown() != 60273.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_space_add_child() != 51616.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_space_hierarchy() != 49322.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_space_invite_user() != 60877.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_space_remove_child() != 39424.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_start_call_inbox() != 65106.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_start_element_call() != 35599.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_start_live_location() != 36743.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_start_self_sas() != 46305.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_start_supervised_sync() != 12615.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_start_user_sas() != 61684.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_start_verification_inbox() != 10754.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_stop_call_inbox() != 53496.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_stop_element_call() != 64659.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_stop_live_location() != 14460.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_thread_replies() != 2174.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_thread_summary() != 42334.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_thumbnail_to_cache() != 14657.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_unban_user() != 60805.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_unignore_user() != 43646.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_unobserve_connection() != 17872.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_unobserve_live_location() != 54971.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_unobserve_receipts() != 35144.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_unobserve_room_list() != 53634.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_unobserve_sends() != 40010.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_unobserve_timeline() != 65490.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_unobserve_typing() != 10359.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_unobserve_verification_inbox() != 13546.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_unpublish_room_alias() != 10951.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_unregister_unifiedpush() != 13839.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_upgrade_room() != 19709.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_wake_sync_once() != 61897.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_client_whoami() != 61766.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_constructor_client_new() != 10289.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_callobserver_on_invite() != 57392.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_callwidgetobserver_on_to_widget() != 45877.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_connectionobserver_on_connection_change() != 391.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_livelocationobserver_on_update() != 57515.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_progressobserver_on_progress() != 58675.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_receiptsobserver_on_changed() != 43366.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_roomlistobserver_on_reset() != 1813.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_roomlistobserver_on_update() != 24627.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_sendobserver_on_update() != 3655.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_syncobserver_on_state() != 42847.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_timelineobserver_on_diff() != 46213.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_timelineobserver_on_error() != 47606.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_typingobserver_on_update() != 63870.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_urlopener_open() != 35460.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_verificationinboxobserver_on_request() != 47600.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_verificationinboxobserver_on_error() != 33605.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_verificationobserver_on_phase() != 37245.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_verificationobserver_on_emojis() != 20544.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_mages_ffi_checksum_method_verificationobserver_on_error() != 722.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
}

/**
 * @suppress
 */
public fun uniffiEnsureInitialized() {
    UniffiLib.INSTANCE
}

// Async support

// Public interface members begin here.


// Interface implemented by anything that can contain an object reference.
//
// Such types expose a `destroy()` method that must be called to cleanly
// dispose of the contained objects. Failure to call this method may result
// in memory leaks.
//
// The easiest way to ensure this method is called is to use the `.use`
// helper method to execute a block and destroy the object at the end.
interface Disposable {
    fun destroy()
    companion object {
        fun destroy(vararg args: Any?) {
            for (arg in args) {
                when (arg) {
                    is Disposable -> arg.destroy()
                    is ArrayList<*> -> {
                        for (idx in arg.indices) {
                            val element = arg[idx]
                            if (element is Disposable) {
                                element.destroy()
                            }
                        }
                    }
                    is Map<*, *> -> {
                        for (element in arg.values) {
                            if (element is Disposable) {
                                element.destroy()
                            }
                        }
                    }
                    is Iterable<*> -> {
                        for (element in arg) {
                            if (element is Disposable) {
                                element.destroy()
                            }
                        }
                    }
                }
            }
        }
    }
}

/**
 * @suppress
 */
inline fun <T : Disposable?, R> T.use(block: (T) -> R) =
    try {
        block(this)
    } finally {
        try {
            // N.B. our implementation is on the nullable type `Disposable?`.
            this?.destroy()
        } catch (e: Throwable) {
            // swallow
        }
    }

/** 
 * Used to instantiate an interface without an actual pointer, for fakes in tests, mostly.
 *
 * @suppress
 * */
object NoPointer// Magic number for the Rust proxy to call using the same mechanism as every other method,
// to free the callback once it's dropped by Rust.
internal const val IDX_CALLBACK_FREE = 0
// Callback return codes
internal const val UNIFFI_CALLBACK_SUCCESS = 0
internal const val UNIFFI_CALLBACK_ERROR = 1
internal const val UNIFFI_CALLBACK_UNEXPECTED_ERROR = 2

/**
 * @suppress
 */
public abstract class FfiConverterCallbackInterface<CallbackInterface: Any>: FfiConverter<CallbackInterface, Long> {
    internal val handleMap = UniffiHandleMap<CallbackInterface>()

    internal fun drop(handle: Long) {
        handleMap.remove(handle)
    }

    override fun lift(value: Long): CallbackInterface {
        return handleMap.get(value)
    }

    override fun read(buf: ByteBuffer) = lift(buf.getLong())

    override fun lower(value: CallbackInterface) = handleMap.insert(value)

    override fun allocationSize(value: CallbackInterface) = 8UL

    override fun write(value: CallbackInterface, buf: ByteBuffer) {
        buf.putLong(lower(value))
    }
}
/**
 * The cleaner interface for Object finalization code to run.
 * This is the entry point to any implementation that we're using.
 *
 * The cleaner registers objects and returns cleanables, so now we are
 * defining a `UniffiCleaner` with a `UniffiClenaer.Cleanable` to abstract the
 * different implmentations available at compile time.
 *
 * @suppress
 */
interface UniffiCleaner {
    interface Cleanable {
        fun clean()
    }

    fun register(value: Any, cleanUpTask: Runnable): UniffiCleaner.Cleanable

    companion object
}

// The fallback Jna cleaner, which is available for both Android, and the JVM.
private class UniffiJnaCleaner : UniffiCleaner {
    private val cleaner = com.sun.jna.internal.Cleaner.getCleaner()

    override fun register(value: Any, cleanUpTask: Runnable): UniffiCleaner.Cleanable =
        UniffiJnaCleanable(cleaner.register(value, cleanUpTask))
}

private class UniffiJnaCleanable(
    private val cleanable: com.sun.jna.internal.Cleaner.Cleanable,
) : UniffiCleaner.Cleanable {
    override fun clean() = cleanable.clean()
}


// We decide at uniffi binding generation time whether we were
// using Android or not.
// There are further runtime checks to chose the correct implementation
// of the cleaner.
private fun UniffiCleaner.Companion.create(): UniffiCleaner =
    try {
        // For safety's sake: if the library hasn't been run in android_cleaner = true
        // mode, but is being run on Android, then we still need to think about
        // Android API versions.
        // So we check if java.lang.ref.Cleaner is there, and use that…
        java.lang.Class.forName("java.lang.ref.Cleaner")
        JavaLangRefCleaner()
    } catch (e: ClassNotFoundException) {
        // … otherwise, fallback to the JNA cleaner.
        UniffiJnaCleaner()
    }

private class JavaLangRefCleaner : UniffiCleaner {
    val cleaner = java.lang.ref.Cleaner.create()

    override fun register(value: Any, cleanUpTask: Runnable): UniffiCleaner.Cleanable =
        JavaLangRefCleanable(cleaner.register(value, cleanUpTask))
}

private class JavaLangRefCleanable(
    val cleanable: java.lang.ref.Cleaner.Cleanable
) : UniffiCleaner.Cleanable {
    override fun clean() = cleanable.clean()
}

/**
 * @suppress
 */
public object FfiConverterUShort: FfiConverter<UShort, Short> {
    override fun lift(value: Short): UShort {
        return value.toUShort()
    }

    override fun read(buf: ByteBuffer): UShort {
        return lift(buf.getShort())
    }

    override fun lower(value: UShort): Short {
        return value.toShort()
    }

    override fun allocationSize(value: UShort) = 2UL

    override fun write(value: UShort, buf: ByteBuffer) {
        buf.putShort(value.toShort())
    }
}

/**
 * @suppress
 */
public object FfiConverterUInt: FfiConverter<UInt, Int> {
    override fun lift(value: Int): UInt {
        return value.toUInt()
    }

    override fun read(buf: ByteBuffer): UInt {
        return lift(buf.getInt())
    }

    override fun lower(value: UInt): Int {
        return value.toInt()
    }

    override fun allocationSize(value: UInt) = 4UL

    override fun write(value: UInt, buf: ByteBuffer) {
        buf.putInt(value.toInt())
    }
}

/**
 * @suppress
 */
public object FfiConverterULong: FfiConverter<ULong, Long> {
    override fun lift(value: Long): ULong {
        return value.toULong()
    }

    override fun read(buf: ByteBuffer): ULong {
        return lift(buf.getLong())
    }

    override fun lower(value: ULong): Long {
        return value.toLong()
    }

    override fun allocationSize(value: ULong) = 8UL

    override fun write(value: ULong, buf: ByteBuffer) {
        buf.putLong(value.toLong())
    }
}

/**
 * @suppress
 */
public object FfiConverterLong: FfiConverter<Long, Long> {
    override fun lift(value: Long): Long {
        return value
    }

    override fun read(buf: ByteBuffer): Long {
        return buf.getLong()
    }

    override fun lower(value: Long): Long {
        return value
    }

    override fun allocationSize(value: Long) = 8UL

    override fun write(value: Long, buf: ByteBuffer) {
        buf.putLong(value)
    }
}

/**
 * @suppress
 */
public object FfiConverterBoolean: FfiConverter<Boolean, Byte> {
    override fun lift(value: Byte): Boolean {
        return value.toInt() != 0
    }

    override fun read(buf: ByteBuffer): Boolean {
        return lift(buf.get())
    }

    override fun lower(value: Boolean): Byte {
        return if (value) 1.toByte() else 0.toByte()
    }

    override fun allocationSize(value: Boolean) = 1UL

    override fun write(value: Boolean, buf: ByteBuffer) {
        buf.put(lower(value))
    }
}

/**
 * @suppress
 */
public object FfiConverterString: FfiConverter<String, RustBuffer.ByValue> {
    // Note: we don't inherit from FfiConverterRustBuffer, because we use a
    // special encoding when lowering/lifting.  We can use `RustBuffer.len` to
    // store our length and avoid writing it out to the buffer.
    override fun lift(value: RustBuffer.ByValue): String {
        try {
            val byteArr = ByteArray(value.len.toInt())
            value.asByteBuffer()!!.get(byteArr)
            return byteArr.toString(Charsets.UTF_8)
        } finally {
            RustBuffer.free(value)
        }
    }

    override fun read(buf: ByteBuffer): String {
        val len = buf.getInt()
        val byteArr = ByteArray(len)
        buf.get(byteArr)
        return byteArr.toString(Charsets.UTF_8)
    }

    fun toUtf8(value: String): ByteBuffer {
        // Make sure we don't have invalid UTF-16, check for lone surrogates.
        return Charsets.UTF_8.newEncoder().run {
            onMalformedInput(CodingErrorAction.REPORT)
            encode(CharBuffer.wrap(value))
        }
    }

    override fun lower(value: String): RustBuffer.ByValue {
        val byteBuf = toUtf8(value)
        // Ideally we'd pass these bytes to `ffi_bytebuffer_from_bytes`, but doing so would require us
        // to copy them into a JNA `Memory`. So we might as well directly copy them into a `RustBuffer`.
        val rbuf = RustBuffer.alloc(byteBuf.limit().toULong())
        rbuf.asByteBuffer()!!.put(byteBuf)
        return rbuf
    }

    // We aren't sure exactly how many bytes our string will be once it's UTF-8
    // encoded.  Allocate 3 bytes per UTF-16 code unit which will always be
    // enough.
    override fun allocationSize(value: String): ULong {
        val sizeForLength = 4UL
        val sizeForString = value.length.toULong() * 3UL
        return sizeForLength + sizeForString
    }

    override fun write(value: String, buf: ByteBuffer) {
        val byteBuf = toUtf8(value)
        buf.putInt(byteBuf.limit())
        buf.put(byteBuf)
    }
}

/**
 * @suppress
 */
public object FfiConverterByteArray: FfiConverterRustBuffer<ByteArray> {
    override fun read(buf: ByteBuffer): ByteArray {
        val len = buf.getInt()
        val byteArr = ByteArray(len)
        buf.get(byteArr)
        return byteArr
    }
    override fun allocationSize(value: ByteArray): ULong {
        return 4UL + value.size.toULong()
    }
    override fun write(value: ByteArray, buf: ByteBuffer) {
        buf.putInt(value.size)
        buf.put(value)
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface ClientInterface {
    
    fun `acceptInvite`(`roomId`: kotlin.String): kotlin.Boolean
    
    fun `acceptVerification`(`flowId`: kotlin.String, `otherUserId`: kotlin.String?, `observer`: VerificationObserver): kotlin.Boolean
    
    fun `banUser`(`roomId`: kotlin.String, `userId`: kotlin.String, `reason`: kotlin.String?): kotlin.Boolean
    
    /**
     * Called by the platform when the WebView receives a postMessage from Element Call.
     *
     * `message` must be the JSON string from `event.data`.
     */
    fun `callWidgetFromWebview`(`sessionId`: kotlin.ULong, `message`: kotlin.String): kotlin.Boolean
    
    fun `cancelVerification`(`flowId`: kotlin.String): kotlin.Boolean
    
    fun `cancelVerificationRequest`(`flowId`: kotlin.String, `otherUserId`: kotlin.String?): kotlin.Boolean
    
    fun `checkVerificationRequest`(`userId`: kotlin.String, `flowId`: kotlin.String): kotlin.Boolean
    
    fun `confirmVerification`(`flowId`: kotlin.String): kotlin.Boolean
    
    fun `createRoom`(`name`: kotlin.String?, `topic`: kotlin.String?, `invitees`: List<kotlin.String>): kotlin.String
    
    /**
     * Create a space (m.space). Returns the new space room_id on success.
     */
    fun `createSpace`(`name`: kotlin.String, `topic`: kotlin.String?, `isPublic`: kotlin.Boolean, `invitees`: List<kotlin.String>): kotlin.String
    
    fun `dmPeerUserId`(`roomId`: kotlin.String): kotlin.String?
    
    /**
     * Download full media described by AttachmentInfo into the SDK's cache dir.
     * `filename_hint` is used to derive a friendly name/extension.
     */
    fun `downloadAttachmentToCacheFile`(`att`: AttachmentInfo, `filenameHint`: kotlin.String?): DownloadResult
    
    /**
     * Download full media described by AttachmentInfo directly to `save_path`.
     */
    fun `downloadAttachmentToPath`(`att`: AttachmentInfo, `savePath`: kotlin.String, `progress`: ProgressObserver?): DownloadResult
    
    fun `edit`(`roomId`: kotlin.String, `targetEventId`: kotlin.String, `newBody`: kotlin.String): kotlin.Boolean
    
    fun `enableRoomEncryption`(`roomId`: kotlin.String): kotlin.Boolean
    
    /**
     * Run a short encryption sync if a permit is available (used on push).
     */
    fun `encryptionCatchupOnce`(): kotlin.Boolean
    
    fun `enqueueText`(`roomId`: kotlin.String, `body`: kotlin.String, `txnId`: kotlin.String?): kotlin.String
    
    fun `ensureDm`(`userId`: kotlin.String): kotlin.String
    
    fun `ensureSendQueueSupervision`()
    
    /**
     * Send the app to background: stop Sliding Sync supervision.
     */
    fun `enterBackground`()
    
    fun `enterForeground`()
    
    fun `fetchNotification`(`roomId`: kotlin.String, `eventId`: kotlin.String): RenderedNotification?
    
    fun `fetchNotificationsSince`(`sinceTsMs`: kotlin.ULong, `maxRooms`: kotlin.UInt, `maxEvents`: kotlin.UInt): List<RenderedNotification>
    
    fun `getPresence`(`userId`: kotlin.String): PresenceInfo
    
    /**
     * Add a user to the ignore list (muting them across all rooms).
     */
    fun `ignoreUser`(`userId`: kotlin.String)
    
    fun `ignoredUsers`(): List<kotlin.String>
    
    fun `inviteUser`(`roomId`: kotlin.String, `userId`: kotlin.String): kotlin.Boolean
    
    fun `isEventReadBy`(`roomId`: kotlin.String, `eventId`: kotlin.String, `userId`: kotlin.String): kotlin.Boolean
    
    fun `isLoggedIn`(): kotlin.Boolean
    
    fun `isMarkedUnread`(`roomId`: kotlin.String): kotlin.Boolean?
    
    /**
     * Return true if the room is a Space (m.space).
     */
    fun `isSpace`(`roomId`: kotlin.String): kotlin.Boolean
    
    /**
     * Check whether a user is currently ignored.
     */
    fun `isUserIgnored`(`userId`: kotlin.String): kotlin.Boolean
    
    fun `joinByIdOrAlias`(`idOrAlias`: kotlin.String): kotlin.Boolean
    
    fun `kickUser`(`roomId`: kotlin.String, `userId`: kotlin.String, `reason`: kotlin.String?): kotlin.Boolean
    
    fun `leaveRoom`(`roomId`: kotlin.String)
    
    fun `listInvited`(): List<RoomProfile>
    
    fun `listMembers`(`roomId`: kotlin.String): List<MemberSummary>
    
    fun `listMyDevices`(): List<DeviceSummary>
    
    fun `loadRoomListCache`(): List<RoomListEntry>
    
    fun `login`(`username`: kotlin.String, `password`: kotlin.String, `deviceDisplayName`: kotlin.String?)
    
    /**
     * SSO with built-in loopback server. Opens a browser and completes login.
     */
    fun `loginSsoLoopback`(`opener`: UrlOpener, `deviceName`: kotlin.String?)
    
    fun `logout`(): kotlin.Boolean
    
    fun `markFullyReadAt`(`roomId`: kotlin.String, `eventId`: kotlin.String): kotlin.Boolean
    
    fun `markRead`(`roomId`: kotlin.String): kotlin.Boolean
    
    fun `markReadAt`(`roomId`: kotlin.String, `eventId`: kotlin.String): kotlin.Boolean
    
    /**
     * Run a cleanup of the SDK's media cache with the current policy.
     */
    fun `mediaCacheClean`()
    
    fun `monitorConnection`(`observer`: ConnectionObserver): kotlin.ULong
    
    fun `mxcThumbnailToCache`(`mxcUri`: kotlin.String, `width`: kotlin.UInt, `height`: kotlin.UInt, `crop`: kotlin.Boolean): kotlin.String
    
    /**
     * List all joined spaces with basic profile info.
     */
    fun `mySpaces`(): List<SpaceInfo>
    
    fun `nextSubId`(): kotlin.ULong
    
    /**
     * Subscribe to other users' live location shares in a room.
     */
    fun `observeLiveLocation`(`roomId`: kotlin.String, `observer`: LiveLocationObserver): kotlin.ULong
    
    fun `observeOwnReceipt`(`roomId`: kotlin.String, `observer`: ReceiptsObserver): kotlin.ULong
    
    fun `observeReceipts`(`roomId`: kotlin.String, `observer`: ReceiptsObserver): kotlin.ULong
    
    fun `observeRoomList`(`observer`: RoomListObserver): kotlin.ULong
    
    fun `observeSends`(`observer`: SendObserver): kotlin.ULong
    
    fun `observeTimeline`(`roomId`: kotlin.String, `observer`: TimelineObserver): kotlin.ULong
    
    fun `observeTyping`(`roomId`: kotlin.String, `observer`: TypingObserver): kotlin.ULong
    
    fun `ownLastRead`(`roomId`: kotlin.String): OwnReceipt
    
    fun `paginateBackwards`(`roomId`: kotlin.String, `count`: kotlin.UShort): kotlin.Boolean
    
    fun `paginateForwards`(`roomId`: kotlin.String, `count`: kotlin.UShort): kotlin.Boolean
    
    fun `publicRooms`(`server`: kotlin.String?, `search`: kotlin.String?, `limit`: kotlin.UInt, `since`: kotlin.String?): PublicRoomsPage
    
    fun `publishRoomAlias`(`roomId`: kotlin.String, `alias`: kotlin.String): kotlin.Boolean
    
    fun `react`(`roomId`: kotlin.String, `eventId`: kotlin.String, `emoji`: kotlin.String): kotlin.Boolean
    
    fun `reactionsBatch`(`roomId`: kotlin.String, `eventIds`: List<kotlin.String>): Map<kotlin.String, List<ReactionSummary>>
    
    /**
     * Return reactions (emoji -> count, me).
     */
    fun `reactionsForEvent`(`roomId`: kotlin.String, `eventId`: kotlin.String): List<ReactionSummary>
    
    fun `recentEvents`(`roomId`: kotlin.String, `limit`: kotlin.UInt): List<MessageEvent>
    
    fun `recoverWithKey`(`recoveryKey`: kotlin.String): kotlin.Boolean
    
    fun `redact`(`roomId`: kotlin.String, `eventId`: kotlin.String, `reason`: kotlin.String?): kotlin.Boolean
    
    /**
     * Register/Update HTTP pusher for UnifiedPush/Matrix gateway (e.g. ntfy)
     */
    fun `registerUnifiedpush`(`appId`: kotlin.String, `pushkey`: kotlin.String, `gatewayUrl`: kotlin.String, `deviceDisplayName`: kotlin.String, `lang`: kotlin.String, `profileTag`: kotlin.String?): kotlin.Boolean
    
    fun `reply`(`roomId`: kotlin.String, `inReplyTo`: kotlin.String, `body`: kotlin.String): kotlin.Boolean
    
    fun `resolveRoomId`(`idOrAlias`: kotlin.String): kotlin.String
    
    fun `retryByTxn`(`roomId`: kotlin.String, `txnId`: kotlin.String): kotlin.Boolean
    
    fun `roomDirectoryVisibility`(`roomId`: kotlin.String): RoomDirectoryVisibility
    
    fun `roomListSetUnreadOnly`(`token`: kotlin.ULong, `unreadOnly`: kotlin.Boolean): kotlin.Boolean
    
    fun `roomNotificationMode`(`roomId`: kotlin.String): FfiRoomNotificationMode?
    
    /**
     * Return the predecessor room if this room replaced an earlier room.
     */
    fun `roomPredecessor`(`roomId`: kotlin.String): PredecessorRoomInfo?
    
    fun `roomProfile`(`roomId`: kotlin.String): RoomProfile?
    
    fun `roomSendQueueSetEnabled`(`roomId`: kotlin.String, `enabled`: kotlin.Boolean): kotlin.Boolean
    
    /**
     * If this room is tombstoned, return its successor room details.
     */
    fun `roomSuccessor`(`roomId`: kotlin.String): SuccessorRoomInfo?
    
    fun `roomTags`(`roomId`: kotlin.String): RoomTags?
    
    fun `roomUnreadStats`(`roomId`: kotlin.String): UnreadStats?
    
    /**
     * Get tombstone / predecessor / successor info for a room, if available.
     */
    fun `roomUpgradeLinks`(`roomId`: kotlin.String): RoomUpgradeLinks?
    
    fun `rooms`(): List<RoomSummary>
    
    fun `searchRoom`(`roomId`: kotlin.String, `query`: kotlin.String, `limit`: kotlin.UInt, `offset`: kotlin.UInt?): SearchPage
    
    fun `searchUsers`(`searchTerm`: kotlin.String, `limit`: kotlin.ULong): List<DirectoryUser>
    
    fun `seenByForEvent`(`roomId`: kotlin.String, `eventId`: kotlin.String, `limit`: kotlin.UInt): List<SeenByEntry>
    
    fun `sendAttachmentBytes`(`roomId`: kotlin.String, `filename`: kotlin.String, `mime`: kotlin.String, `bytes`: kotlin.ByteArray, `progress`: ProgressObserver?): kotlin.Boolean
    
    fun `sendAttachmentFromPath`(`roomId`: kotlin.String, `path`: kotlin.String, `mime`: kotlin.String, `filename`: kotlin.String?, `progress`: ProgressObserver?): kotlin.Boolean
    
    fun `sendExistingAttachment`(`roomId`: kotlin.String, `att`: AttachmentInfo, `body`: kotlin.String?, `progress`: ProgressObserver?): kotlin.Boolean
    
    /**
     * Send a single live location beacon update (geo:`geo:` URI) in the room.
     */
    fun `sendLiveLocation`(`roomId`: kotlin.String, `geoUri`: kotlin.String)
    
    fun `sendMessage`(`roomId`: kotlin.String, `body`: kotlin.String): kotlin.Boolean
    
    /**
     * End a poll (MSC3381, unstable `org.matrix.msc3381.poll.end`).
     *
     * This just sends an `m.poll.end` (unstable) event linked to the given poll
     * start event. It does *not* compute or embed per‑option results.
     */
    fun `sendPollEnd`(`roomId`: kotlin.String, `pollEventId`: kotlin.String)
    
    /**
     * Send a poll response for a given poll event.
     * `answers` are the answer IDs ("a", "b", "c"...), not the labels.
     */
    fun `sendPollResponse`(`roomId`: kotlin.String, `pollEventId`: kotlin.String, `answers`: List<kotlin.String>)
    
    /**
     * Send a new poll (MSC3381, unstable `m.poll.start`).
     * Returns the event ID if sending succeeds.
     */
    fun `sendPollStart`(`roomId`: kotlin.String, `def`: PollDefinition): kotlin.String
    
    fun `sendQueueSetEnabled`(`enabled`: kotlin.Boolean): kotlin.Boolean
    
    /**
     * MSC3440
     */
    fun `sendThreadText`(`roomId`: kotlin.String, `rootEventId`: kotlin.String, `body`: kotlin.String, `replyToEventId`: kotlin.String?): kotlin.Boolean
    
    fun `setMarkUnread`(`roomId`: kotlin.String, `unread`: kotlin.Boolean): kotlin.Boolean
    
    /**
     * Configure the SDK's media retention policy and apply it immediately.
     * Any `None` will keep the SDK default for that parameter.
     */
    fun `setMediaRetentionPolicy`(`maxCacheSizeBytes`: kotlin.ULong?, `maxFileSizeBytes`: kotlin.ULong?, `lastAccessExpirySecs`: kotlin.ULong?, `cleanupFrequencySecs`: kotlin.ULong?)
    
    /**
     * Set this account's presence and optional status message.
     */
    fun `setPresence`(`state`: Presence, `statusMsg`: kotlin.String?)
    
    fun `setRoomCanonicalAlias`(`roomId`: kotlin.String, `alias`: kotlin.String?, `altAliases`: List<kotlin.String>)
    
    fun `setRoomDirectoryVisibility`(`roomId`: kotlin.String, `visibility`: RoomDirectoryVisibility)
    
    fun `setRoomFavourite`(`roomId`: kotlin.String, `fav`: kotlin.Boolean): kotlin.Boolean
    
    fun `setRoomHistoryVisibility`(`roomId`: kotlin.String, `vis`: RoomHistoryVisibility)
    
    fun `setRoomJoinRule`(`roomId`: kotlin.String, `rule`: RoomJoinRule)
    
    fun `setRoomLowPriority`(`roomId`: kotlin.String, `low`: kotlin.Boolean): kotlin.Boolean
    
    fun `setRoomName`(`roomId`: kotlin.String, `name`: kotlin.String): kotlin.Boolean
    
    fun `setRoomNotificationMode`(`roomId`: kotlin.String, `mode`: FfiRoomNotificationMode)
    
    fun `setRoomTopic`(`roomId`: kotlin.String, `topic`: kotlin.String): kotlin.Boolean
    
    fun `setTyping`(`roomId`: kotlin.String, `typing`: kotlin.Boolean): kotlin.Boolean
    
    fun `shutdown`()
    
    /**
     * Add a child (room or subspace) to a space via m.space.child.
     */
    fun `spaceAddChild`(`spaceId`: kotlin.String, `childRoomId`: kotlin.String, `order`: kotlin.String?, `suggested`: kotlin.Boolean?)
    
    /**
     * Traverse a space with the server-side hierarchy API (MSC2946).
     */
    fun `spaceHierarchy`(`spaceId`: kotlin.String, `from`: kotlin.String?, `limit`: kotlin.UInt, `maxDepth`: kotlin.UInt?, `suggestedOnly`: kotlin.Boolean): SpaceHierarchyPage
    
    /**
     * Invite a user to a space.
     */
    fun `spaceInviteUser`(`spaceId`: kotlin.String, `userId`: kotlin.String): kotlin.Boolean
    
    /**
     * Remove a child from a space by sending an empty content state for that key.
     */
    fun `spaceRemoveChild`(`spaceId`: kotlin.String, `childRoomId`: kotlin.String)
    
    fun `startCallInbox`(`observer`: CallObserver): kotlin.ULong
    
    /**
     * Start or join an Element Call session for a room.
     *
     * `element_call_url`:
     * - `None`  -> use "https://call.element.io".
     * - `Some`  -> use a self-hosted Element Call instance.
     */
    fun `startElementCall`(`roomId`: kotlin.String, `elementCallUrl`: kotlin.String?, `intent`: ElementCallIntent, `observer`: CallWidgetObserver): CallSessionInfo
    
    /**
     * Start sharing live location in a room for `duration_ms` milliseconds.
     */
    fun `startLiveLocation`(`roomId`: kotlin.String, `durationMs`: kotlin.ULong, `description`: kotlin.String?)
    
    fun `startSelfSas`(`deviceId`: kotlin.String, `observer`: VerificationObserver): kotlin.String
    
    fun `startSupervisedSync`(`observer`: SyncObserver)
    
    fun `startUserSas`(`userId`: kotlin.String, `observer`: VerificationObserver): kotlin.String
    
    fun `startVerificationInbox`(`observer`: VerificationInboxObserver): kotlin.ULong
    
    fun `stopCallInbox`(`token`: kotlin.ULong): kotlin.Boolean
    
    /**
     * Stop an Element Call widget session: aborts driver + recv loops and drops the handle.
     */
    fun `stopElementCall`(`sessionId`: kotlin.ULong): kotlin.Boolean
    
    /**
     * Stop our live location share (if any) in the room.
     */
    fun `stopLiveLocation`(`roomId`: kotlin.String)
    
    fun `threadReplies`(`roomId`: kotlin.String, `rootEventId`: kotlin.String, `from`: kotlin.String?, `limit`: kotlin.UInt, `directionForward`: kotlin.Boolean): ThreadPage
    
    /**
     * Approximate thread summary: count + latest timestamp by paging relations.
     */
    fun `threadSummary`(`roomId`: kotlin.String, `rootEventId`: kotlin.String, `perPage`: kotlin.UInt, `maxPages`: kotlin.UInt): ThreadSummary
    
    fun `thumbnailToCache`(`att`: AttachmentInfo, `width`: kotlin.UInt, `height`: kotlin.UInt, `useCrop`: kotlin.Boolean): kotlin.String
    
    fun `unbanUser`(`roomId`: kotlin.String, `userId`: kotlin.String, `reason`: kotlin.String?): kotlin.Boolean
    
    /**
     * Remove a user from the ignore list.
     */
    fun `unignoreUser`(`userId`: kotlin.String)
    
    fun `unobserveConnection`(`subId`: kotlin.ULong): kotlin.Boolean
    
    fun `unobserveLiveLocation`(`subId`: kotlin.ULong): kotlin.Boolean
    
    fun `unobserveReceipts`(`subId`: kotlin.ULong): kotlin.Boolean
    
    fun `unobserveRoomList`(`token`: kotlin.ULong): kotlin.Boolean
    
    fun `unobserveSends`(`id`: kotlin.ULong): kotlin.Boolean
    
    fun `unobserveTimeline`(`subId`: kotlin.ULong): kotlin.Boolean
    
    fun `unobserveTyping`(`subId`: kotlin.ULong): kotlin.Boolean
    
    fun `unobserveVerificationInbox`(`subId`: kotlin.ULong): kotlin.Boolean
    
    fun `unpublishRoomAlias`(`roomId`: kotlin.String, `alias`: kotlin.String): kotlin.Boolean
    
    /**
     * Unregister HTTP pusher by ids
     */
    fun `unregisterUnifiedpush`(`appId`: kotlin.String, `pushkey`: kotlin.String): kotlin.Boolean
    
    /**
     * Upgrade a room to a new room version.
     * `new_version` is e.g. "9", "10", "11".
     * Returns the new room ID on success.
     */
    fun `upgradeRoom`(`roomId`: kotlin.String, `newVersion`: kotlin.String): kotlin.String
    
    /**
     * Deprecated, remove after fixing push notifs for android (causes older parts to be used (legacy sync, which causes errors on the current synapse server))
     */
    fun `wakeSyncOnce`(`timeoutMs`: kotlin.UInt): kotlin.Boolean
    
    fun `whoami`(): kotlin.String?
    
    companion object
}

open class Client: Disposable, AutoCloseable, ClientInterface
{

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    constructor(`homeserverUrl`: kotlin.String, `storeDir`: kotlin.String) :
        this(
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_constructor_client_new(
        FfiConverterString.lower(`homeserverUrl`),FfiConverterString.lower(`storeDir`),_status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_free_client(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_mages_ffi_fn_clone_client(pointer!!, status)
        }
    }

    override fun `acceptInvite`(`roomId`: kotlin.String): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_accept_invite(
        it, FfiConverterString.lower(`roomId`),_status)
}
    }
    )
    }
    

    override fun `acceptVerification`(`flowId`: kotlin.String, `otherUserId`: kotlin.String?, `observer`: VerificationObserver): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_accept_verification(
        it, FfiConverterString.lower(`flowId`),FfiConverterOptionalString.lower(`otherUserId`),FfiConverterTypeVerificationObserver.lower(`observer`),_status)
}
    }
    )
    }
    

    override fun `banUser`(`roomId`: kotlin.String, `userId`: kotlin.String, `reason`: kotlin.String?): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_ban_user(
        it, FfiConverterString.lower(`roomId`),FfiConverterString.lower(`userId`),FfiConverterOptionalString.lower(`reason`),_status)
}
    }
    )
    }
    

    
    /**
     * Called by the platform when the WebView receives a postMessage from Element Call.
     *
     * `message` must be the JSON string from `event.data`.
     */override fun `callWidgetFromWebview`(`sessionId`: kotlin.ULong, `message`: kotlin.String): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_call_widget_from_webview(
        it, FfiConverterULong.lower(`sessionId`),FfiConverterString.lower(`message`),_status)
}
    }
    )
    }
    

    override fun `cancelVerification`(`flowId`: kotlin.String): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_cancel_verification(
        it, FfiConverterString.lower(`flowId`),_status)
}
    }
    )
    }
    

    override fun `cancelVerificationRequest`(`flowId`: kotlin.String, `otherUserId`: kotlin.String?): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_cancel_verification_request(
        it, FfiConverterString.lower(`flowId`),FfiConverterOptionalString.lower(`otherUserId`),_status)
}
    }
    )
    }
    

    override fun `checkVerificationRequest`(`userId`: kotlin.String, `flowId`: kotlin.String): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_check_verification_request(
        it, FfiConverterString.lower(`userId`),FfiConverterString.lower(`flowId`),_status)
}
    }
    )
    }
    

    override fun `confirmVerification`(`flowId`: kotlin.String): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_confirm_verification(
        it, FfiConverterString.lower(`flowId`),_status)
}
    }
    )
    }
    

    
    @Throws(FfiException::class)override fun `createRoom`(`name`: kotlin.String?, `topic`: kotlin.String?, `invitees`: List<kotlin.String>): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_create_room(
        it, FfiConverterOptionalString.lower(`name`),FfiConverterOptionalString.lower(`topic`),FfiConverterSequenceString.lower(`invitees`),_status)
}
    }
    )
    }
    

    
    /**
     * Create a space (m.space). Returns the new space room_id on success.
     */
    @Throws(FfiException::class)override fun `createSpace`(`name`: kotlin.String, `topic`: kotlin.String?, `isPublic`: kotlin.Boolean, `invitees`: List<kotlin.String>): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_create_space(
        it, FfiConverterString.lower(`name`),FfiConverterOptionalString.lower(`topic`),FfiConverterBoolean.lower(`isPublic`),FfiConverterSequenceString.lower(`invitees`),_status)
}
    }
    )
    }
    

    override fun `dmPeerUserId`(`roomId`: kotlin.String): kotlin.String? {
            return FfiConverterOptionalString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_dm_peer_user_id(
        it, FfiConverterString.lower(`roomId`),_status)
}
    }
    )
    }
    

    
    /**
     * Download full media described by AttachmentInfo into the SDK's cache dir.
     * `filename_hint` is used to derive a friendly name/extension.
     */
    @Throws(FfiException::class)override fun `downloadAttachmentToCacheFile`(`att`: AttachmentInfo, `filenameHint`: kotlin.String?): DownloadResult {
            return FfiConverterTypeDownloadResult.lift(
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_download_attachment_to_cache_file(
        it, FfiConverterTypeAttachmentInfo.lower(`att`),FfiConverterOptionalString.lower(`filenameHint`),_status)
}
    }
    )
    }
    

    
    /**
     * Download full media described by AttachmentInfo directly to `save_path`.
     */
    @Throws(FfiException::class)override fun `downloadAttachmentToPath`(`att`: AttachmentInfo, `savePath`: kotlin.String, `progress`: ProgressObserver?): DownloadResult {
            return FfiConverterTypeDownloadResult.lift(
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_download_attachment_to_path(
        it, FfiConverterTypeAttachmentInfo.lower(`att`),FfiConverterString.lower(`savePath`),FfiConverterOptionalTypeProgressObserver.lower(`progress`),_status)
}
    }
    )
    }
    

    override fun `edit`(`roomId`: kotlin.String, `targetEventId`: kotlin.String, `newBody`: kotlin.String): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_edit(
        it, FfiConverterString.lower(`roomId`),FfiConverterString.lower(`targetEventId`),FfiConverterString.lower(`newBody`),_status)
}
    }
    )
    }
    

    override fun `enableRoomEncryption`(`roomId`: kotlin.String): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_enable_room_encryption(
        it, FfiConverterString.lower(`roomId`),_status)
}
    }
    )
    }
    

    
    /**
     * Run a short encryption sync if a permit is available (used on push).
     */override fun `encryptionCatchupOnce`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_encryption_catchup_once(
        it, _status)
}
    }
    )
    }
    

    override fun `enqueueText`(`roomId`: kotlin.String, `body`: kotlin.String, `txnId`: kotlin.String?): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_enqueue_text(
        it, FfiConverterString.lower(`roomId`),FfiConverterString.lower(`body`),FfiConverterOptionalString.lower(`txnId`),_status)
}
    }
    )
    }
    

    
    @Throws(FfiException::class)override fun `ensureDm`(`userId`: kotlin.String): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_ensure_dm(
        it, FfiConverterString.lower(`userId`),_status)
}
    }
    )
    }
    

    override fun `ensureSendQueueSupervision`()
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_ensure_send_queue_supervision(
        it, _status)
}
    }
    
    

    
    /**
     * Send the app to background: stop Sliding Sync supervision.
     */override fun `enterBackground`()
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_enter_background(
        it, _status)
}
    }
    
    

    override fun `enterForeground`()
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_enter_foreground(
        it, _status)
}
    }
    
    

    
    @Throws(FfiException::class)override fun `fetchNotification`(`roomId`: kotlin.String, `eventId`: kotlin.String): RenderedNotification? {
            return FfiConverterOptionalTypeRenderedNotification.lift(
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_fetch_notification(
        it, FfiConverterString.lower(`roomId`),FfiConverterString.lower(`eventId`),_status)
}
    }
    )
    }
    

    
    @Throws(FfiException::class)override fun `fetchNotificationsSince`(`sinceTsMs`: kotlin.ULong, `maxRooms`: kotlin.UInt, `maxEvents`: kotlin.UInt): List<RenderedNotification> {
            return FfiConverterSequenceTypeRenderedNotification.lift(
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_fetch_notifications_since(
        it, FfiConverterULong.lower(`sinceTsMs`),FfiConverterUInt.lower(`maxRooms`),FfiConverterUInt.lower(`maxEvents`),_status)
}
    }
    )
    }
    

    
    @Throws(FfiException::class)override fun `getPresence`(`userId`: kotlin.String): PresenceInfo {
            return FfiConverterTypePresenceInfo.lift(
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_get_presence(
        it, FfiConverterString.lower(`userId`),_status)
}
    }
    )
    }
    

    
    /**
     * Add a user to the ignore list (muting them across all rooms).
     */
    @Throws(FfiException::class)override fun `ignoreUser`(`userId`: kotlin.String)
        = 
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_ignore_user(
        it, FfiConverterString.lower(`userId`),_status)
}
    }
    
    

    
    @Throws(FfiException::class)override fun `ignoredUsers`(): List<kotlin.String> {
            return FfiConverterSequenceString.lift(
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_ignored_users(
        it, _status)
}
    }
    )
    }
    

    override fun `inviteUser`(`roomId`: kotlin.String, `userId`: kotlin.String): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_invite_user(
        it, FfiConverterString.lower(`roomId`),FfiConverterString.lower(`userId`),_status)
}
    }
    )
    }
    

    override fun `isEventReadBy`(`roomId`: kotlin.String, `eventId`: kotlin.String, `userId`: kotlin.String): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_is_event_read_by(
        it, FfiConverterString.lower(`roomId`),FfiConverterString.lower(`eventId`),FfiConverterString.lower(`userId`),_status)
}
    }
    )
    }
    

    override fun `isLoggedIn`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_is_logged_in(
        it, _status)
}
    }
    )
    }
    

    override fun `isMarkedUnread`(`roomId`: kotlin.String): kotlin.Boolean? {
            return FfiConverterOptionalBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_is_marked_unread(
        it, FfiConverterString.lower(`roomId`),_status)
}
    }
    )
    }
    

    
    /**
     * Return true if the room is a Space (m.space).
     */override fun `isSpace`(`roomId`: kotlin.String): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_is_space(
        it, FfiConverterString.lower(`roomId`),_status)
}
    }
    )
    }
    

    
    /**
     * Check whether a user is currently ignored.
     */override fun `isUserIgnored`(`userId`: kotlin.String): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_is_user_ignored(
        it, FfiConverterString.lower(`userId`),_status)
}
    }
    )
    }
    

    override fun `joinByIdOrAlias`(`idOrAlias`: kotlin.String): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_join_by_id_or_alias(
        it, FfiConverterString.lower(`idOrAlias`),_status)
}
    }
    )
    }
    

    override fun `kickUser`(`roomId`: kotlin.String, `userId`: kotlin.String, `reason`: kotlin.String?): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_kick_user(
        it, FfiConverterString.lower(`roomId`),FfiConverterString.lower(`userId`),FfiConverterOptionalString.lower(`reason`),_status)
}
    }
    )
    }
    

    
    @Throws(FfiException::class)override fun `leaveRoom`(`roomId`: kotlin.String)
        = 
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_leave_room(
        it, FfiConverterString.lower(`roomId`),_status)
}
    }
    
    

    
    @Throws(FfiException::class)override fun `listInvited`(): List<RoomProfile> {
            return FfiConverterSequenceTypeRoomProfile.lift(
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_list_invited(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(FfiException::class)override fun `listMembers`(`roomId`: kotlin.String): List<MemberSummary> {
            return FfiConverterSequenceTypeMemberSummary.lift(
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_list_members(
        it, FfiConverterString.lower(`roomId`),_status)
}
    }
    )
    }
    

    override fun `listMyDevices`(): List<DeviceSummary> {
            return FfiConverterSequenceTypeDeviceSummary.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_list_my_devices(
        it, _status)
}
    }
    )
    }
    

    override fun `loadRoomListCache`(): List<RoomListEntry> {
            return FfiConverterSequenceTypeRoomListEntry.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_load_room_list_cache(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(FfiException::class)override fun `login`(`username`: kotlin.String, `password`: kotlin.String, `deviceDisplayName`: kotlin.String?)
        = 
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_login(
        it, FfiConverterString.lower(`username`),FfiConverterString.lower(`password`),FfiConverterOptionalString.lower(`deviceDisplayName`),_status)
}
    }
    
    

    
    /**
     * SSO with built-in loopback server. Opens a browser and completes login.
     */
    @Throws(FfiException::class)override fun `loginSsoLoopback`(`opener`: UrlOpener, `deviceName`: kotlin.String?)
        = 
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_login_sso_loopback(
        it, FfiConverterTypeUrlOpener.lower(`opener`),FfiConverterOptionalString.lower(`deviceName`),_status)
}
    }
    
    

    override fun `logout`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_logout(
        it, _status)
}
    }
    )
    }
    

    override fun `markFullyReadAt`(`roomId`: kotlin.String, `eventId`: kotlin.String): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_mark_fully_read_at(
        it, FfiConverterString.lower(`roomId`),FfiConverterString.lower(`eventId`),_status)
}
    }
    )
    }
    

    override fun `markRead`(`roomId`: kotlin.String): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_mark_read(
        it, FfiConverterString.lower(`roomId`),_status)
}
    }
    )
    }
    

    override fun `markReadAt`(`roomId`: kotlin.String, `eventId`: kotlin.String): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_mark_read_at(
        it, FfiConverterString.lower(`roomId`),FfiConverterString.lower(`eventId`),_status)
}
    }
    )
    }
    

    
    /**
     * Run a cleanup of the SDK's media cache with the current policy.
     */
    @Throws(FfiException::class)override fun `mediaCacheClean`()
        = 
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_media_cache_clean(
        it, _status)
}
    }
    
    

    override fun `monitorConnection`(`observer`: ConnectionObserver): kotlin.ULong {
            return FfiConverterULong.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_monitor_connection(
        it, FfiConverterTypeConnectionObserver.lower(`observer`),_status)
}
    }
    )
    }
    

    
    @Throws(FfiException::class)override fun `mxcThumbnailToCache`(`mxcUri`: kotlin.String, `width`: kotlin.UInt, `height`: kotlin.UInt, `crop`: kotlin.Boolean): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_mxc_thumbnail_to_cache(
        it, FfiConverterString.lower(`mxcUri`),FfiConverterUInt.lower(`width`),FfiConverterUInt.lower(`height`),FfiConverterBoolean.lower(`crop`),_status)
}
    }
    )
    }
    

    
    /**
     * List all joined spaces with basic profile info.
     */override fun `mySpaces`(): List<SpaceInfo> {
            return FfiConverterSequenceTypeSpaceInfo.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_my_spaces(
        it, _status)
}
    }
    )
    }
    

    override fun `nextSubId`(): kotlin.ULong {
            return FfiConverterULong.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_next_sub_id(
        it, _status)
}
    }
    )
    }
    

    
    /**
     * Subscribe to other users' live location shares in a room.
     */override fun `observeLiveLocation`(`roomId`: kotlin.String, `observer`: LiveLocationObserver): kotlin.ULong {
            return FfiConverterULong.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_observe_live_location(
        it, FfiConverterString.lower(`roomId`),FfiConverterTypeLiveLocationObserver.lower(`observer`),_status)
}
    }
    )
    }
    

    override fun `observeOwnReceipt`(`roomId`: kotlin.String, `observer`: ReceiptsObserver): kotlin.ULong {
            return FfiConverterULong.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_observe_own_receipt(
        it, FfiConverterString.lower(`roomId`),FfiConverterTypeReceiptsObserver.lower(`observer`),_status)
}
    }
    )
    }
    

    override fun `observeReceipts`(`roomId`: kotlin.String, `observer`: ReceiptsObserver): kotlin.ULong {
            return FfiConverterULong.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_observe_receipts(
        it, FfiConverterString.lower(`roomId`),FfiConverterTypeReceiptsObserver.lower(`observer`),_status)
}
    }
    )
    }
    

    override fun `observeRoomList`(`observer`: RoomListObserver): kotlin.ULong {
            return FfiConverterULong.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_observe_room_list(
        it, FfiConverterTypeRoomListObserver.lower(`observer`),_status)
}
    }
    )
    }
    

    override fun `observeSends`(`observer`: SendObserver): kotlin.ULong {
            return FfiConverterULong.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_observe_sends(
        it, FfiConverterTypeSendObserver.lower(`observer`),_status)
}
    }
    )
    }
    

    override fun `observeTimeline`(`roomId`: kotlin.String, `observer`: TimelineObserver): kotlin.ULong {
            return FfiConverterULong.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_observe_timeline(
        it, FfiConverterString.lower(`roomId`),FfiConverterTypeTimelineObserver.lower(`observer`),_status)
}
    }
    )
    }
    

    override fun `observeTyping`(`roomId`: kotlin.String, `observer`: TypingObserver): kotlin.ULong {
            return FfiConverterULong.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_observe_typing(
        it, FfiConverterString.lower(`roomId`),FfiConverterTypeTypingObserver.lower(`observer`),_status)
}
    }
    )
    }
    

    override fun `ownLastRead`(`roomId`: kotlin.String): OwnReceipt {
            return FfiConverterTypeOwnReceipt.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_own_last_read(
        it, FfiConverterString.lower(`roomId`),_status)
}
    }
    )
    }
    

    override fun `paginateBackwards`(`roomId`: kotlin.String, `count`: kotlin.UShort): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_paginate_backwards(
        it, FfiConverterString.lower(`roomId`),FfiConverterUShort.lower(`count`),_status)
}
    }
    )
    }
    

    override fun `paginateForwards`(`roomId`: kotlin.String, `count`: kotlin.UShort): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_paginate_forwards(
        it, FfiConverterString.lower(`roomId`),FfiConverterUShort.lower(`count`),_status)
}
    }
    )
    }
    

    
    @Throws(FfiException::class)override fun `publicRooms`(`server`: kotlin.String?, `search`: kotlin.String?, `limit`: kotlin.UInt, `since`: kotlin.String?): PublicRoomsPage {
            return FfiConverterTypePublicRoomsPage.lift(
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_public_rooms(
        it, FfiConverterOptionalString.lower(`server`),FfiConverterOptionalString.lower(`search`),FfiConverterUInt.lower(`limit`),FfiConverterOptionalString.lower(`since`),_status)
}
    }
    )
    }
    

    
    @Throws(FfiException::class)override fun `publishRoomAlias`(`roomId`: kotlin.String, `alias`: kotlin.String): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_publish_room_alias(
        it, FfiConverterString.lower(`roomId`),FfiConverterString.lower(`alias`),_status)
}
    }
    )
    }
    

    override fun `react`(`roomId`: kotlin.String, `eventId`: kotlin.String, `emoji`: kotlin.String): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_react(
        it, FfiConverterString.lower(`roomId`),FfiConverterString.lower(`eventId`),FfiConverterString.lower(`emoji`),_status)
}
    }
    )
    }
    

    override fun `reactionsBatch`(`roomId`: kotlin.String, `eventIds`: List<kotlin.String>): Map<kotlin.String, List<ReactionSummary>> {
            return FfiConverterMapStringSequenceTypeReactionSummary.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_reactions_batch(
        it, FfiConverterString.lower(`roomId`),FfiConverterSequenceString.lower(`eventIds`),_status)
}
    }
    )
    }
    

    
    /**
     * Return reactions (emoji -> count, me).
     */override fun `reactionsForEvent`(`roomId`: kotlin.String, `eventId`: kotlin.String): List<ReactionSummary> {
            return FfiConverterSequenceTypeReactionSummary.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_reactions_for_event(
        it, FfiConverterString.lower(`roomId`),FfiConverterString.lower(`eventId`),_status)
}
    }
    )
    }
    

    override fun `recentEvents`(`roomId`: kotlin.String, `limit`: kotlin.UInt): List<MessageEvent> {
            return FfiConverterSequenceTypeMessageEvent.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_recent_events(
        it, FfiConverterString.lower(`roomId`),FfiConverterUInt.lower(`limit`),_status)
}
    }
    )
    }
    

    override fun `recoverWithKey`(`recoveryKey`: kotlin.String): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_recover_with_key(
        it, FfiConverterString.lower(`recoveryKey`),_status)
}
    }
    )
    }
    

    override fun `redact`(`roomId`: kotlin.String, `eventId`: kotlin.String, `reason`: kotlin.String?): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_redact(
        it, FfiConverterString.lower(`roomId`),FfiConverterString.lower(`eventId`),FfiConverterOptionalString.lower(`reason`),_status)
}
    }
    )
    }
    

    
    /**
     * Register/Update HTTP pusher for UnifiedPush/Matrix gateway (e.g. ntfy)
     */override fun `registerUnifiedpush`(`appId`: kotlin.String, `pushkey`: kotlin.String, `gatewayUrl`: kotlin.String, `deviceDisplayName`: kotlin.String, `lang`: kotlin.String, `profileTag`: kotlin.String?): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_register_unifiedpush(
        it, FfiConverterString.lower(`appId`),FfiConverterString.lower(`pushkey`),FfiConverterString.lower(`gatewayUrl`),FfiConverterString.lower(`deviceDisplayName`),FfiConverterString.lower(`lang`),FfiConverterOptionalString.lower(`profileTag`),_status)
}
    }
    )
    }
    

    override fun `reply`(`roomId`: kotlin.String, `inReplyTo`: kotlin.String, `body`: kotlin.String): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_reply(
        it, FfiConverterString.lower(`roomId`),FfiConverterString.lower(`inReplyTo`),FfiConverterString.lower(`body`),_status)
}
    }
    )
    }
    

    
    @Throws(FfiException::class)override fun `resolveRoomId`(`idOrAlias`: kotlin.String): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_resolve_room_id(
        it, FfiConverterString.lower(`idOrAlias`),_status)
}
    }
    )
    }
    

    override fun `retryByTxn`(`roomId`: kotlin.String, `txnId`: kotlin.String): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_retry_by_txn(
        it, FfiConverterString.lower(`roomId`),FfiConverterString.lower(`txnId`),_status)
}
    }
    )
    }
    

    
    @Throws(FfiException::class)override fun `roomDirectoryVisibility`(`roomId`: kotlin.String): RoomDirectoryVisibility {
            return FfiConverterTypeRoomDirectoryVisibility.lift(
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_room_directory_visibility(
        it, FfiConverterString.lower(`roomId`),_status)
}
    }
    )
    }
    

    override fun `roomListSetUnreadOnly`(`token`: kotlin.ULong, `unreadOnly`: kotlin.Boolean): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_room_list_set_unread_only(
        it, FfiConverterULong.lower(`token`),FfiConverterBoolean.lower(`unreadOnly`),_status)
}
    }
    )
    }
    

    override fun `roomNotificationMode`(`roomId`: kotlin.String): FfiRoomNotificationMode? {
            return FfiConverterOptionalTypeFfiRoomNotificationMode.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_room_notification_mode(
        it, FfiConverterString.lower(`roomId`),_status)
}
    }
    )
    }
    

    
    /**
     * Return the predecessor room if this room replaced an earlier room.
     */override fun `roomPredecessor`(`roomId`: kotlin.String): PredecessorRoomInfo? {
            return FfiConverterOptionalTypePredecessorRoomInfo.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_room_predecessor(
        it, FfiConverterString.lower(`roomId`),_status)
}
    }
    )
    }
    

    
    @Throws(FfiException::class)override fun `roomProfile`(`roomId`: kotlin.String): RoomProfile? {
            return FfiConverterOptionalTypeRoomProfile.lift(
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_room_profile(
        it, FfiConverterString.lower(`roomId`),_status)
}
    }
    )
    }
    

    override fun `roomSendQueueSetEnabled`(`roomId`: kotlin.String, `enabled`: kotlin.Boolean): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_room_send_queue_set_enabled(
        it, FfiConverterString.lower(`roomId`),FfiConverterBoolean.lower(`enabled`),_status)
}
    }
    )
    }
    

    
    /**
     * If this room is tombstoned, return its successor room details.
     */override fun `roomSuccessor`(`roomId`: kotlin.String): SuccessorRoomInfo? {
            return FfiConverterOptionalTypeSuccessorRoomInfo.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_room_successor(
        it, FfiConverterString.lower(`roomId`),_status)
}
    }
    )
    }
    

    override fun `roomTags`(`roomId`: kotlin.String): RoomTags? {
            return FfiConverterOptionalTypeRoomTags.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_room_tags(
        it, FfiConverterString.lower(`roomId`),_status)
}
    }
    )
    }
    

    override fun `roomUnreadStats`(`roomId`: kotlin.String): UnreadStats? {
            return FfiConverterOptionalTypeUnreadStats.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_room_unread_stats(
        it, FfiConverterString.lower(`roomId`),_status)
}
    }
    )
    }
    

    
    /**
     * Get tombstone / predecessor / successor info for a room, if available.
     */override fun `roomUpgradeLinks`(`roomId`: kotlin.String): RoomUpgradeLinks? {
            return FfiConverterOptionalTypeRoomUpgradeLinks.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_room_upgrade_links(
        it, FfiConverterString.lower(`roomId`),_status)
}
    }
    )
    }
    

    override fun `rooms`(): List<RoomSummary> {
            return FfiConverterSequenceTypeRoomSummary.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_rooms(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(FfiException::class)override fun `searchRoom`(`roomId`: kotlin.String, `query`: kotlin.String, `limit`: kotlin.UInt, `offset`: kotlin.UInt?): SearchPage {
            return FfiConverterTypeSearchPage.lift(
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_search_room(
        it, FfiConverterString.lower(`roomId`),FfiConverterString.lower(`query`),FfiConverterUInt.lower(`limit`),FfiConverterOptionalUInt.lower(`offset`),_status)
}
    }
    )
    }
    

    
    @Throws(FfiException::class)override fun `searchUsers`(`searchTerm`: kotlin.String, `limit`: kotlin.ULong): List<DirectoryUser> {
            return FfiConverterSequenceTypeDirectoryUser.lift(
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_search_users(
        it, FfiConverterString.lower(`searchTerm`),FfiConverterULong.lower(`limit`),_status)
}
    }
    )
    }
    

    
    @Throws(FfiException::class)override fun `seenByForEvent`(`roomId`: kotlin.String, `eventId`: kotlin.String, `limit`: kotlin.UInt): List<SeenByEntry> {
            return FfiConverterSequenceTypeSeenByEntry.lift(
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_seen_by_for_event(
        it, FfiConverterString.lower(`roomId`),FfiConverterString.lower(`eventId`),FfiConverterUInt.lower(`limit`),_status)
}
    }
    )
    }
    

    override fun `sendAttachmentBytes`(`roomId`: kotlin.String, `filename`: kotlin.String, `mime`: kotlin.String, `bytes`: kotlin.ByteArray, `progress`: ProgressObserver?): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_send_attachment_bytes(
        it, FfiConverterString.lower(`roomId`),FfiConverterString.lower(`filename`),FfiConverterString.lower(`mime`),FfiConverterByteArray.lower(`bytes`),FfiConverterOptionalTypeProgressObserver.lower(`progress`),_status)
}
    }
    )
    }
    

    override fun `sendAttachmentFromPath`(`roomId`: kotlin.String, `path`: kotlin.String, `mime`: kotlin.String, `filename`: kotlin.String?, `progress`: ProgressObserver?): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_send_attachment_from_path(
        it, FfiConverterString.lower(`roomId`),FfiConverterString.lower(`path`),FfiConverterString.lower(`mime`),FfiConverterOptionalString.lower(`filename`),FfiConverterOptionalTypeProgressObserver.lower(`progress`),_status)
}
    }
    )
    }
    

    override fun `sendExistingAttachment`(`roomId`: kotlin.String, `att`: AttachmentInfo, `body`: kotlin.String?, `progress`: ProgressObserver?): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_send_existing_attachment(
        it, FfiConverterString.lower(`roomId`),FfiConverterTypeAttachmentInfo.lower(`att`),FfiConverterOptionalString.lower(`body`),FfiConverterOptionalTypeProgressObserver.lower(`progress`),_status)
}
    }
    )
    }
    

    
    /**
     * Send a single live location beacon update (geo:`geo:` URI) in the room.
     */
    @Throws(FfiException::class)override fun `sendLiveLocation`(`roomId`: kotlin.String, `geoUri`: kotlin.String)
        = 
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_send_live_location(
        it, FfiConverterString.lower(`roomId`),FfiConverterString.lower(`geoUri`),_status)
}
    }
    
    

    override fun `sendMessage`(`roomId`: kotlin.String, `body`: kotlin.String): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_send_message(
        it, FfiConverterString.lower(`roomId`),FfiConverterString.lower(`body`),_status)
}
    }
    )
    }
    

    
    /**
     * End a poll (MSC3381, unstable `org.matrix.msc3381.poll.end`).
     *
     * This just sends an `m.poll.end` (unstable) event linked to the given poll
     * start event. It does *not* compute or embed per‑option results.
     */
    @Throws(FfiException::class)override fun `sendPollEnd`(`roomId`: kotlin.String, `pollEventId`: kotlin.String)
        = 
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_send_poll_end(
        it, FfiConverterString.lower(`roomId`),FfiConverterString.lower(`pollEventId`),_status)
}
    }
    
    

    
    /**
     * Send a poll response for a given poll event.
     * `answers` are the answer IDs ("a", "b", "c"...), not the labels.
     */
    @Throws(FfiException::class)override fun `sendPollResponse`(`roomId`: kotlin.String, `pollEventId`: kotlin.String, `answers`: List<kotlin.String>)
        = 
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_send_poll_response(
        it, FfiConverterString.lower(`roomId`),FfiConverterString.lower(`pollEventId`),FfiConverterSequenceString.lower(`answers`),_status)
}
    }
    
    

    
    /**
     * Send a new poll (MSC3381, unstable `m.poll.start`).
     * Returns the event ID if sending succeeds.
     */
    @Throws(FfiException::class)override fun `sendPollStart`(`roomId`: kotlin.String, `def`: PollDefinition): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_send_poll_start(
        it, FfiConverterString.lower(`roomId`),FfiConverterTypePollDefinition.lower(`def`),_status)
}
    }
    )
    }
    

    override fun `sendQueueSetEnabled`(`enabled`: kotlin.Boolean): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_send_queue_set_enabled(
        it, FfiConverterBoolean.lower(`enabled`),_status)
}
    }
    )
    }
    

    
    /**
     * MSC3440
     */override fun `sendThreadText`(`roomId`: kotlin.String, `rootEventId`: kotlin.String, `body`: kotlin.String, `replyToEventId`: kotlin.String?): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_send_thread_text(
        it, FfiConverterString.lower(`roomId`),FfiConverterString.lower(`rootEventId`),FfiConverterString.lower(`body`),FfiConverterOptionalString.lower(`replyToEventId`),_status)
}
    }
    )
    }
    

    override fun `setMarkUnread`(`roomId`: kotlin.String, `unread`: kotlin.Boolean): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_set_mark_unread(
        it, FfiConverterString.lower(`roomId`),FfiConverterBoolean.lower(`unread`),_status)
}
    }
    )
    }
    

    
    /**
     * Configure the SDK's media retention policy and apply it immediately.
     * Any `None` will keep the SDK default for that parameter.
     */
    @Throws(FfiException::class)override fun `setMediaRetentionPolicy`(`maxCacheSizeBytes`: kotlin.ULong?, `maxFileSizeBytes`: kotlin.ULong?, `lastAccessExpirySecs`: kotlin.ULong?, `cleanupFrequencySecs`: kotlin.ULong?)
        = 
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_set_media_retention_policy(
        it, FfiConverterOptionalULong.lower(`maxCacheSizeBytes`),FfiConverterOptionalULong.lower(`maxFileSizeBytes`),FfiConverterOptionalULong.lower(`lastAccessExpirySecs`),FfiConverterOptionalULong.lower(`cleanupFrequencySecs`),_status)
}
    }
    
    

    
    /**
     * Set this account's presence and optional status message.
     */
    @Throws(FfiException::class)override fun `setPresence`(`state`: Presence, `statusMsg`: kotlin.String?)
        = 
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_set_presence(
        it, FfiConverterTypePresence.lower(`state`),FfiConverterOptionalString.lower(`statusMsg`),_status)
}
    }
    
    

    
    @Throws(FfiException::class)override fun `setRoomCanonicalAlias`(`roomId`: kotlin.String, `alias`: kotlin.String?, `altAliases`: List<kotlin.String>)
        = 
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_set_room_canonical_alias(
        it, FfiConverterString.lower(`roomId`),FfiConverterOptionalString.lower(`alias`),FfiConverterSequenceString.lower(`altAliases`),_status)
}
    }
    
    

    
    @Throws(FfiException::class)override fun `setRoomDirectoryVisibility`(`roomId`: kotlin.String, `visibility`: RoomDirectoryVisibility)
        = 
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_set_room_directory_visibility(
        it, FfiConverterString.lower(`roomId`),FfiConverterTypeRoomDirectoryVisibility.lower(`visibility`),_status)
}
    }
    
    

    override fun `setRoomFavourite`(`roomId`: kotlin.String, `fav`: kotlin.Boolean): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_set_room_favourite(
        it, FfiConverterString.lower(`roomId`),FfiConverterBoolean.lower(`fav`),_status)
}
    }
    )
    }
    

    
    @Throws(FfiException::class)override fun `setRoomHistoryVisibility`(`roomId`: kotlin.String, `vis`: RoomHistoryVisibility)
        = 
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_set_room_history_visibility(
        it, FfiConverterString.lower(`roomId`),FfiConverterTypeRoomHistoryVisibility.lower(`vis`),_status)
}
    }
    
    

    
    @Throws(FfiException::class)override fun `setRoomJoinRule`(`roomId`: kotlin.String, `rule`: RoomJoinRule)
        = 
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_set_room_join_rule(
        it, FfiConverterString.lower(`roomId`),FfiConverterTypeRoomJoinRule.lower(`rule`),_status)
}
    }
    
    

    override fun `setRoomLowPriority`(`roomId`: kotlin.String, `low`: kotlin.Boolean): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_set_room_low_priority(
        it, FfiConverterString.lower(`roomId`),FfiConverterBoolean.lower(`low`),_status)
}
    }
    )
    }
    

    override fun `setRoomName`(`roomId`: kotlin.String, `name`: kotlin.String): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_set_room_name(
        it, FfiConverterString.lower(`roomId`),FfiConverterString.lower(`name`),_status)
}
    }
    )
    }
    

    
    @Throws(FfiException::class)override fun `setRoomNotificationMode`(`roomId`: kotlin.String, `mode`: FfiRoomNotificationMode)
        = 
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_set_room_notification_mode(
        it, FfiConverterString.lower(`roomId`),FfiConverterTypeFfiRoomNotificationMode.lower(`mode`),_status)
}
    }
    
    

    override fun `setRoomTopic`(`roomId`: kotlin.String, `topic`: kotlin.String): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_set_room_topic(
        it, FfiConverterString.lower(`roomId`),FfiConverterString.lower(`topic`),_status)
}
    }
    )
    }
    

    override fun `setTyping`(`roomId`: kotlin.String, `typing`: kotlin.Boolean): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_set_typing(
        it, FfiConverterString.lower(`roomId`),FfiConverterBoolean.lower(`typing`),_status)
}
    }
    )
    }
    

    override fun `shutdown`()
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_shutdown(
        it, _status)
}
    }
    
    

    
    /**
     * Add a child (room or subspace) to a space via m.space.child.
     */
    @Throws(FfiException::class)override fun `spaceAddChild`(`spaceId`: kotlin.String, `childRoomId`: kotlin.String, `order`: kotlin.String?, `suggested`: kotlin.Boolean?)
        = 
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_space_add_child(
        it, FfiConverterString.lower(`spaceId`),FfiConverterString.lower(`childRoomId`),FfiConverterOptionalString.lower(`order`),FfiConverterOptionalBoolean.lower(`suggested`),_status)
}
    }
    
    

    
    /**
     * Traverse a space with the server-side hierarchy API (MSC2946).
     */
    @Throws(FfiException::class)override fun `spaceHierarchy`(`spaceId`: kotlin.String, `from`: kotlin.String?, `limit`: kotlin.UInt, `maxDepth`: kotlin.UInt?, `suggestedOnly`: kotlin.Boolean): SpaceHierarchyPage {
            return FfiConverterTypeSpaceHierarchyPage.lift(
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_space_hierarchy(
        it, FfiConverterString.lower(`spaceId`),FfiConverterOptionalString.lower(`from`),FfiConverterUInt.lower(`limit`),FfiConverterOptionalUInt.lower(`maxDepth`),FfiConverterBoolean.lower(`suggestedOnly`),_status)
}
    }
    )
    }
    

    
    /**
     * Invite a user to a space.
     */override fun `spaceInviteUser`(`spaceId`: kotlin.String, `userId`: kotlin.String): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_space_invite_user(
        it, FfiConverterString.lower(`spaceId`),FfiConverterString.lower(`userId`),_status)
}
    }
    )
    }
    

    
    /**
     * Remove a child from a space by sending an empty content state for that key.
     */
    @Throws(FfiException::class)override fun `spaceRemoveChild`(`spaceId`: kotlin.String, `childRoomId`: kotlin.String)
        = 
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_space_remove_child(
        it, FfiConverterString.lower(`spaceId`),FfiConverterString.lower(`childRoomId`),_status)
}
    }
    
    

    override fun `startCallInbox`(`observer`: CallObserver): kotlin.ULong {
            return FfiConverterULong.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_start_call_inbox(
        it, FfiConverterTypeCallObserver.lower(`observer`),_status)
}
    }
    )
    }
    

    
    /**
     * Start or join an Element Call session for a room.
     *
     * `element_call_url`:
     * - `None`  -> use "https://call.element.io".
     * - `Some`  -> use a self-hosted Element Call instance.
     */
    @Throws(FfiException::class)override fun `startElementCall`(`roomId`: kotlin.String, `elementCallUrl`: kotlin.String?, `intent`: ElementCallIntent, `observer`: CallWidgetObserver): CallSessionInfo {
            return FfiConverterTypeCallSessionInfo.lift(
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_start_element_call(
        it, FfiConverterString.lower(`roomId`),FfiConverterOptionalString.lower(`elementCallUrl`),FfiConverterTypeElementCallIntent.lower(`intent`),FfiConverterTypeCallWidgetObserver.lower(`observer`),_status)
}
    }
    )
    }
    

    
    /**
     * Start sharing live location in a room for `duration_ms` milliseconds.
     */
    @Throws(FfiException::class)override fun `startLiveLocation`(`roomId`: kotlin.String, `durationMs`: kotlin.ULong, `description`: kotlin.String?)
        = 
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_start_live_location(
        it, FfiConverterString.lower(`roomId`),FfiConverterULong.lower(`durationMs`),FfiConverterOptionalString.lower(`description`),_status)
}
    }
    
    

    override fun `startSelfSas`(`deviceId`: kotlin.String, `observer`: VerificationObserver): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_start_self_sas(
        it, FfiConverterString.lower(`deviceId`),FfiConverterTypeVerificationObserver.lower(`observer`),_status)
}
    }
    )
    }
    

    override fun `startSupervisedSync`(`observer`: SyncObserver)
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_start_supervised_sync(
        it, FfiConverterTypeSyncObserver.lower(`observer`),_status)
}
    }
    
    

    override fun `startUserSas`(`userId`: kotlin.String, `observer`: VerificationObserver): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_start_user_sas(
        it, FfiConverterString.lower(`userId`),FfiConverterTypeVerificationObserver.lower(`observer`),_status)
}
    }
    )
    }
    

    override fun `startVerificationInbox`(`observer`: VerificationInboxObserver): kotlin.ULong {
            return FfiConverterULong.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_start_verification_inbox(
        it, FfiConverterTypeVerificationInboxObserver.lower(`observer`),_status)
}
    }
    )
    }
    

    override fun `stopCallInbox`(`token`: kotlin.ULong): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_stop_call_inbox(
        it, FfiConverterULong.lower(`token`),_status)
}
    }
    )
    }
    

    
    /**
     * Stop an Element Call widget session: aborts driver + recv loops and drops the handle.
     */override fun `stopElementCall`(`sessionId`: kotlin.ULong): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_stop_element_call(
        it, FfiConverterULong.lower(`sessionId`),_status)
}
    }
    )
    }
    

    
    /**
     * Stop our live location share (if any) in the room.
     */
    @Throws(FfiException::class)override fun `stopLiveLocation`(`roomId`: kotlin.String)
        = 
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_stop_live_location(
        it, FfiConverterString.lower(`roomId`),_status)
}
    }
    
    

    
    @Throws(FfiException::class)override fun `threadReplies`(`roomId`: kotlin.String, `rootEventId`: kotlin.String, `from`: kotlin.String?, `limit`: kotlin.UInt, `directionForward`: kotlin.Boolean): ThreadPage {
            return FfiConverterTypeThreadPage.lift(
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_thread_replies(
        it, FfiConverterString.lower(`roomId`),FfiConverterString.lower(`rootEventId`),FfiConverterOptionalString.lower(`from`),FfiConverterUInt.lower(`limit`),FfiConverterBoolean.lower(`directionForward`),_status)
}
    }
    )
    }
    

    
    /**
     * Approximate thread summary: count + latest timestamp by paging relations.
     */
    @Throws(FfiException::class)override fun `threadSummary`(`roomId`: kotlin.String, `rootEventId`: kotlin.String, `perPage`: kotlin.UInt, `maxPages`: kotlin.UInt): ThreadSummary {
            return FfiConverterTypeThreadSummary.lift(
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_thread_summary(
        it, FfiConverterString.lower(`roomId`),FfiConverterString.lower(`rootEventId`),FfiConverterUInt.lower(`perPage`),FfiConverterUInt.lower(`maxPages`),_status)
}
    }
    )
    }
    

    
    @Throws(FfiException::class)override fun `thumbnailToCache`(`att`: AttachmentInfo, `width`: kotlin.UInt, `height`: kotlin.UInt, `useCrop`: kotlin.Boolean): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_thumbnail_to_cache(
        it, FfiConverterTypeAttachmentInfo.lower(`att`),FfiConverterUInt.lower(`width`),FfiConverterUInt.lower(`height`),FfiConverterBoolean.lower(`useCrop`),_status)
}
    }
    )
    }
    

    override fun `unbanUser`(`roomId`: kotlin.String, `userId`: kotlin.String, `reason`: kotlin.String?): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_unban_user(
        it, FfiConverterString.lower(`roomId`),FfiConverterString.lower(`userId`),FfiConverterOptionalString.lower(`reason`),_status)
}
    }
    )
    }
    

    
    /**
     * Remove a user from the ignore list.
     */
    @Throws(FfiException::class)override fun `unignoreUser`(`userId`: kotlin.String)
        = 
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_unignore_user(
        it, FfiConverterString.lower(`userId`),_status)
}
    }
    
    

    override fun `unobserveConnection`(`subId`: kotlin.ULong): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_unobserve_connection(
        it, FfiConverterULong.lower(`subId`),_status)
}
    }
    )
    }
    

    override fun `unobserveLiveLocation`(`subId`: kotlin.ULong): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_unobserve_live_location(
        it, FfiConverterULong.lower(`subId`),_status)
}
    }
    )
    }
    

    override fun `unobserveReceipts`(`subId`: kotlin.ULong): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_unobserve_receipts(
        it, FfiConverterULong.lower(`subId`),_status)
}
    }
    )
    }
    

    override fun `unobserveRoomList`(`token`: kotlin.ULong): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_unobserve_room_list(
        it, FfiConverterULong.lower(`token`),_status)
}
    }
    )
    }
    

    override fun `unobserveSends`(`id`: kotlin.ULong): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_unobserve_sends(
        it, FfiConverterULong.lower(`id`),_status)
}
    }
    )
    }
    

    override fun `unobserveTimeline`(`subId`: kotlin.ULong): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_unobserve_timeline(
        it, FfiConverterULong.lower(`subId`),_status)
}
    }
    )
    }
    

    override fun `unobserveTyping`(`subId`: kotlin.ULong): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_unobserve_typing(
        it, FfiConverterULong.lower(`subId`),_status)
}
    }
    )
    }
    

    override fun `unobserveVerificationInbox`(`subId`: kotlin.ULong): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_unobserve_verification_inbox(
        it, FfiConverterULong.lower(`subId`),_status)
}
    }
    )
    }
    

    
    @Throws(FfiException::class)override fun `unpublishRoomAlias`(`roomId`: kotlin.String, `alias`: kotlin.String): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_unpublish_room_alias(
        it, FfiConverterString.lower(`roomId`),FfiConverterString.lower(`alias`),_status)
}
    }
    )
    }
    

    
    /**
     * Unregister HTTP pusher by ids
     */override fun `unregisterUnifiedpush`(`appId`: kotlin.String, `pushkey`: kotlin.String): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_unregister_unifiedpush(
        it, FfiConverterString.lower(`appId`),FfiConverterString.lower(`pushkey`),_status)
}
    }
    )
    }
    

    
    /**
     * Upgrade a room to a new room version.
     * `new_version` is e.g. "9", "10", "11".
     * Returns the new room ID on success.
     */
    @Throws(FfiException::class)override fun `upgradeRoom`(`roomId`: kotlin.String, `newVersion`: kotlin.String): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(FfiException) { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_upgrade_room(
        it, FfiConverterString.lower(`roomId`),FfiConverterString.lower(`newVersion`),_status)
}
    }
    )
    }
    

    
    /**
     * Deprecated, remove after fixing push notifs for android (causes older parts to be used (legacy sync, which causes errors on the current synapse server))
     */override fun `wakeSyncOnce`(`timeoutMs`: kotlin.UInt): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_wake_sync_once(
        it, FfiConverterUInt.lower(`timeoutMs`),_status)
}
    }
    )
    }
    

    override fun `whoami`(): kotlin.String? {
            return FfiConverterOptionalString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_mages_ffi_fn_method_client_whoami(
        it, _status)
}
    }
    )
    }
    

    

    
    
    companion object
    
}

/**
 * @suppress
 */
public object FfiConverterTypeClient: FfiConverter<Client, Pointer> {

    override fun lower(value: Client): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): Client {
        return Client(value)
    }

    override fun read(buf: ByteBuffer): Client {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Client) = 8UL

    override fun write(value: Client, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}



data class AttachmentInfo (
    var `kind`: AttachmentKind, 
    var `mxcUri`: kotlin.String, 
    var `mime`: kotlin.String?, 
    var `sizeBytes`: kotlin.ULong?, 
    var `width`: kotlin.UInt?, 
    var `height`: kotlin.UInt?, 
    var `durationMs`: kotlin.ULong?, 
    /**
     * Provided when available, else UI uses `mxc_uri` to request a thumbnail.
     */
    var `thumbnailMxcUri`: kotlin.String?, 
    /**
     * encrypted "file" (main content)
     */
    var `encrypted`: EncFile?, 
    /**
     * encrypted "thumbnail_file"
     */
    var `thumbnailEncrypted`: EncFile?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeAttachmentInfo: FfiConverterRustBuffer<AttachmentInfo> {
    override fun read(buf: ByteBuffer): AttachmentInfo {
        return AttachmentInfo(
            FfiConverterTypeAttachmentKind.read(buf),
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalUInt.read(buf),
            FfiConverterOptionalUInt.read(buf),
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalTypeEncFile.read(buf),
            FfiConverterOptionalTypeEncFile.read(buf),
        )
    }

    override fun allocationSize(value: AttachmentInfo) = (
            FfiConverterTypeAttachmentKind.allocationSize(value.`kind`) +
            FfiConverterString.allocationSize(value.`mxcUri`) +
            FfiConverterOptionalString.allocationSize(value.`mime`) +
            FfiConverterOptionalULong.allocationSize(value.`sizeBytes`) +
            FfiConverterOptionalUInt.allocationSize(value.`width`) +
            FfiConverterOptionalUInt.allocationSize(value.`height`) +
            FfiConverterOptionalULong.allocationSize(value.`durationMs`) +
            FfiConverterOptionalString.allocationSize(value.`thumbnailMxcUri`) +
            FfiConverterOptionalTypeEncFile.allocationSize(value.`encrypted`) +
            FfiConverterOptionalTypeEncFile.allocationSize(value.`thumbnailEncrypted`)
    )

    override fun write(value: AttachmentInfo, buf: ByteBuffer) {
            FfiConverterTypeAttachmentKind.write(value.`kind`, buf)
            FfiConverterString.write(value.`mxcUri`, buf)
            FfiConverterOptionalString.write(value.`mime`, buf)
            FfiConverterOptionalULong.write(value.`sizeBytes`, buf)
            FfiConverterOptionalUInt.write(value.`width`, buf)
            FfiConverterOptionalUInt.write(value.`height`, buf)
            FfiConverterOptionalULong.write(value.`durationMs`, buf)
            FfiConverterOptionalString.write(value.`thumbnailMxcUri`, buf)
            FfiConverterOptionalTypeEncFile.write(value.`encrypted`, buf)
            FfiConverterOptionalTypeEncFile.write(value.`thumbnailEncrypted`, buf)
    }
}



data class CallInvite (
    var `roomId`: kotlin.String, 
    var `sender`: kotlin.String, 
    var `callId`: kotlin.String, 
    var `isVideo`: kotlin.Boolean, 
    var `tsMs`: kotlin.ULong
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeCallInvite: FfiConverterRustBuffer<CallInvite> {
    override fun read(buf: ByteBuffer): CallInvite {
        return CallInvite(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterULong.read(buf),
        )
    }

    override fun allocationSize(value: CallInvite) = (
            FfiConverterString.allocationSize(value.`roomId`) +
            FfiConverterString.allocationSize(value.`sender`) +
            FfiConverterString.allocationSize(value.`callId`) +
            FfiConverterBoolean.allocationSize(value.`isVideo`) +
            FfiConverterULong.allocationSize(value.`tsMs`)
    )

    override fun write(value: CallInvite, buf: ByteBuffer) {
            FfiConverterString.write(value.`roomId`, buf)
            FfiConverterString.write(value.`sender`, buf)
            FfiConverterString.write(value.`callId`, buf)
            FfiConverterBoolean.write(value.`isVideo`, buf)
            FfiConverterULong.write(value.`tsMs`, buf)
    }
}



data class CallSessionInfo (
    /**
     * Token to identify this running call session on the Rust side.
     */
    var `sessionId`: kotlin.ULong, 
    /**
     * Fully-expanded Element Call URL to load into a WebView.
     */
    var `widgetUrl`: kotlin.String
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeCallSessionInfo: FfiConverterRustBuffer<CallSessionInfo> {
    override fun read(buf: ByteBuffer): CallSessionInfo {
        return CallSessionInfo(
            FfiConverterULong.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: CallSessionInfo) = (
            FfiConverterULong.allocationSize(value.`sessionId`) +
            FfiConverterString.allocationSize(value.`widgetUrl`)
    )

    override fun write(value: CallSessionInfo, buf: ByteBuffer) {
            FfiConverterULong.write(value.`sessionId`, buf)
            FfiConverterString.write(value.`widgetUrl`, buf)
    }
}



data class DeviceSummary (
    var `deviceId`: kotlin.String, 
    var `displayName`: kotlin.String, 
    var `ed25519`: kotlin.String, 
    var `isOwn`: kotlin.Boolean, 
    var `verified`: kotlin.Boolean
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeDeviceSummary: FfiConverterRustBuffer<DeviceSummary> {
    override fun read(buf: ByteBuffer): DeviceSummary {
        return DeviceSummary(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
        )
    }

    override fun allocationSize(value: DeviceSummary) = (
            FfiConverterString.allocationSize(value.`deviceId`) +
            FfiConverterString.allocationSize(value.`displayName`) +
            FfiConverterString.allocationSize(value.`ed25519`) +
            FfiConverterBoolean.allocationSize(value.`isOwn`) +
            FfiConverterBoolean.allocationSize(value.`verified`)
    )

    override fun write(value: DeviceSummary, buf: ByteBuffer) {
            FfiConverterString.write(value.`deviceId`, buf)
            FfiConverterString.write(value.`displayName`, buf)
            FfiConverterString.write(value.`ed25519`, buf)
            FfiConverterBoolean.write(value.`isOwn`, buf)
            FfiConverterBoolean.write(value.`verified`, buf)
    }
}



data class DirectoryUser (
    var `userId`: kotlin.String, 
    var `displayName`: kotlin.String?, 
    var `avatarUrl`: kotlin.String?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeDirectoryUser: FfiConverterRustBuffer<DirectoryUser> {
    override fun read(buf: ByteBuffer): DirectoryUser {
        return DirectoryUser(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: DirectoryUser) = (
            FfiConverterString.allocationSize(value.`userId`) +
            FfiConverterOptionalString.allocationSize(value.`displayName`) +
            FfiConverterOptionalString.allocationSize(value.`avatarUrl`)
    )

    override fun write(value: DirectoryUser, buf: ByteBuffer) {
            FfiConverterString.write(value.`userId`, buf)
            FfiConverterOptionalString.write(value.`displayName`, buf)
            FfiConverterOptionalString.write(value.`avatarUrl`, buf)
    }
}



data class DownloadResult (
    var `path`: kotlin.String, 
    var `bytes`: kotlin.ULong
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeDownloadResult: FfiConverterRustBuffer<DownloadResult> {
    override fun read(buf: ByteBuffer): DownloadResult {
        return DownloadResult(
            FfiConverterString.read(buf),
            FfiConverterULong.read(buf),
        )
    }

    override fun allocationSize(value: DownloadResult) = (
            FfiConverterString.allocationSize(value.`path`) +
            FfiConverterULong.allocationSize(value.`bytes`)
    )

    override fun write(value: DownloadResult, buf: ByteBuffer) {
            FfiConverterString.write(value.`path`, buf)
            FfiConverterULong.write(value.`bytes`, buf)
    }
}



data class EncFile (
    /**
     * mxc://… of the encrypted media
     */
    var `url`: kotlin.String, 
    /**
     * Full JSON of ruma::events::room::message::EncryptedFile (v2)
     */
    var `json`: kotlin.String
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeEncFile: FfiConverterRustBuffer<EncFile> {
    override fun read(buf: ByteBuffer): EncFile {
        return EncFile(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: EncFile) = (
            FfiConverterString.allocationSize(value.`url`) +
            FfiConverterString.allocationSize(value.`json`)
    )

    override fun write(value: EncFile, buf: ByteBuffer) {
            FfiConverterString.write(value.`url`, buf)
            FfiConverterString.write(value.`json`, buf)
    }
}



data class InviteSummary (
    var `roomId`: kotlin.String, 
    var `name`: kotlin.String
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeInviteSummary: FfiConverterRustBuffer<InviteSummary> {
    override fun read(buf: ByteBuffer): InviteSummary {
        return InviteSummary(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: InviteSummary) = (
            FfiConverterString.allocationSize(value.`roomId`) +
            FfiConverterString.allocationSize(value.`name`)
    )

    override fun write(value: InviteSummary, buf: ByteBuffer) {
            FfiConverterString.write(value.`roomId`, buf)
            FfiConverterString.write(value.`name`, buf)
    }
}



data class LatestRoomEvent (
    var `eventId`: kotlin.String, 
    var `sender`: kotlin.String, 
    var `body`: kotlin.String?, 
    var `msgtype`: kotlin.String?, 
    var `eventType`: kotlin.String, 
    var `timestamp`: kotlin.Long, 
    var `isRedacted`: kotlin.Boolean, 
    var `isEncrypted`: kotlin.Boolean
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeLatestRoomEvent: FfiConverterRustBuffer<LatestRoomEvent> {
    override fun read(buf: ByteBuffer): LatestRoomEvent {
        return LatestRoomEvent(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterLong.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
        )
    }

    override fun allocationSize(value: LatestRoomEvent) = (
            FfiConverterString.allocationSize(value.`eventId`) +
            FfiConverterString.allocationSize(value.`sender`) +
            FfiConverterOptionalString.allocationSize(value.`body`) +
            FfiConverterOptionalString.allocationSize(value.`msgtype`) +
            FfiConverterString.allocationSize(value.`eventType`) +
            FfiConverterLong.allocationSize(value.`timestamp`) +
            FfiConverterBoolean.allocationSize(value.`isRedacted`) +
            FfiConverterBoolean.allocationSize(value.`isEncrypted`)
    )

    override fun write(value: LatestRoomEvent, buf: ByteBuffer) {
            FfiConverterString.write(value.`eventId`, buf)
            FfiConverterString.write(value.`sender`, buf)
            FfiConverterOptionalString.write(value.`body`, buf)
            FfiConverterOptionalString.write(value.`msgtype`, buf)
            FfiConverterString.write(value.`eventType`, buf)
            FfiConverterLong.write(value.`timestamp`, buf)
            FfiConverterBoolean.write(value.`isRedacted`, buf)
            FfiConverterBoolean.write(value.`isEncrypted`, buf)
    }
}



data class LiveLocationShareInfo (
    var `userId`: kotlin.String, 
    var `geoUri`: kotlin.String, 
    var `tsMs`: kotlin.ULong, 
    var `isLive`: kotlin.Boolean
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeLiveLocationShareInfo: FfiConverterRustBuffer<LiveLocationShareInfo> {
    override fun read(buf: ByteBuffer): LiveLocationShareInfo {
        return LiveLocationShareInfo(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterULong.read(buf),
            FfiConverterBoolean.read(buf),
        )
    }

    override fun allocationSize(value: LiveLocationShareInfo) = (
            FfiConverterString.allocationSize(value.`userId`) +
            FfiConverterString.allocationSize(value.`geoUri`) +
            FfiConverterULong.allocationSize(value.`tsMs`) +
            FfiConverterBoolean.allocationSize(value.`isLive`)
    )

    override fun write(value: LiveLocationShareInfo, buf: ByteBuffer) {
            FfiConverterString.write(value.`userId`, buf)
            FfiConverterString.write(value.`geoUri`, buf)
            FfiConverterULong.write(value.`tsMs`, buf)
            FfiConverterBoolean.write(value.`isLive`, buf)
    }
}



data class MemberSummary (
    var `userId`: kotlin.String, 
    var `displayName`: kotlin.String?, 
    var `avatarUrl`: kotlin.String?, 
    var `isMe`: kotlin.Boolean, 
    var `membership`: kotlin.String
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeMemberSummary: FfiConverterRustBuffer<MemberSummary> {
    override fun read(buf: ByteBuffer): MemberSummary {
        return MemberSummary(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: MemberSummary) = (
            FfiConverterString.allocationSize(value.`userId`) +
            FfiConverterOptionalString.allocationSize(value.`displayName`) +
            FfiConverterOptionalString.allocationSize(value.`avatarUrl`) +
            FfiConverterBoolean.allocationSize(value.`isMe`) +
            FfiConverterString.allocationSize(value.`membership`)
    )

    override fun write(value: MemberSummary, buf: ByteBuffer) {
            FfiConverterString.write(value.`userId`, buf)
            FfiConverterOptionalString.write(value.`displayName`, buf)
            FfiConverterOptionalString.write(value.`avatarUrl`, buf)
            FfiConverterBoolean.write(value.`isMe`, buf)
            FfiConverterString.write(value.`membership`, buf)
    }
}



data class MessageEvent (
    var `itemId`: kotlin.String, 
    var `eventId`: kotlin.String, 
    var `roomId`: kotlin.String, 
    var `sender`: kotlin.String, 
    var `body`: kotlin.String, 
    var `timestampMs`: kotlin.ULong, 
    var `sendState`: SendState?, 
    var `txnId`: kotlin.String?, 
    var `replyToEventId`: kotlin.String?, 
    var `replyToSender`: kotlin.String?, 
    var `replyToBody`: kotlin.String?, 
    var `attachment`: AttachmentInfo?, 
    var `threadRootEventId`: kotlin.String?, 
    var `isEdited`: kotlin.Boolean, 
    var `pollData`: PollData?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeMessageEvent: FfiConverterRustBuffer<MessageEvent> {
    override fun read(buf: ByteBuffer): MessageEvent {
        return MessageEvent(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterULong.read(buf),
            FfiConverterOptionalTypeSendState.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalTypeAttachmentInfo.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterOptionalTypePollData.read(buf),
        )
    }

    override fun allocationSize(value: MessageEvent) = (
            FfiConverterString.allocationSize(value.`itemId`) +
            FfiConverterString.allocationSize(value.`eventId`) +
            FfiConverterString.allocationSize(value.`roomId`) +
            FfiConverterString.allocationSize(value.`sender`) +
            FfiConverterString.allocationSize(value.`body`) +
            FfiConverterULong.allocationSize(value.`timestampMs`) +
            FfiConverterOptionalTypeSendState.allocationSize(value.`sendState`) +
            FfiConverterOptionalString.allocationSize(value.`txnId`) +
            FfiConverterOptionalString.allocationSize(value.`replyToEventId`) +
            FfiConverterOptionalString.allocationSize(value.`replyToSender`) +
            FfiConverterOptionalString.allocationSize(value.`replyToBody`) +
            FfiConverterOptionalTypeAttachmentInfo.allocationSize(value.`attachment`) +
            FfiConverterOptionalString.allocationSize(value.`threadRootEventId`) +
            FfiConverterBoolean.allocationSize(value.`isEdited`) +
            FfiConverterOptionalTypePollData.allocationSize(value.`pollData`)
    )

    override fun write(value: MessageEvent, buf: ByteBuffer) {
            FfiConverterString.write(value.`itemId`, buf)
            FfiConverterString.write(value.`eventId`, buf)
            FfiConverterString.write(value.`roomId`, buf)
            FfiConverterString.write(value.`sender`, buf)
            FfiConverterString.write(value.`body`, buf)
            FfiConverterULong.write(value.`timestampMs`, buf)
            FfiConverterOptionalTypeSendState.write(value.`sendState`, buf)
            FfiConverterOptionalString.write(value.`txnId`, buf)
            FfiConverterOptionalString.write(value.`replyToEventId`, buf)
            FfiConverterOptionalString.write(value.`replyToSender`, buf)
            FfiConverterOptionalString.write(value.`replyToBody`, buf)
            FfiConverterOptionalTypeAttachmentInfo.write(value.`attachment`, buf)
            FfiConverterOptionalString.write(value.`threadRootEventId`, buf)
            FfiConverterBoolean.write(value.`isEdited`, buf)
            FfiConverterOptionalTypePollData.write(value.`pollData`, buf)
    }
}



data class OwnReceipt (
    var `eventId`: kotlin.String?, 
    var `tsMs`: kotlin.ULong?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeOwnReceipt: FfiConverterRustBuffer<OwnReceipt> {
    override fun read(buf: ByteBuffer): OwnReceipt {
        return OwnReceipt(
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalULong.read(buf),
        )
    }

    override fun allocationSize(value: OwnReceipt) = (
            FfiConverterOptionalString.allocationSize(value.`eventId`) +
            FfiConverterOptionalULong.allocationSize(value.`tsMs`)
    )

    override fun write(value: OwnReceipt, buf: ByteBuffer) {
            FfiConverterOptionalString.write(value.`eventId`, buf)
            FfiConverterOptionalULong.write(value.`tsMs`, buf)
    }
}



data class PollData (
    var `question`: kotlin.String, 
    var `kind`: PollKind, 
    var `maxSelections`: kotlin.UInt, 
    var `options`: List<PollOption>, 
    var `totalVotes`: kotlin.UInt, 
    var `isEnded`: kotlin.Boolean
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypePollData: FfiConverterRustBuffer<PollData> {
    override fun read(buf: ByteBuffer): PollData {
        return PollData(
            FfiConverterString.read(buf),
            FfiConverterTypePollKind.read(buf),
            FfiConverterUInt.read(buf),
            FfiConverterSequenceTypePollOption.read(buf),
            FfiConverterUInt.read(buf),
            FfiConverterBoolean.read(buf),
        )
    }

    override fun allocationSize(value: PollData) = (
            FfiConverterString.allocationSize(value.`question`) +
            FfiConverterTypePollKind.allocationSize(value.`kind`) +
            FfiConverterUInt.allocationSize(value.`maxSelections`) +
            FfiConverterSequenceTypePollOption.allocationSize(value.`options`) +
            FfiConverterUInt.allocationSize(value.`totalVotes`) +
            FfiConverterBoolean.allocationSize(value.`isEnded`)
    )

    override fun write(value: PollData, buf: ByteBuffer) {
            FfiConverterString.write(value.`question`, buf)
            FfiConverterTypePollKind.write(value.`kind`, buf)
            FfiConverterUInt.write(value.`maxSelections`, buf)
            FfiConverterSequenceTypePollOption.write(value.`options`, buf)
            FfiConverterUInt.write(value.`totalVotes`, buf)
            FfiConverterBoolean.write(value.`isEnded`, buf)
    }
}



data class PollDefinition (
    /**
     * Question text
     */
    var `question`: kotlin.String, 
    /**
     * Answer labels – IDs will be generated as "a", "b", "c", ...
     */
    var `answers`: List<kotlin.String>, 
    /**
     * Poll kind: disclosed vs. undisclosed
     */
    var `kind`: PollKind, 
    /**
     * Max selections per user (1 = single choice)
     */
    var `maxSelections`: kotlin.UInt
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypePollDefinition: FfiConverterRustBuffer<PollDefinition> {
    override fun read(buf: ByteBuffer): PollDefinition {
        return PollDefinition(
            FfiConverterString.read(buf),
            FfiConverterSequenceString.read(buf),
            FfiConverterTypePollKind.read(buf),
            FfiConverterUInt.read(buf),
        )
    }

    override fun allocationSize(value: PollDefinition) = (
            FfiConverterString.allocationSize(value.`question`) +
            FfiConverterSequenceString.allocationSize(value.`answers`) +
            FfiConverterTypePollKind.allocationSize(value.`kind`) +
            FfiConverterUInt.allocationSize(value.`maxSelections`)
    )

    override fun write(value: PollDefinition, buf: ByteBuffer) {
            FfiConverterString.write(value.`question`, buf)
            FfiConverterSequenceString.write(value.`answers`, buf)
            FfiConverterTypePollKind.write(value.`kind`, buf)
            FfiConverterUInt.write(value.`maxSelections`, buf)
    }
}



data class PollOption (
    var `id`: kotlin.String, 
    var `text`: kotlin.String, 
    var `votes`: kotlin.UInt, 
    var `isSelected`: kotlin.Boolean, 
    var `isWinner`: kotlin.Boolean
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypePollOption: FfiConverterRustBuffer<PollOption> {
    override fun read(buf: ByteBuffer): PollOption {
        return PollOption(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterUInt.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
        )
    }

    override fun allocationSize(value: PollOption) = (
            FfiConverterString.allocationSize(value.`id`) +
            FfiConverterString.allocationSize(value.`text`) +
            FfiConverterUInt.allocationSize(value.`votes`) +
            FfiConverterBoolean.allocationSize(value.`isSelected`) +
            FfiConverterBoolean.allocationSize(value.`isWinner`)
    )

    override fun write(value: PollOption, buf: ByteBuffer) {
            FfiConverterString.write(value.`id`, buf)
            FfiConverterString.write(value.`text`, buf)
            FfiConverterUInt.write(value.`votes`, buf)
            FfiConverterBoolean.write(value.`isSelected`, buf)
            FfiConverterBoolean.write(value.`isWinner`, buf)
    }
}



data class PredecessorRoomInfo (
    var `roomId`: kotlin.String
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypePredecessorRoomInfo: FfiConverterRustBuffer<PredecessorRoomInfo> {
    override fun read(buf: ByteBuffer): PredecessorRoomInfo {
        return PredecessorRoomInfo(
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: PredecessorRoomInfo) = (
            FfiConverterString.allocationSize(value.`roomId`)
    )

    override fun write(value: PredecessorRoomInfo, buf: ByteBuffer) {
            FfiConverterString.write(value.`roomId`, buf)
    }
}



data class PresenceInfo (
    var `presence`: Presence, 
    var `statusMsg`: kotlin.String?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypePresenceInfo: FfiConverterRustBuffer<PresenceInfo> {
    override fun read(buf: ByteBuffer): PresenceInfo {
        return PresenceInfo(
            FfiConverterTypePresence.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: PresenceInfo) = (
            FfiConverterTypePresence.allocationSize(value.`presence`) +
            FfiConverterOptionalString.allocationSize(value.`statusMsg`)
    )

    override fun write(value: PresenceInfo, buf: ByteBuffer) {
            FfiConverterTypePresence.write(value.`presence`, buf)
            FfiConverterOptionalString.write(value.`statusMsg`, buf)
    }
}



data class PublicRoom (
    var `roomId`: kotlin.String, 
    var `name`: kotlin.String?, 
    var `topic`: kotlin.String?, 
    var `alias`: kotlin.String?, 
    var `avatarUrl`: kotlin.String?, 
    var `memberCount`: kotlin.ULong, 
    var `worldReadable`: kotlin.Boolean, 
    var `guestCanJoin`: kotlin.Boolean
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypePublicRoom: FfiConverterRustBuffer<PublicRoom> {
    override fun read(buf: ByteBuffer): PublicRoom {
        return PublicRoom(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterULong.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
        )
    }

    override fun allocationSize(value: PublicRoom) = (
            FfiConverterString.allocationSize(value.`roomId`) +
            FfiConverterOptionalString.allocationSize(value.`name`) +
            FfiConverterOptionalString.allocationSize(value.`topic`) +
            FfiConverterOptionalString.allocationSize(value.`alias`) +
            FfiConverterOptionalString.allocationSize(value.`avatarUrl`) +
            FfiConverterULong.allocationSize(value.`memberCount`) +
            FfiConverterBoolean.allocationSize(value.`worldReadable`) +
            FfiConverterBoolean.allocationSize(value.`guestCanJoin`)
    )

    override fun write(value: PublicRoom, buf: ByteBuffer) {
            FfiConverterString.write(value.`roomId`, buf)
            FfiConverterOptionalString.write(value.`name`, buf)
            FfiConverterOptionalString.write(value.`topic`, buf)
            FfiConverterOptionalString.write(value.`alias`, buf)
            FfiConverterOptionalString.write(value.`avatarUrl`, buf)
            FfiConverterULong.write(value.`memberCount`, buf)
            FfiConverterBoolean.write(value.`worldReadable`, buf)
            FfiConverterBoolean.write(value.`guestCanJoin`, buf)
    }
}



data class PublicRoomsPage (
    var `rooms`: List<PublicRoom>, 
    var `nextBatch`: kotlin.String?, 
    var `prevBatch`: kotlin.String?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypePublicRoomsPage: FfiConverterRustBuffer<PublicRoomsPage> {
    override fun read(buf: ByteBuffer): PublicRoomsPage {
        return PublicRoomsPage(
            FfiConverterSequenceTypePublicRoom.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: PublicRoomsPage) = (
            FfiConverterSequenceTypePublicRoom.allocationSize(value.`rooms`) +
            FfiConverterOptionalString.allocationSize(value.`nextBatch`) +
            FfiConverterOptionalString.allocationSize(value.`prevBatch`)
    )

    override fun write(value: PublicRoomsPage, buf: ByteBuffer) {
            FfiConverterSequenceTypePublicRoom.write(value.`rooms`, buf)
            FfiConverterOptionalString.write(value.`nextBatch`, buf)
            FfiConverterOptionalString.write(value.`prevBatch`, buf)
    }
}



data class ReactionSummary (
    var `key`: kotlin.String, 
    var `count`: kotlin.UInt, 
    var `me`: kotlin.Boolean
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeReactionSummary: FfiConverterRustBuffer<ReactionSummary> {
    override fun read(buf: ByteBuffer): ReactionSummary {
        return ReactionSummary(
            FfiConverterString.read(buf),
            FfiConverterUInt.read(buf),
            FfiConverterBoolean.read(buf),
        )
    }

    override fun allocationSize(value: ReactionSummary) = (
            FfiConverterString.allocationSize(value.`key`) +
            FfiConverterUInt.allocationSize(value.`count`) +
            FfiConverterBoolean.allocationSize(value.`me`)
    )

    override fun write(value: ReactionSummary, buf: ByteBuffer) {
            FfiConverterString.write(value.`key`, buf)
            FfiConverterUInt.write(value.`count`, buf)
            FfiConverterBoolean.write(value.`me`, buf)
    }
}



data class RenderedNotification (
    var `roomId`: kotlin.String, 
    var `eventId`: kotlin.String, 
    var `roomName`: kotlin.String, 
    var `sender`: kotlin.String, 
    var `senderUserId`: kotlin.String, 
    var `body`: kotlin.String, 
    var `isNoisy`: kotlin.Boolean, 
    var `hasMention`: kotlin.Boolean, 
    var `tsMs`: kotlin.ULong
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeRenderedNotification: FfiConverterRustBuffer<RenderedNotification> {
    override fun read(buf: ByteBuffer): RenderedNotification {
        return RenderedNotification(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterULong.read(buf),
        )
    }

    override fun allocationSize(value: RenderedNotification) = (
            FfiConverterString.allocationSize(value.`roomId`) +
            FfiConverterString.allocationSize(value.`eventId`) +
            FfiConverterString.allocationSize(value.`roomName`) +
            FfiConverterString.allocationSize(value.`sender`) +
            FfiConverterString.allocationSize(value.`senderUserId`) +
            FfiConverterString.allocationSize(value.`body`) +
            FfiConverterBoolean.allocationSize(value.`isNoisy`) +
            FfiConverterBoolean.allocationSize(value.`hasMention`) +
            FfiConverterULong.allocationSize(value.`tsMs`)
    )

    override fun write(value: RenderedNotification, buf: ByteBuffer) {
            FfiConverterString.write(value.`roomId`, buf)
            FfiConverterString.write(value.`eventId`, buf)
            FfiConverterString.write(value.`roomName`, buf)
            FfiConverterString.write(value.`sender`, buf)
            FfiConverterString.write(value.`senderUserId`, buf)
            FfiConverterString.write(value.`body`, buf)
            FfiConverterBoolean.write(value.`isNoisy`, buf)
            FfiConverterBoolean.write(value.`hasMention`, buf)
            FfiConverterULong.write(value.`tsMs`, buf)
    }
}



data class RoomListEntry (
    var `roomId`: kotlin.String, 
    var `name`: kotlin.String, 
    var `lastTs`: kotlin.ULong, 
    var `notifications`: kotlin.ULong, 
    var `messages`: kotlin.ULong, 
    var `mentions`: kotlin.ULong, 
    var `markedUnread`: kotlin.Boolean, 
    var `isFavourite`: kotlin.Boolean, 
    var `isLowPriority`: kotlin.Boolean, 
    var `avatarUrl`: kotlin.String?, 
    var `isDm`: kotlin.Boolean, 
    var `isEncrypted`: kotlin.Boolean, 
    var `memberCount`: kotlin.UInt, 
    var `topic`: kotlin.String?, 
    var `latestEvent`: LatestRoomEvent?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeRoomListEntry: FfiConverterRustBuffer<RoomListEntry> {
    override fun read(buf: ByteBuffer): RoomListEntry {
        return RoomListEntry(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterULong.read(buf),
            FfiConverterULong.read(buf),
            FfiConverterULong.read(buf),
            FfiConverterULong.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterUInt.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalTypeLatestRoomEvent.read(buf),
        )
    }

    override fun allocationSize(value: RoomListEntry) = (
            FfiConverterString.allocationSize(value.`roomId`) +
            FfiConverterString.allocationSize(value.`name`) +
            FfiConverterULong.allocationSize(value.`lastTs`) +
            FfiConverterULong.allocationSize(value.`notifications`) +
            FfiConverterULong.allocationSize(value.`messages`) +
            FfiConverterULong.allocationSize(value.`mentions`) +
            FfiConverterBoolean.allocationSize(value.`markedUnread`) +
            FfiConverterBoolean.allocationSize(value.`isFavourite`) +
            FfiConverterBoolean.allocationSize(value.`isLowPriority`) +
            FfiConverterOptionalString.allocationSize(value.`avatarUrl`) +
            FfiConverterBoolean.allocationSize(value.`isDm`) +
            FfiConverterBoolean.allocationSize(value.`isEncrypted`) +
            FfiConverterUInt.allocationSize(value.`memberCount`) +
            FfiConverterOptionalString.allocationSize(value.`topic`) +
            FfiConverterOptionalTypeLatestRoomEvent.allocationSize(value.`latestEvent`)
    )

    override fun write(value: RoomListEntry, buf: ByteBuffer) {
            FfiConverterString.write(value.`roomId`, buf)
            FfiConverterString.write(value.`name`, buf)
            FfiConverterULong.write(value.`lastTs`, buf)
            FfiConverterULong.write(value.`notifications`, buf)
            FfiConverterULong.write(value.`messages`, buf)
            FfiConverterULong.write(value.`mentions`, buf)
            FfiConverterBoolean.write(value.`markedUnread`, buf)
            FfiConverterBoolean.write(value.`isFavourite`, buf)
            FfiConverterBoolean.write(value.`isLowPriority`, buf)
            FfiConverterOptionalString.write(value.`avatarUrl`, buf)
            FfiConverterBoolean.write(value.`isDm`, buf)
            FfiConverterBoolean.write(value.`isEncrypted`, buf)
            FfiConverterUInt.write(value.`memberCount`, buf)
            FfiConverterOptionalString.write(value.`topic`, buf)
            FfiConverterOptionalTypeLatestRoomEvent.write(value.`latestEvent`, buf)
    }
}



data class RoomProfile (
    var `roomId`: kotlin.String, 
    var `name`: kotlin.String, 
    var `topic`: kotlin.String?, 
    var `memberCount`: kotlin.ULong, 
    var `isEncrypted`: kotlin.Boolean, 
    var `isDm`: kotlin.Boolean, 
    var `avatarUrl`: kotlin.String?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeRoomProfile: FfiConverterRustBuffer<RoomProfile> {
    override fun read(buf: ByteBuffer): RoomProfile {
        return RoomProfile(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterULong.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: RoomProfile) = (
            FfiConverterString.allocationSize(value.`roomId`) +
            FfiConverterString.allocationSize(value.`name`) +
            FfiConverterOptionalString.allocationSize(value.`topic`) +
            FfiConverterULong.allocationSize(value.`memberCount`) +
            FfiConverterBoolean.allocationSize(value.`isEncrypted`) +
            FfiConverterBoolean.allocationSize(value.`isDm`) +
            FfiConverterOptionalString.allocationSize(value.`avatarUrl`)
    )

    override fun write(value: RoomProfile, buf: ByteBuffer) {
            FfiConverterString.write(value.`roomId`, buf)
            FfiConverterString.write(value.`name`, buf)
            FfiConverterOptionalString.write(value.`topic`, buf)
            FfiConverterULong.write(value.`memberCount`, buf)
            FfiConverterBoolean.write(value.`isEncrypted`, buf)
            FfiConverterBoolean.write(value.`isDm`, buf)
            FfiConverterOptionalString.write(value.`avatarUrl`, buf)
    }
}



data class RoomSummary (
    var `id`: kotlin.String, 
    var `name`: kotlin.String
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeRoomSummary: FfiConverterRustBuffer<RoomSummary> {
    override fun read(buf: ByteBuffer): RoomSummary {
        return RoomSummary(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: RoomSummary) = (
            FfiConverterString.allocationSize(value.`id`) +
            FfiConverterString.allocationSize(value.`name`)
    )

    override fun write(value: RoomSummary, buf: ByteBuffer) {
            FfiConverterString.write(value.`id`, buf)
            FfiConverterString.write(value.`name`, buf)
    }
}



data class RoomTags (
    var `isFavourite`: kotlin.Boolean, 
    var `isLowPriority`: kotlin.Boolean
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeRoomTags: FfiConverterRustBuffer<RoomTags> {
    override fun read(buf: ByteBuffer): RoomTags {
        return RoomTags(
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
        )
    }

    override fun allocationSize(value: RoomTags) = (
            FfiConverterBoolean.allocationSize(value.`isFavourite`) +
            FfiConverterBoolean.allocationSize(value.`isLowPriority`)
    )

    override fun write(value: RoomTags, buf: ByteBuffer) {
            FfiConverterBoolean.write(value.`isFavourite`, buf)
            FfiConverterBoolean.write(value.`isLowPriority`, buf)
    }
}



data class RoomUpgradeLinks (
    var `isTombstoned`: kotlin.Boolean, 
    var `successor`: SuccessorRoomInfo?, 
    var `predecessor`: PredecessorRoomInfo?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeRoomUpgradeLinks: FfiConverterRustBuffer<RoomUpgradeLinks> {
    override fun read(buf: ByteBuffer): RoomUpgradeLinks {
        return RoomUpgradeLinks(
            FfiConverterBoolean.read(buf),
            FfiConverterOptionalTypeSuccessorRoomInfo.read(buf),
            FfiConverterOptionalTypePredecessorRoomInfo.read(buf),
        )
    }

    override fun allocationSize(value: RoomUpgradeLinks) = (
            FfiConverterBoolean.allocationSize(value.`isTombstoned`) +
            FfiConverterOptionalTypeSuccessorRoomInfo.allocationSize(value.`successor`) +
            FfiConverterOptionalTypePredecessorRoomInfo.allocationSize(value.`predecessor`)
    )

    override fun write(value: RoomUpgradeLinks, buf: ByteBuffer) {
            FfiConverterBoolean.write(value.`isTombstoned`, buf)
            FfiConverterOptionalTypeSuccessorRoomInfo.write(value.`successor`, buf)
            FfiConverterOptionalTypePredecessorRoomInfo.write(value.`predecessor`, buf)
    }
}



data class SasEmojis (
    var `flowId`: kotlin.String, 
    var `otherUser`: kotlin.String, 
    var `otherDevice`: kotlin.String, 
    var `emojis`: List<kotlin.String>
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeSasEmojis: FfiConverterRustBuffer<SasEmojis> {
    override fun read(buf: ByteBuffer): SasEmojis {
        return SasEmojis(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterSequenceString.read(buf),
        )
    }

    override fun allocationSize(value: SasEmojis) = (
            FfiConverterString.allocationSize(value.`flowId`) +
            FfiConverterString.allocationSize(value.`otherUser`) +
            FfiConverterString.allocationSize(value.`otherDevice`) +
            FfiConverterSequenceString.allocationSize(value.`emojis`)
    )

    override fun write(value: SasEmojis, buf: ByteBuffer) {
            FfiConverterString.write(value.`flowId`, buf)
            FfiConverterString.write(value.`otherUser`, buf)
            FfiConverterString.write(value.`otherDevice`, buf)
            FfiConverterSequenceString.write(value.`emojis`, buf)
    }
}



data class SearchHit (
    var `roomId`: kotlin.String, 
    var `eventId`: kotlin.String, 
    var `sender`: kotlin.String, 
    var `body`: kotlin.String, 
    var `timestampMs`: kotlin.ULong
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeSearchHit: FfiConverterRustBuffer<SearchHit> {
    override fun read(buf: ByteBuffer): SearchHit {
        return SearchHit(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterULong.read(buf),
        )
    }

    override fun allocationSize(value: SearchHit) = (
            FfiConverterString.allocationSize(value.`roomId`) +
            FfiConverterString.allocationSize(value.`eventId`) +
            FfiConverterString.allocationSize(value.`sender`) +
            FfiConverterString.allocationSize(value.`body`) +
            FfiConverterULong.allocationSize(value.`timestampMs`)
    )

    override fun write(value: SearchHit, buf: ByteBuffer) {
            FfiConverterString.write(value.`roomId`, buf)
            FfiConverterString.write(value.`eventId`, buf)
            FfiConverterString.write(value.`sender`, buf)
            FfiConverterString.write(value.`body`, buf)
            FfiConverterULong.write(value.`timestampMs`, buf)
    }
}



data class SearchPage (
    var `hits`: List<SearchHit>, 
    /**
     * Pagination offset for the *next* page. `None` means “no more results”.
     */
    var `nextOffset`: kotlin.UInt?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeSearchPage: FfiConverterRustBuffer<SearchPage> {
    override fun read(buf: ByteBuffer): SearchPage {
        return SearchPage(
            FfiConverterSequenceTypeSearchHit.read(buf),
            FfiConverterOptionalUInt.read(buf),
        )
    }

    override fun allocationSize(value: SearchPage) = (
            FfiConverterSequenceTypeSearchHit.allocationSize(value.`hits`) +
            FfiConverterOptionalUInt.allocationSize(value.`nextOffset`)
    )

    override fun write(value: SearchPage, buf: ByteBuffer) {
            FfiConverterSequenceTypeSearchHit.write(value.`hits`, buf)
            FfiConverterOptionalUInt.write(value.`nextOffset`, buf)
    }
}



data class SeenByEntry (
    var `userId`: kotlin.String, 
    var `displayName`: kotlin.String?, 
    var `avatarUrl`: kotlin.String?, 
    var `tsMs`: kotlin.ULong?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeSeenByEntry: FfiConverterRustBuffer<SeenByEntry> {
    override fun read(buf: ByteBuffer): SeenByEntry {
        return SeenByEntry(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalULong.read(buf),
        )
    }

    override fun allocationSize(value: SeenByEntry) = (
            FfiConverterString.allocationSize(value.`userId`) +
            FfiConverterOptionalString.allocationSize(value.`displayName`) +
            FfiConverterOptionalString.allocationSize(value.`avatarUrl`) +
            FfiConverterOptionalULong.allocationSize(value.`tsMs`)
    )

    override fun write(value: SeenByEntry, buf: ByteBuffer) {
            FfiConverterString.write(value.`userId`, buf)
            FfiConverterOptionalString.write(value.`displayName`, buf)
            FfiConverterOptionalString.write(value.`avatarUrl`, buf)
            FfiConverterOptionalULong.write(value.`tsMs`, buf)
    }
}



data class SendUpdate (
    var `roomId`: kotlin.String, 
    var `txnId`: kotlin.String, 
    var `attempts`: kotlin.UInt, 
    var `state`: SendState, 
    var `eventId`: kotlin.String?, 
    var `error`: kotlin.String?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeSendUpdate: FfiConverterRustBuffer<SendUpdate> {
    override fun read(buf: ByteBuffer): SendUpdate {
        return SendUpdate(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterUInt.read(buf),
            FfiConverterTypeSendState.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: SendUpdate) = (
            FfiConverterString.allocationSize(value.`roomId`) +
            FfiConverterString.allocationSize(value.`txnId`) +
            FfiConverterUInt.allocationSize(value.`attempts`) +
            FfiConverterTypeSendState.allocationSize(value.`state`) +
            FfiConverterOptionalString.allocationSize(value.`eventId`) +
            FfiConverterOptionalString.allocationSize(value.`error`)
    )

    override fun write(value: SendUpdate, buf: ByteBuffer) {
            FfiConverterString.write(value.`roomId`, buf)
            FfiConverterString.write(value.`txnId`, buf)
            FfiConverterUInt.write(value.`attempts`, buf)
            FfiConverterTypeSendState.write(value.`state`, buf)
            FfiConverterOptionalString.write(value.`eventId`, buf)
            FfiConverterOptionalString.write(value.`error`, buf)
    }
}



data class SpaceChildInfo (
    var `roomId`: kotlin.String, 
    var `name`: kotlin.String?, 
    var `topic`: kotlin.String?, 
    var `alias`: kotlin.String?, 
    var `avatarUrl`: kotlin.String?, 
    var `isSpace`: kotlin.Boolean, 
    var `memberCount`: kotlin.ULong, 
    var `worldReadable`: kotlin.Boolean, 
    var `guestCanJoin`: kotlin.Boolean, 
    var `suggested`: kotlin.Boolean
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeSpaceChildInfo: FfiConverterRustBuffer<SpaceChildInfo> {
    override fun read(buf: ByteBuffer): SpaceChildInfo {
        return SpaceChildInfo(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterULong.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
        )
    }

    override fun allocationSize(value: SpaceChildInfo) = (
            FfiConverterString.allocationSize(value.`roomId`) +
            FfiConverterOptionalString.allocationSize(value.`name`) +
            FfiConverterOptionalString.allocationSize(value.`topic`) +
            FfiConverterOptionalString.allocationSize(value.`alias`) +
            FfiConverterOptionalString.allocationSize(value.`avatarUrl`) +
            FfiConverterBoolean.allocationSize(value.`isSpace`) +
            FfiConverterULong.allocationSize(value.`memberCount`) +
            FfiConverterBoolean.allocationSize(value.`worldReadable`) +
            FfiConverterBoolean.allocationSize(value.`guestCanJoin`) +
            FfiConverterBoolean.allocationSize(value.`suggested`)
    )

    override fun write(value: SpaceChildInfo, buf: ByteBuffer) {
            FfiConverterString.write(value.`roomId`, buf)
            FfiConverterOptionalString.write(value.`name`, buf)
            FfiConverterOptionalString.write(value.`topic`, buf)
            FfiConverterOptionalString.write(value.`alias`, buf)
            FfiConverterOptionalString.write(value.`avatarUrl`, buf)
            FfiConverterBoolean.write(value.`isSpace`, buf)
            FfiConverterULong.write(value.`memberCount`, buf)
            FfiConverterBoolean.write(value.`worldReadable`, buf)
            FfiConverterBoolean.write(value.`guestCanJoin`, buf)
            FfiConverterBoolean.write(value.`suggested`, buf)
    }
}



data class SpaceHierarchyPage (
    var `children`: List<SpaceChildInfo>, 
    var `nextBatch`: kotlin.String?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeSpaceHierarchyPage: FfiConverterRustBuffer<SpaceHierarchyPage> {
    override fun read(buf: ByteBuffer): SpaceHierarchyPage {
        return SpaceHierarchyPage(
            FfiConverterSequenceTypeSpaceChildInfo.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: SpaceHierarchyPage) = (
            FfiConverterSequenceTypeSpaceChildInfo.allocationSize(value.`children`) +
            FfiConverterOptionalString.allocationSize(value.`nextBatch`)
    )

    override fun write(value: SpaceHierarchyPage, buf: ByteBuffer) {
            FfiConverterSequenceTypeSpaceChildInfo.write(value.`children`, buf)
            FfiConverterOptionalString.write(value.`nextBatch`, buf)
    }
}



data class SpaceInfo (
    var `roomId`: kotlin.String, 
    var `name`: kotlin.String, 
    var `topic`: kotlin.String?, 
    var `memberCount`: kotlin.ULong, 
    var `isEncrypted`: kotlin.Boolean, 
    var `isPublic`: kotlin.Boolean
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeSpaceInfo: FfiConverterRustBuffer<SpaceInfo> {
    override fun read(buf: ByteBuffer): SpaceInfo {
        return SpaceInfo(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterULong.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
        )
    }

    override fun allocationSize(value: SpaceInfo) = (
            FfiConverterString.allocationSize(value.`roomId`) +
            FfiConverterString.allocationSize(value.`name`) +
            FfiConverterOptionalString.allocationSize(value.`topic`) +
            FfiConverterULong.allocationSize(value.`memberCount`) +
            FfiConverterBoolean.allocationSize(value.`isEncrypted`) +
            FfiConverterBoolean.allocationSize(value.`isPublic`)
    )

    override fun write(value: SpaceInfo, buf: ByteBuffer) {
            FfiConverterString.write(value.`roomId`, buf)
            FfiConverterString.write(value.`name`, buf)
            FfiConverterOptionalString.write(value.`topic`, buf)
            FfiConverterULong.write(value.`memberCount`, buf)
            FfiConverterBoolean.write(value.`isEncrypted`, buf)
            FfiConverterBoolean.write(value.`isPublic`, buf)
    }
}



data class SuccessorRoomInfo (
    var `roomId`: kotlin.String, 
    var `reason`: kotlin.String?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeSuccessorRoomInfo: FfiConverterRustBuffer<SuccessorRoomInfo> {
    override fun read(buf: ByteBuffer): SuccessorRoomInfo {
        return SuccessorRoomInfo(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: SuccessorRoomInfo) = (
            FfiConverterString.allocationSize(value.`roomId`) +
            FfiConverterOptionalString.allocationSize(value.`reason`)
    )

    override fun write(value: SuccessorRoomInfo, buf: ByteBuffer) {
            FfiConverterString.write(value.`roomId`, buf)
            FfiConverterOptionalString.write(value.`reason`, buf)
    }
}



data class SyncStatus (
    var `phase`: SyncPhase, 
    var `message`: kotlin.String?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeSyncStatus: FfiConverterRustBuffer<SyncStatus> {
    override fun read(buf: ByteBuffer): SyncStatus {
        return SyncStatus(
            FfiConverterTypeSyncPhase.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: SyncStatus) = (
            FfiConverterTypeSyncPhase.allocationSize(value.`phase`) +
            FfiConverterOptionalString.allocationSize(value.`message`)
    )

    override fun write(value: SyncStatus, buf: ByteBuffer) {
            FfiConverterTypeSyncPhase.write(value.`phase`, buf)
            FfiConverterOptionalString.write(value.`message`, buf)
    }
}



data class ThreadPage (
    var `rootEventId`: kotlin.String, 
    var `roomId`: kotlin.String, 
    var `messages`: List<MessageEvent>, 
    var `nextBatch`: kotlin.String?, 
    var `prevBatch`: kotlin.String?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeThreadPage: FfiConverterRustBuffer<ThreadPage> {
    override fun read(buf: ByteBuffer): ThreadPage {
        return ThreadPage(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterSequenceTypeMessageEvent.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: ThreadPage) = (
            FfiConverterString.allocationSize(value.`rootEventId`) +
            FfiConverterString.allocationSize(value.`roomId`) +
            FfiConverterSequenceTypeMessageEvent.allocationSize(value.`messages`) +
            FfiConverterOptionalString.allocationSize(value.`nextBatch`) +
            FfiConverterOptionalString.allocationSize(value.`prevBatch`)
    )

    override fun write(value: ThreadPage, buf: ByteBuffer) {
            FfiConverterString.write(value.`rootEventId`, buf)
            FfiConverterString.write(value.`roomId`, buf)
            FfiConverterSequenceTypeMessageEvent.write(value.`messages`, buf)
            FfiConverterOptionalString.write(value.`nextBatch`, buf)
            FfiConverterOptionalString.write(value.`prevBatch`, buf)
    }
}



data class ThreadSummary (
    var `rootEventId`: kotlin.String, 
    var `roomId`: kotlin.String, 
    var `count`: kotlin.ULong, 
    var `latestTsMs`: kotlin.ULong?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeThreadSummary: FfiConverterRustBuffer<ThreadSummary> {
    override fun read(buf: ByteBuffer): ThreadSummary {
        return ThreadSummary(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterULong.read(buf),
            FfiConverterOptionalULong.read(buf),
        )
    }

    override fun allocationSize(value: ThreadSummary) = (
            FfiConverterString.allocationSize(value.`rootEventId`) +
            FfiConverterString.allocationSize(value.`roomId`) +
            FfiConverterULong.allocationSize(value.`count`) +
            FfiConverterOptionalULong.allocationSize(value.`latestTsMs`)
    )

    override fun write(value: ThreadSummary, buf: ByteBuffer) {
            FfiConverterString.write(value.`rootEventId`, buf)
            FfiConverterString.write(value.`roomId`, buf)
            FfiConverterULong.write(value.`count`, buf)
            FfiConverterOptionalULong.write(value.`latestTsMs`, buf)
    }
}



data class UnreadStats (
    var `messages`: kotlin.ULong, 
    var `notifications`: kotlin.ULong, 
    var `mentions`: kotlin.ULong
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeUnreadStats: FfiConverterRustBuffer<UnreadStats> {
    override fun read(buf: ByteBuffer): UnreadStats {
        return UnreadStats(
            FfiConverterULong.read(buf),
            FfiConverterULong.read(buf),
            FfiConverterULong.read(buf),
        )
    }

    override fun allocationSize(value: UnreadStats) = (
            FfiConverterULong.allocationSize(value.`messages`) +
            FfiConverterULong.allocationSize(value.`notifications`) +
            FfiConverterULong.allocationSize(value.`mentions`)
    )

    override fun write(value: UnreadStats, buf: ByteBuffer) {
            FfiConverterULong.write(value.`messages`, buf)
            FfiConverterULong.write(value.`notifications`, buf)
            FfiConverterULong.write(value.`mentions`, buf)
    }
}




enum class AttachmentKind {
    
    IMAGE,
    VIDEO,
    FILE;
    companion object
}


/**
 * @suppress
 */
public object FfiConverterTypeAttachmentKind: FfiConverterRustBuffer<AttachmentKind> {
    override fun read(buf: ByteBuffer) = try {
        AttachmentKind.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: AttachmentKind) = 4UL

    override fun write(value: AttachmentKind, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}





sealed class ConnectionState {
    
    object Disconnected : ConnectionState()
    
    
    object Connecting : ConnectionState()
    
    
    object Connected : ConnectionState()
    
    
    object Syncing : ConnectionState()
    
    
    data class Reconnecting(
        val `attempt`: kotlin.UInt, 
        val `nextRetrySecs`: kotlin.UInt) : ConnectionState() {
        companion object
    }
    

    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeConnectionState : FfiConverterRustBuffer<ConnectionState>{
    override fun read(buf: ByteBuffer): ConnectionState {
        return when(buf.getInt()) {
            1 -> ConnectionState.Disconnected
            2 -> ConnectionState.Connecting
            3 -> ConnectionState.Connected
            4 -> ConnectionState.Syncing
            5 -> ConnectionState.Reconnecting(
                FfiConverterUInt.read(buf),
                FfiConverterUInt.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: ConnectionState) = when(value) {
        is ConnectionState.Disconnected -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
            )
        }
        is ConnectionState.Connecting -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
            )
        }
        is ConnectionState.Connected -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
            )
        }
        is ConnectionState.Syncing -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
            )
        }
        is ConnectionState.Reconnecting -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
                + FfiConverterUInt.allocationSize(value.`attempt`)
                + FfiConverterUInt.allocationSize(value.`nextRetrySecs`)
            )
        }
    }

    override fun write(value: ConnectionState, buf: ByteBuffer) {
        when(value) {
            is ConnectionState.Disconnected -> {
                buf.putInt(1)
                Unit
            }
            is ConnectionState.Connecting -> {
                buf.putInt(2)
                Unit
            }
            is ConnectionState.Connected -> {
                buf.putInt(3)
                Unit
            }
            is ConnectionState.Syncing -> {
                buf.putInt(4)
                Unit
            }
            is ConnectionState.Reconnecting -> {
                buf.putInt(5)
                FfiConverterUInt.write(value.`attempt`, buf)
                FfiConverterUInt.write(value.`nextRetrySecs`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






enum class ElementCallIntent {
    
    /**
     * Start a new call in this room.
     */
    START_CALL,
    /**
     * Join an existing call in this room.
     */
    JOIN_EXISTING;
    companion object
}


/**
 * @suppress
 */
public object FfiConverterTypeElementCallIntent: FfiConverterRustBuffer<ElementCallIntent> {
    override fun read(buf: ByteBuffer) = try {
        ElementCallIntent.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: ElementCallIntent) = 4UL

    override fun write(value: ElementCallIntent, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}







sealed class FfiException: kotlin.Exception() {
    
    class Msg(
        
        val v1: kotlin.String
        ) : FfiException() {
        override val message
            get() = "v1=${ v1 }"
    }
    

    companion object ErrorHandler : UniffiRustCallStatusErrorHandler<FfiException> {
        override fun lift(error_buf: RustBuffer.ByValue): FfiException = FfiConverterTypeFfiError.lift(error_buf)
    }

    
}

/**
 * @suppress
 */
public object FfiConverterTypeFfiError : FfiConverterRustBuffer<FfiException> {
    override fun read(buf: ByteBuffer): FfiException {
        

        return when(buf.getInt()) {
            1 -> FfiException.Msg(
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid error enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: FfiException): ULong {
        return when(value) {
            is FfiException.Msg -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4UL
                + FfiConverterString.allocationSize(value.v1)
            )
        }
    }

    override fun write(value: FfiException, buf: ByteBuffer) {
        when(value) {
            is FfiException.Msg -> {
                buf.putInt(1)
                FfiConverterString.write(value.v1, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }

}




enum class FfiRoomNotificationMode {
    
    ALL_MESSAGES,
    MENTIONS_AND_KEYWORDS_ONLY,
    MUTE;
    companion object
}


/**
 * @suppress
 */
public object FfiConverterTypeFfiRoomNotificationMode: FfiConverterRustBuffer<FfiRoomNotificationMode> {
    override fun read(buf: ByteBuffer) = try {
        FfiRoomNotificationMode.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: FfiRoomNotificationMode) = 4UL

    override fun write(value: FfiRoomNotificationMode, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class PollKind {
    
    DISCLOSED,
    UNDISCLOSED;
    companion object
}


/**
 * @suppress
 */
public object FfiConverterTypePollKind: FfiConverterRustBuffer<PollKind> {
    override fun read(buf: ByteBuffer) = try {
        PollKind.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: PollKind) = 4UL

    override fun write(value: PollKind, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class Presence {
    
    ONLINE,
    OFFLINE,
    UNAVAILABLE;
    companion object
}


/**
 * @suppress
 */
public object FfiConverterTypePresence: FfiConverterRustBuffer<Presence> {
    override fun read(buf: ByteBuffer) = try {
        Presence.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: Presence) = 4UL

    override fun write(value: Presence, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class RoomDirectoryVisibility {
    
    PUBLIC,
    PRIVATE;
    companion object
}


/**
 * @suppress
 */
public object FfiConverterTypeRoomDirectoryVisibility: FfiConverterRustBuffer<RoomDirectoryVisibility> {
    override fun read(buf: ByteBuffer) = try {
        RoomDirectoryVisibility.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: RoomDirectoryVisibility) = 4UL

    override fun write(value: RoomDirectoryVisibility, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class RoomHistoryVisibility {
    
    INVITED,
    JOINED,
    SHARED,
    WORLD_READABLE;
    companion object
}


/**
 * @suppress
 */
public object FfiConverterTypeRoomHistoryVisibility: FfiConverterRustBuffer<RoomHistoryVisibility> {
    override fun read(buf: ByteBuffer) = try {
        RoomHistoryVisibility.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: RoomHistoryVisibility) = 4UL

    override fun write(value: RoomHistoryVisibility, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class RoomJoinRule {
    
    PUBLIC,
    INVITE,
    KNOCK,
    RESTRICTED,
    KNOCK_RESTRICTED;
    companion object
}


/**
 * @suppress
 */
public object FfiConverterTypeRoomJoinRule: FfiConverterRustBuffer<RoomJoinRule> {
    override fun read(buf: ByteBuffer) = try {
        RoomJoinRule.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: RoomJoinRule) = 4UL

    override fun write(value: RoomJoinRule, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class SasPhase {
    
    REQUESTED,
    READY,
    EMOJIS,
    CONFIRMED,
    CANCELLED,
    FAILED,
    DONE;
    companion object
}


/**
 * @suppress
 */
public object FfiConverterTypeSasPhase: FfiConverterRustBuffer<SasPhase> {
    override fun read(buf: ByteBuffer) = try {
        SasPhase.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: SasPhase) = 4UL

    override fun write(value: SasPhase, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class SendState {
    
    ENQUEUED,
    SENDING,
    SENT,
    RETRYING,
    FAILED;
    companion object
}


/**
 * @suppress
 */
public object FfiConverterTypeSendState: FfiConverterRustBuffer<SendState> {
    override fun read(buf: ByteBuffer) = try {
        SendState.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: SendState) = 4UL

    override fun write(value: SendState, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class SyncPhase {
    
    IDLE,
    RUNNING,
    BACKING_OFF,
    ERROR;
    companion object
}


/**
 * @suppress
 */
public object FfiConverterTypeSyncPhase: FfiConverterRustBuffer<SyncPhase> {
    override fun read(buf: ByteBuffer) = try {
        SyncPhase.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: SyncPhase) = 4UL

    override fun write(value: SyncPhase, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}





sealed class TimelineDiffKind {
    
    data class Append(
        val `values`: List<MessageEvent>) : TimelineDiffKind() {
        companion object
    }
    
    data class PushBack(
        val `value`: MessageEvent) : TimelineDiffKind() {
        companion object
    }
    
    data class PushFront(
        val `value`: MessageEvent) : TimelineDiffKind() {
        companion object
    }
    
    object PopBack : TimelineDiffKind()
    
    
    object PopFront : TimelineDiffKind()
    
    
    data class Truncate(
        val `length`: kotlin.UInt) : TimelineDiffKind() {
        companion object
    }
    
    object Clear : TimelineDiffKind()
    
    
    data class Reset(
        val `values`: List<MessageEvent>) : TimelineDiffKind() {
        companion object
    }
    
    data class UpdateByItemId(
        val `itemId`: kotlin.String, 
        val `value`: MessageEvent) : TimelineDiffKind() {
        companion object
    }
    
    data class RemoveByItemId(
        val `itemId`: kotlin.String) : TimelineDiffKind() {
        companion object
    }
    
    data class UpsertByItemId(
        val `itemId`: kotlin.String, 
        val `value`: MessageEvent) : TimelineDiffKind() {
        companion object
    }
    

    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeTimelineDiffKind : FfiConverterRustBuffer<TimelineDiffKind>{
    override fun read(buf: ByteBuffer): TimelineDiffKind {
        return when(buf.getInt()) {
            1 -> TimelineDiffKind.Append(
                FfiConverterSequenceTypeMessageEvent.read(buf),
                )
            2 -> TimelineDiffKind.PushBack(
                FfiConverterTypeMessageEvent.read(buf),
                )
            3 -> TimelineDiffKind.PushFront(
                FfiConverterTypeMessageEvent.read(buf),
                )
            4 -> TimelineDiffKind.PopBack
            5 -> TimelineDiffKind.PopFront
            6 -> TimelineDiffKind.Truncate(
                FfiConverterUInt.read(buf),
                )
            7 -> TimelineDiffKind.Clear
            8 -> TimelineDiffKind.Reset(
                FfiConverterSequenceTypeMessageEvent.read(buf),
                )
            9 -> TimelineDiffKind.UpdateByItemId(
                FfiConverterString.read(buf),
                FfiConverterTypeMessageEvent.read(buf),
                )
            10 -> TimelineDiffKind.RemoveByItemId(
                FfiConverterString.read(buf),
                )
            11 -> TimelineDiffKind.UpsertByItemId(
                FfiConverterString.read(buf),
                FfiConverterTypeMessageEvent.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: TimelineDiffKind) = when(value) {
        is TimelineDiffKind.Append -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
                + FfiConverterSequenceTypeMessageEvent.allocationSize(value.`values`)
            )
        }
        is TimelineDiffKind.PushBack -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
                + FfiConverterTypeMessageEvent.allocationSize(value.`value`)
            )
        }
        is TimelineDiffKind.PushFront -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
                + FfiConverterTypeMessageEvent.allocationSize(value.`value`)
            )
        }
        is TimelineDiffKind.PopBack -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
            )
        }
        is TimelineDiffKind.PopFront -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
            )
        }
        is TimelineDiffKind.Truncate -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
                + FfiConverterUInt.allocationSize(value.`length`)
            )
        }
        is TimelineDiffKind.Clear -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
            )
        }
        is TimelineDiffKind.Reset -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
                + FfiConverterSequenceTypeMessageEvent.allocationSize(value.`values`)
            )
        }
        is TimelineDiffKind.UpdateByItemId -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
                + FfiConverterString.allocationSize(value.`itemId`)
                + FfiConverterTypeMessageEvent.allocationSize(value.`value`)
            )
        }
        is TimelineDiffKind.RemoveByItemId -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
                + FfiConverterString.allocationSize(value.`itemId`)
            )
        }
        is TimelineDiffKind.UpsertByItemId -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
                + FfiConverterString.allocationSize(value.`itemId`)
                + FfiConverterTypeMessageEvent.allocationSize(value.`value`)
            )
        }
    }

    override fun write(value: TimelineDiffKind, buf: ByteBuffer) {
        when(value) {
            is TimelineDiffKind.Append -> {
                buf.putInt(1)
                FfiConverterSequenceTypeMessageEvent.write(value.`values`, buf)
                Unit
            }
            is TimelineDiffKind.PushBack -> {
                buf.putInt(2)
                FfiConverterTypeMessageEvent.write(value.`value`, buf)
                Unit
            }
            is TimelineDiffKind.PushFront -> {
                buf.putInt(3)
                FfiConverterTypeMessageEvent.write(value.`value`, buf)
                Unit
            }
            is TimelineDiffKind.PopBack -> {
                buf.putInt(4)
                Unit
            }
            is TimelineDiffKind.PopFront -> {
                buf.putInt(5)
                Unit
            }
            is TimelineDiffKind.Truncate -> {
                buf.putInt(6)
                FfiConverterUInt.write(value.`length`, buf)
                Unit
            }
            is TimelineDiffKind.Clear -> {
                buf.putInt(7)
                Unit
            }
            is TimelineDiffKind.Reset -> {
                buf.putInt(8)
                FfiConverterSequenceTypeMessageEvent.write(value.`values`, buf)
                Unit
            }
            is TimelineDiffKind.UpdateByItemId -> {
                buf.putInt(9)
                FfiConverterString.write(value.`itemId`, buf)
                FfiConverterTypeMessageEvent.write(value.`value`, buf)
                Unit
            }
            is TimelineDiffKind.RemoveByItemId -> {
                buf.putInt(10)
                FfiConverterString.write(value.`itemId`, buf)
                Unit
            }
            is TimelineDiffKind.UpsertByItemId -> {
                buf.putInt(11)
                FfiConverterString.write(value.`itemId`, buf)
                FfiConverterTypeMessageEvent.write(value.`value`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}







public interface CallObserver {
    
    fun `onInvite`(`invite`: CallInvite)
    
    companion object
}



// Put the implementation in an object so we don't pollute the top-level namespace
internal object uniffiCallbackInterfaceCallObserver {
    internal object `onInvite`: UniffiCallbackInterfaceCallObserverMethod0 {
        override fun callback(`uniffiHandle`: Long,`invite`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeCallObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onInvite`(
                    FfiConverterTypeCallInvite.lift(`invite`),
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }

    internal object uniffiFree: UniffiCallbackInterfaceFree {
        override fun callback(handle: Long) {
            FfiConverterTypeCallObserver.handleMap.remove(handle)
        }
    }

    internal var vtable = UniffiVTableCallbackInterfaceCallObserver.UniffiByValue(
        `onInvite`,
        uniffiFree,
    )

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: UniffiLib) {
        lib.uniffi_mages_ffi_fn_init_callback_vtable_callobserver(vtable)
    }
}

/**
 * The ffiConverter which transforms the Callbacks in to handles to pass to Rust.
 *
 * @suppress
 */
public object FfiConverterTypeCallObserver: FfiConverterCallbackInterface<CallObserver>()





public interface CallWidgetObserver {
    
    /**
     * Called whenever a JSON `postMessage` payload needs to go *to* the widget.
     *
     * Kotlin should forward this verbatim into the WebView using `postMessage`.
     */
    fun `onToWidget`(`message`: kotlin.String)
    
    companion object
}



// Put the implementation in an object so we don't pollute the top-level namespace
internal object uniffiCallbackInterfaceCallWidgetObserver {
    internal object `onToWidget`: UniffiCallbackInterfaceCallWidgetObserverMethod0 {
        override fun callback(`uniffiHandle`: Long,`message`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeCallWidgetObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onToWidget`(
                    FfiConverterString.lift(`message`),
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }

    internal object uniffiFree: UniffiCallbackInterfaceFree {
        override fun callback(handle: Long) {
            FfiConverterTypeCallWidgetObserver.handleMap.remove(handle)
        }
    }

    internal var vtable = UniffiVTableCallbackInterfaceCallWidgetObserver.UniffiByValue(
        `onToWidget`,
        uniffiFree,
    )

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: UniffiLib) {
        lib.uniffi_mages_ffi_fn_init_callback_vtable_callwidgetobserver(vtable)
    }
}

/**
 * The ffiConverter which transforms the Callbacks in to handles to pass to Rust.
 *
 * @suppress
 */
public object FfiConverterTypeCallWidgetObserver: FfiConverterCallbackInterface<CallWidgetObserver>()





public interface ConnectionObserver {
    
    fun `onConnectionChange`(`state`: ConnectionState)
    
    companion object
}



// Put the implementation in an object so we don't pollute the top-level namespace
internal object uniffiCallbackInterfaceConnectionObserver {
    internal object `onConnectionChange`: UniffiCallbackInterfaceConnectionObserverMethod0 {
        override fun callback(`uniffiHandle`: Long,`state`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeConnectionObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onConnectionChange`(
                    FfiConverterTypeConnectionState.lift(`state`),
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }

    internal object uniffiFree: UniffiCallbackInterfaceFree {
        override fun callback(handle: Long) {
            FfiConverterTypeConnectionObserver.handleMap.remove(handle)
        }
    }

    internal var vtable = UniffiVTableCallbackInterfaceConnectionObserver.UniffiByValue(
        `onConnectionChange`,
        uniffiFree,
    )

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: UniffiLib) {
        lib.uniffi_mages_ffi_fn_init_callback_vtable_connectionobserver(vtable)
    }
}

/**
 * The ffiConverter which transforms the Callbacks in to handles to pass to Rust.
 *
 * @suppress
 */
public object FfiConverterTypeConnectionObserver: FfiConverterCallbackInterface<ConnectionObserver>()





public interface LiveLocationObserver {
    
    fun `onUpdate`(`shares`: List<LiveLocationShareInfo>)
    
    companion object
}



// Put the implementation in an object so we don't pollute the top-level namespace
internal object uniffiCallbackInterfaceLiveLocationObserver {
    internal object `onUpdate`: UniffiCallbackInterfaceLiveLocationObserverMethod0 {
        override fun callback(`uniffiHandle`: Long,`shares`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeLiveLocationObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onUpdate`(
                    FfiConverterSequenceTypeLiveLocationShareInfo.lift(`shares`),
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }

    internal object uniffiFree: UniffiCallbackInterfaceFree {
        override fun callback(handle: Long) {
            FfiConverterTypeLiveLocationObserver.handleMap.remove(handle)
        }
    }

    internal var vtable = UniffiVTableCallbackInterfaceLiveLocationObserver.UniffiByValue(
        `onUpdate`,
        uniffiFree,
    )

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: UniffiLib) {
        lib.uniffi_mages_ffi_fn_init_callback_vtable_livelocationobserver(vtable)
    }
}

/**
 * The ffiConverter which transforms the Callbacks in to handles to pass to Rust.
 *
 * @suppress
 */
public object FfiConverterTypeLiveLocationObserver: FfiConverterCallbackInterface<LiveLocationObserver>()





public interface ProgressObserver {
    
    fun `onProgress`(`sent`: kotlin.ULong, `total`: kotlin.ULong?)
    
    companion object
}



// Put the implementation in an object so we don't pollute the top-level namespace
internal object uniffiCallbackInterfaceProgressObserver {
    internal object `onProgress`: UniffiCallbackInterfaceProgressObserverMethod0 {
        override fun callback(`uniffiHandle`: Long,`sent`: Long,`total`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeProgressObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onProgress`(
                    FfiConverterULong.lift(`sent`),
                    FfiConverterOptionalULong.lift(`total`),
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }

    internal object uniffiFree: UniffiCallbackInterfaceFree {
        override fun callback(handle: Long) {
            FfiConverterTypeProgressObserver.handleMap.remove(handle)
        }
    }

    internal var vtable = UniffiVTableCallbackInterfaceProgressObserver.UniffiByValue(
        `onProgress`,
        uniffiFree,
    )

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: UniffiLib) {
        lib.uniffi_mages_ffi_fn_init_callback_vtable_progressobserver(vtable)
    }
}

/**
 * The ffiConverter which transforms the Callbacks in to handles to pass to Rust.
 *
 * @suppress
 */
public object FfiConverterTypeProgressObserver: FfiConverterCallbackInterface<ProgressObserver>()





public interface ReceiptsObserver {
    
    fun `onChanged`()
    
    companion object
}



// Put the implementation in an object so we don't pollute the top-level namespace
internal object uniffiCallbackInterfaceReceiptsObserver {
    internal object `onChanged`: UniffiCallbackInterfaceReceiptsObserverMethod0 {
        override fun callback(`uniffiHandle`: Long,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeReceiptsObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onChanged`(
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }

    internal object uniffiFree: UniffiCallbackInterfaceFree {
        override fun callback(handle: Long) {
            FfiConverterTypeReceiptsObserver.handleMap.remove(handle)
        }
    }

    internal var vtable = UniffiVTableCallbackInterfaceReceiptsObserver.UniffiByValue(
        `onChanged`,
        uniffiFree,
    )

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: UniffiLib) {
        lib.uniffi_mages_ffi_fn_init_callback_vtable_receiptsobserver(vtable)
    }
}

/**
 * The ffiConverter which transforms the Callbacks in to handles to pass to Rust.
 *
 * @suppress
 */
public object FfiConverterTypeReceiptsObserver: FfiConverterCallbackInterface<ReceiptsObserver>()





public interface RoomListObserver {
    
    fun `onReset`(`items`: List<RoomListEntry>)
    
    fun `onUpdate`(`item`: RoomListEntry)
    
    companion object
}



// Put the implementation in an object so we don't pollute the top-level namespace
internal object uniffiCallbackInterfaceRoomListObserver {
    internal object `onReset`: UniffiCallbackInterfaceRoomListObserverMethod0 {
        override fun callback(`uniffiHandle`: Long,`items`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeRoomListObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onReset`(
                    FfiConverterSequenceTypeRoomListEntry.lift(`items`),
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }
    internal object `onUpdate`: UniffiCallbackInterfaceRoomListObserverMethod1 {
        override fun callback(`uniffiHandle`: Long,`item`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeRoomListObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onUpdate`(
                    FfiConverterTypeRoomListEntry.lift(`item`),
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }

    internal object uniffiFree: UniffiCallbackInterfaceFree {
        override fun callback(handle: Long) {
            FfiConverterTypeRoomListObserver.handleMap.remove(handle)
        }
    }

    internal var vtable = UniffiVTableCallbackInterfaceRoomListObserver.UniffiByValue(
        `onReset`,
        `onUpdate`,
        uniffiFree,
    )

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: UniffiLib) {
        lib.uniffi_mages_ffi_fn_init_callback_vtable_roomlistobserver(vtable)
    }
}

/**
 * The ffiConverter which transforms the Callbacks in to handles to pass to Rust.
 *
 * @suppress
 */
public object FfiConverterTypeRoomListObserver: FfiConverterCallbackInterface<RoomListObserver>()





public interface SendObserver {
    
    fun `onUpdate`(`update`: SendUpdate)
    
    companion object
}



// Put the implementation in an object so we don't pollute the top-level namespace
internal object uniffiCallbackInterfaceSendObserver {
    internal object `onUpdate`: UniffiCallbackInterfaceSendObserverMethod0 {
        override fun callback(`uniffiHandle`: Long,`update`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeSendObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onUpdate`(
                    FfiConverterTypeSendUpdate.lift(`update`),
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }

    internal object uniffiFree: UniffiCallbackInterfaceFree {
        override fun callback(handle: Long) {
            FfiConverterTypeSendObserver.handleMap.remove(handle)
        }
    }

    internal var vtable = UniffiVTableCallbackInterfaceSendObserver.UniffiByValue(
        `onUpdate`,
        uniffiFree,
    )

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: UniffiLib) {
        lib.uniffi_mages_ffi_fn_init_callback_vtable_sendobserver(vtable)
    }
}

/**
 * The ffiConverter which transforms the Callbacks in to handles to pass to Rust.
 *
 * @suppress
 */
public object FfiConverterTypeSendObserver: FfiConverterCallbackInterface<SendObserver>()





public interface SyncObserver {
    
    fun `onState`(`status`: SyncStatus)
    
    companion object
}



// Put the implementation in an object so we don't pollute the top-level namespace
internal object uniffiCallbackInterfaceSyncObserver {
    internal object `onState`: UniffiCallbackInterfaceSyncObserverMethod0 {
        override fun callback(`uniffiHandle`: Long,`status`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeSyncObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onState`(
                    FfiConverterTypeSyncStatus.lift(`status`),
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }

    internal object uniffiFree: UniffiCallbackInterfaceFree {
        override fun callback(handle: Long) {
            FfiConverterTypeSyncObserver.handleMap.remove(handle)
        }
    }

    internal var vtable = UniffiVTableCallbackInterfaceSyncObserver.UniffiByValue(
        `onState`,
        uniffiFree,
    )

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: UniffiLib) {
        lib.uniffi_mages_ffi_fn_init_callback_vtable_syncobserver(vtable)
    }
}

/**
 * The ffiConverter which transforms the Callbacks in to handles to pass to Rust.
 *
 * @suppress
 */
public object FfiConverterTypeSyncObserver: FfiConverterCallbackInterface<SyncObserver>()





public interface TimelineObserver {
    
    fun `onDiff`(`diff`: TimelineDiffKind)
    
    fun `onError`(`message`: kotlin.String)
    
    companion object
}



// Put the implementation in an object so we don't pollute the top-level namespace
internal object uniffiCallbackInterfaceTimelineObserver {
    internal object `onDiff`: UniffiCallbackInterfaceTimelineObserverMethod0 {
        override fun callback(`uniffiHandle`: Long,`diff`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeTimelineObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onDiff`(
                    FfiConverterTypeTimelineDiffKind.lift(`diff`),
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }
    internal object `onError`: UniffiCallbackInterfaceTimelineObserverMethod1 {
        override fun callback(`uniffiHandle`: Long,`message`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeTimelineObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onError`(
                    FfiConverterString.lift(`message`),
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }

    internal object uniffiFree: UniffiCallbackInterfaceFree {
        override fun callback(handle: Long) {
            FfiConverterTypeTimelineObserver.handleMap.remove(handle)
        }
    }

    internal var vtable = UniffiVTableCallbackInterfaceTimelineObserver.UniffiByValue(
        `onDiff`,
        `onError`,
        uniffiFree,
    )

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: UniffiLib) {
        lib.uniffi_mages_ffi_fn_init_callback_vtable_timelineobserver(vtable)
    }
}

/**
 * The ffiConverter which transforms the Callbacks in to handles to pass to Rust.
 *
 * @suppress
 */
public object FfiConverterTypeTimelineObserver: FfiConverterCallbackInterface<TimelineObserver>()





public interface TypingObserver {
    
    fun `onUpdate`(`names`: List<kotlin.String>)
    
    companion object
}



// Put the implementation in an object so we don't pollute the top-level namespace
internal object uniffiCallbackInterfaceTypingObserver {
    internal object `onUpdate`: UniffiCallbackInterfaceTypingObserverMethod0 {
        override fun callback(`uniffiHandle`: Long,`names`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeTypingObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onUpdate`(
                    FfiConverterSequenceString.lift(`names`),
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }

    internal object uniffiFree: UniffiCallbackInterfaceFree {
        override fun callback(handle: Long) {
            FfiConverterTypeTypingObserver.handleMap.remove(handle)
        }
    }

    internal var vtable = UniffiVTableCallbackInterfaceTypingObserver.UniffiByValue(
        `onUpdate`,
        uniffiFree,
    )

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: UniffiLib) {
        lib.uniffi_mages_ffi_fn_init_callback_vtable_typingobserver(vtable)
    }
}

/**
 * The ffiConverter which transforms the Callbacks in to handles to pass to Rust.
 *
 * @suppress
 */
public object FfiConverterTypeTypingObserver: FfiConverterCallbackInterface<TypingObserver>()





public interface UrlOpener {
    
    fun `open`(`url`: kotlin.String): kotlin.Boolean
    
    companion object
}



// Put the implementation in an object so we don't pollute the top-level namespace
internal object uniffiCallbackInterfaceUrlOpener {
    internal object `open`: UniffiCallbackInterfaceUrlOpenerMethod0 {
        override fun callback(`uniffiHandle`: Long,`url`: RustBuffer.ByValue,`uniffiOutReturn`: ByteByReference,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeUrlOpener.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`open`(
                    FfiConverterString.lift(`url`),
                )
            }
            val writeReturn = { value: kotlin.Boolean -> uniffiOutReturn.setValue(FfiConverterBoolean.lower(value)) }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }

    internal object uniffiFree: UniffiCallbackInterfaceFree {
        override fun callback(handle: Long) {
            FfiConverterTypeUrlOpener.handleMap.remove(handle)
        }
    }

    internal var vtable = UniffiVTableCallbackInterfaceUrlOpener.UniffiByValue(
        `open`,
        uniffiFree,
    )

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: UniffiLib) {
        lib.uniffi_mages_ffi_fn_init_callback_vtable_urlopener(vtable)
    }
}

/**
 * The ffiConverter which transforms the Callbacks in to handles to pass to Rust.
 *
 * @suppress
 */
public object FfiConverterTypeUrlOpener: FfiConverterCallbackInterface<UrlOpener>()





public interface VerificationInboxObserver {
    
    fun `onRequest`(`flowId`: kotlin.String, `fromUser`: kotlin.String, `fromDevice`: kotlin.String)
    
    fun `onError`(`message`: kotlin.String)
    
    companion object
}



// Put the implementation in an object so we don't pollute the top-level namespace
internal object uniffiCallbackInterfaceVerificationInboxObserver {
    internal object `onRequest`: UniffiCallbackInterfaceVerificationInboxObserverMethod0 {
        override fun callback(`uniffiHandle`: Long,`flowId`: RustBuffer.ByValue,`fromUser`: RustBuffer.ByValue,`fromDevice`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeVerificationInboxObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onRequest`(
                    FfiConverterString.lift(`flowId`),
                    FfiConverterString.lift(`fromUser`),
                    FfiConverterString.lift(`fromDevice`),
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }
    internal object `onError`: UniffiCallbackInterfaceVerificationInboxObserverMethod1 {
        override fun callback(`uniffiHandle`: Long,`message`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeVerificationInboxObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onError`(
                    FfiConverterString.lift(`message`),
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }

    internal object uniffiFree: UniffiCallbackInterfaceFree {
        override fun callback(handle: Long) {
            FfiConverterTypeVerificationInboxObserver.handleMap.remove(handle)
        }
    }

    internal var vtable = UniffiVTableCallbackInterfaceVerificationInboxObserver.UniffiByValue(
        `onRequest`,
        `onError`,
        uniffiFree,
    )

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: UniffiLib) {
        lib.uniffi_mages_ffi_fn_init_callback_vtable_verificationinboxobserver(vtable)
    }
}

/**
 * The ffiConverter which transforms the Callbacks in to handles to pass to Rust.
 *
 * @suppress
 */
public object FfiConverterTypeVerificationInboxObserver: FfiConverterCallbackInterface<VerificationInboxObserver>()





public interface VerificationObserver {
    
    fun `onPhase`(`flowId`: kotlin.String, `phase`: SasPhase)
    
    fun `onEmojis`(`payload`: SasEmojis)
    
    fun `onError`(`flowId`: kotlin.String, `message`: kotlin.String)
    
    companion object
}



// Put the implementation in an object so we don't pollute the top-level namespace
internal object uniffiCallbackInterfaceVerificationObserver {
    internal object `onPhase`: UniffiCallbackInterfaceVerificationObserverMethod0 {
        override fun callback(`uniffiHandle`: Long,`flowId`: RustBuffer.ByValue,`phase`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeVerificationObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onPhase`(
                    FfiConverterString.lift(`flowId`),
                    FfiConverterTypeSasPhase.lift(`phase`),
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }
    internal object `onEmojis`: UniffiCallbackInterfaceVerificationObserverMethod1 {
        override fun callback(`uniffiHandle`: Long,`payload`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeVerificationObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onEmojis`(
                    FfiConverterTypeSasEmojis.lift(`payload`),
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }
    internal object `onError`: UniffiCallbackInterfaceVerificationObserverMethod2 {
        override fun callback(`uniffiHandle`: Long,`flowId`: RustBuffer.ByValue,`message`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeVerificationObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onError`(
                    FfiConverterString.lift(`flowId`),
                    FfiConverterString.lift(`message`),
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }

    internal object uniffiFree: UniffiCallbackInterfaceFree {
        override fun callback(handle: Long) {
            FfiConverterTypeVerificationObserver.handleMap.remove(handle)
        }
    }

    internal var vtable = UniffiVTableCallbackInterfaceVerificationObserver.UniffiByValue(
        `onPhase`,
        `onEmojis`,
        `onError`,
        uniffiFree,
    )

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: UniffiLib) {
        lib.uniffi_mages_ffi_fn_init_callback_vtable_verificationobserver(vtable)
    }
}

/**
 * The ffiConverter which transforms the Callbacks in to handles to pass to Rust.
 *
 * @suppress
 */
public object FfiConverterTypeVerificationObserver: FfiConverterCallbackInterface<VerificationObserver>()




/**
 * @suppress
 */
public object FfiConverterOptionalUInt: FfiConverterRustBuffer<kotlin.UInt?> {
    override fun read(buf: ByteBuffer): kotlin.UInt? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterUInt.read(buf)
    }

    override fun allocationSize(value: kotlin.UInt?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterUInt.allocationSize(value)
        }
    }

    override fun write(value: kotlin.UInt?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterUInt.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalULong: FfiConverterRustBuffer<kotlin.ULong?> {
    override fun read(buf: ByteBuffer): kotlin.ULong? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterULong.read(buf)
    }

    override fun allocationSize(value: kotlin.ULong?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterULong.allocationSize(value)
        }
    }

    override fun write(value: kotlin.ULong?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterULong.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalBoolean: FfiConverterRustBuffer<kotlin.Boolean?> {
    override fun read(buf: ByteBuffer): kotlin.Boolean? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterBoolean.read(buf)
    }

    override fun allocationSize(value: kotlin.Boolean?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterBoolean.allocationSize(value)
        }
    }

    override fun write(value: kotlin.Boolean?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterBoolean.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalString: FfiConverterRustBuffer<kotlin.String?> {
    override fun read(buf: ByteBuffer): kotlin.String? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterString.read(buf)
    }

    override fun allocationSize(value: kotlin.String?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterString.allocationSize(value)
        }
    }

    override fun write(value: kotlin.String?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterString.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalTypeAttachmentInfo: FfiConverterRustBuffer<AttachmentInfo?> {
    override fun read(buf: ByteBuffer): AttachmentInfo? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeAttachmentInfo.read(buf)
    }

    override fun allocationSize(value: AttachmentInfo?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeAttachmentInfo.allocationSize(value)
        }
    }

    override fun write(value: AttachmentInfo?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeAttachmentInfo.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalTypeEncFile: FfiConverterRustBuffer<EncFile?> {
    override fun read(buf: ByteBuffer): EncFile? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeEncFile.read(buf)
    }

    override fun allocationSize(value: EncFile?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeEncFile.allocationSize(value)
        }
    }

    override fun write(value: EncFile?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeEncFile.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalTypeLatestRoomEvent: FfiConverterRustBuffer<LatestRoomEvent?> {
    override fun read(buf: ByteBuffer): LatestRoomEvent? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeLatestRoomEvent.read(buf)
    }

    override fun allocationSize(value: LatestRoomEvent?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeLatestRoomEvent.allocationSize(value)
        }
    }

    override fun write(value: LatestRoomEvent?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeLatestRoomEvent.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalTypePollData: FfiConverterRustBuffer<PollData?> {
    override fun read(buf: ByteBuffer): PollData? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypePollData.read(buf)
    }

    override fun allocationSize(value: PollData?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypePollData.allocationSize(value)
        }
    }

    override fun write(value: PollData?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypePollData.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalTypePredecessorRoomInfo: FfiConverterRustBuffer<PredecessorRoomInfo?> {
    override fun read(buf: ByteBuffer): PredecessorRoomInfo? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypePredecessorRoomInfo.read(buf)
    }

    override fun allocationSize(value: PredecessorRoomInfo?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypePredecessorRoomInfo.allocationSize(value)
        }
    }

    override fun write(value: PredecessorRoomInfo?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypePredecessorRoomInfo.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalTypeRenderedNotification: FfiConverterRustBuffer<RenderedNotification?> {
    override fun read(buf: ByteBuffer): RenderedNotification? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeRenderedNotification.read(buf)
    }

    override fun allocationSize(value: RenderedNotification?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeRenderedNotification.allocationSize(value)
        }
    }

    override fun write(value: RenderedNotification?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeRenderedNotification.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalTypeRoomProfile: FfiConverterRustBuffer<RoomProfile?> {
    override fun read(buf: ByteBuffer): RoomProfile? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeRoomProfile.read(buf)
    }

    override fun allocationSize(value: RoomProfile?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeRoomProfile.allocationSize(value)
        }
    }

    override fun write(value: RoomProfile?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeRoomProfile.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalTypeRoomTags: FfiConverterRustBuffer<RoomTags?> {
    override fun read(buf: ByteBuffer): RoomTags? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeRoomTags.read(buf)
    }

    override fun allocationSize(value: RoomTags?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeRoomTags.allocationSize(value)
        }
    }

    override fun write(value: RoomTags?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeRoomTags.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalTypeRoomUpgradeLinks: FfiConverterRustBuffer<RoomUpgradeLinks?> {
    override fun read(buf: ByteBuffer): RoomUpgradeLinks? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeRoomUpgradeLinks.read(buf)
    }

    override fun allocationSize(value: RoomUpgradeLinks?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeRoomUpgradeLinks.allocationSize(value)
        }
    }

    override fun write(value: RoomUpgradeLinks?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeRoomUpgradeLinks.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalTypeSuccessorRoomInfo: FfiConverterRustBuffer<SuccessorRoomInfo?> {
    override fun read(buf: ByteBuffer): SuccessorRoomInfo? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeSuccessorRoomInfo.read(buf)
    }

    override fun allocationSize(value: SuccessorRoomInfo?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeSuccessorRoomInfo.allocationSize(value)
        }
    }

    override fun write(value: SuccessorRoomInfo?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeSuccessorRoomInfo.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalTypeUnreadStats: FfiConverterRustBuffer<UnreadStats?> {
    override fun read(buf: ByteBuffer): UnreadStats? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeUnreadStats.read(buf)
    }

    override fun allocationSize(value: UnreadStats?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeUnreadStats.allocationSize(value)
        }
    }

    override fun write(value: UnreadStats?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeUnreadStats.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalTypeFfiRoomNotificationMode: FfiConverterRustBuffer<FfiRoomNotificationMode?> {
    override fun read(buf: ByteBuffer): FfiRoomNotificationMode? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeFfiRoomNotificationMode.read(buf)
    }

    override fun allocationSize(value: FfiRoomNotificationMode?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeFfiRoomNotificationMode.allocationSize(value)
        }
    }

    override fun write(value: FfiRoomNotificationMode?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeFfiRoomNotificationMode.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalTypeSendState: FfiConverterRustBuffer<SendState?> {
    override fun read(buf: ByteBuffer): SendState? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeSendState.read(buf)
    }

    override fun allocationSize(value: SendState?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeSendState.allocationSize(value)
        }
    }

    override fun write(value: SendState?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeSendState.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalTypeProgressObserver: FfiConverterRustBuffer<ProgressObserver?> {
    override fun read(buf: ByteBuffer): ProgressObserver? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeProgressObserver.read(buf)
    }

    override fun allocationSize(value: ProgressObserver?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeProgressObserver.allocationSize(value)
        }
    }

    override fun write(value: ProgressObserver?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeProgressObserver.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceString: FfiConverterRustBuffer<List<kotlin.String>> {
    override fun read(buf: ByteBuffer): List<kotlin.String> {
        val len = buf.getInt()
        return List<kotlin.String>(len) {
            FfiConverterString.read(buf)
        }
    }

    override fun allocationSize(value: List<kotlin.String>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterString.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<kotlin.String>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterString.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeDeviceSummary: FfiConverterRustBuffer<List<DeviceSummary>> {
    override fun read(buf: ByteBuffer): List<DeviceSummary> {
        val len = buf.getInt()
        return List<DeviceSummary>(len) {
            FfiConverterTypeDeviceSummary.read(buf)
        }
    }

    override fun allocationSize(value: List<DeviceSummary>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeDeviceSummary.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<DeviceSummary>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeDeviceSummary.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeDirectoryUser: FfiConverterRustBuffer<List<DirectoryUser>> {
    override fun read(buf: ByteBuffer): List<DirectoryUser> {
        val len = buf.getInt()
        return List<DirectoryUser>(len) {
            FfiConverterTypeDirectoryUser.read(buf)
        }
    }

    override fun allocationSize(value: List<DirectoryUser>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeDirectoryUser.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<DirectoryUser>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeDirectoryUser.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeLiveLocationShareInfo: FfiConverterRustBuffer<List<LiveLocationShareInfo>> {
    override fun read(buf: ByteBuffer): List<LiveLocationShareInfo> {
        val len = buf.getInt()
        return List<LiveLocationShareInfo>(len) {
            FfiConverterTypeLiveLocationShareInfo.read(buf)
        }
    }

    override fun allocationSize(value: List<LiveLocationShareInfo>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeLiveLocationShareInfo.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<LiveLocationShareInfo>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeLiveLocationShareInfo.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeMemberSummary: FfiConverterRustBuffer<List<MemberSummary>> {
    override fun read(buf: ByteBuffer): List<MemberSummary> {
        val len = buf.getInt()
        return List<MemberSummary>(len) {
            FfiConverterTypeMemberSummary.read(buf)
        }
    }

    override fun allocationSize(value: List<MemberSummary>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeMemberSummary.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<MemberSummary>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeMemberSummary.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeMessageEvent: FfiConverterRustBuffer<List<MessageEvent>> {
    override fun read(buf: ByteBuffer): List<MessageEvent> {
        val len = buf.getInt()
        return List<MessageEvent>(len) {
            FfiConverterTypeMessageEvent.read(buf)
        }
    }

    override fun allocationSize(value: List<MessageEvent>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeMessageEvent.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<MessageEvent>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeMessageEvent.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypePollOption: FfiConverterRustBuffer<List<PollOption>> {
    override fun read(buf: ByteBuffer): List<PollOption> {
        val len = buf.getInt()
        return List<PollOption>(len) {
            FfiConverterTypePollOption.read(buf)
        }
    }

    override fun allocationSize(value: List<PollOption>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypePollOption.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<PollOption>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypePollOption.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypePublicRoom: FfiConverterRustBuffer<List<PublicRoom>> {
    override fun read(buf: ByteBuffer): List<PublicRoom> {
        val len = buf.getInt()
        return List<PublicRoom>(len) {
            FfiConverterTypePublicRoom.read(buf)
        }
    }

    override fun allocationSize(value: List<PublicRoom>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypePublicRoom.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<PublicRoom>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypePublicRoom.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeReactionSummary: FfiConverterRustBuffer<List<ReactionSummary>> {
    override fun read(buf: ByteBuffer): List<ReactionSummary> {
        val len = buf.getInt()
        return List<ReactionSummary>(len) {
            FfiConverterTypeReactionSummary.read(buf)
        }
    }

    override fun allocationSize(value: List<ReactionSummary>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeReactionSummary.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<ReactionSummary>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeReactionSummary.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeRenderedNotification: FfiConverterRustBuffer<List<RenderedNotification>> {
    override fun read(buf: ByteBuffer): List<RenderedNotification> {
        val len = buf.getInt()
        return List<RenderedNotification>(len) {
            FfiConverterTypeRenderedNotification.read(buf)
        }
    }

    override fun allocationSize(value: List<RenderedNotification>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeRenderedNotification.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<RenderedNotification>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeRenderedNotification.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeRoomListEntry: FfiConverterRustBuffer<List<RoomListEntry>> {
    override fun read(buf: ByteBuffer): List<RoomListEntry> {
        val len = buf.getInt()
        return List<RoomListEntry>(len) {
            FfiConverterTypeRoomListEntry.read(buf)
        }
    }

    override fun allocationSize(value: List<RoomListEntry>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeRoomListEntry.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<RoomListEntry>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeRoomListEntry.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeRoomProfile: FfiConverterRustBuffer<List<RoomProfile>> {
    override fun read(buf: ByteBuffer): List<RoomProfile> {
        val len = buf.getInt()
        return List<RoomProfile>(len) {
            FfiConverterTypeRoomProfile.read(buf)
        }
    }

    override fun allocationSize(value: List<RoomProfile>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeRoomProfile.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<RoomProfile>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeRoomProfile.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeRoomSummary: FfiConverterRustBuffer<List<RoomSummary>> {
    override fun read(buf: ByteBuffer): List<RoomSummary> {
        val len = buf.getInt()
        return List<RoomSummary>(len) {
            FfiConverterTypeRoomSummary.read(buf)
        }
    }

    override fun allocationSize(value: List<RoomSummary>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeRoomSummary.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<RoomSummary>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeRoomSummary.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeSearchHit: FfiConverterRustBuffer<List<SearchHit>> {
    override fun read(buf: ByteBuffer): List<SearchHit> {
        val len = buf.getInt()
        return List<SearchHit>(len) {
            FfiConverterTypeSearchHit.read(buf)
        }
    }

    override fun allocationSize(value: List<SearchHit>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeSearchHit.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<SearchHit>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeSearchHit.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeSeenByEntry: FfiConverterRustBuffer<List<SeenByEntry>> {
    override fun read(buf: ByteBuffer): List<SeenByEntry> {
        val len = buf.getInt()
        return List<SeenByEntry>(len) {
            FfiConverterTypeSeenByEntry.read(buf)
        }
    }

    override fun allocationSize(value: List<SeenByEntry>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeSeenByEntry.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<SeenByEntry>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeSeenByEntry.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeSpaceChildInfo: FfiConverterRustBuffer<List<SpaceChildInfo>> {
    override fun read(buf: ByteBuffer): List<SpaceChildInfo> {
        val len = buf.getInt()
        return List<SpaceChildInfo>(len) {
            FfiConverterTypeSpaceChildInfo.read(buf)
        }
    }

    override fun allocationSize(value: List<SpaceChildInfo>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeSpaceChildInfo.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<SpaceChildInfo>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeSpaceChildInfo.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeSpaceInfo: FfiConverterRustBuffer<List<SpaceInfo>> {
    override fun read(buf: ByteBuffer): List<SpaceInfo> {
        val len = buf.getInt()
        return List<SpaceInfo>(len) {
            FfiConverterTypeSpaceInfo.read(buf)
        }
    }

    override fun allocationSize(value: List<SpaceInfo>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeSpaceInfo.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<SpaceInfo>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeSpaceInfo.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterMapStringSequenceTypeReactionSummary: FfiConverterRustBuffer<Map<kotlin.String, List<ReactionSummary>>> {
    override fun read(buf: ByteBuffer): Map<kotlin.String, List<ReactionSummary>> {
        val len = buf.getInt()
        return buildMap<kotlin.String, List<ReactionSummary>>(len) {
            repeat(len) {
                val k = FfiConverterString.read(buf)
                val v = FfiConverterSequenceTypeReactionSummary.read(buf)
                this[k] = v
            }
        }
    }

    override fun allocationSize(value: Map<kotlin.String, List<ReactionSummary>>): ULong {
        val spaceForMapSize = 4UL
        val spaceForChildren = value.map { (k, v) ->
            FfiConverterString.allocationSize(k) +
            FfiConverterSequenceTypeReactionSummary.allocationSize(v)
        }.sum()
        return spaceForMapSize + spaceForChildren
    }

    override fun write(value: Map<kotlin.String, List<ReactionSummary>>, buf: ByteBuffer) {
        buf.putInt(value.size)
        // The parens on `(k, v)` here ensure we're calling the right method,
        // which is important for compatibility with older android devices.
        // Ref https://blog.danlew.net/2017/03/16/kotlin-puzzler-whose-line-is-it-anyways/
        value.forEach { (k, v) ->
            FfiConverterString.write(k, buf)
            FfiConverterSequenceTypeReactionSummary.write(v, buf)
        }
    }
}

