package org.mian.gitnex.helpers.languagestatistics;

import java.util.HashMap;
import java.util.Map;
import org.mian.gitnex.R;

/**
 * @author mmarif
 */
public class LanguageColor {
	private static final Map<String, Integer> colors = new HashMap<>();

	static {
		colors.put("ASP.NET", R.color.default_lang_color);
		colors.put("ATS", R.color.ats);
		colors.put("ActionScript", R.color.action_script);
		colors.put("Ada", R.color.ada);
		colors.put("AngelScript", R.color.angel_script);
		colors.put("Ant Build System", R.color.ant_build_system);
		colors.put("Antlers", R.color.antlers);
		colors.put("ApacheConf", R.color.apache_conf);
		colors.put("Apex", R.color.apex);
		colors.put("AppleScript", R.color.apple_script);
		colors.put("AsciiDoc", R.color.ascii_doc);
		colors.put("Assembly", R.color.assembly);
		colors.put("Awk", R.color.awk);
		colors.put("BASIC", R.color.basic);
		colors.put("Batchfile", R.color.batch_file);
		colors.put("Bison", R.color.bison);
		colors.put("Blade", R.color.blade);
		colors.put("C", R.color.c);
		colors.put("C#", R.color.c_sharp);
		colors.put("C++", R.color.c_plus_plus);
		colors.put("CMake", R.color.c_make);
		colors.put("COBOL", R.color.c_make);
		colors.put("CSS", R.color.css);
		colors.put("CSV", R.color.csv);
		colors.put("Classic ASP", R.color.classic_asp);
		colors.put("Clojure", R.color.clojure);
		colors.put("Closure Templates", R.color.closure_templates);
		colors.put("CodeQL", R.color.code_ql);
		colors.put("CoffeeScript", R.color.coffee_script);
		colors.put("ColdFusion", R.color.cold_fusion);
		colors.put("Common Lisp", R.color.common_lisp);
		colors.put("Cython", R.color.cython);
		colors.put("DNS Zone", R.color.cython);
		colors.put("Dart", R.color.dart);
		colors.put("Diff", R.color.dart);
		colors.put("Dockerfile", R.color.docker_file);
		colors.put("Dotenv", R.color.dot_env);
		colors.put("E-mail", R.color.dot_env);
		colors.put("EJS", R.color.ejs);
		colors.put("Elixir", R.color.elixir);
		colors.put("Elm", R.color.elm);
		colors.put("Emacs Lisp", R.color.emacs_lisp);
		colors.put("EmberScript", R.color.ember_script);
		colors.put("Erlang", R.color.erlang);
		colors.put("Forth", R.color.forth);
		colors.put("Fortran", R.color.fortran);
		colors.put("Fortran Free Form", R.color.fortran_free_form);
		colors.put("FreeBasic", R.color.free_basic);
		colors.put("GDScript", R.color.gd_script);
		colors.put("GLSL", R.color.glsl);
		colors.put("Git Attributes", R.color.git_attributes);
		colors.put("Git Config", R.color.git_config);
		colors.put("Gnuplot", R.color.gnuplot);
		colors.put("Go", R.color.go);
		colors.put("Go Checksums", R.color.go_checksums);
		colors.put("Go Module", R.color.go_module);
		colors.put("Gradle", R.color.gradle);
		colors.put("GraphQL", R.color.graph_ql);
		colors.put("Groovy", R.color.groovy);
		colors.put("HAProxy", R.color.ha_proxy);
		colors.put("HCL", R.color.hcl);
		colors.put("HTML", R.color.html);
		colors.put("HTML+PHP", R.color.html_php);
		colors.put("Hack", R.color.hack);
		colors.put("Haml", R.color.haml);
		colors.put("Haskell", R.color.haskell);
		colors.put("Haxe", R.color.haxe);
		colors.put("INI", R.color.ini);
		colors.put("Ignore List", R.color.ignore_list);
		colors.put("JAR Manifest", R.color.jar_manifest);
		colors.put("JSON", R.color.json);
		colors.put("JSON with Comments", R.color.json_with_comments);
		colors.put("JSON5", R.color.json5);
		colors.put("JSONLD", R.color.json_ld);
		colors.put("JSONiq", R.color.json_iq);
		colors.put("Java", R.color.java);
		colors.put("Java Properties", R.color.java_properties);
		colors.put("Java Server Pages", R.color.java_server_pages);
		colors.put("JavaScript", R.color.java_script);
		colors.put("Jinja", R.color.jinja);
		colors.put("Julia", R.color.julia);
		colors.put("Jupyter Notebook", R.color.jupyter_notebook);
		colors.put("Kotlin", R.color.kotlin);
		colors.put("LLVM", R.color.llvm);
		colors.put("LSL", R.color.lsl);
		colors.put("Lasso", R.color.lasso);
		colors.put("Latte", R.color.latte);
		colors.put("Less", R.color.less);
		colors.put("LiveScript", R.color.live_script);
		colors.put("Lua", R.color.lua);
		colors.put("MATLAB", R.color.matlab);
		colors.put("MTML", R.color.mtml);
		colors.put("Makefile", R.color.make_file);
		colors.put("Markdown", R.color.markdown);
		colors.put("Mathematica", R.color.mathematica);
		colors.put("Maven POM", R.color.mathematica);
		colors.put("Max", R.color.max);
		colors.put("Mercury", R.color.mercury);
		colors.put("Mermaid", R.color.mermaid);
		colors.put("Meson", R.color.meson);
		colors.put("MiniYAML", R.color.mini_yaml);
		colors.put("NPM Config", R.color.npm_rc);
		colors.put("NSIS", R.color.npm_rc);
		colors.put("Nginx", R.color.nginx);
		colors.put("Nim", R.color.nim);
		colors.put("Nix", R.color.nix);
		colors.put("ObjectScript", R.color.object_script);
		colors.put("Objective-C", R.color.objective_c);
		colors.put("Objective-C++", R.color.objective_c_plus_plus);
		colors.put("PHP", R.color.php);
		colors.put("PLSQL", R.color.pl_sql);
		colors.put("PLpgSQL", R.color.pl_pg_sql);
		colors.put("Pascal", R.color.pascal);
		colors.put("Perl", R.color.perl);
		colors.put("PostCSS", R.color.post_css);
		colors.put("PostScript", R.color.post_script);
		colors.put("PowerShell", R.color.power_shell);
		colors.put("Proguard", R.color.pro_log);
		colors.put("Prolog", R.color.pro_log);
		colors.put("Public Key", R.color.post_css);
		colors.put("Pug", R.color.pug);
		colors.put("Puppet", R.color.puppet);
		colors.put("Python", R.color.python);
		colors.put("Python console", R.color.python);
		colors.put("Python traceback", R.color.python);
		colors.put("QML", R.color.qml);
		colors.put("Qt Script", R.color.qt_script);
		colors.put("R", R.color.r);
		colors.put("Racket", R.color.racket);
		colors.put("Raku", R.color.raku);
		colors.put("Raw token data", R.color.raku);
		colors.put("Regular Expression", R.color.regexp);
		colors.put("Rich Text Format", R.color.regexp);
		colors.put("Roff", R.color.roff);
		colors.put("Roff Manpage", R.color.hack);
		colors.put("Ruby", R.color.ruby);
		colors.put("Rust", R.color.rust);
		colors.put("SCSS", R.color.scss);
		colors.put("SELinux Policy", R.color.scss);
		colors.put("SQL", R.color.sql);
		colors.put("SQLPL", R.color.sql);
		colors.put("SSH Config", R.color.r);
		colors.put("SVG", R.color.svg);
		colors.put("Sass", R.color.sass);
		colors.put("Scala", R.color.scala);
		colors.put("Scheme", R.color.scheme);
		colors.put("Shell", R.color.shell);
		colors.put("ShellCheck Config", R.color.scheme);
		colors.put("ShellSession", R.color.scala);
		colors.put("Smarty", R.color.smarty);
		colors.put("Standard ML", R.color.standard_ml);
		colors.put("Stata", R.color.stata);
		colors.put("Stylus", R.color.stylus);
		colors.put("Svelte", R.color.svelte);
		colors.put("Swift", R.color.swift);
		colors.put("TOML", R.color.toml);
		colors.put("TSQL", R.color.swift);
		colors.put("TSV", R.color.smarty);
		colors.put("TSX", R.color.toml);
		colors.put("TXL", R.color.smarty);
		colors.put("Tcl", R.color.tcl);
		colors.put("TeX", R.color.tex);
		colors.put("Texinfo", R.color.tex);
		colors.put("Text", R.color.roff);
		colors.put("Twig", R.color.twig);
		colors.put("TypeScript", R.color.type_script);
		colors.put("Unity3D Asset", R.color.unity_asset);
		colors.put("VBA", R.color.vba);
		colors.put("VBScript", R.color.vbs);
		colors.put("VHDL", R.color.vhdl);
		colors.put("Vala", R.color.vala);
		colors.put("Vim Help File", R.color.vim);
		colors.put("Vim Script", R.color.vim);
		colors.put("Vim Snippet", R.color.vb_net);
		colors.put("Visual Basic .NET", R.color.hack);
		colors.put("Visual Basic 6.0", R.color.vb6);
		colors.put("Volt", R.color.volt);
		colors.put("Vue", R.color.vue);
		colors.put("WebAssembly", R.color.web_assembly);
		colors.put("Wikitext", R.color.wiki);
		colors.put("Windows Registry Entries", R.color.win_reg_entries);
		colors.put("XML", R.color.xml);
		colors.put("XML Property List", R.color.xml_props_list);
		colors.put("XQuery", R.color.vb6);
		colors.put("XS", R.color.wiki);
		colors.put("XSLT", R.color.xslt);
		colors.put("XProc", R.color.yaml);
		colors.put("YAML", R.color.vb6);
		colors.put("Zephir", R.color.zep);
		colors.put("cURL Config", R.color.zep);
		colors.put("desktop", R.color.win_reg_entries);
		colors.put("dircolors", R.color.xslt);
		colors.put("robots.txt", R.color.yaml);
		colors.put("sed", R.color.sed);
		colors.put("xBase", R.color.x_base);
		colors.put("D", R.color.wiki);
	}

	public static int languageColor(String key) {
		if (key == null) {
			return R.color.default_lang_color;
		}
		Integer color = colors.get(key);
		return color != null ? color : R.color.default_lang_color;
	}
}
