export default class Color {
  static TRANSPARENT = 0;
  static clampRGB = value => Color.clamp(Math.round(value), 0, 255);
  static clamp = (value, min, max) => Math.max(min, Math.min(value, max));
  static red = color => color >> 16 & 0xff;
  static green = color => color >> 8 & 0xff;
  static blue = color => color & 0xff;
  static rgb(red, green, blue) {
    red = Color.clampRGB(red);
    green = Color.clampRGB(green);
    blue = Color.clampRGB(blue);
    return 0xff000000 | red << 16 | green << 8 | blue;
  }
}
Color;
//# sourceMappingURL=Color.js.map