"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isMaterialYouSupported = exports.getPalletteFromAndroid = void 0;
var _reactNative = require("react-native");
// @ts-expect-error any
const isTurboModuleEnabled = global.__turboModuleProxy != null;
const MaterialYouColorsModule = isTurboModuleEnabled ?
// eslint-disable-next-line @typescript-eslint/no-var-requires
require('./NativeMaterialYouColors').default : _reactNative.NativeModules === null || _reactNative.NativeModules === void 0 ? void 0 : _reactNative.NativeModules.MaterialYouColors;
const MaterialYouColors = MaterialYouColorsModule || null;
if (!MaterialYouColors) {
  const LINKING_ERROR = "\n...\n\nThe package 'react-native-material-you-colors' doesn't seem to be linked. Make sure: \n" + '- You rebuilt the app after installing the package.\n' + '- You are not using Expo Go.\n\n' + 'If you are using Expo, please note that the native side of the library (for obtaining the Android Material You color palette)\n' + 'may not work in the Expo Go app. However, it should work as expected in the production build.\n\n...';
  console.error(LINKING_ERROR);
}
const isMaterialYouSupported = _reactNative.Platform.OS === 'android' && _reactNative.Platform.Version >= 31 && MaterialYouColors;
exports.isMaterialYouSupported = isMaterialYouSupported;
const getPalletteFromAndroid = MaterialYouColors === null || MaterialYouColors === void 0 ? void 0 : MaterialYouColors.getColors;
exports.getPalletteFromAndroid = getPalletteFromAndroid;
//# sourceMappingURL=MaterialYouColors.android.js.map