"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Pluralization = exports.defaultPluralizer = exports.useMakePlural = void 0;
const make_plural_1 = require("make-plural");
function useMakePlural({ pluralizer, includeZero = true, ordinal = false, }) {
    return function (_i18n, count) {
        return [
            includeZero && count === 0 ? "zero" : "",
            pluralizer(count, ordinal),
        ].filter(Boolean);
    };
}
exports.useMakePlural = useMakePlural;
exports.defaultPluralizer = useMakePlural({
    pluralizer: make_plural_1.en,
    includeZero: true,
});
class Pluralization {
    constructor(i18n) {
        this.i18n = i18n;
        this.registry = {};
        this.register("default", exports.defaultPluralizer);
    }
    register(locale, pluralizer) {
        this.registry[locale] = pluralizer;
    }
    get(locale) {
        return (this.registry[locale] ||
            this.registry[this.i18n.locale] ||
            this.registry["default"]);
    }
}
exports.Pluralization = Pluralization;
//# sourceMappingURL=Pluralization.js.map