/// <reference types="react" />
import { LayoutChangeEvent, NativeScrollEvent } from 'react-native';
import Animated from 'react-native-reanimated';
import type { SharedScrollContainerProps } from './types';
/**
 * The arguments for the useScrollContainerLogic hook.
 */
interface UseScrollContainerLogicArgs {
    /**
     * The ScrollView or FlatList ref that is rendered in the scroll container.
     *
     * @type {React.RefObject<Animated.ScrollView | Animated.FlatList<any>>}
     */
    scrollRef: React.RefObject<Animated.ScrollView | Animated.FlatList<any>>;
    /**
     * This is a hack to ensure that the larger repositions itself correctly.
     *
     * @type {number}
     * @default 4
     */
    adjustmentOffset?: number;
    /**
     * Whether or not the large header should be shown. This is used to animate the large header in
     * and out.
     *
     * @type {SharedScrollContainerProps['largeHeaderShown']}
     */
    largeHeaderShown: SharedScrollContainerProps['largeHeaderShown'];
    /**
     * Whether or not the large header exists.
     */
    largeHeaderExists: boolean;
    /**
     * Disables the auto fix scroll mechanism. This is useful if you want to disable the auto scroll
     * when the large header is partially visible.
     *
     * @default false
     */
    disableAutoFixScroll?: boolean;
    /**
     * This property controls whether or not the header component is absolutely positioned.
     * This is useful if you want to render a header component that allows for transparency.
     */
    absoluteHeader?: boolean;
    /**
     * This property is used when `absoluteHeader` is true. This is the initial height of the
     * absolute header. Since the header's height is computed on its layout event, this is used
     * to set the initial height of the header so that it doesn't jump when it is initially rendered.
     */
    initialAbsoluteHeaderHeight?: number;
    /**
     * A number between 0 and 1 representing at what point the header should fade in,
     * based on the percentage of the LargeHeader's height. For example, if this is set to 0.5,
     * the header will fade in when the scroll position is at 50% of the LargeHeader's height.
     *
     * @default 1
     */
    headerFadeInThreshold?: number;
    /**
     * Whether or not the scroll container is inverted.
     */
    inverted?: boolean;
    /**
     * A custom worklet that allows custom tracking scroll container's
     * state (i.e., its scroll contentInset, contentOffset, etc.). Please
     * ensure that this function is a [worklet](https://docs.swmansion.com/react-native-reanimated/docs/2.x/fundamentals/worklets/).
     */
    onScrollWorklet?: (evt: NativeScrollEvent) => void;
}
/**
 * This hook computes the animation logic for the scroll container.
 *
 * @param {UseScrollContainerLogicArgs} args
 * @returns {ReturnType<UseScrollContainerLogicArgs>}
 */
export declare const useScrollContainerLogic: ({ scrollRef, largeHeaderShown, largeHeaderExists, disableAutoFixScroll, adjustmentOffset, absoluteHeader, initialAbsoluteHeaderHeight, headerFadeInThreshold, inverted, onScrollWorklet, }: UseScrollContainerLogicArgs) => {
    scrollY: import("react-native-reanimated").SharedValue<number>;
    showNavBar: Readonly<Animated.SharedValue<0 | 1>>;
    largeHeaderHeight: import("react-native-reanimated").SharedValue<number>;
    largeHeaderOpacity: Readonly<Animated.SharedValue<number>>;
    scrollHandler: (event: import("react-native").NativeSyntheticEvent<NativeScrollEvent>) => void;
    debouncedFixScroll: import("use-debounce").DebouncedState<() => void>;
    absoluteHeaderHeight: number;
    onAbsoluteHeaderLayout: (e: LayoutChangeEvent) => void;
    scrollViewAdjustments: {
        scrollIndicatorInsets: {
            top: number;
            bottom: number;
        };
        contentContainerStyle: {
            paddingTop: number;
            paddingBottom: number;
        };
    };
};
export {};
//# sourceMappingURL=useScrollContainerLogic.d.ts.map