import React from 'react';
import { StyleSheet } from 'react-native';
import Animated, { interpolateColor, useAnimatedStyle } from 'react-native-reanimated';
const HeaderBottomBorder = _ref => {
  let {
    opacity,
    style,
    initialBorderColor = '#E5E5E5',
    borderColor = '#E5E5E5',
    borderWidth = 1
  } = _ref;
  const borderBottomStyle = useAnimatedStyle(() => ({
    backgroundColor: interpolateColor(opacity.value, [0, 1], [initialBorderColor, borderColor])
  }), [initialBorderColor, borderColor]);
  return /*#__PURE__*/React.createElement(Animated.View, {
    style: [styles.line, borderBottomStyle, {
      height: borderWidth
    }, style]
  });
};
export default HeaderBottomBorder;
const styles = StyleSheet.create({
  line: {
    width: '100%'
  }
});
//# sourceMappingURL=HeaderBottomBorder.js.map