import React, { useMemo } from 'react';
import { useWindowDimensions } from 'react-native';
import { StyleSheet, View } from 'react-native';
import { useSafeAreaInsets } from 'react-native-safe-area-context';
import { FadingView } from '../containers';
import { HeaderBottomBorder } from '../line';
const MIN_CENTER_WIDTH_PRC = 0.4;
const Header = _ref => {
  let {
    showNavBar,
    headerStyle,
    headerLeft = null,
    headerLeftStyle,
    headerLeftFadesIn,
    headerCenter = null,
    headerCenterStyle,
    headerCenterFadesIn = true,
    headerRight = null,
    headerRightStyle,
    headerRightFadesIn,
    noBottomBorder = false,
    ignoreTopSafeArea = false,
    borderColor,
    initialBorderColor,
    borderWidth,
    SurfaceComponent
  } = _ref;
  const {
    top
  } = useSafeAreaInsets();
  const dimensions = useWindowDimensions();
  const headerCenterExists = !!headerCenter;
  const {
    centerWidth,
    minSideHeaderWidth
  } = useMemo(() => {
    const _centerWidth = headerCenterExists ? MIN_CENTER_WIDTH_PRC * dimensions.width : 0;
    const _minSideHeaderWidth = (dimensions.width - _centerWidth) / 2;
    return {
      centerWidth: _centerWidth,
      minSideHeaderWidth: _minSideHeaderWidth
    };
  }, [headerCenterExists, dimensions]);
  const noHeaderLeftRight = !headerLeft && !headerRight;
  return /*#__PURE__*/React.createElement(View, null, SurfaceComponent && SurfaceComponent({
    showNavBar
  }), /*#__PURE__*/React.createElement(View, {
    style: [styles.container, !ignoreTopSafeArea && {
      paddingTop: top
    }, headerStyle]
  }, headerLeftFadesIn ? /*#__PURE__*/React.createElement(FadingView, {
    opacity: showNavBar,
    style: [styles.leftContainer, noHeaderLeftRight && styles.noFlex, {
      width: minSideHeaderWidth
    }, headerLeftStyle]
  }, headerLeft) : /*#__PURE__*/React.createElement(View, {
    style: [styles.leftContainer, noHeaderLeftRight && styles.noFlex, {
      width: minSideHeaderWidth
    }, headerLeftStyle]
  }, headerLeft), headerCenter && (headerCenterFadesIn ? /*#__PURE__*/React.createElement(FadingView, {
    opacity: showNavBar,
    style: [styles.centerContainer, {
      minWidth: centerWidth
    }, headerCenterStyle]
  }, headerCenter) : /*#__PURE__*/React.createElement(View, {
    style: [styles.centerContainer, {
      width: centerWidth
    }, headerCenterStyle]
  }, headerCenter)), headerRightFadesIn ? /*#__PURE__*/React.createElement(FadingView, {
    opacity: showNavBar,
    style: [styles.rightContainer, noHeaderLeftRight && styles.noFlex, {
      width: minSideHeaderWidth
    }, headerRightStyle]
  }, headerRight) : /*#__PURE__*/React.createElement(View, {
    style: [styles.rightContainer, noHeaderLeftRight && styles.noFlex, {
      width: minSideHeaderWidth
    }, headerRightStyle]
  }, headerRight)), !noBottomBorder && /*#__PURE__*/React.createElement(HeaderBottomBorder, {
    opacity: showNavBar,
    borderColor: borderColor,
    initialBorderColor: initialBorderColor,
    borderWidth: borderWidth
  }));
};
export default Header;
const styles = StyleSheet.create({
  container: {
    flexDirection: 'row',
    width: '100%',
    alignItems: 'center',
    justifyContent: 'flex-start'
  },
  leftContainer: {
    flexDirection: 'row',
    paddingHorizontal: 8,
    paddingVertical: 4,
    justifyContent: 'flex-start',
    alignItems: 'center',
    overflow: 'hidden'
  },
  centerContainer: {
    flex: 1,
    flexDirection: 'row',
    paddingHorizontal: 6,
    alignItems: 'center',
    justifyContent: 'center'
  },
  rightContainer: {
    flexDirection: 'row-reverse',
    paddingVertical: 4,
    paddingHorizontal: 8,
    alignItems: 'center',
    justifyContent: 'flex-start',
    overflow: 'hidden'
  },
  noFlex: {
    display: 'none'
  }
});
//# sourceMappingURL=Header.js.map