import React from 'react';
import type { GenerationStyle, MapPaletteToThemeType, MaterialYouPalette, MaterialYouThemeContext, ThemeProviderProps } from './Types';
export * from './Types';
export default class MaterialYou {
    static isSupported: boolean;
    /**
     * Generate a complete Material You palette from a single HEX color (seed color).
     *
     * Various styles are available to choose from, each of which dictates how the palette will be generated.
     *
     * **Note:** The input seed color should be in HEX format, #RRGGBB, without the alpha channel, for example, `#1b6ef3`.
     */
    static generatePaletteFromColor: (colorSeed: string, style?: GenerationStyle) => MaterialYouPalette;
    static createThemeContext<T extends MapPaletteToThemeType>(mapPaletteToTheme: T): {
        useMaterialYouTheme: () => ReturnType<T>["light"] & MaterialYouThemeContext;
        ThemeProvider: ({ colorScheme, fallbackColor, generationStyle, seedColor, children, }: ThemeProviderProps) => React.JSX.Element;
    };
    /**
     * Get the Material You color palette from the Android system on the device.
     *
     * If Material You is not supported on the user's device, a color palette generated from a seed color will be returned.
     *
     * @param {string} [fallbackSeedColor='#1b6ef3'] - The seed color in HEX format, #RRGGBB, without the alpha channel (e.g., `#1b6ef3`).
     * @param {GenerationStyle} [style='TONAL_SPOT'] - Various styles are available to choose from, each of which dictates how the palette will be generated.
     */
    static getMaterialYouPalette(fallbackSeedColor?: string, style?: GenerationStyle): MaterialYouPalette;
}
//# sourceMappingURL=index.d.ts.map