export default class ColorUtils {
    static XYZ_WHITE_REFERENCE_X: number;
    static XYZ_WHITE_REFERENCE_Y: number;
    static XYZ_WHITE_REFERENCE_Z: number;
    static constrain(amount: number, low: number, high: number): number;
    /**
     * Converts a color from CIE XYZ to its RGB representation.
     *
     * This method expects the XYZ representation to use the D65 illuminant and the CIE
     * 2° Standard Observer (1931).
     *
     * @param x X component value [0...95.047)
     * @param y Y component value [0...100)
     * @param z Z component value [0...108.883)
     * @return int containing the RGB representation
     */
    static XYZToColor(x: number, y: number, z: number): number;
    /**
     * Convert a color appearance model representation to an ARGB color.
     *
     * Note: the returned color may have a lower chroma than requested. Whether a chroma is
     * available depends on luminance. For example, there's no such thing as a high chroma light
     * red, due to the limitations of our eyes and/or physics. If the requested chroma is
     * unavailable, the highest possible chroma at the requested luminance is returned.
     *
     * @param hue    hue, in degrees, in CAM coordinates
     * @param chroma chroma in CAM coordinates.
     * @param lstar  perceptual luminance, L* in L*a*b*
     */
    static CAMToColor(hue: number, chroma: number, lstar: number): number;
}
//# sourceMappingURL=ColorUtils.d.ts.map