import { Material3Scheme, Material3Theme } from './ExpoMaterial3Theme.types';
export declare const isDynamicThemeSupported: boolean;
/**
 * Hook to manage material3 theme.
 *
 * It returns:
 * - a Material 3 theme:
 *   - the system theme (or a fallback theme if not supported) if sourceColor is not provided
 *   - a theme based on sourceColor if provided
 * - a function to update the theme based on a source color
 * - a function to reset the theme to default
 *
 * @param params.fallbackSourceColor - optional - source color for the fallback theme (default to #6750A4)
 * @param params.sourceColor - optional - source color for the theme (overwrite system theme)
 * @returns
 */
export declare function useMaterial3Theme(params?: {
    fallbackSourceColor?: string;
    sourceColor?: string;
}): {
    theme: Material3Theme;
    updateTheme: (sourceColor: string) => void;
    resetTheme: () => void;
};
/**
 * Get the Material 3 theme from the system (works only on Android 12+).
 *
 * If the system does not support Material3, it will return a theme based on the fallback source color.
 *
 * @param fallbackSourceColor source color for the fallback theme (default to #6750A4)
 * @returns
 */
export declare function getMaterial3Theme(fallbackSourceColor?: string): Material3Theme;
export declare function getMaterial3ThemeAsync(fallbackSourceColor?: string): Promise<Material3Theme>;
/**
 * Create a Material 3 theme based on the source color.
 *
 * @param sourceColor source color for the theme
 * @returns
 */
export declare function createMaterial3Theme(sourceColor: string): Material3Theme;
export { Material3Scheme, Material3Theme };
//# sourceMappingURL=index.d.ts.map