import React from 'react';
import { StyleProp, ViewStyle } from 'react-native';
import Animated from 'react-native-reanimated';
interface HeaderBottomBorderProps {
    /**
     * Animated value that controls the opacity of the bottom border.
     *
     * @type {Animated.SharedValue<number>}
     */
    opacity: Animated.SharedValue<number>;
    /**
     * Style of the bottom border component.
     */
    style?: StyleProp<ViewStyle>;
    /**
     *
     */
    initialBorderColor?: string;
    /**
     * Color of the bottom border.
     *
     * @default '#E5E5E5'
     */
    borderColor?: string;
    /**
     * Width of the bottom border.
     *
     * @default 1
     */
    borderWidth?: number;
}
declare const HeaderBottomBorder: React.FC<HeaderBottomBorderProps>;
export default HeaderBottomBorder;
//# sourceMappingURL=HeaderBottomBorder.d.ts.map