import React from 'react';
import { StyleSheet, View } from 'react-native';
const LH_VERTICAL_PADDING = 6;
const LH_HORIZONTAL_PADDING = 12;

/**
 * A convenience component to wrap your large header content with.
 *
 * @param {LargeHeaderProps} props
 */
const LargeHeader = _ref => {
  let {
    headerStyle,
    children
  } = _ref;
  return /*#__PURE__*/React.createElement(View, {
    style: [styles.headerContainer, headerStyle]
  }, children);
};
export default LargeHeader;
const styles = StyleSheet.create({
  headerContainer: {
    width: '100%',
    flexDirection: 'row',
    justifyContent: 'space-between',
    paddingVertical: LH_VERTICAL_PADDING,
    paddingHorizontal: LH_HORIZONTAL_PADDING
  }
});
//# sourceMappingURL=LargeHeader.js.map