function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React from 'react';
import { Dimensions } from 'react-native';
import Animated, { Extrapolate, interpolate, useAnimatedStyle, useSharedValue } from 'react-native-reanimated';
/**
 * A view that scales and translates based on the scroll position. This is useful for
 * mimicking the behavior of the iOS navigation bar.
 *
 * @param {AnimatedScalingViewProps} props
 */
const AnimatedScalingView = _ref => {
  let {
    style,
    startRange = 0,
    startScale = 1,
    endRange = Dimensions.get('window').height * 0.1,
    endScale = 1.05,
    scrollY,
    translationDirection = 'right',
    children,
    ...viewProps
  } = _ref;
  const width = useSharedValue(0);
  const animatedStyle = useAnimatedStyle(() => {
    const scaleInterpolation = interpolate(-scrollY.value, [startRange, endRange], [startScale, endScale], Extrapolate.CLAMP);
    if (translationDirection === 'none') {
      return {
        transform: [{
          scale: scaleInterpolation
        }]
      };
    }
    if (translationDirection === 'right') {
      const scaleTransformOffset = interpolate(scaleInterpolation, [startScale, endScale], [0, width.value * (endScale - startScale) / 2], Extrapolate.CLAMP);
      return {
        transform: [{
          scale: scaleInterpolation
        }, {
          translateX: scaleTransformOffset
        }]
      };
    }

    // For now, we only support right translations.
    // TODO: Implement left translations.
    return {};
  }, [translationDirection, startRange, endRange, startScale, endScale]);
  return /*#__PURE__*/React.createElement(Animated.View, _extends({
    onLayout: evt => width.value = evt.nativeEvent.layout.width,
    style: [animatedStyle, style]
  }, viewProps), children);
};
export default AnimatedScalingView;
//# sourceMappingURL=ScalingView.js.map