function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useImperativeHandle } from 'react';
import { StyleSheet, View } from 'react-native';
import { useSafeAreaInsets } from 'react-native-safe-area-context';
import Animated, { useAnimatedRef } from 'react-native-reanimated';
import { FlashList } from '@shopify/flash-list';
import FadingView from './FadingView';
import { useScrollContainerLogic } from './useScrollContainerLogic';
const AnimatedFlashList = Animated.createAnimatedComponent(FlashList);
const FlashListWithHeadersInputComp = (_ref, ref) => {
  let {
    largeHeaderShown,
    containerStyle,
    LargeHeaderSubtitleComponent,
    LargeHeaderComponent,
    largeHeaderContainerStyle,
    HeaderComponent,
    onLargeHeaderLayout,
    onScrollBeginDrag,
    onScrollEndDrag,
    onScrollWorklet,
    onMomentumScrollBegin,
    onMomentumScrollEnd,
    ignoreLeftSafeArea,
    ignoreRightSafeArea,
    disableAutoFixScroll = false,
    // We use this to ensure that the onScroll property isn't accidentally used.
    // @ts-ignore
    onScroll: _unusedOnScroll,
    absoluteHeader = false,
    initialAbsoluteHeaderHeight = 0,
    contentContainerStyle = {},
    automaticallyAdjustsScrollIndicatorInsets,
    headerFadeInThreshold = 1,
    disableLargeHeaderFadeAnim = false,
    scrollIndicatorInsets = {},
    inverted,
    ...rest
  } = _ref;
  if (_unusedOnScroll) {
    throw new Error("The 'onScroll' property is not supported. Please use onScrollWorklet to track the scroll container's state.");
  }
  const insets = useSafeAreaInsets();
  const scrollRef = useAnimatedRef();
  useImperativeHandle(ref, () => scrollRef.current);
  const {
    scrollY,
    showNavBar,
    largeHeaderHeight,
    largeHeaderOpacity,
    scrollHandler,
    debouncedFixScroll,
    onAbsoluteHeaderLayout,
    scrollViewAdjustments
  } = useScrollContainerLogic({
    scrollRef,
    largeHeaderShown,
    disableAutoFixScroll,
    largeHeaderExists: !!LargeHeaderComponent,
    absoluteHeader,
    initialAbsoluteHeaderHeight,
    headerFadeInThreshold,
    inverted: !!inverted,
    onScrollWorklet
  });
  return /*#__PURE__*/React.createElement(View, {
    style: [styles.container, containerStyle, !ignoreLeftSafeArea && {
      paddingLeft: insets.left
    }, !ignoreRightSafeArea && {
      paddingRight: insets.right
    }]
  }, !absoluteHeader && HeaderComponent({
    showNavBar,
    scrollY
  }), /*#__PURE__*/React.createElement(AnimatedFlashList, _extends({
    ref: scrollRef,
    scrollEventThrottle: 16,
    overScrollMode: "auto",
    onScroll: scrollHandler,
    automaticallyAdjustContentInsets: false,
    onScrollBeginDrag: e => {
      debouncedFixScroll.cancel();
      if (onScrollBeginDrag) onScrollBeginDrag(e);
    },
    onScrollEndDrag: e => {
      debouncedFixScroll();
      if (onScrollEndDrag) onScrollEndDrag(e);
    },
    onMomentumScrollBegin: e => {
      debouncedFixScroll.cancel();
      if (onMomentumScrollBegin) onMomentumScrollBegin(e);
    },
    onMomentumScrollEnd: e => {
      debouncedFixScroll();
      if (onMomentumScrollEnd) onMomentumScrollEnd(e);
    },
    contentContainerStyle: {
      // The reason why we do this is because FlashList does not support an array of
      // styles (will throw a warning when you supply one).
      ...scrollViewAdjustments.contentContainerStyle,
      ...contentContainerStyle
    },
    automaticallyAdjustsScrollIndicatorInsets: automaticallyAdjustsScrollIndicatorInsets !== undefined ? automaticallyAdjustsScrollIndicatorInsets : !absoluteHeader,
    scrollIndicatorInsets: {
      ...scrollViewAdjustments.scrollIndicatorInsets,
      ...scrollIndicatorInsets
    },
    ListHeaderComponent: /*#__PURE__*/React.createElement(React.Fragment, null, LargeHeaderComponent && /*#__PURE__*/React.createElement(View, {
      onLayout: e => {
        largeHeaderHeight.value = e.nativeEvent.layout.height;
        if (onLargeHeaderLayout) onLargeHeaderLayout(e.nativeEvent.layout);
      }
    }, !disableLargeHeaderFadeAnim ? /*#__PURE__*/React.createElement(FadingView, {
      opacity: largeHeaderOpacity,
      style: largeHeaderContainerStyle
    }, LargeHeaderComponent({
      scrollY,
      showNavBar
    })) : /*#__PURE__*/React.createElement(View, {
      style: largeHeaderContainerStyle
    }, LargeHeaderComponent({
      scrollY,
      showNavBar
    }))), LargeHeaderSubtitleComponent && LargeHeaderSubtitleComponent({
      showNavBar,
      scrollY
    })),
    inverted: inverted
  }, rest)), absoluteHeader && /*#__PURE__*/React.createElement(View, {
    style: styles.absoluteHeader,
    onLayout: onAbsoluteHeaderLayout
  }, HeaderComponent({
    showNavBar,
    scrollY
  })));
};

// The typecast is needed to make the component generic.
const FlashListWithHeaders = /*#__PURE__*/React.forwardRef(FlashListWithHeadersInputComp);
export default FlashListWithHeaders;
const styles = StyleSheet.create({
  container: {
    flex: 1
  },
  absoluteHeader: {
    position: 'absolute',
    top: 0,
    right: 0,
    left: 0
  }
});
//# sourceMappingURL=FlashList.js.map