import { Image, findNodeHandle } from 'react-native';
// eslint-disable-next-line @typescript-eslint/no-explicit-any
export function generateHeaderForNative(obj) {
    if (!obj) {
        return [];
    }
    return Object.entries(obj).map(([key, value]) => ({ key, value }));
}
export function resolveAssetSourceForVideo(source) {
    // will convert source id to uri
    const convertToUri = (sourceItem) => {
        const resolveItem = Image.resolveAssetSource(sourceItem);
        if (resolveItem) {
            return resolveItem.uri;
        }
        else {
            console.warn('cannot resolve item ', sourceItem);
            return undefined;
        }
    };
    // This is deprecated, but we need to support it for backward compatibility
    if (typeof source === 'number') {
        return {
            uri: convertToUri(source),
        };
    }
    if ('uri' in source && typeof source.uri === 'number') {
        return {
            ...source,
            uri: convertToUri(source.uri),
        };
    }
    return source;
}
export function getReactTag(ref) {
    if (!ref.current) {
        throw new Error('Video Component is not mounted');
    }
    const reactTag = findNodeHandle(ref.current);
    if (!reactTag) {
        throw new Error('Cannot find reactTag for Video Component in components tree');
    }
    return reactTag;
}
//# sourceMappingURL=utils.js.map