import type { MaterialYouPalette, GenerationStyle } from '../Types';
type StyleType = Record<GenerationStyle, Record<'a1' | 'a2' | 'a3' | 'n1' | 'n2', [number, number]>>;
export default class Palette {
    static ACCENT1_CHROMA: number;
    static ACCENT2_CHROMA: number;
    static ACCENT3_CHROMA: number;
    static ACCENT3_HUE_SHIFT: number;
    static NEUTRAL1_CHROMA: number;
    static NEUTRAL2_CHROMA: number;
    static GOOGLE_BLUE: number;
    static getStyle(hue: number, chroma: number): StyleType;
    static HueAdd(hue: number, amountDegrees: number): number;
    static HueSubtract(hue: number, amountDegrees: number): number;
    static ChromaMultiple(chroma: number, multiple: number): number;
    static getHueRotation(sourceHue: number, hueAndRotations: Array<[number, number]>): number;
    static HueVibrantSecondary(hue: number): number;
    static HueVibrantTertiary(hue: number): number;
    static HueExpressiveSecondary(hue: number): number;
    static HueExpressiveTertiary(hue: number): number;
    static wrapDegreesDouble(degrees: number): number;
    static generate(seed: string, style?: GenerationStyle): MaterialYouPalette;
}
export {};
//# sourceMappingURL=Palette.d.ts.map