import*as e from"../../core/common/common.js";import*as t from"../../core/host/host.js";import*as s from"../../core/i18n/i18n.js";import*as i from"../../core/sdk/sdk.js";import*as r from"../../third_party/marked/marked.js";import*as n from"../../core/root/root.js";import*as o from"../bindings/bindings.js";import*as a from"../workspace/workspace.js";const u={improvements:"Improvements",pageErrors:"Page Errors",breakingChanges:"Breaking Changes",pageErrorIssue:"A page error issue: the page is not working correctly",breakingChangeIssue:"A breaking change issue: the page may stop working in an upcoming version of Chrome",improvementIssue:"An improvement issue: there is an opportunity to improve the page"},l=s.i18n.registerUIStrings("models/issues_manager/Issue.ts",u),d=s.i18n.getLocalizedString.bind(void 0,l);var c,g;!function(e){e.CrossOriginEmbedderPolicy="CrossOriginEmbedderPolicy",e.Generic="Generic",e.MixedContent="MixedContent",e.Cookie="Cookie",e.HeavyAd="HeavyAd",e.ContentSecurityPolicy="ContentSecurityPolicy",e.LowTextContrast="LowTextContrast",e.Cors="Cors",e.AttributionReporting="AttributionReporting",e.QuirksMode="QuirksMode",e.Other="Other"}(c||(c={})),function(e){e.PageError="PageError",e.BreakingChange="BreakingChange",e.Improvement="Improvement"}(g||(g={}));class m{#e;#t;issueId=void 0;#s;constructor(e,s=null,i){this.#e="object"==typeof e?e.code:e,this.#t=s,this.issueId=i,t.userMetrics.issueCreated("string"==typeof e?e:e.umaCode),this.#s=!1}code(){return this.#e}getBlockedByResponseDetails(){return[]}cookies(){return[]}rawCookieLines(){return[]}elements(){return[]}requests(){return[]}sources(){return[]}trackingSites(){return[]}isAssociatedWithRequestId(e){for(const t of this.requests())if(t.requestId===e)return!0;return!1}model(){return this.#t}isCausedByThirdParty(){return!1}getIssueId(){return this.issueId}isHidden(){return this.#s}setHidden(e){this.#s=e}}function h(e){if(e)return{url:e.url,scriptId:e.scriptId,lineNumber:e.lineNumber,columnNumber:0===e.columnNumber?void 0:e.columnNumber-1}}var p=Object.freeze({__proto__:null,get IssueCategory(){return c},get IssueKind(){return g},getIssueKindName:function(e){switch(e){case g.BreakingChange:return d(u.breakingChanges);case g.Improvement:return d(u.improvements);case g.PageError:return d(u.pageErrors)}},getIssueKindDescription:function(e){switch(e){case g.PageError:return d(u.pageErrorIssue);case g.BreakingChange:return d(u.breakingChangeIssue);case g.Improvement:return d(u.improvementIssue)}},unionIssueKind:function(e,t){return e===g.PageError||t===g.PageError?g.PageError:e===g.BreakingChange||t===g.BreakingChange?g.BreakingChange:g.Improvement},getShowThirdPartyIssuesSetting:function(){return e.Settings.Settings.instance().createSetting("showThirdPartyIssues",!1)},Issue:m,toZeroBasedLocation:h});const I={link:"https://tools.ietf.org/id/draft-ietf-httpbis-header-structure-15.html#rfc.section.4.2.2",linkTitle:"Structured Headers RFC"};class f extends m{issueDetails;constructor(e,t){super(function(e){switch(e.violationType){case"PermissionPolicyDisabled":return"AttributionReportingIssue::PermissionPolicyDisabled";case"UntrustworthyReportingOrigin":return"AttributionReportingIssue::UntrustworthyReportingOrigin";case"InsecureContext":return"AttributionReportingIssue::InsecureContext";case"InvalidHeader":return"AttributionReportingIssue::InvalidRegisterSourceHeader";case"InvalidRegisterTriggerHeader":return"AttributionReportingIssue::InvalidRegisterTriggerHeader";case"SourceAndTriggerHeaders":return"AttributionReportingIssue::SourceAndTriggerHeaders";case"SourceIgnored":return"AttributionReportingIssue::SourceIgnored";case"TriggerIgnored":return"AttributionReportingIssue::TriggerIgnored";case"OsSourceIgnored":return"AttributionReportingIssue::OsSourceIgnored";case"OsTriggerIgnored":return"AttributionReportingIssue::OsTriggerIgnored";case"InvalidRegisterOsSourceHeader":return"AttributionReportingIssue::InvalidRegisterOsSourceHeader";case"InvalidRegisterOsTriggerHeader":return"AttributionReportingIssue::InvalidRegisterOsTriggerHeader";case"WebAndOsHeaders":return"AttributionReportingIssue::WebAndOsHeaders";default:return"AttributionReportingIssue::Unknown"}}(e),t),this.issueDetails=e}getCategory(){return c.AttributionReporting}getHeaderValidatorLink(e){const t=new URL("https://wicg.github.io/attribution-reporting-api/validate-headers");return t.searchParams.set("header",e),this.issueDetails.invalidParameter&&t.searchParams.set("json",this.issueDetails.invalidParameter),{link:t.toString(),linkTitle:"Header Validator"}}getDescription(){switch(this.code()){case"AttributionReportingIssue::PermissionPolicyDisabled":return{file:"arPermissionPolicyDisabled.md",links:[]};case"AttributionReportingIssue::UntrustworthyReportingOrigin":return{file:"arUntrustworthyReportingOrigin.md",links:[]};case"AttributionReportingIssue::InsecureContext":return{file:"arInsecureContext.md",links:[]};case"AttributionReportingIssue::InvalidRegisterSourceHeader":return{file:"arInvalidRegisterSourceHeader.md",links:[this.getHeaderValidatorLink("source")]};case"AttributionReportingIssue::InvalidRegisterTriggerHeader":return{file:"arInvalidRegisterTriggerHeader.md",links:[this.getHeaderValidatorLink("trigger")]};case"AttributionReportingIssue::InvalidRegisterOsSourceHeader":return{file:"arInvalidRegisterOsSourceHeader.md",links:[this.getHeaderValidatorLink("os-source")]};case"AttributionReportingIssue::InvalidRegisterOsTriggerHeader":return{file:"arInvalidRegisterOsTriggerHeader.md",links:[this.getHeaderValidatorLink("os-trigger")]};case"AttributionReportingIssue::SourceAndTriggerHeaders":return{file:"arSourceAndTriggerHeaders.md",links:[]};case"AttributionReportingIssue::WebAndOsHeaders":return{file:"arWebAndOsHeaders.md",links:[]};case"AttributionReportingIssue::SourceIgnored":return{file:"arSourceIgnored.md",links:[I]};case"AttributionReportingIssue::TriggerIgnored":return{file:"arTriggerIgnored.md",links:[I]};case"AttributionReportingIssue::OsSourceIgnored":return{file:"arOsSourceIgnored.md",links:[I]};case"AttributionReportingIssue::OsTriggerIgnored":return{file:"arOsTriggerIgnored.md",links:[I]};case"AttributionReportingIssue::Unknown":return null}}primaryKey(){return JSON.stringify(this.issueDetails)}getKind(){switch(this.code()){case"AttributionReportingIssue::PermissionPolicyDisabled":case"AttributionReportingIssue::UntrustworthyReportingOrigin":case"AttributionReportingIssue::InsecureContext":case"AttributionReportingIssue::InvalidRegisterSourceHeader":case"AttributionReportingIssue::InvalidRegisterTriggerHeader":case"AttributionReportingIssue::InvalidRegisterOsSourceHeader":case"AttributionReportingIssue::InvalidRegisterOsTriggerHeader":case"AttributionReportingIssue::SourceAndTriggerHeaders":case"AttributionReportingIssue::WebAndOsHeaders":case"AttributionReportingIssue::SourceIgnored":case"AttributionReportingIssue::TriggerIgnored":case"AttributionReportingIssue::OsSourceIgnored":case"AttributionReportingIssue::OsTriggerIgnored":case"AttributionReportingIssue::Unknown":return g.PageError}}static fromInspectorIssue(e,t){const{attributionReportingIssueDetails:s}=t.details;return s?[new f(s,e)]:(console.warn("Attribution Reporting issue without details received."),[])}}var k=Object.freeze({__proto__:null,AttributionReportingIssue:f});let C=null;class S{constructor(){i.TargetManager.TargetManager.instance().addModelListener(i.ResourceTreeModel.ResourceTreeModel,i.ResourceTreeModel.Events.Load,this.#i,this,{scoped:!0});for(const e of i.TargetManager.TargetManager.instance().models(i.ResourceTreeModel.ResourceTreeModel))e.target().outermostTarget()===e.target()&&this.#r(e)}static instance({forceNew:e}={forceNew:!1}){return C&&!e||(C=new S),C}#r(e){e.target().auditsAgent().invoke_checkFormsIssues()}#i(e){const{resourceTreeModel:t}=e.data;this.#r(t)}}var y=Object.freeze({__proto__:null,CheckFormsIssuesTrigger:S});function w(e){const t=new Map;e.substitutions?.forEach(((e,s)=>{t.set(s,e())}));return{file:e.file,links:e.links.map((function(e){return{link:e.link,linkTitle:e.linkTitle()}})),substitutions:t}}async function v(e){try{return(await fetch(e.toString())).text()}catch(t){throw new Error(`Markdown file ${e.toString()} not found. Make sure it is correctly listed in the relevant BUILD.gn files.`)}}async function b(e){return v(new URL(`descriptions/${e}`,import.meta.url))}function T(e,t){const s=r.Marked.lexer(e),i=D(s);if(!i)throw new Error("Markdown issue descriptions must start with a heading");return{title:i,markdown:s.slice(1),links:t.links}}const A=/\{(PLACEHOLDER_[a-zA-Z][a-zA-Z0-9]*)\}/g,R=/PLACEHOLDER_[a-zA-Z][a-zA-Z0-9]*/;function P(e,t){const s=new Set(t?t.keys():[]);!function(e){const t=[...e].filter((e=>!R.test(e)));if(t.length>0)throw new Error(`Invalid placeholders provided in the substitutions map: ${t}`)}(s);const i=e.replace(A,((e,i)=>{const r=t?t.get(i):void 0;if(!r)throw new Error(`No replacment provided for placeholder '${i}'.`);return s.delete(i),r}));if(s.size>0)throw new Error(`Unused replacements provided: ${[...s]}`);return i}function D(e){return 0===e.length||"heading"!==e[0].type||1!==e[0].depth?null:e[0].text}async function M(e){const t=await b(e.file);return D(r.Marked.lexer(t))}var E=Object.freeze({__proto__:null,resolveLazyDescription:w,getFileContent:v,getMarkdownFileContent:b,createIssueDescriptionFromMarkdown:async function(e){return T(P(await b(e.file),e.substitutions),e)},createIssueDescriptionFromRawMarkdown:T,substitutePlaceholders:P,findTitleFromMarkdownAst:D,getIssueTitleFromMarkdownDescription:M});const F={clientHintsInfrastructure:"Client Hints Infrastructure"},x=s.i18n.registerUIStrings("models/issues_manager/ClientHintIssue.ts",F),L=s.i18n.getLazilyComputedLocalizedString.bind(void 0,x);class O extends m{issueDetails;constructor(e,t){super({code:"ClientHintIssue",umaCode:["ClientHintIssue",e.clientHintIssueReason].join("::")},t),this.issueDetails=e}getCategory(){return c.Other}details(){return this.issueDetails}getDescription(){const e=N.get(this.issueDetails.clientHintIssueReason);return e?w(e):null}sources(){return[this.issueDetails.sourceCodeLocation]}primaryKey(){return JSON.stringify(this.issueDetails)}getKind(){return g.BreakingChange}static fromInspectorIssue(e,t){const s=t.details.clientHintIssueDetails;return s?[new O(s,e)]:(console.warn("Client Hint issue without details received."),[])}}const N=new Map([["MetaTagAllowListInvalidOrigin",{file:"clientHintMetaTagAllowListInvalidOrigin.md",links:[{link:"https://wicg.github.io/client-hints-infrastructure/",linkTitle:L(F.clientHintsInfrastructure)}]}],["MetaTagModifiedHTML",{file:"clientHintMetaTagModifiedHTML.md",links:[{link:"https://wicg.github.io/client-hints-infrastructure/",linkTitle:L(F.clientHintsInfrastructure)}]}]]);var H=Object.freeze({__proto__:null,ClientHintIssue:O});const U={contentSecurityPolicySource:"Content Security Policy - Source Allowlists",contentSecurityPolicyInlineCode:"Content Security Policy - Inline Code",contentSecurityPolicyEval:"Content Security Policy - Eval",trustedTypesFixViolations:"Trusted Types - Fix violations",trustedTypesPolicyViolation:"Trusted Types - Policy violation"},_=s.i18n.registerUIStrings("models/issues_manager/ContentSecurityPolicyIssue.ts",U),W=s.i18n.getLazilyComputedLocalizedString.bind(void 0,_);class q extends m{#n;constructor(e,t,s){super(["ContentSecurityPolicyIssue",e.contentSecurityPolicyViolationType].join("::"),t,s),this.#n=e}getCategory(){return c.ContentSecurityPolicy}primaryKey(){return JSON.stringify(this.#n,["blockedURL","contentSecurityPolicyViolationType","violatedDirective","isReportOnly","sourceCodeLocation","url","lineNumber","columnNumber","violatingNodeId"])}getDescription(){const e=X.get(this.#n.contentSecurityPolicyViolationType);return e?w(e):null}details(){return this.#n}getKind(){return this.#n.isReportOnly?g.Improvement:g.PageError}static fromInspectorIssue(e,t){const s=t.details.contentSecurityPolicyIssueDetails;return s?[new q(s,e,t.issueId)]:(console.warn("Content security policy issue without details received."),[])}}const B={file:"cspURLViolation.md",links:[{link:"https://developers.google.com/web/fundamentals/security/csp#source_allowlists",linkTitle:W(U.contentSecurityPolicySource)}]},z={file:"cspInlineViolation.md",links:[{link:"https://developers.google.com/web/fundamentals/security/csp#inline_code_is_considered_harmful",linkTitle:W(U.contentSecurityPolicyInlineCode)}]},V={file:"cspEvalViolation.md",links:[{link:"https://developers.google.com/web/fundamentals/security/csp#eval_too",linkTitle:W(U.contentSecurityPolicyEval)}]},j={file:"cspTrustedTypesSinkViolation.md",links:[{link:"https://web.dev/trusted-types/#fix-the-violations",linkTitle:W(U.trustedTypesFixViolations)}]},K={file:"cspTrustedTypesPolicyViolation.md",links:[{link:"https://web.dev/trusted-types/",linkTitle:W(U.trustedTypesPolicyViolation)}]},$=["ContentSecurityPolicyIssue","kURLViolation"].join("::"),G=["ContentSecurityPolicyIssue","kInlineViolation"].join("::"),Q=["ContentSecurityPolicyIssue","kEvalViolation"].join("::"),J=["ContentSecurityPolicyIssue","kTrustedTypesSinkViolation"].join("::"),Y=["ContentSecurityPolicyIssue","kTrustedTypesPolicyViolation"].join("::"),X=new Map([["kURLViolation",B],["kInlineViolation",z],["kEvalViolation",V],["kTrustedTypesSinkViolation",j],["kTrustedTypesPolicyViolation",K]]);var Z=Object.freeze({__proto__:null,ContentSecurityPolicyIssue:q,urlViolationCode:$,inlineViolationCode:G,evalViolationCode:Q,trustedTypesSinkViolationCode:J,trustedTypesPolicyViolationCode:Y});let ee=null;class te{#o=new WeakMap;#a=new WeakMap;constructor(){i.TargetManager.TargetManager.instance().observeModels(i.ResourceTreeModel.ResourceTreeModel,this)}static instance({forceNew:e}={forceNew:!1}){return ee&&!e||(ee=new te),ee}async modelAdded(e){this.#o.set(e,e.addEventListener(i.ResourceTreeModel.Events.Load,this.#i,this)),this.#a.set(e,e.addEventListener(i.ResourceTreeModel.Events.FrameAdded,this.#u,this))}modelRemoved(t){const s=this.#o.get(t);s&&e.EventTarget.removeEventListeners([s]);const i=this.#a.get(t);i&&e.EventTarget.removeEventListeners([i])}#l(e){n.Runtime.experiments.isEnabled("contrastIssues")&&e.target().auditsAgent().invoke_checkContrast({})}#i(e){const{resourceTreeModel:t}=e.data;this.#l(t)}async#u(e){if(!n.Runtime.experiments.isEnabled("contrastIssues"))return;const t=e.data;if(!t.isMainFrame())return;const s=await t.resourceTreeModel().target().runtimeAgent().invoke_evaluate({expression:"document.readyState",returnByValue:!0});s.result&&"complete"===s.result.value&&this.#l(t.resourceTreeModel())}}var se=Object.freeze({__proto__:null,ContrastCheckTrigger:te});const ie={samesiteCookiesExplained:"SameSite cookies explained",howSchemefulSamesiteWorks:"How Schemeful Same-Site Works",aSecure:"a secure",anInsecure:"an insecure",firstPartySetsExplained:"`First-Party Sets` and the `SameParty` attribute"},re=s.i18n.registerUIStrings("models/issues_manager/CookieIssue.ts",ie),ne=s.i18n.getLazilyComputedLocalizedString.bind(void 0,re);class oe extends m{#n;constructor(e,t,s){super(e,s),this.#n=t}#d(){if(this.#n.cookie){const{domain:e,path:t,name:s}=this.#n.cookie;return`${e};${t};${s}`}return this.#n.rawCookieLine??"no-cookie-info"}primaryKey(){const e=this.#n.request?this.#n.request.requestId:"no-request";return`${this.code()}-(${this.#d()})-(${e})`}static createIssuesFromCookieIssueDetails(e,t){const s=[];if(e.cookieExclusionReasons&&e.cookieExclusionReasons.length>0){for(const i of e.cookieExclusionReasons){const r=oe.codeForCookieIssueDetails(i,e.cookieWarningReasons,e.operation,e.cookieUrl);r&&s.push(new oe(r,e,t))}return s}if(e.cookieWarningReasons)for(const i of e.cookieWarningReasons){const r=oe.codeForCookieIssueDetails(i,[],e.operation,e.cookieUrl);r&&s.push(new oe(r,e,t))}return s}static codeForCookieIssueDetails(e,t,s,i){const r=i&&(i.startsWith("https://")||i.startsWith("wss://"))?"Secure":"Insecure";if("ExcludeSameSiteStrict"===e||"ExcludeSameSiteLax"===e||"ExcludeSameSiteUnspecifiedTreatedAsLax"===e){if(t&&t.length>0){if(t.includes("WarnSameSiteStrictLaxDowngradeStrict"))return["CookieIssue","ExcludeNavigationContextDowngrade",r].join("::");if(t.includes("WarnSameSiteStrictCrossDowngradeStrict")||t.includes("WarnSameSiteStrictCrossDowngradeLax")||t.includes("WarnSameSiteLaxCrossDowngradeStrict")||t.includes("WarnSameSiteLaxCrossDowngradeLax"))return["CookieIssue","ExcludeContextDowngrade",s,r].join("::")}return"ExcludeSameSiteUnspecifiedTreatedAsLax"===e?["CookieIssue",e,s].join("::"):null}return"WarnSameSiteStrictLaxDowngradeStrict"===e?["CookieIssue",e,r].join("::"):"WarnSameSiteStrictCrossDowngradeStrict"===e||"WarnSameSiteStrictCrossDowngradeLax"===e||"WarnSameSiteLaxCrossDowngradeLax"===e||"WarnSameSiteLaxCrossDowngradeStrict"===e?["CookieIssue","WarnCrossDowngrade",s,r].join("::"):["CookieIssue",e,s].join("::")}cookies(){return this.#n.cookie?[this.#n.cookie]:[]}rawCookieLines(){return this.#n.rawCookieLine?[this.#n.rawCookieLine]:[]}requests(){return this.#n.request?[this.#n.request]:[]}getCategory(){return c.Cookie}getDescription(){const e=Me.get(this.code());return e?w(e):null}isCausedByThirdParty(){return ae(i.FrameManager.FrameManager.instance().getOutermostFrame(),this.#n.cookieUrl)}getKind(){return this.#n.cookieExclusionReasons?.length>0?g.PageError:g.BreakingChange}static fromInspectorIssue(e,t){const s=t.details.cookieIssueDetails;return s?oe.createIssuesFromCookieIssueDetails(s,e):(console.warn("Cookie issue without details received."),[])}}function ae(t,s){if(!t)return!0;if(!s||""===t.domainAndRegistry())return!1;const i=e.ParsedURL.ParsedURL.fromString(s);return!!i&&!function(e,t){if(e.length<=t.length)return e===t;if(!e.endsWith(t))return!1;return e.substr(0,e.length-t.length).endsWith(".")}(i.domain(),t.domainAndRegistry())}const ue={file:"SameSiteUnspecifiedTreatedAsLaxRead.md",links:[{link:"https://web.dev/samesite-cookies-explained/",linkTitle:ne(ie.samesiteCookiesExplained)}]},le={file:"SameSiteUnspecifiedTreatedAsLaxSet.md",links:[{link:"https://web.dev/samesite-cookies-explained/",linkTitle:ne(ie.samesiteCookiesExplained)}]},de={file:"SameSiteUnspecifiedLaxAllowUnsafeRead.md",links:[{link:"https://web.dev/samesite-cookies-explained/",linkTitle:ne(ie.samesiteCookiesExplained)}]},ce={file:"SameSiteUnspecifiedLaxAllowUnsafeSet.md",links:[{link:"https://web.dev/samesite-cookies-explained/",linkTitle:ne(ie.samesiteCookiesExplained)}]},ge={file:"SameSiteNoneInsecureErrorRead.md",links:[{link:"https://web.dev/samesite-cookies-explained/",linkTitle:ne(ie.samesiteCookiesExplained)}]},me={file:"SameSiteNoneInsecureErrorSet.md",links:[{link:"https://web.dev/samesite-cookies-explained/",linkTitle:ne(ie.samesiteCookiesExplained)}]},he={file:"SameSiteNoneInsecureWarnRead.md",links:[{link:"https://web.dev/samesite-cookies-explained/",linkTitle:ne(ie.samesiteCookiesExplained)}]},pe={file:"SameSiteNoneInsecureWarnSet.md",links:[{link:"https://web.dev/samesite-cookies-explained/",linkTitle:ne(ie.samesiteCookiesExplained)}]},Ie=[{link:"https://web.dev/schemeful-samesite/",linkTitle:ne(ie.howSchemefulSamesiteWorks)}];function fe({isDestinationSecure:e,isOriginSecure:t}){return new Map([["PLACEHOLDER_destination",()=>e?"a secure":"an insecure"],["PLACEHOLDER_origin",()=>t?"a secure":"an insecure"]])}function ke(e){return{file:"SameSiteWarnStrictLaxDowngradeStrict.md",substitutions:fe({isDestinationSecure:e,isOriginSecure:!e}),links:Ie}}function Ce(e){return{file:"SameSiteExcludeNavigationContextDowngrade.md",substitutions:fe({isDestinationSecure:e,isOriginSecure:!e}),links:Ie}}function Se(e){return{file:"SameSiteWarnCrossDowngradeRead.md",substitutions:fe({isDestinationSecure:e,isOriginSecure:!e}),links:Ie}}function ye(e){return{file:"SameSiteExcludeContextDowngradeRead.md",substitutions:fe({isDestinationSecure:e,isOriginSecure:!e}),links:Ie}}function we(e){return{file:"SameSiteWarnCrossDowngradeSet.md",substitutions:fe({isDestinationSecure:!e,isOriginSecure:e}),links:Ie}}function ve(e){return{file:"SameSiteExcludeContextDowngradeSet.md",substitutions:fe({isDestinationSecure:e,isOriginSecure:!e}),links:Ie}}const be={file:"SameSiteInvalidSameParty.md",links:[{link:"https://developer.chrome.com/blog/first-party-sets-sameparty/",linkTitle:ne(ie.firstPartySetsExplained)}]},Te={file:"SameSiteSamePartyCrossPartyContextSet.md",links:[{link:"https://developer.chrome.com/blog/first-party-sets-sameparty/",linkTitle:ne(ie.firstPartySetsExplained)}]},Ae={file:"CookieAttributeValueExceedsMaxSize.md",links:[]},Re={file:"cookieWarnDomainNonAscii.md",links:[]},Pe={file:"cookieExcludeDomainNonAscii.md",links:[]},De={file:"cookieExcludeBlockedWithinFirstPartySet.md",links:[]},Me=new Map([["CookieIssue::ExcludeSameSiteUnspecifiedTreatedAsLax::ReadCookie",ue],["CookieIssue::ExcludeSameSiteUnspecifiedTreatedAsLax::SetCookie",le],["CookieIssue::WarnSameSiteUnspecifiedLaxAllowUnsafe::ReadCookie",de],["CookieIssue::WarnSameSiteUnspecifiedLaxAllowUnsafe::SetCookie",ce],["CookieIssue::WarnSameSiteUnspecifiedCrossSiteContext::ReadCookie",de],["CookieIssue::WarnSameSiteUnspecifiedCrossSiteContext::SetCookie",ce],["CookieIssue::ExcludeSameSiteNoneInsecure::ReadCookie",ge],["CookieIssue::ExcludeSameSiteNoneInsecure::SetCookie",me],["CookieIssue::WarnSameSiteNoneInsecure::ReadCookie",he],["CookieIssue::WarnSameSiteNoneInsecure::SetCookie",pe],["CookieIssue::WarnSameSiteStrictLaxDowngradeStrict::Secure",ke(!0)],["CookieIssue::WarnSameSiteStrictLaxDowngradeStrict::Insecure",ke(!1)],["CookieIssue::WarnCrossDowngrade::ReadCookie::Secure",Se(!0)],["CookieIssue::WarnCrossDowngrade::ReadCookie::Insecure",Se(!1)],["CookieIssue::WarnCrossDowngrade::SetCookie::Secure",we(!0)],["CookieIssue::WarnCrossDowngrade::SetCookie::Insecure",we(!1)],["CookieIssue::ExcludeNavigationContextDowngrade::Secure",Ce(!0)],["CookieIssue::ExcludeNavigationContextDowngrade::Insecure",Ce(!1)],["CookieIssue::ExcludeContextDowngrade::ReadCookie::Secure",ye(!0)],["CookieIssue::ExcludeContextDowngrade::ReadCookie::Insecure",ye(!1)],["CookieIssue::ExcludeContextDowngrade::SetCookie::Secure",ve(!0)],["CookieIssue::ExcludeContextDowngrade::SetCookie::Insecure",ve(!1)],["CookieIssue::ExcludeInvalidSameParty::SetCookie",be],["CookieIssue::ExcludeSamePartyCrossPartyContext::SetCookie",Te],["CookieIssue::WarnAttributeValueExceedsMaxSize::ReadCookie",Ae],["CookieIssue::WarnAttributeValueExceedsMaxSize::SetCookie",Ae],["CookieIssue::WarnDomainNonASCII::ReadCookie",Re],["CookieIssue::WarnDomainNonASCII::SetCookie",Re],["CookieIssue::ExcludeDomainNonASCII::ReadCookie",Pe],["CookieIssue::ExcludeDomainNonASCII::SetCookie",Pe],["CookieIssue::ExcludeThirdPartyCookieBlockedInFirstPartySet::ReadCookie",De],["CookieIssue::ExcludeThirdPartyCookieBlockedInFirstPartySet::SetCookie",De]]);var Ee=Object.freeze({__proto__:null,CookieIssue:oe,isCausedByThirdParty:ae});const Fe={corsPrivateNetworkAccess:"Private Network Access",CORS:"Cross-Origin Resource Sharing (`CORS`)"},xe=s.i18n.registerUIStrings("models/issues_manager/CorsIssue.ts",Fe),Le=s.i18n.getLocalizedString.bind(void 0,xe);var Oe;function Ne(e){switch(e.corsErrorStatus.corsError){case"InvalidAllowMethodsPreflightResponse":case"InvalidAllowHeadersPreflightResponse":case"PreflightMissingAllowOriginHeader":case"PreflightMultipleAllowOriginValues":case"PreflightInvalidAllowOriginValue":case"MissingAllowOriginHeader":case"MultipleAllowOriginValues":case"InvalidAllowOriginValue":return Oe.InvalidHeaderValues;case"PreflightWildcardOriginNotAllowed":case"WildcardOriginNotAllowed":return Oe.WildcardOriginNotAllowed;case"PreflightInvalidStatus":case"PreflightDisallowedRedirect":case"InvalidResponse":return Oe.PreflightResponseInvalid;case"AllowOriginMismatch":case"PreflightAllowOriginMismatch":return Oe.OriginMismatch;case"InvalidAllowCredentials":case"PreflightInvalidAllowCredentials":return Oe.AllowCredentialsRequired;case"MethodDisallowedByPreflightResponse":return Oe.MethodDisallowedByPreflightResponse;case"HeaderDisallowedByPreflightResponse":return Oe.HeaderDisallowedByPreflightResponse;case"RedirectContainsCredentials":return Oe.RedirectContainsCredentials;case"DisallowedByMode":return Oe.DisallowedByMode;case"CorsDisabledScheme":return Oe.CorsDisabledScheme;case"PreflightMissingAllowExternal":return Oe.PreflightMissingAllowExternal;case"PreflightInvalidAllowExternal":return Oe.PreflightInvalidAllowExternal;case"InsecurePrivateNetwork":return Oe.InsecurePrivateNetwork;case"NoCorsRedirectModeNotFollow":return Oe.NoCorsRedirectModeNotFollow;case"InvalidPrivateNetworkAccess":return Oe.InvalidPrivateNetworkAccess;case"UnexpectedPrivateNetworkAccess":return Oe.UnexpectedPrivateNetworkAccess;case"PreflightMissingAllowPrivateNetwork":case"PreflightInvalidAllowPrivateNetwork":return Oe.PreflightAllowPrivateNetworkError}}!function(e){e.InsecurePrivateNetwork="CorsIssue::InsecurePrivateNetwork",e.InvalidHeaderValues="CorsIssue::InvalidHeaders",e.WildcardOriginNotAllowed="CorsIssue::WildcardOriginWithCredentials",e.PreflightResponseInvalid="CorsIssue::PreflightResponseInvalid",e.OriginMismatch="CorsIssue::OriginMismatch",e.AllowCredentialsRequired="CorsIssue::AllowCredentialsRequired",e.MethodDisallowedByPreflightResponse="CorsIssue::MethodDisallowedByPreflightResponse",e.HeaderDisallowedByPreflightResponse="CorsIssue::HeaderDisallowedByPreflightResponse",e.RedirectContainsCredentials="CorsIssue::RedirectContainsCredentials",e.DisallowedByMode="CorsIssue::DisallowedByMode",e.CorsDisabledScheme="CorsIssue::CorsDisabledScheme",e.PreflightMissingAllowExternal="CorsIssue::PreflightMissingAllowExternal",e.PreflightInvalidAllowExternal="CorsIssue::PreflightInvalidAllowExternal",e.NoCorsRedirectModeNotFollow="CorsIssue::NoCorsRedirectModeNotFollow",e.InvalidPrivateNetworkAccess="CorsIssue::InvalidPrivateNetworkAccess",e.UnexpectedPrivateNetworkAccess="CorsIssue::UnexpectedPrivateNetworkAccess",e.PreflightAllowPrivateNetworkError="CorsIssue::PreflightAllowPrivateNetworkError"}(Oe||(Oe={}));class He extends m{#n;constructor(e,t,s){super(Ne(e),t,s),this.#n=e}getCategory(){return c.Cors}details(){return this.#n}getDescription(){switch(Ne(this.#n)){case Oe.InsecurePrivateNetwork:return{file:"corsInsecurePrivateNetwork.md",links:[{link:"https://developer.chrome.com/blog/private-network-access-update",linkTitle:Le(Fe.corsPrivateNetworkAccess)}]};case Oe.PreflightAllowPrivateNetworkError:return{file:"corsPreflightAllowPrivateNetworkError.md",links:[{link:"https://developer.chrome.com/blog/private-network-access-update",linkTitle:Le(Fe.corsPrivateNetworkAccess)}]};case Oe.InvalidHeaderValues:return{file:"corsInvalidHeaderValues.md",links:[{link:"https://web.dev/cross-origin-resource-sharing",linkTitle:Le(Fe.CORS)}]};case Oe.WildcardOriginNotAllowed:return{file:"corsWildcardOriginNotAllowed.md",links:[{link:"https://web.dev/cross-origin-resource-sharing",linkTitle:Le(Fe.CORS)}]};case Oe.PreflightResponseInvalid:return{file:"corsPreflightResponseInvalid.md",links:[{link:"https://web.dev/cross-origin-resource-sharing",linkTitle:Le(Fe.CORS)}]};case Oe.OriginMismatch:return{file:"corsOriginMismatch.md",links:[{link:"https://web.dev/cross-origin-resource-sharing",linkTitle:Le(Fe.CORS)}]};case Oe.AllowCredentialsRequired:return{file:"corsAllowCredentialsRequired.md",links:[{link:"https://web.dev/cross-origin-resource-sharing",linkTitle:Le(Fe.CORS)}]};case Oe.MethodDisallowedByPreflightResponse:return{file:"corsMethodDisallowedByPreflightResponse.md",links:[{link:"https://web.dev/cross-origin-resource-sharing",linkTitle:Le(Fe.CORS)}]};case Oe.HeaderDisallowedByPreflightResponse:return{file:"corsHeaderDisallowedByPreflightResponse.md",links:[{link:"https://web.dev/cross-origin-resource-sharing",linkTitle:Le(Fe.CORS)}]};case Oe.RedirectContainsCredentials:return{file:"corsRedirectContainsCredentials.md",links:[{link:"https://web.dev/cross-origin-resource-sharing",linkTitle:Le(Fe.CORS)}]};case Oe.DisallowedByMode:return{file:"corsDisallowedByMode.md",links:[{link:"https://web.dev/cross-origin-resource-sharing",linkTitle:Le(Fe.CORS)}]};case Oe.CorsDisabledScheme:return{file:"corsDisabledScheme.md",links:[{link:"https://web.dev/cross-origin-resource-sharing",linkTitle:Le(Fe.CORS)}]};case Oe.NoCorsRedirectModeNotFollow:return{file:"corsNoCorsRedirectModeNotFollow.md",links:[{link:"https://web.dev/cross-origin-resource-sharing",linkTitle:Le(Fe.CORS)}]};case Oe.PreflightMissingAllowExternal:case Oe.PreflightInvalidAllowExternal:case Oe.InvalidPrivateNetworkAccess:case Oe.UnexpectedPrivateNetworkAccess:return null}}primaryKey(){return JSON.stringify(this.#n)}getKind(){return!this.#n.isWarning||"InsecurePrivateNetwork"!==this.#n.corsErrorStatus.corsError&&"PreflightMissingAllowPrivateNetwork"!==this.#n.corsErrorStatus.corsError&&"PreflightInvalidAllowPrivateNetwork"!==this.#n.corsErrorStatus.corsError?g.PageError:g.BreakingChange}static fromInspectorIssue(e,t){const s=t.details.corsIssueDetails;return s?[new He(s,e,t.issueId)]:(console.warn("Cors issue without details received."),[])}}var Ue=Object.freeze({__proto__:null,get IssueCode(){return Oe},CorsIssue:He});const _e={coopAndCoep:"COOP and COEP",samesiteAndSameorigin:"Same-Site and Same-Origin"},We=s.i18n.registerUIStrings("models/issues_manager/CrossOriginEmbedderPolicyIssue.ts",_e),qe=s.i18n.getLazilyComputedLocalizedString.bind(void 0,We);function Be(e){switch(e){case"CoepFrameResourceNeedsCoepHeader":case"CoopSandboxedIFrameCannotNavigateToCoopPage":case"CorpNotSameOrigin":case"CorpNotSameOriginAfterDefaultedToSameOriginByCoep":case"CorpNotSameSite":return!0}return!1}class ze extends m{#n;constructor(e,t){super(`CrossOriginEmbedderPolicyIssue::${e.reason}`,t),this.#n=e}primaryKey(){return`${this.code()}-(${this.#n.request.requestId})`}getBlockedByResponseDetails(){return[this.#n]}requests(){return[this.#n.request]}getCategory(){return c.CrossOriginEmbedderPolicy}getDescription(){const e=Ve.get(this.code());return e?w(e):null}getKind(){return g.PageError}}const Ve=new Map([["CrossOriginEmbedderPolicyIssue::CorpNotSameOriginAfterDefaultedToSameOriginByCoep",{file:"CoepCorpNotSameOriginAfterDefaultedToSameOriginByCoep.md",links:[{link:"https://web.dev/coop-coep/",linkTitle:qe(_e.coopAndCoep)},{link:"https://web.dev/same-site-same-origin/",linkTitle:qe(_e.samesiteAndSameorigin)}]}],["CrossOriginEmbedderPolicyIssue::CoepFrameResourceNeedsCoepHeader",{file:"CoepFrameResourceNeedsCoepHeader.md",links:[{link:"https://web.dev/coop-coep/",linkTitle:qe(_e.coopAndCoep)}]}],["CrossOriginEmbedderPolicyIssue::CoopSandboxedIframeCannotNavigateToCoopPage",{file:"CoepCoopSandboxedIframeCannotNavigateToCoopPage.md",links:[{link:"https://web.dev/coop-coep/",linkTitle:qe(_e.coopAndCoep)}]}],["CrossOriginEmbedderPolicyIssue::CorpNotSameSite",{file:"CoepCorpNotSameSite.md",links:[{link:"https://web.dev/coop-coep/",linkTitle:qe(_e.coopAndCoep)},{link:"https://web.dev/same-site-same-origin/",linkTitle:qe(_e.samesiteAndSameorigin)}]}],["CrossOriginEmbedderPolicyIssue::CorpNotSameOrigin",{file:"CoepCorpNotSameOrigin.md",links:[{link:"https://web.dev/coop-coep/",linkTitle:qe(_e.coopAndCoep)},{link:"https://web.dev/same-site-same-origin/",linkTitle:qe(_e.samesiteAndSameorigin)}]}]]);var je=Object.freeze({__proto__:null,isCrossOriginEmbedderPolicyIssue:Be,CrossOriginEmbedderPolicyIssue:ze});const Ke={AuthorizationCoveredByWildcard:"Authorization will not be covered by the wildcard symbol (*) in CORS `Access-Control-Allow-Headers` handling.",CanRequestURLHTTPContainingNewline:"Resource requests whose URLs contained both removed whitespace `\\(n|r|t)` characters and less-than characters (`<`) are blocked. Please remove newlines and encode less-than characters from places like element attribute values in order to load these resources.",ChromeLoadTimesConnectionInfo:"`chrome.loadTimes()` is deprecated, instead use standardized API: Navigation Timing 2.",ChromeLoadTimesFirstPaintAfterLoadTime:"`chrome.loadTimes()` is deprecated, instead use standardized API: Paint Timing.",ChromeLoadTimesWasAlternateProtocolAvailable:"`chrome.loadTimes()` is deprecated, instead use standardized API: `nextHopProtocol` in Navigation Timing 2.",CookieWithTruncatingChar:"Cookies containing a `\\(0|r|n)` character will be rejected instead of truncated.",CrossOriginAccessBasedOnDocumentDomain:"Relaxing the same-origin policy by setting `document.domain` is deprecated, and will be disabled by default. This deprecation warning is for a cross-origin access that was enabled by setting `document.domain`.",CrossOriginWindowAlert:"Triggering window.alert from cross origin iframes has been deprecated and will be removed in the future.",CrossOriginWindowConfirm:"Triggering window.confirm from cross origin iframes has been deprecated and will be removed in the future.",CSSSelectorInternalMediaControlsOverlayCastButton:"The `disableRemotePlayback` attribute should be used in order to disable the default Cast integration instead of using `-internal-media-controls-overlay-cast-button` selector.",DataUrlInSvgUse:"Support for data: URLs in SVGUseElement is deprecated and it will be removed in the future.",DocumentDomainSettingWithoutOriginAgentClusterHeader:"Relaxing the same-origin policy by setting `document.domain` is deprecated, and will be disabled by default. To continue using this feature, please opt-out of origin-keyed agent clusters by sending an `Origin-Agent-Cluster: ?0` header along with the HTTP response for the document and frames. See https://developer.chrome.com/blog/immutable-document-domain/ for more details.",DOMMutationEvents:"DOM Mutation Events, including `DOMSubtreeModified`, `DOMNodeInserted`, `DOMNodeRemoved`, `DOMNodeRemovedFromDocument`, `DOMNodeInsertedIntoDocument`, and `DOMCharacterDataModified` are deprecated (https://w3c.github.io/uievents/#legacy-event-types) and will be removed. Please use `MutationObserver` instead.",ExpectCTHeader:"The `Expect-CT` header is deprecated and will be removed. Chrome requires Certificate Transparency for all publicly trusted certificates issued after April 30, 2018.",GeolocationInsecureOrigin:"`getCurrentPosition()` and `watchPosition()` no longer work on insecure origins. To use this feature, you should consider switching your application to a secure origin, such as HTTPS. See https://goo.gle/chrome-insecure-origins for more details.",GeolocationInsecureOriginDeprecatedNotRemoved:"`getCurrentPosition()` and `watchPosition()` are deprecated on insecure origins. To use this feature, you should consider switching your application to a secure origin, such as HTTPS. See https://goo.gle/chrome-insecure-origins for more details.",GetUserMediaInsecureOrigin:"`getUserMedia()` no longer works on insecure origins. To use this feature, you should consider switching your application to a secure origin, such as HTTPS. See https://goo.gle/chrome-insecure-origins for more details.",HostCandidateAttributeGetter:"`RTCPeerConnectionIceErrorEvent.hostCandidate` is deprecated. Please use `RTCPeerConnectionIceErrorEvent.address` or `RTCPeerConnectionIceErrorEvent.port` instead.",IdentityInCanMakePaymentEvent:"The merchant origin and arbitrary data from the `canmakepayment` service worker event are deprecated and will be removed: `topOrigin`, `paymentRequestOrigin`, `methodData`, `modifiers`.",InsecurePrivateNetworkSubresourceRequest:"The website requested a subresource from a network that it could only access because of its users' privileged network position. These requests expose non-public devices and servers to the internet, increasing the risk of a cross-site request forgery (CSRF) attack, and/or information leakage. To mitigate these risks, Chrome deprecates requests to non-public subresources when initiated from non-secure contexts, and will start blocking them.",InterestGroupDailyUpdateUrl:"The `dailyUpdateUrl` field of `InterestGroups` passed to `joinAdInterestGroup()` has been renamed to `updateUrl`, to more accurately reflect its behavior.",LocalCSSFileExtensionRejected:"CSS cannot be loaded from `file:` URLs unless they end in a `.css` file extension.",MediaSourceAbortRemove:"Using `SourceBuffer.abort()` to abort `remove()`'s asynchronous range removal is deprecated due to specification change. Support will be removed in the future. You should listen to the `updateend` event instead. `abort()` is intended to only abort an asynchronous media append or reset parser state.",MediaSourceDurationTruncatingBuffered:"Setting `MediaSource.duration` below the highest presentation timestamp of any buffered coded frames is deprecated due to specification change. Support for implicit removal of truncated buffered media will be removed in the future. You should instead perform explicit `remove(newDuration, oldDuration)` on all `sourceBuffers`, where `newDuration < oldDuration`.",NonStandardDeclarativeShadowDOM:"The older, non-standardized `shadowroot` attribute is deprecated, and will *no longer function* in M119. Please use the new, standardized `shadowrootmode` attribute instead.",NoSysexWebMIDIWithoutPermission:"Web MIDI will ask a permission to use even if the sysex is not specified in the `MIDIOptions`.",NotificationInsecureOrigin:"The Notification API may no longer be used from insecure origins. You should consider switching your application to a secure origin, such as HTTPS. See https://goo.gle/chrome-insecure-origins for more details.",NotificationPermissionRequestedIframe:"Permission for the Notification API may no longer be requested from a cross-origin iframe. You should consider requesting permission from a top-level frame or opening a new window instead.",ObsoleteCreateImageBitmapImageOrientationNone:"Option `imageOrientation: 'none'` in createImageBitmap is deprecated. Please use createImageBitmap with option {imageOrientation: 'from-image'} instead.",ObsoleteWebRtcCipherSuite:"Your partner is negotiating an obsolete (D)TLS version. Please check with your partner to have this fixed.",OverflowVisibleOnReplacedElement:"Specifying `overflow: visible` on img, video and canvas tags may cause them to produce visual content outside of the element bounds. See https://github.com/WICG/shared-element-transitions/blob/main/debugging_overflow_on_images.md.",PaymentInstruments:"`paymentManager.instruments` is deprecated. Please use just-in-time install for payment handlers instead.",PaymentRequestCSPViolation:"Your `PaymentRequest` call bypassed Content-Security-Policy (CSP) `connect-src` directive. This bypass is deprecated. Please add the payment method identifier from the `PaymentRequest` API (in `supportedMethods` field) to your CSP `connect-src` directive.",PersistentQuotaType:"`StorageType.persistent` is deprecated. Please use standardized `navigator.storage` instead.",PictureSourceSrc:"`<source src>` with a `<picture>` parent is invalid and therefore ignored. Please use `<source srcset>` instead.",PrefixedCancelAnimationFrame:"webkitCancelAnimationFrame is vendor-specific. Please use the standard cancelAnimationFrame instead.",PrefixedRequestAnimationFrame:"webkitRequestAnimationFrame is vendor-specific. Please use the standard requestAnimationFrame instead.",PrefixedVideoDisplayingFullscreen:"HTMLVideoElement.webkitDisplayingFullscreen is deprecated. Please use Document.fullscreenElement instead.",PrefixedVideoEnterFullScreen:"HTMLVideoElement.webkitEnterFullScreen() is deprecated. Please use Element.requestFullscreen() instead.",PrefixedVideoEnterFullscreen:"HTMLVideoElement.webkitEnterFullscreen() is deprecated. Please use Element.requestFullscreen() instead.",PrefixedVideoExitFullScreen:"HTMLVideoElement.webkitExitFullScreen() is deprecated. Please use Document.exitFullscreen() instead.",PrefixedVideoExitFullscreen:"HTMLVideoElement.webkitExitFullscreen() is deprecated. Please use Document.exitFullscreen() instead.",PrefixedVideoSupportsFullscreen:"HTMLVideoElement.webkitSupportsFullscreen is deprecated. Please use Document.fullscreenEnabled instead.",PrivacySandboxExtensionsAPI:"We're deprecating the API `chrome.privacy.websites.privacySandboxEnabled`, though it will remain active for backward compatibility until release M113. Instead, please use `chrome.privacy.websites.topicsEnabled`, `chrome.privacy.websites.fledgeEnabled` and `chrome.privacy.websites.adMeasurementEnabled`. See https://developer.chrome.com/docs/extensions/reference/privacy/#property-websites-privacySandboxEnabled.",RangeExpand:"Range.expand() is deprecated. Please use Selection.modify() instead.",RequestedSubresourceWithEmbeddedCredentials:"Subresource requests whose URLs contain embedded credentials (e.g. `https://user:pass@host/`) are blocked.",RTCConstraintEnableDtlsSrtpFalse:"The constraint `DtlsSrtpKeyAgreement` is removed. You have specified a `false` value for this constraint, which is interpreted as an attempt to use the removed `SDES key negotiation` method. This functionality is removed; use a service that supports `DTLS key negotiation` instead.",RTCConstraintEnableDtlsSrtpTrue:"The constraint `DtlsSrtpKeyAgreement` is removed. You have specified a `true` value for this constraint, which had no effect, but you can remove this constraint for tidiness.",RTCPeerConnectionGetStatsLegacyNonCompliant:"The callback-based getStats() is deprecated and will be removed. Use the spec-compliant getStats() instead.",RtcpMuxPolicyNegotiate:"The `rtcpMuxPolicy` option is deprecated and will be removed.",SharedArrayBufferConstructedWithoutIsolation:"`SharedArrayBuffer` will require cross-origin isolation. See https://developer.chrome.com/blog/enabling-shared-array-buffer/ for more details.",TextToSpeech_DisallowedByAutoplay:"`speechSynthesis.speak()` without user activation is deprecated and will be removed.",V8SharedArrayBufferConstructedInExtensionWithoutIsolation:"Extensions should opt into cross-origin isolation to continue using `SharedArrayBuffer`. See https://developer.chrome.com/docs/extensions/mv3/cross-origin-isolation/.",WebSQL:"Web SQL is deprecated. Please use SQLite WebAssembly or Indexed Database",WindowPlacementPermissionDescriptorUsed:"The permission descriptor `window-placement` is deprecated. Use `window-management` instead. For more help, check https://bit.ly/window-placement-rename.",WindowPlacementPermissionPolicyParsed:"The permission policy `window-placement` is deprecated. Use `window-management` instead. For more help, check https://bit.ly/window-placement-rename.",XHRJSONEncodingDetection:"UTF-16 is not supported by response json in `XMLHttpRequest`",XMLHttpRequestSynchronousInNonWorkerOutsideBeforeUnload:"Synchronous `XMLHttpRequest` on the main thread is deprecated because of its detrimental effects to the end user's experience. For more help, check https://xhr.spec.whatwg.org/.",XRSupportsSession:"`supportsSession()` is deprecated. Please use `isSessionSupported()` and check the resolved boolean value instead."},$e={AuthorizationCoveredByWildcard:{milestone:97},CSSSelectorInternalMediaControlsOverlayCastButton:{chromeStatusFeature:5714245488476160},CanRequestURLHTTPContainingNewline:{chromeStatusFeature:5735596811091968},ChromeLoadTimesConnectionInfo:{chromeStatusFeature:5637885046816768},ChromeLoadTimesFirstPaintAfterLoadTime:{chromeStatusFeature:5637885046816768},ChromeLoadTimesWasAlternateProtocolAvailable:{chromeStatusFeature:5637885046816768},CookieWithTruncatingChar:{milestone:103},CrossOriginAccessBasedOnDocumentDomain:{milestone:115},DOMMutationEvents:{chromeStatusFeature:5083947249172480,milestone:127},DataUrlInSvgUse:{chromeStatusFeature:5128825141198848,milestone:119},DocumentDomainSettingWithoutOriginAgentClusterHeader:{milestone:115},ExpectCTHeader:{chromeStatusFeature:6244547273687040,milestone:107},IdentityInCanMakePaymentEvent:{chromeStatusFeature:5190978431352832},InsecurePrivateNetworkSubresourceRequest:{chromeStatusFeature:5436853517811712,milestone:92},LocalCSSFileExtensionRejected:{milestone:64},MediaSourceAbortRemove:{chromeStatusFeature:6107495151960064},MediaSourceDurationTruncatingBuffered:{chromeStatusFeature:6107495151960064},NoSysexWebMIDIWithoutPermission:{chromeStatusFeature:5138066234671104,milestone:82},NonStandardDeclarativeShadowDOM:{chromeStatusFeature:6239658726391808,milestone:119},NotificationPermissionRequestedIframe:{chromeStatusFeature:6451284559265792},ObsoleteCreateImageBitmapImageOrientationNone:{milestone:111},ObsoleteWebRtcCipherSuite:{milestone:81},OverflowVisibleOnReplacedElement:{chromeStatusFeature:5137515594383360,milestone:108},PaymentInstruments:{chromeStatusFeature:5099285054488576},PaymentRequestCSPViolation:{chromeStatusFeature:6286595631087616},PersistentQuotaType:{chromeStatusFeature:5176235376246784,milestone:106},RTCConstraintEnableDtlsSrtpFalse:{milestone:97},RTCConstraintEnableDtlsSrtpTrue:{milestone:97},RTCPeerConnectionGetStatsLegacyNonCompliant:{chromeStatusFeature:4631626228695040,milestone:117},RequestedSubresourceWithEmbeddedCredentials:{chromeStatusFeature:5669008342777856},RtcpMuxPolicyNegotiate:{chromeStatusFeature:5654810086866944,milestone:62},SharedArrayBufferConstructedWithoutIsolation:{milestone:106},TextToSpeech_DisallowedByAutoplay:{chromeStatusFeature:5687444770914304,milestone:71},V8SharedArrayBufferConstructedInExtensionWithoutIsolation:{milestone:96},WebSQL:{chromeStatusFeature:5134293578285056,milestone:115},WindowPlacementPermissionDescriptorUsed:{chromeStatusFeature:5137018030391296,milestone:112},WindowPlacementPermissionPolicyParsed:{chromeStatusFeature:5137018030391296,milestone:112},XHRJSONEncodingDetection:{milestone:93},XRSupportsSession:{milestone:80}},Ge={feature:"Check the feature status page for more details.",milestone:"This change will go into effect with milestone {milestone}.",title:"Deprecated Feature Used"},Qe=s.i18n.registerUIStrings("models/issues_manager/DeprecationIssue.ts",Ge),Je=s.i18n.getLazilyComputedLocalizedString.bind(void 0,Qe),Ye=s.i18n.registerUIStrings("generated/Deprecation.ts",Ke),Xe=s.i18n.getLazilyComputedLocalizedString.bind(void 0,Ye);class Ze extends m{#n;constructor(e,t){super({code:["DeprecationIssue",e.type].join("::"),umaCode:"DeprecationIssue"},t),this.#n=e}getCategory(){return c.Other}details(){return this.#n}getDescription(){let e=()=>"";const t=Ke[this.#n.type];t&&(e=Xe(t));const s=[],i=$e[this.#n.type],r=i?.chromeStatusFeature??0;0!==r&&s.push({link:`https://chromestatus.com/feature/${r}`,linkTitle:Je(Ge.feature)});const n=i?.milestone??0;return 0!==n&&s.push({link:"https://chromiumdash.appspot.com/schedule",linkTitle:Je(Ge.milestone,{milestone:n})}),w({file:"deprecation.md",substitutions:new Map([["PLACEHOLDER_title",Je(Ge.title)],["PLACEHOLDER_message",e]]),links:s})}sources(){return this.#n.sourceCodeLocation?[this.#n.sourceCodeLocation]:[]}primaryKey(){return JSON.stringify(this.#n)}getKind(){return g.BreakingChange}static fromInspectorIssue(e,t){const s=t.details.deprecationIssueDetails;return s?[new Ze(s,e)]:(console.warn("Deprecation issue without details received."),[])}}var et=Object.freeze({__proto__:null,DeprecationIssue:Ze});const tt={fedCmUserInfo:"Federated Credential Management User Info API"},st=s.i18n.registerUIStrings("models/issues_manager/FederatedAuthUserInfoRequestIssue.ts",tt),it=s.i18n.getLazilyComputedLocalizedString.bind(void 0,st);class rt extends m{#n;constructor(e,t){super({code:"FederatedAuthUserInfoRequestIssue",umaCode:["FederatedAuthUserInfoRequestIssue",e.federatedAuthUserInfoRequestIssueReason].join("::")},t),this.#n=e}getCategory(){return c.Other}details(){return this.#n}getDescription(){const e=nt.get(this.#n.federatedAuthUserInfoRequestIssueReason);return e?w(e):null}primaryKey(){return JSON.stringify(this.#n)}getKind(){return g.PageError}static fromInspectorIssue(e,t){const s=t.details.federatedAuthUserInfoRequestIssueDetails;return s?[new rt(s,e)]:(console.warn("Federated auth user info request issue without details received."),[])}}const nt=new Map([["NotSameOrigin",{file:"federatedAuthUserInfoRequestNotSameOrigin.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:it(tt.fedCmUserInfo)}]}],["NotIframe",{file:"federatedAuthUserInfoRequestNotIframe.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:it(tt.fedCmUserInfo)}]}],["NotPotentiallyTrustworthy",{file:"federatedAuthUserInfoRequestNotPotentiallyTrustworthy.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:it(tt.fedCmUserInfo)}]}],["NoApiPermission",{file:"federatedAuthUserInfoRequestNoApiPermission.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:it(tt.fedCmUserInfo)}]}],["NotSignedInWithIdp",{file:"federatedAuthUserInfoRequestNotSignedInWithIdp.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:it(tt.fedCmUserInfo)}]}],["NoAccountSharingPermission",{file:"federatedAuthUserInfoRequestNoAccountSharingPermission.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:it(tt.fedCmUserInfo)}]}],["InvalidConfigOrWellKnown",{file:"federatedAuthUserInfoRequestInvalidConfigOrWellKnown.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:it(tt.fedCmUserInfo)}]}],["InvalidAccountsResponse",{file:"federatedAuthUserInfoRequestInvalidAccountsResponse.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:it(tt.fedCmUserInfo)}]}],["NoReturningUserFromFetchedAccounts",{file:"federatedAuthUserInfoRequestNoReturningUserFromFetchedAccounts.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:it(tt.fedCmUserInfo)}]}]]);var ot=Object.freeze({__proto__:null,FederatedAuthUserInfoRequestIssue:rt});const at={crossOriginPortalPostMessage:"Portals - Same-origin communication channels",howDoesAutofillWorkPageTitle:"How does autofill work?",labelFormlementsPageTitle:"The label elements",inputFormElementPageTitle:"The form input element",autocompleteAttributePageTitle:"HTML attribute: autocomplete"},ut=s.i18n.registerUIStrings("models/issues_manager/GenericIssue.ts",at),lt=s.i18n.getLazilyComputedLocalizedString.bind(void 0,ut);class dt extends m{#n;constructor(e,t,s){super(["GenericIssue",e.errorType].join("::"),t,s),this.#n=e}getCategory(){return c.Generic}primaryKey(){return`${this.code()}-(${this.#n.frameId})-(${this.#n.violatingNodeId})-(${this.#n.violatingNodeAttribute})`}getDescription(){const e=wt.get(this.#n.errorType);return e?w(e):null}details(){return this.#n}getKind(){return vt.get(this.#n.errorType)||g.Improvement}static fromInspectorIssue(e,t){const s=t.details.genericIssueDetails;return s?[new dt(s,e,t.issueId)]:(console.warn("Generic issue without details received."),[])}}const ct={file:"genericCrossOriginPortalPostMessageError.md",links:[{link:"https://github.com/WICG/portals#same-origin-communication-channels",linkTitle:lt(at.crossOriginPortalPostMessage)}]},gt={file:"genericFormLabelForNameError.md",links:[{link:"https://html.spec.whatwg.org/multipage/forms.html#attr-label-for",linkTitle:s.i18n.lockedLazyString("HTML Standard")}]},mt={file:"genericFormInputWithNoLabelError.md",links:[]},ht={file:"genericFormAutocompleteAttributeEmptyError.md",links:[]},pt={file:"genericFormDuplicateIdForInputError.md",links:[{link:"https://web.dev/learn/forms/autofill/#how-does-autofill-work",linkTitle:lt(at.howDoesAutofillWorkPageTitle)}]},It={file:"genericFormAriaLabelledByToNonExistingId.md",links:[{link:"https://developer.mozilla.org/en-US/docs/Web/HTML/Element/label",linkTitle:lt(at.labelFormlementsPageTitle)}]},ft={file:"genericFormEmptyIdAndNameAttributesForInputError.md",links:[{link:"https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input",linkTitle:lt(at.inputFormElementPageTitle)}]},kt={file:"genericFormInputAssignedAutocompleteValueToIdOrNameAttributeError.md",links:[{link:"https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/autocomplete#values",linkTitle:lt(at.autocompleteAttributePageTitle)}]},Ct={file:"genericFormInputHasWrongButWellIntendedAutocompleteValueError.md",links:[{link:"https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/autocomplete#values",linkTitle:lt(at.autocompleteAttributePageTitle)}]},St={file:"genericFormLabelForMatchesNonExistingIdError.md",links:[{link:"https://developer.mozilla.org/en-US/docs/Web/HTML/Element/label",linkTitle:lt(at.labelFormlementsPageTitle)}]},yt={file:"genericFormLabelHasNeitherForNorNestedInput.md",links:[{link:"https://developer.mozilla.org/en-US/docs/Web/HTML/Element/label",linkTitle:lt(at.labelFormlementsPageTitle)}]},wt=new Map([["CrossOriginPortalPostMessageError",ct],["FormLabelForNameError",gt],["FormInputWithNoLabelError",mt],["FormAutocompleteAttributeEmptyError",ht],["FormDuplicateIdForInputError",pt],["FormAriaLabelledByToNonExistingId",It],["FormEmptyIdAndNameAttributesForInputError",ft],["FormInputAssignedAutocompleteValueToIdOrNameAttributeError",kt],["FormLabelForMatchesNonExistingIdError",St],["FormLabelHasNeitherForNorNestedInput",yt],["FormInputHasWrongButWellIntendedAutocompleteValueError",Ct]]),vt=new Map([["CrossOriginPortalPostMessageError",g.Improvement],["FormLabelForNameError",g.PageError],["FormInputWithNoLabelError",g.Improvement],["FormAutocompleteAttributeEmptyError",g.PageError],["FormDuplicateIdForInputError",g.PageError],["FormAriaLabelledByToNonExistingId",g.Improvement],["FormEmptyIdAndNameAttributesForInputError",g.Improvement],["FormInputAssignedAutocompleteValueToIdOrNameAttributeError",g.Improvement],["FormLabelForMatchesNonExistingIdError",g.PageError],["FormLabelHasNeitherForNorNestedInput",g.Improvement],["FormInputHasWrongButWellIntendedAutocompleteValueError",g.Improvement]]);var bt=Object.freeze({__proto__:null,GenericIssue:dt,genericCrossOriginPortalPostMessageError:ct,genericFormLabelForNameError:gt,genericFormInputWithNoLabelError:mt,genericFormAutocompleteAttributeEmptyError:ht,genericFormDuplicateIdForInputError:pt,genericFormAriaLabelledByToNonExistingId:It,genericFormEmptyIdAndNameAttributesForInputError:ft,genericFormInputAssignedAutocompleteValueToIdOrNameAttributeError:kt,genericFormInputHasWrongButWellIntendedAutocompleteValue:Ct,genericFormLabelForMatchesNonExistingIdError:St,genericFormLabelHasNeitherForNorNestedInput:yt});const Tt={handlingHeavyAdInterventions:"Handling Heavy Ad Interventions"},At=s.i18n.registerUIStrings("models/issues_manager/HeavyAdIssue.ts",Tt),Rt=s.i18n.getLocalizedString.bind(void 0,At);class Pt extends m{#n;constructor(e,t){super({code:"HeavyAdIssue",umaCode:["HeavyAdIssue",e.reason].join("::")},t),this.#n=e}details(){return this.#n}primaryKey(){return`HeavyAdIssue-${JSON.stringify(this.#n)}`}getDescription(){return{file:"heavyAd.md",links:[{link:"https://developers.google.com/web/updates/2020/05/heavy-ad-interventions",linkTitle:Rt(Tt.handlingHeavyAdInterventions)}]}}getCategory(){return c.HeavyAd}getKind(){switch(this.#n.resolution){case"HeavyAdBlocked":return g.PageError;case"HeavyAdWarning":return g.BreakingChange}}static fromInspectorIssue(e,t){const s=t.details.heavyAdIssueDetails;return s?[new Pt(s,e)]:(console.warn("Heavy Ad issue without details received."),[])}}var Dt=Object.freeze({__proto__:null,HeavyAdIssue:Pt});const Mt={bounceTrackingMitigations:"Bounce Tracking Mitigations"},Et=s.i18n.registerUIStrings("models/issues_manager/BounceTrackingIssue.ts",Mt),Ft=s.i18n.getLocalizedString.bind(void 0,Et);class xt extends m{#n;constructor(e,t){super("BounceTrackingIssue",t),this.#n=e}getCategory(){return c.Other}getDescription(){return{file:"bounceTrackingMitigations.md",links:[{link:"https://privacycg.github.io/nav-tracking-mitigations/#bounce-tracking-mitigations",linkTitle:Ft(Mt.bounceTrackingMitigations)}]}}details(){return this.#n}getKind(){return g.BreakingChange}primaryKey(){return JSON.stringify(this.#n)}trackingSites(){return this.#n.trackingSites?this.#n.trackingSites:[]}static fromInspectorIssue(e,t){const s=t.details.bounceTrackingIssueDetails;return s?[new xt(s,e)]:(console.warn("Bounce tracking issue without details received."),[])}}const Lt={fedCm:"Federated Credential Management API"},Ot=s.i18n.registerUIStrings("models/issues_manager/FederatedAuthRequestIssue.ts",Lt),Nt=s.i18n.getLazilyComputedLocalizedString.bind(void 0,Ot);class Ht extends m{#n;constructor(e,t){super({code:"FederatedAuthRequestIssue",umaCode:["FederatedAuthRequestIssue",e.federatedAuthRequestIssueReason].join("::")},t),this.#n=e}getCategory(){return c.Other}details(){return this.#n}getDescription(){const e=Ut.get(this.#n.federatedAuthRequestIssueReason);return e?w(e):null}primaryKey(){return JSON.stringify(this.#n)}getKind(){return g.PageError}static fromInspectorIssue(e,t){const s=t.details.federatedAuthRequestIssueDetails;return s?[new Ht(s,e)]:(console.warn("Federated auth request issue without details received."),[])}}const Ut=new Map([["TooManyRequests",{file:"federatedAuthRequestTooManyRequests.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:Nt(Lt.fedCm)}]}],["ConfigHttpNotFound",{file:"federatedAuthRequestManifestHttpNotFound.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:Nt(Lt.fedCm)}]}],["ConfigNoResponse",{file:"federatedAuthRequestManifestNoResponse.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:Nt(Lt.fedCm)}]}],["ConfigInvalidResponse",{file:"federatedAuthRequestManifestInvalidResponse.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:Nt(Lt.fedCm)}]}],["ClientMetadataHttpNotFound",{file:"federatedAuthRequestClientMetadataHttpNotFound.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:Nt(Lt.fedCm)}]}],["ClientMetadataNoResponse",{file:"federatedAuthRequestClientMetadataNoResponse.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:Nt(Lt.fedCm)}]}],["ClientMetadataInvalidResponse",{file:"federatedAuthRequestClientMetadataInvalidResponse.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:Nt(Lt.fedCm)}]}],["ErrorFetchingSignin",{file:"federatedAuthRequestErrorFetchingSignin.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:Nt(Lt.fedCm)}]}],["InvalidSigninResponse",{file:"federatedAuthRequestInvalidSigninResponse.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:Nt(Lt.fedCm)}]}],["AccountsHttpNotFound",{file:"federatedAuthRequestAccountsHttpNotFound.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:Nt(Lt.fedCm)}]}],["AccountsNoResponse",{file:"federatedAuthRequestAccountsNoResponse.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:Nt(Lt.fedCm)}]}],["AccountsInvalidResponse",{file:"federatedAuthRequestAccountsInvalidResponse.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:Nt(Lt.fedCm)}]}],["IdTokenHttpNotFound",{file:"federatedAuthRequestIdTokenHttpNotFound.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:Nt(Lt.fedCm)}]}],["IdTokenNoResponse",{file:"federatedAuthRequestIdTokenNoResponse.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:Nt(Lt.fedCm)}]}],["IdTokenInvalidResponse",{file:"federatedAuthRequestIdTokenInvalidResponse.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:Nt(Lt.fedCm)}]}],["IdTokenInvalidRequest",{file:"federatedAuthRequestIdTokenInvalidRequest.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:Nt(Lt.fedCm)}]}],["ErrorIdToken",{file:"federatedAuthRequestErrorIdToken.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:Nt(Lt.fedCm)}]}],["Canceled",{file:"federatedAuthRequestCanceled.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:Nt(Lt.fedCm)}]}]]),_t={colorAndContrastAccessibility:"Color and contrast accessibility"},Wt=s.i18n.registerUIStrings("models/issues_manager/LowTextContrastIssue.ts",_t),qt=s.i18n.getLocalizedString.bind(void 0,Wt);class Bt extends m{#n;constructor(e,t){super("LowTextContrastIssue",t),this.#n=e}primaryKey(){return`${this.code()}-(${this.#n.violatingNodeId})`}getCategory(){return c.LowTextContrast}details(){return this.#n}getDescription(){return{file:"LowTextContrast.md",links:[{link:"https://web.dev/color-and-contrast-accessibility/",linkTitle:qt(_t.colorAndContrastAccessibility)}]}}getKind(){return g.Improvement}static fromInspectorIssue(e,t){const s=t.details.lowTextContrastIssueDetails;return s?[new Bt(s,e)]:(console.warn("LowTextContrast issue without details received."),[])}}var zt=Object.freeze({__proto__:null,LowTextContrastIssue:Bt});const Vt={preventingMixedContent:"Preventing mixed content"},jt=s.i18n.registerUIStrings("models/issues_manager/MixedContentIssue.ts",Vt),Kt=s.i18n.getLocalizedString.bind(void 0,jt);class $t extends m{#n;constructor(e,t){super("MixedContentIssue",t),this.#n=e}requests(){return this.#n.request?[this.#n.request]:[]}getDetails(){return this.#n}getCategory(){return c.MixedContent}getDescription(){return{file:"mixedContent.md",links:[{link:"https://web.dev/what-is-mixed-content/",linkTitle:Kt(Vt.preventingMixedContent)}]}}primaryKey(){return JSON.stringify(this.#n)}getKind(){switch(this.#n.resolutionStatus){case"MixedContentAutomaticallyUpgraded":case"MixedContentWarning":return g.Improvement;case"MixedContentBlocked":return g.PageError}}static fromInspectorIssue(e,t){const s=t.details.mixedContentIssueDetails;return s?[new $t(s,e)]:(console.warn("Mixed content issue without details received."),[])}}var Gt=Object.freeze({__proto__:null,MixedContentIssue:$t});const Qt={documentCompatibilityMode:"Document compatibility mode"},Jt=s.i18n.registerUIStrings("models/issues_manager/QuirksModeIssue.ts",Qt),Yt=s.i18n.getLocalizedString.bind(void 0,Jt);class Xt extends m{#n;constructor(e,t){super({code:"QuirksModeIssue",umaCode:["QuirksModeIssue",e.isLimitedQuirksMode?"LimitedQuirksMode":"QuirksMode"].join("::")},t),this.#n=e}primaryKey(){return`${this.code()}-(${this.#n.documentNodeId})-(${this.#n.url})`}getCategory(){return c.QuirksMode}details(){return this.#n}getDescription(){return{file:"CompatibilityModeQuirks.md",links:[{link:"https://web.dev/doctype/",linkTitle:Yt(Qt.documentCompatibilityMode)}]}}getKind(){return g.Improvement}static fromInspectorIssue(e,t){const s=t.details.quirksModeIssueDetails;return s?[new Xt(s,e)]:(console.warn("Quirks Mode issue without details received."),[])}}var Zt=Object.freeze({__proto__:null,QuirksModeIssue:Xt});const es={enablingSharedArrayBuffer:"Enabling `SharedArrayBuffer`"},ts=s.i18n.registerUIStrings("models/issues_manager/SharedArrayBufferIssue.ts",es),ss=s.i18n.getLocalizedString.bind(void 0,ts);class is extends m{#n;constructor(e,t){super({code:"SharedArrayBufferIssue",umaCode:["SharedArrayBufferIssue",e.type].join("::")},t),this.#n=e}getCategory(){return c.Other}details(){return this.#n}getDescription(){return{file:"sharedArrayBuffer.md",links:[{link:"https://developer.chrome.com/blog/enabling-shared-array-buffer/",linkTitle:ss(es.enablingSharedArrayBuffer)}]}}primaryKey(){return JSON.stringify(this.#n)}getKind(){return this.#n.isWarning?g.BreakingChange:g.PageError}static fromInspectorIssue(e,t){const s=t.details.sharedArrayBufferIssueDetails;return s?[new is(s,e)]:(console.warn("SAB transfer issue without details received."),[])}}var rs=Object.freeze({__proto__:null,SharedArrayBufferIssue:is});const ns=["StylesheetLoadingIssue","LateImportRule"].join("::");class os extends m{#n;constructor(e,t){super(`StylesheetLoadingIssue::${e.styleSheetLoadingIssueReason}`,t),this.#n=e}sources(){return[this.#n.sourceCodeLocation]}requests(){if(!this.#n.failedRequestInfo)return[];const{url:e,requestId:t}=this.#n.failedRequestInfo;return t?[{url:e,requestId:t}]:[]}details(){return this.#n}primaryKey(){return JSON.stringify(this.#n)}getDescription(){switch(this.#n.styleSheetLoadingIssueReason){case"LateImportRule":return{file:"stylesheetLateImport.md",links:[]};case"RequestFailed":return{file:"stylesheetRequestFailed.md",links:[]}}}getCategory(){return c.Other}getKind(){return g.PageError}static fromInspectorIssue(e,t){const s=t.details.stylesheetLoadingIssueDetails;return s?[new os(s,e)]:(console.warn("Stylesheet loading issue without details received"),[])}}var as=Object.freeze({__proto__:null,lateImportStylesheetLoadingCode:ns,StylesheetLoadingIssue:os});class us{issuesManager;#c=new o.PresentationConsoleMessageHelper.PresentationSourceFrameMessageManager;constructor(e){this.issuesManager=e,this.issuesManager.addEventListener("IssueAdded",this.#g,this),this.issuesManager.addEventListener("FullUpdateRequired",this.#m,this)}#g(e){const{issue:t}=e.data;this.#h(t)}async#h(t){if(!this.#p(t)&&!this.#I(t))return;const s=t.model();if(!s)return;const i=h(t.details().sourceCodeLocation),r=t.getDescription();if(!r||!i)return;const n=await M(r);if(!n)return;this.#c.addMessage(new ls(n,t.getKind(),(()=>{e.Revealer.reveal(t)})),{line:i.lineNumber,column:i.columnNumber??-1,url:i.url,scriptId:i.scriptId},s.target())}#m(){this.#f();const e=this.issuesManager.issues();for(const t of e)this.#h(t)}#p(e){return e instanceof q&&e.code()===J||e.code()===Y}#I(e){return e.code()===ns}#f(){this.#c.clear()}}class ls extends a.UISourceCode.Message{#k;constructor(e,t,s){super(a.UISourceCode.Message.Level.Issue,e,s),this.#k=t}getIssueKind(){return this.#k}}var ds=Object.freeze({__proto__:null,SourceFrameIssuesManager:us,IssueMessage:ls});let cs=null;const gs=new Map([["CookieIssue",oe.fromInspectorIssue],["MixedContentIssue",$t.fromInspectorIssue],["HeavyAdIssue",Pt.fromInspectorIssue],["ContentSecurityPolicyIssue",q.fromInspectorIssue],["BlockedByResponseIssue",function(e,t){const s=t.details.blockedByResponseIssueDetails;return s?Be(s.reason)?[new ze(s,e)]:[]:(console.warn("BlockedByResponse issue without details received."),[])}],["SharedArrayBufferIssue",is.fromInspectorIssue],["LowTextContrastIssue",Bt.fromInspectorIssue],["CorsIssue",He.fromInspectorIssue],["QuirksModeIssue",Xt.fromInspectorIssue],["AttributionReportingIssue",f.fromInspectorIssue],["GenericIssue",dt.fromInspectorIssue],["DeprecationIssue",Ze.fromInspectorIssue],["ClientHintIssue",O.fromInspectorIssue],["FederatedAuthRequestIssue",Ht.fromInspectorIssue],["BounceTrackingIssue",xt.fromInspectorIssue],["StylesheetLoadingIssue",os.fromInspectorIssue],["FederatedAuthUserInfoRequestIssue",rt.fromInspectorIssue]]);function ms(){return{}}class hs extends e.ObjectWrapper.ObjectWrapper{showThirdPartyIssuesSetting;hideIssueSetting;#C=new WeakMap;#S=new Map;#y=new Map;#w=new Map;#v=new Map;#b=!1;#T=new Map;#A=new Map;constructor(e,t){super(),this.showThirdPartyIssuesSetting=e,this.hideIssueSetting=t,new us(this),i.TargetManager.TargetManager.instance().observeModels(i.IssuesModel.IssuesModel,this),i.TargetManager.TargetManager.instance().addModelListener(i.ResourceTreeModel.ResourceTreeModel,i.ResourceTreeModel.Events.PrimaryPageChanged,this.#R,this),i.FrameManager.FrameManager.instance().addEventListener(i.FrameManager.Events.FrameAddedToTarget,this.#P,this),this.showThirdPartyIssuesSetting?.addChangeListener((()=>this.#D())),this.hideIssueSetting?.addChangeListener((()=>this.#D())),i.TargetManager.TargetManager.instance().observeTargets({targetAdded:e=>{e.outermostTarget()===e&&this.#D()},targetRemoved:e=>{}},{scoped:!0})}static instance(e={forceNew:!1,ensureFirst:!1}){if(cs&&e.ensureFirst)throw new Error('IssuesManager was already created. Either set "ensureFirst" to false or make sure that this invocation is really the first one.');return cs&&!e.forceNew||(cs=new hs(e.showThirdPartyIssuesSetting,e.hideIssueSetting)),cs}static removeInstance(){cs=null}reloadForAccurateInformationRequired(){return!this.#b}#R(e){const{frame:t}=e.data,s=new Map;for(const[e,r]of this.#S.entries())if(r.isAssociatedWithRequestId(t.loaderId)&&s.set(e,r),"BounceTrackingIssue"===r.code()){!1===t.resourceTreeModel().target().model(i.NetworkManager.NetworkManager)?.requestForLoaderId(t.loaderId)?.hasUserGesture()&&s.set(e,r)}this.#S=s,this.#b=!0,this.#D()}#P(e){const{frame:t}=e.data;t.isOutermostFrame()&&i.TargetManager.TargetManager.instance().isInScope(t.resourceTreeModel())&&this.#D()}modelAdded(e){const t=e.addEventListener("IssueAdded",this.#M,this);this.#C.set(e,t)}modelRemoved(t){const s=this.#C.get(t);s&&e.EventTarget.removeEventListeners([s])}#M(e){const{issuesModel:t,inspectorIssue:s}=e.data,i=function(e,t){const s=gs.get(t.code);return s?s(e,t):(console.warn(`No handler registered for issue code ${t.code}`),[])}(t,s);for(const e of i)this.addIssue(t,e)}addIssue(e,t){if(!t.getDescription())return;const s=t.primaryKey();if(this.#S.has(s))return;this.#S.set(s,t);const i=e.target().outermostTarget();if(i){let e=this.#A.get(i);e||(e=new Set,this.#A.set(i,e)),e.add(t)}if(this.#E(t)){this.#y.set(s,t),this.#w.set(t.getKind(),1+(this.#w.get(t.getKind())||0));const i=t.getIssueId();i&&this.#T.set(i,t);const r=this.hideIssueSetting?.get();this.#F(t,r),t.isHidden()&&this.#v.set(t.getKind(),1+(this.#v.get(t.getKind())||0)),this.dispatchEventToListeners("IssueAdded",{issuesModel:e,issue:t})}this.dispatchEventToListeners("IssuesCountUpdated")}issues(){return this.#y.values()}numberOfIssues(e){return e?(this.#w.get(e)??0)-this.numberOfHiddenIssues(e):this.#y.size-this.numberOfHiddenIssues()}numberOfHiddenIssues(e){if(e)return this.#v.get(e)??0;let t=0;for(const e of this.#v.values())t+=e;return t}numberOfAllStoredIssues(){return this.#S.size}#E(e){const t=i.TargetManager.TargetManager.instance().scopeTarget();return!!t&&(!!this.#A.get(t)?.has(e)&&(this.showThirdPartyIssuesSetting?.get()||!e.isCausedByThirdParty()))}#F(e,t){const s=e.code();if(t&&t[s])return"Hidden"===t[s]?void e.setHidden(!0):void e.setHidden(!1)}#D(){this.#y.clear(),this.#w.clear(),this.#T.clear(),this.#v.clear();const e=this.hideIssueSetting?.get();for(const[t,s]of this.#S)if(this.#E(s)){this.#F(s,e),this.#y.set(t,s),this.#w.set(s.getKind(),1+(this.#w.get(s.getKind())??0)),s.isHidden()&&this.#v.set(s.getKind(),1+(this.#v.get(s.getKind())||0));const i=s.getIssueId();i&&this.#T.set(i,s)}this.dispatchEventToListeners("FullUpdateRequired"),this.dispatchEventToListeners("IssuesCountUpdated")}unhideAllIssues(){for(const e of this.#S.values())e.setHidden(!1);this.hideIssueSetting?.set({})}getIssueById(e){return this.#T.get(e)}}globalThis.addIssueForTest=e=>{const t=i.TargetManager.TargetManager.instance().primaryPageTarget()?.model(i.IssuesModel.IssuesModel);t?.issueAdded({issue:e})};var ps=Object.freeze({__proto__:null,defaultHideIssueByCodeSetting:ms,getHideIssueByCodeSetting:function(){return e.Settings.Settings.instance().createSetting("HideIssueByCodeSetting-Experiment-2021",{})},IssuesManager:hs});class Is extends e.ResolverBase.ResolverBase{#x=null;#L;constructor(e=hs.instance()){super(),this.#L=e}getForId(e){return this.#L.getIssueById(e)||null}#g(e){const{issue:t}=e.data,s=t.getIssueId();s&&this.onResolve(s,t)}startListening(){this.#x||(this.#x=this.#L.addEventListener("IssueAdded",this.#g,this))}stopListening(){this.#x&&(e.EventTarget.removeEventListeners([this.#x]),this.#x=null)}}var fs=Object.freeze({__proto__:null,IssueResolver:Is});function ks(e,t){if(t instanceof i.NetworkRequest.NetworkRequest)return function(e,t){return e.filter((e=>{for(const s of e.requests())if(s.requestId===t.requestId())return!0;return!1}))}(e,t);if(t instanceof i.Cookie.Cookie)return function(e,t,s,i){return e.filter((e=>{for(const r of e.cookies())if(r.domain===t&&r.name===s&&r.path===i)return!0;return!1}))}(e,t.domain(),t.name(),t.path());throw new Error(`issues can not be associated with ${JSON.stringify(t)}`)}var Cs=Object.freeze({__proto__:null,issuesAssociatedWith:ks,hasIssues:function(e){return ks(Array.from(hs.instance().issues()),e).length>0},hasIssueOfCategory:function(e,t){return ks(Array.from(hs.instance().issues()),e).some((e=>e.getCategory()===t))},reveal:async function(t,s){if("string"==typeof t){const s=hs.instance().getIssueById(t);if(s)return e.Revealer.reveal(s)}const i=ks(Array.from(hs.instance().issues()),t).filter((e=>!s||e.getCategory()===s));if(i.length>0)return e.Revealer.reveal(i[0])}});export{k as AttributionReportingIssue,y as CheckFormsIssuesTrigger,H as ClientHintIssue,Z as ContentSecurityPolicyIssue,se as ContrastCheckTrigger,Ee as CookieIssue,Ue as CorsIssue,je as CrossOriginEmbedderPolicyIssue,et as DeprecationIssue,ot as FederatedAuthUserInfoRequestIssue,bt as GenericIssue,Dt as HeavyAdIssue,p as Issue,fs as IssueResolver,ps as IssuesManager,zt as LowTextContrastIssue,E as MarkdownIssueDescription,Gt as MixedContentIssue,Zt as QuirksModeIssue,Cs as RelatedIssue,rs as SharedArrayBufferIssue,ds as SourceFrameIssuesManager,as as StylesheetLoadingIssue};
